<?php



namespace Config;



// Create a new instance of our RouteCollection class.

$routes = Services::routes();

$routes->setAutoRoute(true);





/*

 * --------------------------------------------------------------------

 * Router Setup

 * --------------------------------------------------------------------

 */

$routes->setDefaultNamespace('App\Controllers');

$routes->setDefaultController('Index_controller');

$routes->setDefaultMethod('index');

$routes->setTranslateURIDashes(false);

$routes->set404Override();



// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps

// where controller filters or CSRF chapters_indion are bypassed.

// If you don't want to define all routes, please use the Auto Routing (Improved).

// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.

// $routes->setAutoRoute(false);



/*

 * --------------------------------------------------------------------

 * Route Definitions

 * --------------------------------------------------------------------

 */



// We get a performance increase by specifying the default

// route since we don't have to scan directories.







//*-------------- Admin User --------------*//



// $routes->get('/', 'Home::index');

$routes->get('/index', 'Index_controller::index');

$routes->post('/login', 'Index_controller::login');

$routes->get('/logout', 'Index_controller::logout');

$routes->group("admin", function ($routes) {

    $routes->get('/', 'Index_controller::index');

    $routes->get('index', 'Index_controller::index');

    $routes->get('forgot', 'Index_controller::forgot');

    $routes->post('forgot_hndl', 'Index_controller::forgot_hndl');

    $routes->get('profile', 'Index_controller::admin_profile');

    $routes->get('profile_edit/(:num)', 'Index_controller::profile_edit/$1');



    $routes->get('dashboard', 'Index_controller::dashboard');

    $routes->get('user_tbl', 'Index_controller::user_tbl');

    $routes->post('get_user_by_zone', 'Index_controller::get_user_by_zone');

    $routes->post('get_user_by_region', 'Index_controller::get_user_by_region');

    $routes->post('get_user_by_hq', 'Index_controller::get_user_by_hq');

    $routes->get('add_user', 'Index_controller::add_user');

    $routes->post('user_insert', 'Index_controller::user_insert');

    $routes->get('user_edit/(:num)', 'Index_controller::user_edit/$1');

    $routes->post('user_update', 'Index_controller::user_update');

    $routes->get('user_delete/(:num)', 'Index_controller::user_delete/$1');

    $routes->get('total_data', 'Index_controller::total_Data');

    $routes->post('get_total_data_by_zone', 'Index_controller::get_total_data_by_zone');

    $routes->post('get_total_data_by_region', 'Index_controller::get_total_data_by_region');

    $routes->post('get_total_data_by_hq', 'Index_controller::get_total_data_by_hq');

    $routes->get('total_doctors', 'Index_controller::total_Doctors');

    $routes->get('total_patients', 'Index_controller::total_Patients');

    $routes->get('total_rx', 'Index_controller::total_rx');

    $routes->get('doctor_users_count', 'Index_controller::doctor_users_count');

    $routes->get('patient_users_count', 'Index_controller::patient_users_count');

    $routes->get('doctor_patients/(:num)', 'Index_controller::doctor_patients/$1');

    $routes->get('total_rx', 'Index_controller::total_rx');

    $routes->post('get_regions_by_zone', 'Index_controller::get_regions_by_zone');

    $routes->post('get_hq_by_region', 'Index_controller::get_hq_by_region');

    $routes->post('get_doctor_data_by_zone', 'Index_controller::get_doctor_data_by_zone');

    $routes->post('get_doctor_data_by_region', 'Index_controller::get_doctor_data_by_region');

    $routes->post('get_doctor_data_by_hq', 'Index_controller::get_doctor_data_by_hq');

    $routes->post('get_user_doctor_by_zone', 'Index_controller::get_user_doctor_by_zone');

    $routes->post('get_user_doctor_by_region', 'Index_controller::get_user_doctor_by_region');

    $routes->post('get_user_doctor_by_hq', 'Index_controller::get_user_doctor_by_hq');

    $routes->post('get_patient_data_by_zone', 'Index_controller::get_patient_data_by_zone');

    $routes->post('get_patient_data_by_region', 'Index_controller::get_patient_data_by_region');

    $routes->post('get_patient_data_by_hq', 'Index_controller::get_patient_data_by_hq');

    $routes->post('get_user_patient_by_zone', 'Index_controller::get_user_patient_by_zone');

    $routes->post('get_user_patient_by_region', 'Index_controller::get_user_patient_by_region');

    $routes->post('get_user_patient_by_hq', 'Index_controller::get_user_patient_by_hq');

    $routes->post('get_rx_by_zone', 'Index_controller::get_rx_by_zone');

    $routes->post('get_rx_by_region', 'Index_controller::get_rx_by_region');

    $routes->post('get_rx_by_hq', 'Index_controller::get_rx_by_hq');

    $routes->get('get_data_by_data', 'Index_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Index_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Index_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Index_controller::get_rx_data_by_date');

    $routes->get('generate_excel_by_total_data', 'Index_controller::generate_excel_by_total_data');
    $routes->get('generate_excel_by_total_doctors', 'Index_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Index_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Index_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Index_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Index_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Index_controller::generate_excel_by_user_tbl');


    $routes->get('total_poster', 'Index_controller::total_poster');
    $routes->get('birthday_tbl', 'Index_controller::birthday_tbl');
    $routes->get('anniversary_tbl', 'Index_controller::anniversary_tbl');
    $routes->get('brandreminder_tbl', 'Index_controller::brandreminder_tbl');
    $routes->get('thankyou_tbl', 'Index_controller::thankyou_tbl');

    $routes->get('total_videos', 'Index_controller::total_videos');
    $routes->get('total_birthday_videos', 'Index_controller::total_birthday_videos');
    $routes->get('total_anniversary_videos', 'Index_controller::total_anniversary_videos');
    $routes->get('total_festival_videos', 'Index_controller::total_festival_videos');

    $routes->get('users_count', 'Index_controller::users_count');
    $routes->get('users_date_count', 'Index_controller::users_date_count');

    $routes->get('brands_form', 'Index_controller::brands_form');
    $routes->get('brands_table', 'Index_controller::brands_table');
    $routes->post('brands_insert', 'Index_controller::brands_insert');
    $routes->get('brands_edit/(:num)', 'Index_controller::brands_edit/$1');
    $routes->post('brands_update', 'Index_controller::brands_update');
    $routes->get('brands_delete/(:num)', 'Index_controller::brands_delete/$1');

    $routes->get('campaign_form', 'Index_controller::campaign_form');
    $routes->get('campaign_table', 'Index_controller::campaign_table');
    $routes->post('campaign_insert', 'Index_controller::campaign_insert');
    $routes->get('campaign_edit/(:num)', 'Index_controller::campaign_edit/$1');
    $routes->post('campaign_update', 'Index_controller::campaign_update');
    $routes->get('campaign_delete/(:num)', 'Index_controller::campaign_delete/$1');

    $routes->get('language_form', 'Index_controller::language_form');
    $routes->get('language_table', 'Index_controller::language_table');
    $routes->post('language_insert', 'Index_controller::language_insert');
    $routes->get('language_edit/(:num)', 'Index_controller::language_edit/$1');
    $routes->post('language_update', 'Index_controller::language_update');
    $routes->get('language_delete/(:num)', 'Index_controller::language_delete/$1');

    $routes->get('frame_form', 'Index_controller::frame_form');
    $routes->get('frame_table', 'Index_controller::frame_table');
    $routes->post('frame_insert', 'Index_controller::frame_insert');
    $routes->get('frame_edit/(:num)', 'Index_controller::frame_edit/$1');
    $routes->post('frame_update', 'Index_controller::frame_update');
    $routes->get('frame_delete/(:num)', 'Index_controller::frame_delete/$1');

    $routes->get('birthday_frame_form', 'Index_controller::birthday_frame_form');
    $routes->get('birthday_frame_table', 'Index_controller::birthday_frame_table');
    $routes->post('birthday_frame_insert', 'Index_controller::birthday_frame_insert');
    $routes->get('birthday_frame_edit/(:num)', 'Index_controller::birthday_frame_edit/$1');
    $routes->post('birthday_frame_update', 'Index_controller::birthday_frame_update');
    $routes->get('birthday_frame_delete/(:num)', 'Index_controller::birthday_frame_delete/$1');

    $routes->get('anniversary_frame_form', 'Index_controller::anniversary_frame_form');
    $routes->get('anniversary_frame_table', 'Index_controller::anniversary_frame_table');
    $routes->post('anniversary_frame_insert', 'Index_controller::anniversary_frame_insert');
    $routes->get('anniversary_frame_edit/(:num)', 'Index_controller::anniversary_frame_edit/$1');
    $routes->post('anniversary_frame_update', 'Index_controller::anniversary_frame_update');
    $routes->get('anniversary_frame_delete/(:num)', 'Index_controller::anniversary_frame_delete/$1');

    $routes->get('brandreminder_frame_form', 'Index_controller::brandreminder_frame_form');
    $routes->get('brandreminder_frame_table', 'Index_controller::brandreminder_frame_table');
    $routes->post('brandreminder_frame_insert', 'Index_controller::brandreminder_frame_insert');
    $routes->get('brandreminder_frame_edit/(:num)', 'Index_controller::brandreminder_frame_edit/$1');
    $routes->post('brandreminder_frame_update', 'Index_controller::brandreminder_frame_update');
    $routes->get('brandreminder_frame_delete/(:num)', 'Index_controller::brandreminder_frame_delete/$1');

    $routes->get('thankyou_frame_form', 'Index_controller::thankyou_frame_form');
    $routes->get('thankyou_frame_table', 'Index_controller::thankyou_frame_table');
    $routes->post('thankyou_frame_insert', 'Index_controller::thankyou_frame_insert');
    $routes->get('thankyou_frame_edit/(:num)', 'Index_controller::thankyou_frame_edit/$1');
    $routes->post('thankyou_frame_update', 'Index_controller::thankyou_frame_update');
    $routes->get('thankyou_frame_delete/(:num)', 'Index_controller::thankyou_frame_delete/$1');


    $routes->get('birthday_video_frame_form', 'Index_controller::birthday_video_frame_form');
    $routes->get('birthday_video_frame_table', 'Index_controller::birthday_video_frame_table');
    $routes->post('birthday_video_frame_insert', 'Index_controller::birthday_video_frame_insert');
    $routes->get('birthday_video_frame_edit/(:num)', 'Index_controller::birthday_video_frame_edit/$1');
    $routes->post('birthday_video_frame_update', 'Index_controller::birthday_video_frame_update');
    $routes->get('birthday_video_frame_delete/(:num)', 'Index_controller::birthday_video_frame_delete/$1');

    $routes->get('anniversary_video_frame_form', 'Index_controller::anniversary_video_frame_form');
    $routes->get('anniversary_video_frame_table', 'Index_controller::anniversary_video_frame_table');
    $routes->post('anniversary_video_frame_insert', 'Index_controller::anniversary_video_frame_insert');
    $routes->get('anniversary_video_frame_edit/(:num)', 'Index_controller::anniversary_video_frame_edit/$1');
    $routes->post('anniversary_video_frame_update', 'Index_controller::anniversary_video_frame_update');
    $routes->get('anniversary_video_frame_delete/(:num)', 'Index_controller::anniversary_video_frame_delete/$1');

    $routes->get('festival_video_frame_form', 'Index_controller::festival_video_frame_form');
    $routes->get('festival_video_frame_table', 'Index_controller::festival_video_frame_table');
    $routes->post('festival_video_frame_insert', 'Index_controller::festival_video_frame_insert');
    $routes->get('festival_video_frame_edit/(:num)', 'Index_controller::festival_video_frame_edit/$1');
    $routes->post('festival_video_frame_update', 'Index_controller::festival_video_frame_update');
    $routes->get('festival_video_frame_delete/(:num)', 'Index_controller::festival_video_frame_delete/$1');

});

$routes->group("zone", function ($routes) {
    $routes->get('dashboard', 'Zone_controller::dashboard');

    $routes->get('user_tbl', 'Zone_controller::user_tbl');

    $routes->get('add_user', 'Zone_controller::add_user');

    $routes->post('user_insert', 'Zone_controller::user_insert');

    $routes->get('user_edit/(:num)', 'Zone_controller::user_edit/$1');

    $routes->post('user_update', 'Zone_controller::user_update');

    $routes->get('user_delete/(:num)', 'Zone_controller::user_delete/$1');

    $routes->get('profile', 'Zone_controller::admin_profile');



    $routes->get('user_delete/(:num)', 'Zone_controller::user_delete/$1');

    $routes->get('total_patients', 'Zone_controller::total_Patients');

    $routes->get('total_doctors', 'Zone_controller::total_Doctors');

    $routes->get('doctor_users_count', 'Zone_controller::doctor_users_count');

    $routes->get('patient_users_count', 'Zone_controller::patient_users_count');

    $routes->get('doctor_patients/(:num)', 'Zone_controller::doctor_patients/$1');

    $routes->get('total_rx', 'Zone_controller::total_rx');

    $routes->get('get_total_rx_data', 'Zone_controller::get_total_rx_data');

    $routes->post('get_user_by_region', 'Zone_controller::get_user_by_region');

    $routes->post('get_user_by_hq', 'Zone_controller::get_user_by_hq');



    $routes->post('get_hq_by_region', 'Zone_controller::get_hq_by_region');

    $routes->post('get_doctor_data_by_region', 'Zone_controller::get_doctor_data_by_region');

    $routes->post('get_doctor_data_by_hq', 'Zone_controller::get_doctor_data_by_hq');

    $routes->post('get_user_doctor_by_region', 'Zone_controller::get_user_doctor_by_region');

    $routes->post('get_user_doctor_by_hq', 'Zone_controller::get_user_doctor_by_hq');

    $routes->post('get_patient_data_by_region', 'Zone_controller::get_patient_data_by_region');

    $routes->post('get_patient_data_by_hq', 'Zone_controller::get_patient_data_by_hq');

    $routes->post('get_user_patient_by_region', 'Zone_controller::get_user_patient_by_region');

    $routes->post('get_user_patient_by_hq', 'Zone_controller::get_user_patient_by_hq');

    $routes->post('get_rx_by_region', 'Zone_controller::get_rx_by_region');

    $routes->post('get_rx_by_hq', 'Zone_controller::get_rx_by_hq');



    $routes->get('get_data_by_data', 'Zone_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Zone_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Zone_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Zone_controller::get_rx_data_by_date');

    $routes->get('generate_excel_by_total_data', 'Zone_controller::generate_excel_by_total_data');
    $routes->get('generate_excel_by_total_doctors', 'Zone_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Zone_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Zone_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Zone_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Zone_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Zone_controller::generate_excel_by_user_tbl');


    $routes->get('total_poster', 'Zone_controller::total_poster');
    $routes->get('birthday_tbl', 'Zone_controller::birthday_tbl');
    $routes->get('anniversary_tbl', 'Zone_controller::anniversary_tbl');
    $routes->get('brandreminder_tbl', 'Zone_controller::brandreminder_tbl');
    $routes->get('thankyou_tbl', 'Zone_controller::thankyou_tbl');

    $routes->get('total_videos', 'Zone_controller::total_videos');
    $routes->get('total_birthday_videos', 'Zone_controller::total_birthday_videos');
    $routes->get('total_anniversary_videos', 'Zone_controller::total_anniversary_videos');

    $routes->get('users_count', 'Zone_controller::users_count');
    $routes->get('users_date_count', 'Zone_controller::users_date_count');

    $routes->get('poster_maker/(:num)', 'Zone_controller::poster_maker/$1');
    $routes->post('add_poster', 'Zone_controller::add_poster');
    $routes->post('poster_download_status', 'Zone_controller::poster_download_status');
    $routes->post('poster_share_status', 'Zone_controller::poster_share_status');

    $routes->get('video_maker', 'Zone_controller::video_maker');
    $routes->post('add_video', 'Zone_controller::add_video');
    $routes->post('video_download_status', 'Zone_controller::video_download_status');
    $routes->post('video_share_status', 'Zone_controller::video_share_status');

});

$routes->group("rbm", function ($routes) {

    $routes->get('dashboard', 'Regional_controller::r_dashboard');

    $routes->get('user_tbl', 'Regional_controller::r_user_tbl');

    $routes->get('add_user', 'Regional_controller::r_add_user');

    $routes->post('user_insert', 'Regional_controller::r_user_insert');

    $routes->get('user_edit/(:num)', 'Regional_controller::r_user_edit/$1');

    $routes->post('user_update', 'Regional_controller::r_user_update');

    $routes->get('user_delete/(:num)', 'Regional_controller::r_user_delete/$1');

    $routes->get('profile', 'Regional_controller::r_admin_profile');

    $routes->get('user_delete/(:num)', 'Regional_controller::r_user_delete/$1');



    $routes->get('total_doctors', 'Regional_controller::r_total_Doctors');

    $routes->get('total_patients', 'Regional_controller::r_total_Patients');

    $routes->get('doctor_users_count', 'Regional_controller::r_doctor_users_count');

    $routes->get('patient_users_count', 'Regional_controller::r_patient_users_count');

    $routes->get('doctor_patients/(:num)', 'Regional_controller::r_doctor_patients/$1');

    $routes->get('total_rx', 'Regional_controller::total_rx');



    $routes->post('get_user_by_hq', 'Regional_controller::get_user_by_hq');



    $routes->post('get_doctor_data_by_hq', 'Regional_controller::get_doctor_data_by_hq');

    $routes->post('get_user_doctor_by_hq', 'Regional_controller::get_user_doctor_by_hq');

    $routes->post('get_patient_data_by_hq', 'Regional_controller::get_patient_data_by_hq');

    $routes->post('get_user_patient_by_hq', 'Regional_controller::get_user_patient_by_hq');

    $routes->post('get_rx_by_hq', 'Regional_controller::get_rx_by_hq');


    $routes->get('get_data_by_data', 'Regional_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Regional_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Regional_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Regional_controller::get_rx_data_by_date');

    $routes->get('generate_excel_by_total_data', 'Regional_controller::generate_excel_by_total_data');
    $routes->get('generate_excel_by_total_doctors', 'Regional_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Regional_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Regional_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Regional_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Regional_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Regional_controller::generate_excel_by_user_tbl');


    $routes->get('total_poster', 'Regional_controller::total_poster');
    $routes->get('birthday_tbl', 'Regional_controller::birthday_tbl');
    $routes->get('anniversary_tbl', 'Regional_controller::anniversary_tbl');
    $routes->get('brandreminder_tbl', 'Regional_controller::brandreminder_tbl');
    $routes->get('thankyou_tbl', 'Regional_controller::thankyou_tbl');

    $routes->get('total_videos', 'Regional_controller::total_videos');
    $routes->get('total_birthday_videos', 'Regional_controller::total_birthday_videos');
    $routes->get('total_anniversary_videos', 'Regional_controller::total_anniversary_videos');

    $routes->get('users_count', 'Regional_controller::users_count');
    $routes->get('users_date_count', 'Regional_controller::users_date_count');

    $routes->get('poster_maker/(:num)', 'Regional_controller::poster_maker/$1');
    $routes->post('add_poster', 'Regional_controller::add_poster');
    $routes->post('poster_download_status', 'Regional_controller::poster_download_status');
    $routes->post('poster_share_status', 'Regional_controller::poster_share_status');

    $routes->get('video_maker', 'Regional_controller::video_maker');
    $routes->post('add_video', 'Regional_controller::add_video');
    $routes->post('video_download_status', 'Regional_controller::video_download_status');
    $routes->post('video_share_status', 'Regional_controller::video_share_status');

});

$routes->group("abm", function ($routes) {
    $routes->get('dashboard', 'Area_controller::a_dashboard');

    $routes->get('user_tbl', 'Area_controller::a_user_tbl');

    $routes->get('add_user', 'Area_controller::a_add_user');

    $routes->post('user_insert', 'Area_controller::a_user_insert');

    $routes->get('user_edit/(:num)', 'Area_controller::a_user_edit/$1');

    $routes->post('user_update', 'Area_controller::a_user_update');

    $routes->get('user_delete/(:num)', 'Area_controller::a_user_delete/$1');

    $routes->get('profile', 'Area_controller::a_admin_profile');



    $routes->get('user_delete/(:num)', 'Area_controller::a_user_delete/$1');

    $routes->get('total_patients', 'Area_controller::a_total_Patients');

    $routes->get('total_doctors', 'Area_controller::a_total_Doctors');

    $routes->get('doctor_users_count', 'Area_controller::a_doctor_users_count');

    $routes->get('patient_users_count', 'Area_controller::a_patient_users_count');

    $routes->get('doctor_patients/(:num)', 'Area_controller::a_doctor_patients/$1');

    $routes->get('total_rx', 'Area_controller::total_rx');

    $routes->get('get_data_by_data', 'Area_controller::get_data_by_data');
    $routes->get('get_doctor_data_by_date', 'Area_controller::get_doctor_data_by_date');
    $routes->get('get_patient_data_by_date', 'Area_controller::get_patient_data_by_date');
    $routes->get('get_rx_data_by_date', 'Area_controller::get_rx_data_by_date');

    $routes->get('generate_excel_by_total_doctors', 'Area_controller::generate_excel_by_total_doctors');
    $routes->get('generate_excel_by_total_patients', 'Area_controller::generate_excel_by_total_patients');
    $routes->get('generate_excel_by_total_rx', 'Area_controller::generate_excel_by_total_rx');
    $routes->get('generate_excel_by_doctor_users_count', 'Area_controller::generate_excel_by_doctor_users_count');
    $routes->get('generate_excel_by_patient_users_count', 'Area_controller::generate_excel_by_patient_users_count');
    $routes->get('generate_excel_by_user_tbl', 'Area_controller::generate_excel_by_user_tbl');


    $routes->get('total_poster', 'Area_controller::totel_poster');
    $routes->get('total_videos', 'Area_controller::totel_videos');
    $routes->get('users_count', 'Area_controller::users_count');
    $routes->get('users_date_count', 'Area_controller::users_date_count');

    $routes->get('poster_maker/(:num)', 'Area_controller::poster_maker/$1');
    $routes->post('add_poster', 'Area_controller::add_poster');
    $routes->post('poster_download_status', 'Area_controller::poster_download_status');
    $routes->post('poster_share_status', 'Area_controller::poster_share_status');

    $routes->get('video_maker', 'Area_controller::video_maker');
    $routes->post('add_video', 'Area_controller::add_video');
    $routes->post('video_download_status', 'Area_controller::video_download_status');
    $routes->post('video_share_status', 'Area_controller::video_share_status');


});


$routes->group("user", function ($routes) {

    $routes->get('dashboard', 'Index_controller::u_dashboard');

    $routes->get('data_dashboard', 'Index_controller::data_dashboard');

    $routes->get('total_doctors', 'Index_controller::u_doctors');

    $routes->get('add_doctor', 'Index_controller::doctorform');

    $routes->post('check_phone_exists', 'Index_controller::check_phone_exists');

    $routes->post('doctor_data', 'Index_controller::dr_data');

    $routes->get('doctor_edit/(:num)', 'Index_controller::doctoredit/$1');

    $routes->post('check_phone_and_id_exists', 'Index_controller::check_phone_and_id_exists');

    $routes->post('doctor_update', 'Index_controller::dr_update');



    $routes->get('total_patients', 'Index_controller::u_patients');

    $routes->get('add_patient/(:num)', 'Index_controller::addpatients/$1');

    $routes->get('suggest_patients', 'User::suggest_patients');

    $routes->post('patient_data', 'Index_controller::patient_data');



    $routes->get('rx_information', 'Index_controller::rx_information');

    $routes->get('add_rx', 'Index_controller::addrx');

    $routes->post('rx_data', 'Index_controller::rx_data');

    $routes->get('total_rx', 'Index_controller::u_rx');



    $routes->get('profile', 'Index_controller::u_profile');

    $routes->get('profile_edit', 'Index_controller::u_profile_edit');

    $routes->post('profile_update', 'Index_controller::u_profile_update');



    $routes->get('posters', 'Index_controller::u_select_poster');
    $routes->get('get_campaigns_by_language/(:num)', 'Index_controller::get_campaigns_by_language/$1');
    $routes->get('poster_maker/(:num)', 'Index_controller::poster_maker/$1');
    $routes->post('add_poster', 'Index_controller::add_poster');
    $routes->post('poster_download_status', 'Index_controller::poster_download_status');
    $routes->post('poster_share_status', 'Index_controller::poster_share_status');
    $routes->get('poster_table', 'Index_controller::poster_tbl');

    $routes->get('birthday_posters', 'Index_controller::birthday_posters');
    $routes->get('birthday_poster_maker/(:num)', 'Index_controller::birthday_poster_maker/$1');
    $routes->post('add_birthday_poster', 'Index_controller::add_birthday_poster');
    $routes->post('birthday_poster_download_status', 'Index_controller::birthday_poster_download_status');
    $routes->post('birthday_poster_share_status', 'Index_controller::birthday_poster_share_status');
    $routes->get('birthday_poster_table', 'Index_controller::birthday_poster_tbl');

    $routes->get('anniversary_posters', 'Index_controller::anniversary_posters');
    $routes->get('anniversary_poster_maker/(:num)', 'Index_controller::anniversary_poster_maker/$1');
    $routes->post('add_anniversary_poster', 'Index_controller::add_anniversary_poster');
    $routes->post('anniversary_poster_download_status', 'Index_controller::anniversary_poster_download_status');
    $routes->post('anniversary_poster_share_status', 'Index_controller::anniversary_poster_share_status');
    $routes->get('anniversary_poster_table', 'Index_controller::anniversary_poster_tbl');

    $routes->get('brandreminder_posters', 'Index_controller::brandreminder_posters');
    $routes->get('brandreminder_poster_maker/(:num)', 'Index_controller::brandreminder_poster_maker/$1');
    $routes->post('add_brandreminder_poster', 'Index_controller::add_brandreminder_poster');
    $routes->post('brandreminder_poster_download_status', 'Index_controller::brandreminder_poster_download_status');
    $routes->post('brandreminder_poster_share_status', 'Index_controller::brandreminder_poster_share_status');
    $routes->get('brandreminder_poster_table', 'Index_controller::brandreminder_poster_tbl');

    $routes->get('thankyou_posters', 'Index_controller::thankyou_posters');
    $routes->get('thankyou_poster_maker/(:num)', 'Index_controller::thankyou_poster_maker/$1');
    $routes->post('add_thankyou_poster', 'Index_controller::add_thankyou_poster');
    $routes->post('thankyou_poster_download_status', 'Index_controller::thankyou_poster_download_status');
    $routes->post('thankyou_poster_share_status', 'Index_controller::thankyou_poster_share_status');
    $routes->get('thankyou_poster_table', 'Index_controller::thankyou_poster_tbl');

    $routes->get('video_type_selection', 'Index_controller::video_type_selection');

    $routes->get('video_maker', 'Index_controller::video_maker');
    $routes->post('add_video', 'Index_controller::add_video');
    $routes->post('video_download_status', 'Index_controller::video_download_status');
    $routes->post('video_share_status', 'Index_controller::video_share_status');
    $routes->get('video_table', 'Index_controller::video_tbl');

    $routes->get('birthday_video', 'Index_controller::birthday_video');
    $routes->get('birthday_video_maker/(:num)', 'Index_controller::birthday_video_maker/$1');
    $routes->post('add_birthday_video', 'Index_controller::add_birthday_video');
    $routes->post('birthday_video_download_status', 'Index_controller::birthday_video_download_status');
    $routes->post('birthday_video_share_status', 'Index_controller::birthday_video_share_status');
    $routes->get('birthday_video_table', 'Index_controller::birthday_video_tbl');

    $routes->get('anniversary_video', 'Index_controller::anniversary_video');
    $routes->get('anniversary_video_maker/(:num)', 'Index_controller::anniversary_video_maker/$1');
    $routes->post('add_anniversary_video', 'Index_controller::add_anniversary_video');
    $routes->post('anniversary_video_download_status', 'Index_controller::anniversary_video_download_status');
    $routes->post('anniversary_video_share_status', 'Index_controller::anniversary_video_share_status');
    $routes->get('anniversary_video_table', 'Index_controller::anniversary_video_tbl');

    $routes->get('festival_video', 'Index_controller::festival_video');
    $routes->get('festival_video_maker/(:num)', 'Index_controller::festival_video_maker/$1');
    $routes->post('add_festival_video', 'Index_controller::add_festival_video');
    $routes->post('festival_video_download_status', 'Index_controller::festival_video_download_status');
    $routes->post('festival_video_share_status', 'Index_controller::festival_video_share_status');
    $routes->get('festival_video_table', 'Index_controller::festival_video_tbl');

});


$routes->get('PrivacyPolicy', 'Index_controller::privacy_policy');


$routes->group("api", function ($routes) {

    $routes->post("login", "Login::index");

    $routes->post("forget", "Login::forget");
    $routes->post("createAccount", "Login::createAccount");



    $routes->group("doctor", function ($routes) {

        $routes->get("/", "Doctor::list", ["filter" => 'authFilter']);

        $routes->get("count", "Users::doctorCount", ["filter" => 'authFilter']);

        $routes->get("code/(:any)", "Doctor::code/$1", ["filter" => 'authFilter']);

        $routes->get("(:num)", "Doctor::show/$1", ["filter" => 'authFilter']);

        $routes->post("/", "Doctor::create", ["filter" => 'authFilter']);

        $routes->put("(:num)", "Doctor::update/$1", ["filter" => 'authFilter']);

        $routes->delete("delete/(:num)", "Doctor::delete/$1", ["filter" => 'authFilter']);

        $routes->get("dashboard", "Doctor::dashboard", ["filter" => 'authFilter']);

    });

    $routes->group("user", function ($routes) {

        $routes->post("edit/(:num)", "Users::editUser/$1", ["filter" => 'authFilter']);
        $routes->get("delete", "Users::delateUser", ["filter" => 'authFilter']);

        $routes->post("synchData/(:num)", "Users::synchData/$1", ["filter" => 'authFilter']);

        $routes->get("/", "Users::list", ["filter" => 'authFilter']);



        $routes->get("me", "Users::myProfile", ["filter" => 'authFilter']);

        $routes->get("HQ", "Users::myHQ", ["filter" => 'authFilter']);
        $routes->get("Region", "Users::myRegion", ["filter" => 'authFilter']);
        $routes->get("Zone", "Users::myZone", ["filter" => 'authFilter']);

        $routes->get("(:num)", "Users::show/$1", ["filter" => 'authFilter']);

        $routes->post("employee", "Users::savaEmployee", ["filter" => 'authFilter']);

        $routes->post("/", "Users::create", ["filter" => 'authFilter']);

        $routes->put("(:num)", "Users::update/$1", ["filter" => 'authFilter']);

        $routes->delete("delete/(:num)", "Users::delete/$1", ["filter" => 'authFilter']);

        $routes->get("patientCount", "Users::patientCount", ["filter" => 'authFilter']);

        $routes->get("patientRx/count", "Users::patientRx", ["filter" => 'authFilter']);

        $routes->get("patientsByDoctor/(:num)", "Users::patientByDoctor/$1", ["filter" => 'authFilter']);

        $routes->get("patients", "Users::patient", ["filter" => 'authFilter']);

        $routes->get("findPatients", "Users::findPatients", ["filter" => 'authFilter']);

        $routes->get("patientsRx", "Users::patientRx", ["filter" => 'authFilter']);

        $routes->post("patients", "Users::savePatient", ["filter" => 'authFilter']);

        $routes->post("patients/(:num)", "Users::updatePatient/$1", ["filter" => 'authFilter']);

        $routes->post("patientRx", "Users::savePatientRx", ["filter" => 'authFilter']);

        $routes->get("doctorTotal", "Users::getDoctorTotal", ["filter" => 'authFilter']);

        $routes->post("uploadimg", "Users::uploadimg", ["filter" => 'authFilter']);

    });

});





/*

 * --------------------------------------------------------------------

 * Additional Routing

 * --------------------------------------------------------------------

 *

 * There will often be times that you need additional routing and you

 * need it to be able to override any defaults in this file. Environment

 * based routes is one such time. require() additional route files here

 * to make that happen.

 *

 * You will have access to the $routes object within that file without

 * needing to reload it.

 */

if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {

    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';

}