<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Video_Model;
use App\Models\Birthday_Frame_Model;
use App\Models\Anniversary_Frame_Model;
use App\Models\Brandreminder_Frame_Model;
use App\Models\Thankyou_Frame_Model;
use App\Models\Missyou_Frame_Model;
use App\Models\Birthday_Poster_Model;
use App\Models\Anniversary_Poster_Model;
use App\Models\Brandreminder_Poster_Model;
use App\Models\Thankyou_Poster_Model;
use App\Models\Missyou_Poster_Model;
use App\Models\Brands_Model;
use App\Models\Birthday_Video_Frame_Model;
use App\Models\Anniversary_Video_Frame_Model;
use App\Models\Birthday_Video_Model;
use App\Models\Anniversary_Video_Model;
use App\Models\Festival_Video_Frame_Model;
use App\Models\Festival_Video_Model;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Area_controller extends BaseController
{

    public function dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $patient = new Patient_Model;
            $rx = new Rx_Model;
            $posterModel = new Poster_Model();
            $videosModel = new Video_Model();


            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }
            $hq = $hq_id;
            $data = [
                'totalUsers' => $user->where('HQ', $hq)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->countAllResults(),
                'totalDoctors' => $doctor->where('hq_id', $hq_id)->countAllResults(),
                'totalPatients' => $patient->where('hq_id', $hq_id)->countAllResults(),
                'totalrx' => $rx->where('hq_id', $hq_id)->countAllResults(),
                'totalPosters' => $posterModel->getTotalPostersByHq($hq_id),
                'totalVideos' => $videosModel->getTotalVideosByHq($hq_id),
                'controller' => 'abm'
            ];
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }



    public function doctorform()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');

            $data['row'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/doctorform', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function check_phone_exists()
    {
        $phone = $this->request->getPost('phone');
        $doctor = new Doctor_Model();
        $exists = $doctor->checkPhoneExists($phone);
        if ($exists) {
            echo "exists";
        } else {
            echo "not_exists";
        }
    }


    public function dr_data()
    {
        $doctor = new Doctor_Model();

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
            'user' => $this->request->getPost('user'),
            'user_id' => $this->request->getPost('user_id'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $doctor->save($data);
        return redirect()->to('abm/add_doctor');
    }

    public function doctoredit($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $userid = $session->get('UserID');

            $doctor = new Doctor_Model();

            $data['row'] = $doctor->where('id', $id)->first();

            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $userid)->first();

            return view('admin/doctoredit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function check_phone_and_id_exists()
    {
        $phone = $this->request->getPost('phone');
        $id = $this->request->getPost('id');

        $doctorModel = new Doctor_Model();
        $result = $doctorModel->checkPhoneAndIdExists($phone, $id);

        return $this->response->setJSON($result);
    }


    public function dr_update()
    {
        $doctor = new Doctor_Model();
        $id = $this->request->getPost('id');

        $data = [
            'doctor' => $this->request->getPost('doctor'),
            'hospital' => $this->request->getPost('hospital'),
            'registration_no' => $this->request->getPost('registration_no'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'place' => $this->request->getPost('place'),
            'district' => $this->request->getPost('district'),
            'state' => $this->request->getPost('state'),
            'country' => $this->request->getPost('country'),
        ];

        $doctor->where('id', $id)->set($data)->update();
        return redirect()->to('abm/u_doctors');
    }

    public function u_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $doctor = new Doctor_Model;
            $data['data'] = $doctor->where('user_id', $id)->getDoctorUser();

            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/doctortbl_u', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function addpatients($id)
    {
        $session = session();
        if ($session->has('UserID')) {

            $userid = $session->get('UserID');

            $user = new User_Model;

            $doctor = new Doctor_Model();
            $patient = new Patient_Model();

            $data['row'] = $doctor->where('id', $id)->first();
            $data['patients'] = $patient->where('dr_id', $id)->findAll();

            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $userid)->first();

            return view('admin/patientform', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_data()
    {
        $patient = new Patient_Model();

        $id = $this->request->getPost('id');

        $combination = $this->request->getPost('combination');
        if (!empty($combination)) {
            $combinationStr = implode(', ', $combination);
        } else {
            $combinationStr = "No";
        }

        $ARB = $this->request->getPost('ARB');
        if (!empty($ARB)) {
            $StrARB = implode(', ', $ARB);
        }
        $ARB_other = $this->request->getPost('ARB_other');
        if (!empty($StrARB)) {
            if (!empty($ARB_other)) {
                $ARBStr = $StrARB . ", " . $ARB_other;
            } else {
                $ARBStr = $StrARB;
            }
        } else {
            $ARBStr = $ARB_other;
        }

        $ACEI = $this->request->getPost('ACE-I');
        if (!empty($ACEI)) {
            $StrACEI = implode(', ', $ACEI);
        }
        $ACE_other = $this->request->getPost('ACE_other');
        if (!empty($StrACEI)) {
            if (!empty($ACE_other)) {
                $ACEIStr = $StrACEI . ", " . $ACE_other;
            } else {
                $ACEIStr = $StrACEI;
            }
        } else {
            $ACEIStr = $ACE_other;
        }

        $BB = $this->request->getPost('BB');
        if (!empty($BB)) {
            $StrBB = implode(', ', $BB);
        }
        $BB_other = $this->request->getPost('BB_other');
        if (!empty($StrBB)) {
            if (!empty($BB_other)) {
                $BBStr = $StrBB . ", " . $BB_other;
            } else {
                $BBStr = $StrBB;
            }
        } else {
            $BBStr = $BB_other;
        }

        $CCB = $this->request->getPost('CCB');
        if (!empty($CCB)) {
            $StrCCB = implode(', ', $CCB);
        }
        $CCB_other = $this->request->getPost('CCB_other');
        if (!empty($StrCCB)) {
            if (!empty($CCB_other)) {
                $CCBStr = $StrCCB . ", " . $CCB_other;
            } else {
                $CCBStr = $StrCCB;
            }
        } else {
            $CCBStr = $CCB_other;
        }

        $Diuretic = $this->request->getPost('Diuretic');
        if (!empty($Diuretic)) {
            $StrDiuretic = implode(', ', $Diuretic);
        }
        $Diuretic_other = $this->request->getPost('Diuretic_other');
        if (!empty($StrDiuretic)) {
            if (!empty($Diuretic_other)) {
                $DiureticStr = $StrDiuretic . ", " . $Diuretic_other;
            } else {
                $DiureticStr = $StrDiuretic;
            }
        } else {
            $DiureticStr = $Diuretic_other;
        }

        $comorbid_con = $this->request->getPost('comorbid_con');
        if (!empty($comorbid_con)) {
            $comorbid_conStr = implode(', ', $comorbid_con);
        }
        $comorbid_other = $this->request->getPost('comorbid_other');
        if (!empty($comorbid_conStr)) {
            if (!empty($comorbid_other)) {
                $comorbid = $comorbid_conStr . ", " . $comorbid_other;
            } else {
                $comorbid = $comorbid_conStr;
            }
        } else {
            $comorbid = $comorbid_other;
        }

        $data = [
            'name' => $this->request->getPost('name'),
            'phone' => $this->request->getPost('phone'),
            'place' => $this->request->getPost('place'),
            'examination' => $this->request->getPost('examination'),
            'age' => $this->request->getPost('age'),
            'gender' => $this->request->getPost('gender'),
            'hypertension' => $this->request->getPost('hypertension'),
            'hypertension_drugs' => $this->request->getPost('drugs'),
            'drugs_combination' => $combinationStr,
            'arb' => $ARBStr,
            'arb_dose' => $this->request->getPost('ARB_dose'),
            'ace_i' => $ACEIStr,
            'ace_i_dose' => $this->request->getPost('ACE_dose'),
            'bb' => $BBStr,
            'bb_dose' => $this->request->getPost('BB_dose'),
            'ccb' => $CCBStr,
            'ccb_dose' => $this->request->getPost('CCB_dose'),
            'diuretic' => $DiureticStr,
            'diuretic_dose' => $this->request->getPost('Diuretic_dose'),
            'other' => $this->request->getPost('Other'),
            'other_dose' => $this->request->getPost('Other_dose'),
            'sbp1' => $this->request->getPost('sbp1'),
            'sbp2' => $this->request->getPost('sbp2'),
            'sbp3' => $this->request->getPost('sbp3'),
            'dbp1' => $this->request->getPost('dbp1'),
            'dbp2' => $this->request->getPost('dbp2'),
            'dbp3' => $this->request->getPost('dbp3'),
            'average_sbp' => $this->request->getPost('average_sbp'),
            'average_dbp' => $this->request->getPost('average_dbp'),
            'co_morbid_conditions' => $comorbid,
            'drugs_co_morbidity' => $this->request->getPost('drg_comorbid'),
            'dr_id' => $this->request->getPost('dr_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d H:i:s'),
        ];

        if (!empty($id)) {
            $data['id'] = $id;
        }

        $patient->save($data);
        $name = urlencode($this->request->getPost('name'));
        $date = urlencode($data['date']);

        return redirect()->to('abm/rx_information?name=' . $name . '&date=' . $date);
    }

    public function u_patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $patient = new Patient_Model;
            $data['data'] = $patient->where('patient_data.user_id', $id)->getPatientUser();

            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/patient_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function rx_information()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;

            $name = $this->request->getVar('name');
            $date = $this->request->getVar('date');

            if (!$name || !$date) {
                return redirect()->to('/admin/dashboard');
            }

            $patientModel = new Patient_model();
            $data['patientData'] = $patientModel->getPatientData($name, $date);

            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/rx_information', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function rx_data()
    {
        $rx = new Rx_Model();

        $patient_name = str_replace(' ', '_', $this->request->getPost('patient_name'));
        $phone_no = $this->request->getPost('phone_number');
        $folder = $patient_name . "_" . $phone_no;
        $file = $this->request->getFile('image');
        $image = "Prescription Not Uploaded";

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $randomName = $file->getRandomName();
            $destination = 'assets/patient_data/' . $folder . '/';
            if (!is_dir($destination)) {
                mkdir($destination, 0777, true);
            }
            $file->move($destination, $randomName);
            $image = $folder . "/" . $randomName;
        }

        $indication = $this->request->getPost('indication');
        $indicationStr = !empty($indication) ? $indication : "";

        $prescription = $this->request->getPost('prescription_information');
        if (!empty($prescription)) {
            $prescriptionStr = implode(', ', $prescription);
        } else {
            $prescriptionStr = "";
        }

        $co_morbidity = $this->request->getPost('co_morbidity_prescription');
        if (!empty($co_morbidity)) {
            $co_morbidityStr = implode(', ', $co_morbidity);
        } else {
            $co_morbidityStr = "";
        }

        $data = [
            'image' => $image,
            'doctor_name' => $this->request->getPost('doctor_name'),
            'patient_name' => $this->request->getPost('patient_name'),
            'phone_no' => $this->request->getPost('phone_number'),
            'quantity' => 'Null',
            'strips' => $this->request->getPost('strips'),
            'indication' => $indicationStr,
            'secondary' => $this->request->getPost('secondary'),
            'prescription_information' => $prescriptionStr,
            'co_morbidity_prescription' => $co_morbidityStr,
            'patient_id' => $this->request->getPost('patient_id'),
            'doctor_id' => $this->request->getPost('doctor_id'),
            'user_id' => $this->request->getPost('user_id'),
            'user' => $this->request->getPost('user'),
            'empno' => $this->request->getPost('empno'),
            'hq_id' => $this->request->getPost('hq_id'),
            'region_id' => $this->request->getPost('region_id'),
            'zone_id' => $this->request->getPost('zone_id'),
            'date' => date('Y-m-d'),
        ];
        $rx->save($data);
        return redirect()->to('abm/u_rx');
    }

    public function u_rx()
    {
        $session = session();
        if ($session->has('UserID')) {

            $id = $session->get('UserID');

            $user = new User_Model;
            $data['row'] = $user->where('UserID', $id)->first();

            $rx = new Rx_Model;
            $data['data'] = $rx->where('user_id', $id)->getRecord();

            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/rx_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int) ($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 20;
                // Get total number of items
                $data['total'] = $user->where('tbl_user.HQ', $hq_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->countAllResults();

                $user_array = $user->where('tbl_user.HQ', $hq_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUser(20, $data["page"]);
                $data['data'] = $user_array;

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'abm';

                $data['userType'] = $session->get('userType');

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('admin/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function total_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int) ($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data['total'] = $doctor->where('doctor_data.hq_id', $row['HQ'])->countAllResults();

                $data['data'] = $doctor->getTotalDoctor($data['perPage'], $data['page'], 0, 0, $row['HQ']);

                $data['Name'] = $user->where('UserID', $id)->first();

                $data['controller'] = 'abm';
                $data['userType'] = $session->get('userType');

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('admin/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                // Get the current page from the URL, otherwise default to page 1
                $data['page'] = (int) ($this->request->getGet('page') ?? 1);
                // Number of items per page
                $data['perPage'] = 500;
                // Get total number of items
                $data['total'] = $patient->where('patient_data.hq_id', $hq_id)->countAllResults();

                $data['data'] = $patient->getTotalPatients($data['perPage'], $data['page'], 0, 0, $hq_id);

                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'abm';
                $data['userType'] = $session->get('userType');

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('admin/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;

            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            foreach ($row as $zrow) {
                $hq_id = $zrow['HQ'];
            }

            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int) ($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $rx->where('rx_data.hq_id', $hq_id)->countAllResults();

            $data['data'] = $rx->getTotalPatientsrx($data['perPage'], $data['page'], 0, 0, $hq_id);

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }
            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int) ($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $doctor->where('hq_id', $hq_id)->countAllResults();

            $data['data'] = $doctor->gettotalDoctorEentry($data['perPage'], $data["page"], 0, 0, $hq_id);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            // Get the current page from the URL, otherwise default to page 1
            $data['page'] = (int) ($this->request->getGet('page') ?? 1);
            // Number of items per page
            $data['perPage'] = 500;
            // Get total number of items
            $data['total'] = $patient->where('hq_id', $hq_id)->countAllResults();

            $data['data'] = $patient->gettotalPatientEentry($data['perPage'], $data["page"], 0, 0, $hq_id);
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['userType'] = $session->get('userType');
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['userType'] = $session->get('userType');

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function add_user()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['data'] = $user->where('UserID', $id)->getRecords();
                $data['Name'] = $user->where('UserID', $id)->first();
                $data['controller'] = 'abm';

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('abm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function user_insert()
    {
        $user_insert = new User_Model;

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => 'BO',
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
            'isActive' => '1',
        ];
        $user_insert->save($data);
        return redirect()->to('abm/add_user');
    }

    public function user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $data['Name'] = $user->where('UserID', $id)->first();
        $data['controller'] = 'abm';

        $FrameModel = new Frame_Model();
        $campaign = $FrameModel->getAllCampaignsWithFrames();
        $data['campaigns'] = $campaign;

        return view('abm/user_edit', $data);
    }

    public function user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'DESIG' => $this->request->getVar('desig'),
            'pass' => 'telminorm',
            'isActive' => '1',
        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('abm/user_tbl');
    }

    public function user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('abm/user_tbl');
    }

    public function get_doctor_data_by_date()
    {
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $doctor = new Doctor_Model();

        $hq_id = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];
        $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
        $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
        $searchText = $this->request->getGet('searchText') ? $this->request->getGet('searchText') : "";
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $doctor = new Doctor_Model();
        $table_data = $doctor->getTotalDoctor($pagesize, $page, 0, 0, $hq_id, $startDate, $endDate, $searchText);

        $total = count($doctor->getTotalDoctor(0, 0, 0, 0, $hq_id, $startDate, $endDate, $searchText));

        return $this->response->setJSON(['table_data' => $table_data, 'total' => $total]);
    }

    public function get_patient_data_by_date()
    {
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $hq_id = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];
        $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
        $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
        $searchText = $this->request->getGet('searchText') ? $this->request->getGet('searchText') : "";
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $patient = new Patient_Model();
        $table_data = $patient->getTotalPatients($pagesize, $page, 0, 0, $hq_id, $startDate, $endDate, $searchText);

        $total = count($patient->getTotalPatients(0, 0, 0, 0, $hq_id, $startDate, $endDate, $searchText));

        return $this->response->setJSON(['table_data' => $table_data, 'total' => $total]);
    }

    public function get_rx_data_by_date()
    {
        $session = session();
        $user = new User_Model;
        $id = $session->get('UserID');
        $row = $user->where('UserID', $id)->first();

        $hq_id = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];
        $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
        $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
        $searchText = $this->request->getGet('searchText') ? $this->request->getGet('searchText') : "";
        $page = $this->request->getGet('page');
        $pagesize = $this->request->getGet('pagesize');

        $rx = new Rx_Model();
        $table_data = $rx->getTotalPatientsrx($pagesize, $page, 0, 0, $hq_id, $startDate, $endDate, $searchText);

        $total = count($rx->getTotalPatientsrx(0, 0, 0, 0, $hq_id, $startDate, $endDate, $searchText));

        return $this->response->setJSON(['table_data' => $table_data, 'total' => $total]);
    }


    public function generate_excel_by_total_doctors()
    {
        try {

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $doctor = new Doctor_Model();

            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];
            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";



            $data = $doctor->getTotalDoctor(0, 0, 0, 0, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Doctor Name', 'Cln./Hosp. Name', 'SBU Code', 'Phone', 'E-mail', 'Place', 'District', 'State', 'Country', 'Date', 'Employee', 'Emp. ID', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalDoctors.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['doctor'], $row['hospital'], $row['registration_no'], $row['phone'], $row['email'], $row['place'], $row['district'], $row['state'], $row['country'], $row['date'], $row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE']]);

            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_total_patients()
    {
        try {

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $patient = new Patient_Model();

            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];

            $data = $patient->getTotalPatients(0, 0, 0, 0, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Doctor', 'Name', 'Phone', 'Place', 'Gender', 'Age', 'Examination Date', 'Hypertension', 'Hypertension Drugs', 'Drugs Combination', 'ARB Prescription', 'ARB Dose', 'ACE-I Prescription', 'ACE-I Dose', 'BB Prescription', 'BB Dose', 'CCB Prescription', 'CCB Dose', 'Diuretic Prescription', 'Diuretic Dose', 'Other Prescription', 'Other Dose', 'SBP', 'DBP', 'Average SBP', 'Average DBP', 'Co-morbid Condition', 'Drugs for co-morbidity', 'Date', 'Employee', 'Emp. ID', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalPatient.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [
                    $row['doctor'],
                    $row['name'],
                    $row['phone'],
                    $row['place'],
                    $row['gender'],
                    $row['age'],
                    $row['examination'],
                    $row['hypertension'],
                    $row['hypertension_drugs'],
                    $row['drugs_combination'],
                    $row['arb'],
                    $row['arb_dose'],
                    $row['ace_i'],
                    $row['ace_i_dose'],
                    $row['bb'],
                    $row['bb_dose'],
                    $row['ccb'],
                    $row['ccb_dose'],
                    $row['diuretic'],
                    $row['diuretic_dose'],
                    $row['other'],
                    $row['other_dose'],
                    $row['sbp1'],
                    $row['dbp1'],
                    $row['average_sbp'],
                    $row['average_dbp'],
                    $row['co_morbid_conditions'],
                    $row['drugs_co_morbidity'],
                    $row['date'],
                    $row['user'],
                    $row['empno'],
                    $row['HQ'],
                    $row['REGION'],
                    $row['ZONE']
                ]);
            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_total_rx()
    {
        try {

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $rx = new Rx_Model();

            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];

            $data = $rx->getTotalPatientsrx(0, 0, 0, 0, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Patient Name', 'Patient Phone', 'Doctor Name', 'Quantity of Strips', 'Indication', 'Secondary', 'Prescription Information', 'Co-Morbidity Prescription', 'Date', 'Employee', 'Emp. ID', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalRx.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [
                    $row['patient_name'],
                    $row['phone_no'],
                    $row['doctor_name'],
                    $row['strips'],
                    $row['indication'],
                    $row['secondary'],
                    $row['prescription_information'],
                    $row['co_morbidity_prescription'],
                    $row['date'],
                    $row['user'],
                    $row['empno'],
                    $row['HQ'],
                    $row['REGION'],
                    $row['ZONE']
                ]);
            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_doctor_users_count()
    {
        try {


            $doctor = new Doctor_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];

            $data = $doctor->gettotalDoctorEentry(0, 0, 0, 0, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region', 'Zone', 'Totel Doctors'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="DoctorsUserCount.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_patient_users_count()
    {
        try {

            $patient = new Patient_Model;

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];

            $data = $patient->gettotalPatientEentry(0, 0, 0, 0, $hq, $startDate, $endDate);

            // CSV Header
            $header = ['Employee Name', 'Emp. ID', 'Area', 'Region', 'Zone', 'Totel Patients'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="PatientUsersCount.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['user'], $row['empno'], $row['HQ'], $row['REGION'], $row['ZONE'], $row['entry_count']]);
            }

            // Close the output stream
            fclose($file);
            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }

    public function generate_excel_by_user_tbl()
    {
        try {

            $rx = new Rx_Model();

            $session = session();
            $user = new User_Model;
            $id = $session->get('UserID');
            $row = $user->where('UserID', $id)->first();

            $startDate = $this->request->getGet('startDate') ? $this->request->getGet('startDate') : "";
            $endDate = $this->request->getGet('endDate') ? $this->request->getGet('endDate') : "";
            $hq = $this->request->getGet('hq') ? $this->request->getGet('hq') : $row['HQ'];

            $user = new User_Model;
            $data = $user->getTotalUser(0, 0, 0, 0, $hq);


            // CSV Header
            $header = ['Employee Name', 'Phone', 'Email', 'Emp. ID', 'Designation', 'City', 'Area', 'Region', 'Zone'];

            // Create a file pointer connected to the output stream
            $file = fopen('php://output', 'w');

            // Set headers to prompt download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment;filename="TotalUser.csv"');

            // Output the header
            fputcsv($file, $header);


            //print_r(count($data));
            // Output each row of the data
            foreach ($data as $row) {
                fputcsv($file, [$row['Name'], $row['phoneNO'], $row['mail'], $row['empNO'], $row['DESIG'], $row['city'], $row['HQ'], $row['REGION'], $row['ZONE']]);

            }

            // Close the output stream
            fclose($file);

            exit;
        }
        //catch exception
        catch (Exception $e) {
            echo 'Message: ' . $e->getMessage();
        }

    }



    public function totel_poster()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $posterModel->getPosterWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function totel_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $videosModel->getVideosWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function total_poster()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $posterModel->getPosterWithUsersDetailsByHq($hq_id);


            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function birthday_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Birthday_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByHq($hq_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/birthday_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function anniversary_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Anniversary_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByHq($hq_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';


            return view('admin/anniversary_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function brandreminder_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Brandreminder_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByHq($hq_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/brandreminder_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function thankyou_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Thankyou_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByHq($hq_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/thankyou_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function missyou_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $poster = new Missyou_Poster_Model;
            $id = $session->get('UserID');

            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $poster->getPosterWithUsersDetailsByHq($hq_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/missyou_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function total_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $videosModel->getVideosWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_birthday_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $VideoModel = new Birthday_Video_Model;

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $VideoModel->getVideosWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;
            $data['controller'] = 'abm';

            return view('admin/birthday_videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_anniversary_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $VideoModel = new Anniversary_Video_Model();

            $id = $session->get('UserID');
            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $VideoModel->getVideosWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;
            $data['controller'] = 'abm';

            return view('admin/anniversary_videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function total_festival_videos()
    {
        $session = session();
        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $video = new Festival_Video_Model;

            $id = $session->get('UserID');
            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $video->getVideosWithUsersDetailsByHq($hq_id);
            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;
            $data['controller'] = 'abm';

            return view('admin/festival_videos', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function users_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            // Fetch user count data for the same region
            $data['data'] = $posterModel->getUserCountByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function users_date_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $posterModel->getEntryByDateByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function select_posters()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/select_posters_type', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function poster_selection()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $language = new Language_Model;

            $language_array = $language->getRecords();
            $data['language'] = $language_array;


            return view('admin/poster_selection', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;


            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';
            $data['Name'] = $user->where('UserID', $id)->first();

            return view('admin/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function poster_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function birthday_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $birthday = new Birthday_Frame_Model();

            $birthday_array = $birthday->getRecords();
            $data['data'] = $birthday_array;

            return view('admin/birthday_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Birthday_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $id = $session->get('UserID');
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/birthday_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_birthday_poster()
    {
        $poster = new Birthday_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function birthday_poster_download_status()
    {
        $poster = new Birthday_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_poster_share_status()
    {
        $poster = new Birthday_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function anniversary_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $anniversary = new anniversary_Frame_Model();

            $anniversary_array = $anniversary->getRecords();
            $data['data'] = $anniversary_array;

            return view('admin/anniversary_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new anniversary_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/anniversary_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_anniversary_poster()
    {
        $poster = new Anniversary_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function anniversary_poster_download_status()
    {
        $poster = new Anniversary_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_poster_share_status()
    {
        $poster = new Anniversary_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }



    public function brandreminder_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $brandreminder = new brandreminder_Frame_Model();

            $brandreminder_array = $brandreminder->getRecords();
            $data['data'] = $brandreminder_array;

            return view('admin/brandreminder_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function brandreminder_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new brandreminder_Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/brandreminder_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_brandreminder_poster()
    {
        $poster = new Brandreminder_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function brandreminder_poster_download_status()
    {
        $poster = new Brandreminder_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function brandreminder_poster_share_status()
    {
        $poster = new Brandreminder_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function thankyou_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $thankyou = new thankyou_Frame_Model();

            $thankyou_array = $thankyou->getRecords();
            $data['data'] = $thankyou_array;

            return view('admin/thankyou_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function thankyou_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new thankyou_Frame_Model;
            $brands = new Brands_Model;

            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $brands_data = $brands->getRecords();
            $data['brands'] = $brands_data;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/thankyou_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_thankyou_poster()
    {
        $poster = new Thankyou_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'brand' => $this->request->getPost('input_text4'),
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function thankyou_poster_download_status()
    {
        $poster = new Thankyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function thankyou_poster_share_status()
    {
        $poster = new Thankyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }



    public function missyou_posters()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $missyou = new Missyou_Frame_Model();

            $missyou_array = $missyou->getRecords();
            $data['data'] = $missyou_array;

            return view('admin/missyou_posters', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function missyou_poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Missyou_Frame_Model;
            $brands = new Brands_Model;

            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $brands_data = $brands->getRecords();
            $data['brands'] = $brands_data;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/missyou_poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_missyou_poster()
    {
        $poster = new Missyou_Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'brand' => $this->request->getPost('input_text4'),
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function missyou_poster_download_status()
    {
        $poster = new Missyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function missyou_poster_share_status()
    {
        $poster = new Missyou_Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function select_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();

            $id = $session->get('UserID');

            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('admin/select_video_type', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function video_maker()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_video()
    {
        $video = new Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function video_download_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_share_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $birthday = new Birthday_Video_Frame_Model();

            $birthday_array = $birthday->getRecords();
            $data['data'] = $birthday_array;

            return view('admin/birthday_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function birthday_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Birthday_Video_Frame_Model;

            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/birthday_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_birthday_video()
    {
        $video = new Birthday_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function birthday_video_download_status()
    {
        $poster = new Birthday_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function birthday_video_share_status()
    {
        $poster = new Birthday_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function anniversary_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $anniversary = new Anniversary_Video_Frame_Model();

            $anniversary_array = $anniversary->getRecords();
            $data['data'] = $anniversary_array;

            return view('admin/anniversary_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function anniversary_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Anniversary_Video_Frame_Model;

            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/anniversary_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_anniversary_video()
    {
        $video = new Anniversary_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function anniversary_video_download_status()
    {
        $poster = new Anniversary_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function anniversary_video_share_status()
    {
        $poster = new Anniversary_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function festival_video()
    {
        $session = session();
        if ($session->has('UserID')) {

            $userModel = new User_Model();
            $id = $session->get('UserID');
            $data['Name'] = $userModel->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            $festival = new Festival_Video_Frame_Model();

            $festival_array = $festival->getRecords();
            $data['data'] = $festival_array;

            return view('admin/festival_video', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function festival_video_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Festival_Video_Frame_Model;

            $photo_frame = $frame->getRow($id);
            $data['video_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();
            $data['Name'] = $user->where('UserID', $id)->first();
            $data['controller'] = 'abm';

            return view('admin/festival_video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_festival_video()
    {
        $video = new Festival_Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frame_id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function festival_video_download_status()
    {
        $video = new Festival_Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $video->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

}