<?php

namespace App\Models;

use CodeIgniter\Model;

class Doctor_Model extends Model
{
    protected $table = 'doctor_data';
    protected $allowedFields = ['id', 'doctor', 'hospital', 'registration_no', 'phone', 'email', 'place', 'district', 'state', 'country', 'user', 'user_id', 'empno', 'hq_id', 'region_id', 'zone_id', 'date'];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }

    public function checkPhoneExists($phone)
    {
        $query = $this->where('phone', $phone)->countAllResults();
        return ($query > 0) ? true : false;
    }
    public function checkPhoneAndIdExists($phone, $id)
    {
        $doctor = $this->where('phone', $phone)->first();

        if (!$doctor) {
            return 'exists';
        } elseif ($doctor['id'] == $id) {
            return 'id_match';
        } elseif ($doctor['id'] != $id) {
            return 'phone_only';
        }
    }


    public function getTotalDoctors()
    {
        return $this->select(' COUNT(*) as total ')
            ->groupBy('doctor, user, date')
            ->findAll()
        ;
    }

    // public function getTotalData()
    // {
    //     return $this->select('doctor_data.date, COUNT(DISTINCT doctor_data.id) as total_doctors, COUNT(DISTINCT patient_data.id) as total_patients, COUNT(DISTINCT rx_data.id) as total_rx')
    //                 ->join('patient_data', 'patient_data.dr_id = doctor_data.id', 'left')
    //                 ->join('rx_data', 'rx_data.doctor_id = doctor_data.id', 'left')
    //                 ->groupBy('doctor_data.date')
    //                 ->findAll();
    // }


//     public function getTotalData()
// {
//     $doctorData = $this->db->table('doctor_data')
//                     ->select('doctor_data.date as entry_date, COUNT(DISTINCT doctor_data.id) as total_doctors, 0 as total_patients, 0 as total_rx')
//                     ->groupBy('doctor_data.date');
                    
//     $patientData = $this->db->table('patient_data')
//                      ->select('patient_data.date as entry_date, 0 as total_doctors, COUNT(DISTINCT patient_data.id) as total_patients, 0 as total_rx')
//                      ->groupBy('patient_data.date');
                     
//     $rxData = $this->db->table('rx_data')
//                 ->select('rx_data.date as entry_date, 0 as total_doctors, 0 as total_patients, COUNT(DISTINCT rx_data.id) as total_rx')
//                 ->groupBy('rx_data.date');
    
//     // Subqueries
//     $subQuery1 = $doctorData->getCompiledSelect();
//     $subQuery2 = $patientData->getCompiledSelect();
//     $subQuery3 = $rxData->getCompiledSelect();
    
//     // Union the results
//     $results = $this->db->query("
//         SELECT entry_date, SUM(total_doctors) as total_doctors, SUM(total_patients) as total_patients, SUM(total_rx) as total_rx FROM ( ($subQuery1) UNION ALL ($subQuery2) UNION ALL ($subQuery3) ) as combined_data GROUP BY entry_date ")
//        ->getResult();
    
//     return $results;
// }



    public function getTotalDoctorUser()
    {
        return $this->select('user, COUNT(*) AS entry_count')
            ->groupBy('doctor,date')
            ->getRecords();
    }

    public function getDoctorUser()
    {
        return $this->select('*')
            ->groupBy('doctor, date')
            ->orderBy('id', 'DESC')
            ->findAll();

    }
    public function getTotalDoctor()
    {
        return $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->groupBy(' doctor, user, date')
            ->orderBy('id', 'DESC')
            ->findAll();
    }

    public function getTableDataByZone($zone_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('zone_id', $zone_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getTableDataByRegion($region_id, $zone_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getTableDataByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneDoctorByRegion($region_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneDoctorByHQ($hq_id, $region_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionDoctorByHQ($hq_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function gettotalDoctorEentry()
    {
        return $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->findAll()
        ;
    }

    public function getUserDoctorByZone($zone_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getUserDoctorByRegion($region_id, $zone_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getUserDoctorByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneUserDoctorByRegion($region_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneUserDoctorByHQ($hq_id, $region_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionUserDoctorByHQ($hq_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

}


?>