<?php

namespace App\Models;

use CodeIgniter\Model;

class Patient_Model extends Model
{
    protected $table = 'patient_data';
    protected $allowedFields = [
        'id', 'name', 'phone', 'place', 'examination', 'age', 'gender', 'hypertension', 'hypertension_drugs', 'drugs_combination', 'arb', 'arb_dose', 'ace_i', 'ace_i_dose', 'bb', 'bb_dose', 'ccb', 'ccb_dose', 'diuretic', 'diuretic_dose', 'other', 'other_dose', 'sbp1', 'dbp1', 'sbp2', 'dbp2', 'sbp3', 'dbp3', 'average_sbp', 'average_dbp', 'co_morbid_conditions', 'drugs_co_morbidity', 'dr_id', 'user_id', 'user', 'empno', 'hq_id', 'region_id', 'zone_id', 'status', 'date'
    ];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this->findAll();
    }

    public function getPatientsbyUser()
    {
        return $this->select('patient_data.*,doctor_data.doctor')
        ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
        ->groupBy('name, dr_id, user, date')
        ->findAll();
    }
    
    public function getPatientData($name, $date)
    {
        return $this->where('patient_data.name', $name)
                    ->where('patient_data.date', $date)
                    ->select('patient_data.*,doctor_data.doctor')
                    ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
                    ->first();
    }


    public function findByPhoneNumber_corrt($phoneNumber)
    {
        return $this->where('phone', $phoneNumber)->first();
    }

    public function findByPhoneNumber($phoneNumber)
    {
        return $this->where('patient_data.phone', $phoneNumber)
            ->select('patient_data.*,doctor_data.doctor')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->first();
    }

    public function getRow($id)
    {
        return $this->where('patient_data.id', $id)
            ->select('patient_data.*,doctor_data.doctor')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->first();
    }


    public function getTotalPatient()
    {
        return $this->select(' COUNT(*) as total ')
            ->groupBy('name, user, date')
            ->findAll()
        ;
    }

    public function getTotalPatientUser()
    {
        return $this->select('user, COUNT(*) AS entry_count')
            ->groupBy('name,date')
            ->getRecords();
    }

    public function getPatientUser()
    {
        return $this->select('patient_data.*,doctor_data.doctor')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->groupBy('name, date')
            ->orderBy('id', 'DESC')
            ->findAll();

    }


    public function getTotalPatients()
    {
        return $this->select('patient_data.*,doctor_data.doctor,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->groupBy('patient_data.name,patient_data.user, patient_data.date')
            ->orderBy('patient_data.id', 'DESC')
            ->findAll();
    }

    public function getPatientDataByZone($zone_id)
    {
        $query = $this->select('patient_data.*, doctor_data.doctor, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.zone_id', $zone_id) 
            ->groupBy('name, doctor, user, date')
            ->orderBy('patient_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getPatientDataByRegion($region_id, $zone_id)
    {
        $query = $this->select('patient_data.*, doctor_data.doctor, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.region_id', $region_id)
            ->where('patient_data.zone_id', $zone_id) 
            ->groupBy('name, doctor, user, date')
            ->orderBy('patient_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getPatientDataByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('patient_data.*, doctor_data.doctor, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.hq_id', $hq_id)
            ->where('patient_data.region_id', $region_id)
            ->where('patient_data.zone_id', $zone_id)
            ->groupBy('name, doctor, user, date')
            ->orderBy('patient_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    
    public function getZonePatientByRegion($region_id)
    {
        $query = $this->select('patient_data.*, doctor_data.doctor, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.region_id', $region_id)
            ->groupBy('name, doctor, user, date')
            ->orderBy('patient_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZonePatientByHQ($hq_id, $region_id)
    {
        $query = $this->select('patient_data.*, doctor_data.doctor, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.hq_id', $hq_id)
            ->where('patient_data.region_id', $region_id)
            ->groupBy('name, doctor, user, date')
            ->orderBy('patient_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionPatientByHQ($hq_id)
    {
        $query = $this->select('patient_data.*, doctor_data.doctor, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.hq_id', $hq_id)
            ->groupBy('name, doctor, user, date')
            ->orderBy('patient_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function gettotalPatientEentry()
    {
        return $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
        ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
        ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
        ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->findAll()
        ;
    }

    public function getUserPatientByZone($zone_id)
    {
        $query = $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.zone_id', $zone_id)
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getUserPatientByRegion($region_id, $zone_id)
    {
        $query = $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.region_id', $region_id)
            ->where('patient_data.zone_id', $zone_id) 
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getUserPatientByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.hq_id', $hq_id)
            ->where('patient_data.region_id', $region_id)
            ->where('patient_data.zone_id', $zone_id)
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneUserPatientByRegion($region_id)
    {
        $query = $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.region_id', $region_id)
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneUserPatientByHQ($hq_id, $region_id)
    {
        $query = $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.hq_id', $hq_id)
            ->where('patient_data.region_id', $region_id)
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionUserPatientByHQ($hq_id)
    {
        $query = $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('patient_data.hq_id', $hq_id)
            ->groupBy('patient_data.user_id, patient_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function findPatientbyUser($user_id)

    {

        return $this->distinct('patient_data.id')->select('patient_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')

            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')

            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')

            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')

            ->where('patient_data.user_id', $user_id)

            ->findAll();

    }

    public function findPatientbyHQ($user_id)

    {

        return $this->distinct('patient_data.id')->select('patient_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')

            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')

            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')

            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')

            ->join('patient_data', 'patient_data.hq_id = tbl_user.HQ', 'left')

            ->join('tbl_user', 'tbl_user.UserID = '.$user_id)

            ->findAll();

    }

    public function findPatientbyRegion($user_id)

    {

        return $this->distinct('patient_data.id')->select('patient_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')

            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')

            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')

            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')

            ->join('patient_data', 'patient_data.region_id = tbl_user.REGIONId', 'left')

            ->join('tbl_user', 'tbl_user.UserID = '.$user_id)

            ->findAll();

    }

    public function findPatientbyZone($user_id)

    {

        return $this->distinct('patient_data.id')->select('patient_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')

            ->join('tbl_hq', 'patient_data.hq_id = tbl_hq.HQID', 'left')

            ->join('tbl_region', 'patient_data.region_id = tbl_region.REGIONId', 'left')

            ->join('tbl_zone', 'patient_data.zone_id = tbl_zone.ZONEId', 'left')

            ->join('patient_data', 'patient_data.zone_id = tbl_user.zoneId', 'left')

            ->join('tbl_user', 'tbl_user.UserID = '.$user_id)

            ->findAll();

    }

    

}


?>