<?php

namespace App\Models;

use CodeIgniter\Model;

class Rx_Model extends Model
{
    protected $table = 'rx_data';
    protected $allowedFields = [ 'id', 'image', 'doctor_name', 'patient_name', 'phone_no', 'quantity', 'strips', 'indication', 'secondary', 'prescription_information', 'co_morbidity_prescription', 'patient_id', 'doctor_id', 'user_id', 'user', 'empno', 'hq_id', 'region_id', 'zone_id', 'date'];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this -> orderBy('id','DESC')->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }


    // public function getTotalData()
    // {
    //     return $this->select('rx_data.empno, rx_data.user, rx_data.date as rx_date, 
    //             doctor_data.id, doctor, registration_no, 
    //             tbl_zone.ZONE, tbl_region.REGION, tbl_hq.HQ, 
    //             COUNT(DISTINCT patient_data.id) as total_patients, 
    //             COUNT(DISTINCT CASE WHEN rx_data.prescription_information != "Non-Prescriber" THEN rx_data.id ELSE NULL END) as total_telminorm, 
    //             COUNT(DISTINCT CASE WHEN rx_data.co_morbidity_prescription LIKE "%RXtor%" THEN rx_data.id ELSE NULL END) as total_rxtor, 
    //             COUNT(DISTINCT CASE WHEN rx_data.co_morbidity_prescription LIKE "%Suitglip%" THEN rx_data.id ELSE NULL END) as total_suitglip, 
    //             COUNT(DISTINCT CASE WHEN rx_data.co_morbidity_prescription LIKE "%Glyree%" THEN rx_data.id ELSE NULL END) as total_glyree')
    //         ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
    //         ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
    //         ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
    //         ->join('patient_data', 'patient_data.dr_id = rx_data.doctor_id', 'left')
    //         ->join('doctor_data', 'doctor_data.id = rx_data.doctor_id', 'left')
    //         ->where('rx_data.prescription_information !=', 'Non-Prescriber')
    //         ->orWhere('rx_data.co_morbidity_prescription !=', 'Non-Prescriber')
    //         ->groupBy('rx_data.date, doctor_data.doctor')
    //         ->findAll();
    // }


    // public function getTotalData()
    // {
    //     $results = $this->select('rx_data.empno, rx_data.user, rx_data.date as rx_date, 
    //             doctor_data.id, doctor, registration_no, 
    //             tbl_zone.ZONE, tbl_region.REGION, tbl_hq.HQ')
    //         ->select('GROUP_CONCAT(DISTINCT rx_data.prescription_information ORDER BY rx_data.prescription_information SEPARATOR ", ") as prescription_info')
    //         ->select('COUNT(DISTINCT patient_data.id) as total_patients')
    //         ->select('COUNT(DISTINCT CASE WHEN rx_data.co_morbidity_prescription LIKE "%RXtor%" THEN rx_data.id ELSE NULL END) as total_rxtor')
    //         ->select('COUNT(DISTINCT CASE WHEN rx_data.co_morbidity_prescription LIKE "%Suitglip%" THEN rx_data.id ELSE NULL END) as total_suitglip')
    //         ->select('COUNT(DISTINCT CASE WHEN rx_data.co_morbidity_prescription LIKE "%Glyree%" THEN rx_data.id ELSE NULL END) as total_glyree')
    //         ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
    //         ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
    //         ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
    //         ->join('patient_data', 'patient_data.dr_id = rx_data.doctor_id', 'left')
    //         ->join('doctor_data', 'doctor_data.id = rx_data.doctor_id', 'left')
    //         ->where('rx_data.prescription_information !=', 'Non-Prescriber')
    //         ->orWhere('rx_data.co_morbidity_prescription !=', 'Non-Prescriber')
    //         ->groupBy('rx_data.date, doctor_data.doctor')
    //         ->findAll();
    
    //     foreach ($results as &$row) {
    //         if (!empty($row['prescription_info'])) {
    //             $prescription_info_values = array_map('trim', explode(',', $row['prescription_info']));
    //             $prescription_info_values = array_filter($prescription_info_values, function($value) {
    //                 return $value !== 'Non-Prescriber';
    //             });
    //             $distinct_count = count($prescription_info_values);
    //             $row['total_prescription_info'] = $distinct_count;
    //         } else {
    //             $row['total_prescription_info'] = 0;
    //         }
    //     }
    
    //     return $results;
    // }
    

    public function getTotalData()
    {
        $results = $this->select('rx_data.empno, rx_data.user, rx_data.date as rx_date, 
                doctor_data.id, doctor, registration_no, 
                tbl_user.city, tbl_zone.ZONE, tbl_region.REGION, tbl_hq.HQ')
            ->select('GROUP_CONCAT(DISTINCT rx_data.prescription_information ORDER BY rx_data.prescription_information SEPARATOR ", ") as prescription_info')
            ->select('COUNT(DISTINCT patient_data.id) as total_patients')
            ->select('GROUP_CONCAT(DISTINCT rx_data.co_morbidity_prescription ORDER BY rx_data.co_morbidity_prescription SEPARATOR ", ") as co_morbidity_prescription')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_user', 'rx_data.user_id = tbl_user.UserID', 'left')
            ->join('patient_data', 'patient_data.dr_id = rx_data.doctor_id', 'left')
            ->join('doctor_data', 'doctor_data.id = rx_data.doctor_id', 'left')
            ->where('rx_data.prescription_information !=', 'Non-Prescriber')
            ->orWhere('rx_data.co_morbidity_prescription !=', 'Non-Prescriber')
            ->groupBy('rx_data.date, doctor_data.doctor, rx_data.empno, rx_data.user, doctor_data.id, doctor, registration_no, tbl_zone.ZONE, tbl_region.REGION, tbl_hq.HQ')
            ->findAll();
        foreach ($results as &$row) {
            if (!empty($row['prescription_info'])) {
                $prescription_info_values = array_map('trim', explode(',', $row['prescription_info']));
                $prescription_info_values = array_filter($prescription_info_values, function($value) {
                    return $value !== 'Non-Prescriber';
                });
                $distinct_count = count($prescription_info_values);
                $row['total_prescription'] = $distinct_count;
            } else {
                $row['total_prescription'] = 0;
            }
            $total_rxtor = 0;
            $total_suitglip = 0;
            $total_glyree = 0;
            if (!empty($row['co_morbidity_prescription'])) {
                $co_morbidity_values = array_map('trim', explode(',', $row['co_morbidity_prescription']));
                foreach ($co_morbidity_values as $value) {
                    if (stripos($value, 'RXtor') !== false) {
                        $total_rxtor++;
                    }
                    if (stripos($value, 'Suitglip') !== false) {
                        $total_suitglip++;
                    }
                    if (stripos($value, 'Glyree') !== false) {
                        $total_glyree++;
                    }
                }
            }
            $row['total_rxtor'] = $total_rxtor;
            $row['total_suitglip'] = $total_suitglip;
            $row['total_glyree'] = $total_glyree;
        }
    
        return $results;
    }

    
    



    public function getTotalRxUser()
    {
        return $this->select('user_id, COUNT(*) AS entry_count')
            ->groupBy('id,date')
            ->getRecords();
    }

    public function getTotalPatientsrx()
    {
        return $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->orderBy('rx_data.id', 'DESC')
            ->findAll();
    }

    public function getRxByZone($zone_id)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.zone_id', $zone_id)
            ->orderBy('rx_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRxByRegion($region_id, $zone_id)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.region_id', $region_id)
            ->where('rx_data.zone_id', $zone_id)
            ->orderBy('rx_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRxByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.hq_id', $hq_id)
            ->where('rx_data.region_id', $region_id)
            ->where('rx_data.zone_id', $zone_id)
            ->orderBy('rx_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneRxByRegion($region_id)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.region_id', $region_id)
            ->orderBy('rx_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneRxByHQ($hq_id, $region_id )
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.hq_id', $hq_id)
            ->where('rx_data.region_id', $region_id)
            ->orderBy('rx_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionRxByHQ($hq_id)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.hq_id', $hq_id)
            ->orderBy('rx_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }
    
    
    public function findPatientRxbyUser($user_id)
   {
       return $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
           ->where('rx_data.user_id', $user_id)
           ->findAll();
   }
   public function findPatientRxbyHQ($user_id)
   {
       return $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
           ->join('rx_data', 'rx_data.hq_id = tbl_user.HQ', 'left')
           ->join('tbl_user', 'tbl_user.UserID = '.$user_id)
           ->findAll();
   }
   public function findPatientRxbyRegion($user_id)
   {
       return $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
           ->join('rx_data', 'rx_data.region_id = tbl_user.REGIONId', 'left')
           ->join('tbl_user', 'tbl_user.UserID = '.$user_id)
           ->findAll();
   }
   public function findPatientRxbyZone($user_id)
   {
       return $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
           ->join('rx_data', 'rx_data.zone_id = tbl_user.zoneId', 'left')
           ->join('tbl_user', 'tbl_user.UserID = '.$user_id)
           ->findAll();
   }

}


?>