<?php

namespace App\Models;

use CodeIgniter\Model;

class User_Model extends Model
{
    protected $table = 'tbl_user';
    protected $allowedFields = ['UserID ', 'Name', 'mail', 'pass', 'userImg', 'userType', 'HQ', 'city', 'createdBy', 'empNO', 'DESIG', 'phoneNO', 'REGIONId', 'zoneId'];

    public function getRecords()
    {
        return $this->findAll();
    }

    public function getRow($id)
    {
        return $this->where('UserID ', $id)->first();
    }
    public function getTotalUsers()
    {
        return $this->countAllResults();
    }
    public function getTotalUser()
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->orderBy('tbl_user.UserID', 'ASC')
            ->findAll();
    }

    public function getUserDataByZone($zone_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zone_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getUserDataByRegion($region_id, $zone_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zone_id)
            ->where('tbl_user.REGIONId', $region_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getUserDataByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zone_id)
            ->where('tbl_user.REGIONId', $region_id)
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getProfile()
    {
        return $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->findAll();
    }

    public function getZoneUserByRegion($region_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $region_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }
    public function getZoneUserByHQ($hq_id, $region_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $region_id)
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionUserByHQ($hq_id)
    {
        $query = $this->select('tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hq_id)
            ->orderBy('tbl_user.UserID', 'ASC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

}




?>