<!DOCTYPE html>
<html lang="en">

<?php include("head.php") ?>

<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>

        <div class="container-fluid "><br>
            <div class="row">
                <div class="col-sm-12 ">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">Doctor Edit</h3>
                        <a href="<?php echo site_url($controller . '/u_doctors'); ?>" class="btn btn-primary btn">My
                            Doctors</a><br>
                        <form id="doctorForm" action="<?php echo site_url($controller . '/doctor_update') ?>"
                            method="post" onsubmit="return validateForm()" enctype="multipart/form-data">
                            <div class="col-sm-12 row">
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Doctor Name</label>
                                    <input required type="text" class="form-control" placeholder="Doctor Name"
                                        value="<?= $row['doctor']; ?>" name="doctor"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Clinic / Hospital Name</label>
                                    <input required type="text" class="form-control"
                                        placeholder="Clinic / Hospital Name" value="<?= $row['hospital']; ?>"
                                        name="hospital"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> SBU Code</label>
                                    <input required type="text" class="form-control" placeholder="SBU Code"
                                        value="<?= $row['registration_no']; ?>" name="registration_no"
                                        maxlength="16"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Phone</label>
                                    <input required type="tel" class="form-control" name="phone" id="phone"
                                        value="<?= $row['phone']; ?>" pattern="[6-9]{1}[0-9]{9}"
                                        placeholder="Phone"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> E-mail</label>
                                    <input required type="email" class="form-control" placeholder="E-mail"
                                        value="<?= $row['email']; ?>" name="email"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Place</label>
                                    <input required type="text" class="form-control" placeholder="Place"
                                        value="<?= $row['place']; ?>" name="place"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> District</label>
                                    <input required type="text" class="form-control" placeholder="District"
                                        value="<?= $row['district']; ?>" name="district"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> State</label>
                                    <input required type="text" class="form-control" placeholder="State"
                                        value="<?= $row['state']; ?>" name="state"><br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Country</label>
                                    <input required type="text" class="form-control" placeholder="Country"
                                        value="<?= $row['country']; ?>" name="country"><br>
                                </div>
                                <input class=" input" type="hidden" required name="id" value="<?= $row['id']; ?>">


                            </div>
                            <center>

                                <div class="col-xs-12 ">
                                    <br>

                                    <!-- Change this in your HTML -->
                                    <input type="submit" class="btn btn-primary" name="submit_btn" value="submit">
                                </div>
                            </center>
                        </form>


                    </div>
                </div>
            </div>
            <div class=" ">
                <br>
            </div>
        </div>


    </div>


    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <?php include("footer.php") ?>


</body>
<script>
    function validateForm() {
            var doctor = document.forms["doctorForm"]["doctor"].value.trim();
            var hospital = document.forms["doctorForm"]["hospital"].value.trim();
            var registration_no = document.forms["doctorForm"]["registration_no"].value.trim();
            var phone = document.forms["doctorForm"]["phone"].value.trim();
            var email = document.forms["doctorForm"]["email"].value.trim();
            var place = document.forms["doctorForm"]["place"].value.trim();
            var district = document.forms["doctorForm"]["district"].value.trim();
            var state = document.forms["doctorForm"]["state"].value.trim();
            var country = document.forms["doctorForm"]["country"].value.trim();
            if (doctor == "" || hospital == "" || registration_no == "" || phone == "" || email == "" ||
                place == "" || district == "" || state == "" || country == "") {
                alert("Please fill out all fields");
                return false;
            }
            if (phone.length != 10 || isNaN(phone)) {
                alert("Please enter a valid 10-digit phone number");
                return false;
            }
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailPattern.test(email)) {
                alert("Please enter a valid email address");
                return false;
            }
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function() {
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (xhr.status === 200) {
                        var response = xhr.responseText;
                        if (response === "exists") {
                            alert("Phone number already exists. Please use a different one.");
                        } else {
                            document.getElementById("doctorForm").submit();
                        }
                    } else {
                        alert("Error checking phone number");
                    }
                }
            };
            xhr.open("POST", "<?php echo site_url('user/check_phone_exists') ?>", true);
            xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            validateFormxhr.send("phone=" + phone);
            return false;
        }
</script>

</html>