<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">My Doctors</h3>
                        <div class="table-responsive">                           
                            <table class="table" id="myTable" style="">
                                <thead>
                                    <tr>
                                    <th scope="col">S. No.</th>
                                    <th scope="col">Add Patient</th>
                                    <th scope="col">Doctor Name</th>
                                    <th scope="col">Cln./Hosp. Name</th>
                                    <th scope="col">SBU Code</th>
                                    <th scope="col">Phone</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Place / District </th>
                                    <th scope="col">State / Country</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Edit</th>
                                </tr>
                                </thead>
                                <tbody>
                                   <?php
                                $serial = 0;
                                if (!empty($data)) {
                                    foreach ($data as $row) {
                                        $serial++;
                                        ?>
                                        <tr>
                                            <td><?php echo $serial ?></td>
                                            <td>
                                                <a href="<?php echo site_url($controller. '/add_patient/' . $row['id']) ?>" style="border-radius: 3px;" class="btn btn-primary"><i class="bi bi-person-plus"></i></a>
                                            </td>
                                            <td><?php echo $row['doctor']; ?></td>
                                            <td><?php echo $row['hospital']; ?></td>
                                            <td><?php echo $row['registration_no']; ?></td>
                                            <td><?php echo $row['phone']; ?></td>
                                            <td><?php echo $row['email']; ?></td>
                                            <td><?php echo $row['place']; ?> / <?php echo $row['district']; ?></td>
                                            <td><?php echo $row['state']; ?> /<?php echo $row['country']; ?></td>
                                            <td><?php echo $row['date']; ?></td>
                                            <td>
                                                <a href="<?php echo site_url($controller. '/doctor_edit/' . $row['id']) ?>"
                                                    style="border-radius: 3px;" class="btn btn-primary"><i class="bi bi-pencil-square"></i></a>
                                            </td>
                                        </tr>
                                    <?php }
                                } else { ?>
                                <?php } ?>
                                </tbody>
                            </table>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>

    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>

</body>
</html>