<!DOCTYPE html>
<html lang="en">

<?php include("head.php") ?>

<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>

        <div class="container-fluid"><br>
            <div class="row">
                <div class="col-sm-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">Prescription Information</h3>

                        <form id="rxForm" action="<?= site_url($controller. '/rx_data') ?>" method="post" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="patient_name" class="form-label">Patient Name</label>
                                    <input type="text" class="form-control" id="patient_name" required name="patient_name" 
                                           placeholder="Patient Name" value="<?php echo $patientData['name'] ?? '' ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="doctor_name" class="form-label">Doctor Name</label>
                                    <input type="text" class="form-control" id="doctor_name" required name="doctor_name" 
                                           placeholder="Doctor Name" value="<?php echo $patientData['doctor'] ?? '' ?>">
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="phone_number" class="form-label">Patient Phone</label>
                                    <input type="tel" class="form-control" id="phone_number" name="phone_number" 
                                           pattern="[6-9]{1}[0-9]{9}" placeholder="Patient Phone" 
                                           value="<?php echo $patientData['phone'] ?? '' ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="strips" class="form-label">Quantity of Strips</label>
                                    <input type="number" class="form-control" id="strips" required name="strips" 
                                           placeholder="Quantity of Strips">
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="indication" class="form-label">Indication</label>
                                    <input type="text" class="form-control" id="indication" name="indication" 
                                           placeholder="Indication">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="secondary" class="form-label">Units of Current Secondary</label>
                                    <input type="number" class="form-control" id="secondary" required name="secondary" 
                                           placeholder="Units of Current Secondary">
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Prescription Information</label>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="prescriptionDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                            Select Prescription Options
                                        </button>
                                        <div class="dropdown-menu p-3" style="width: 100%; min-width: 300px;" aria-labelledby="prescriptionDropdown">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Telminorm 20" id="telminorm20">
                                                <label class="form-check-label" for="telminorm20">Telminorm 20</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Telminorm 40" id="telminorm40">
                                                <label class="form-check-label" for="telminorm40">Telminorm 40</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Telminorm AM 40/5" id="telminormAM">
                                                <label class="form-check-label" for="telminormAM">Telminorm AM 40/5</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Telminorm BXL 40/25" id="telminormBXL25">
                                                <label class="form-check-label" for="telminormBXL25">Telminorm BXL 40/25</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Telminorm BXL 40/50" id="telminormBXL50">
                                                <label class="form-check-label" for="telminormBXL50">Telminorm BXL 40/50</label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Emnorm Range" id="emnormRange">
                                                <label class="form-check-label" for="emnormRange">Emnorm Range</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input prescription-checkbox" type="checkbox" name="prescription_information[]" value="Non-Prescriber" id="nonPrescriber">
                                                <label class="form-check-label" for="nonPrescriber">Non-Prescriber</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="prescriptionSelected" class="mt-2 small text-muted">No options selected</div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Co-Morbidity Prescription</label>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="comorbidityDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                            Select Co-Morbidity Options
                                        </button>
                                        <div class="dropdown-menu p-3" style="width: 100%; min-width: 250px;" aria-labelledby="comorbidityDropdown">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input comorbidity-checkbox" type="checkbox" name="co_morbidity_prescription[]" value="Emnorm Range" id="coEmnorm">
                                                <label class="form-check-label" for="coEmnorm">Emnorm Range</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input comorbidity-checkbox" type="checkbox" name="co_morbidity_prescription[]" value="Non-Prescriber" id="coNonPrescriber">
                                                <label class="form-check-label" for="coNonPrescriber">Non-Prescriber</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="comorbiditySelected" class="mt-2 small text-muted">No options selected</div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="image" class="form-label">Upload Prescription Image</label>
                                    <input class="form-control" type="file" id="image" name="image" 
                                           accept="image/webp,image/png,image/jpeg">
                                </div>
                            </div>
                            
                            <!-- Hidden fields -->
                            <input type="hidden" name="patient_id" value="<?php echo $patientData['id'] ?? '' ?>">
                            <input type="hidden" name="doctor_id" value="<?php echo $patientData['dr_id'] ?? '' ?>">
                            <input type="hidden" name="user_id" value="<?php echo $patientData['user_id'] ?? '' ?>">
                            <input type="hidden" name="user" value="<?php echo $patientData['user'] ?? '' ?>">
                            <input type="hidden" name="empno" value="<?php echo $patientData['empno'] ?? '' ?>">
                            <input type="hidden" name="hq_id" value="<?php echo $patientData['hq_id'] ?? '' ?>">
                            <input type="hidden" name="region_id" value="<?php echo $patientData['region_id'] ?? '' ?>">
                            <input type="hidden" name="zone_id" value="<?php echo $patientData['zone_id'] ?? '' ?>">
                            
                            <div class="text-center mt-4">
                                <button type="submit" id="submitBtn" class="btn btn-primary">Submit</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
            <div class=""><br></div>
        </div>

    </div>

    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>

    <?php include("footer.php") ?>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Function to update selected options display
            function updateSelectedOptions(checkboxClass, displayElementId) {
                const checkboxes = document.querySelectorAll(`.${checkboxClass}`);
                const displayElement = document.getElementById(displayElementId);
                const selectedValues = [];
                
                checkboxes.forEach(checkbox => {
                    if (checkbox.checked) {
                        selectedValues.push(checkbox.nextElementSibling.textContent);
                    }
                });
                
                if (selectedValues.length > 0) {
                    displayElement.textContent = selectedValues.join(', ');
                    displayElement.classList.remove('text-muted');
                    displayElement.classList.add('text-primary', 'fw-bold');
                } else {
                    displayElement.textContent = 'No options selected';
                    displayElement.classList.remove('text-primary', 'fw-bold');
                    displayElement.classList.add('text-muted');
                }
            }
            
            // Add event listeners to prescription checkboxes
            document.querySelectorAll('.prescription-checkbox').forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    updateSelectedOptions('prescription-checkbox', 'prescriptionSelected');
                });
            });
            
            // Add event listeners to comorbidity checkboxes
            document.querySelectorAll('.comorbidity-checkbox').forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    updateSelectedOptions('comorbidity-checkbox', 'comorbiditySelected');
                });
            });
            
            // Prevent dropdown from closing when clicking inside
            document.querySelectorAll('.dropdown-menu').forEach(menu => {
                menu.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
            });
            
            // Form validation
            document.getElementById("submitBtn").addEventListener("click", function(event) {
                event.preventDefault();                 
                
                // Check required text fields
                var requiredFields = document.querySelectorAll("#rxForm input[required]");
                for (var i = 0; i < requiredFields.length; i++) {
                    if (!requiredFields[i].value) {
                        alert("Please fill out all required fields.");
                        requiredFields[i].focus();
                        return;
                    }
                }
                
                // Check prescription information checkboxes
                var prescriptionChecked = document.querySelectorAll('input[name="prescription_information[]"]:checked');
                if (prescriptionChecked.length === 0) {
                    alert("Select at least one option from the Prescription Information section.");
                    document.getElementById('prescriptionDropdown').focus();
                    return;
                }
                
                // Check co-morbidity prescription checkboxes
                var coMorbidityChecked = document.querySelectorAll('input[name="co_morbidity_prescription[]"]:checked');
                if (coMorbidityChecked.length === 0) {
                    alert("Select at least one option from the Co-Morbidity Prescription section.");
                    document.getElementById('comorbidityDropdown').focus();
                    return;
                }
                
                // If all validations pass, submit the form
                document.getElementById("rxForm").submit();
            });
        });
    </script>
</body>
</html>