<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">My Patients Rx Information</h3>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                     <tr>
                                    <th scope="col">S. No</th>
                                    <th scope="col">Image</th>
                                    <th scope="col">Patient Name</th>
                                    <th scope="col">Patient Phone</th>
                                    <th scope="col">Doctor Name</th>
                                    <th scope="col">Quantity of Strips</th>
                                    <th scope="col">Indication</th>
                                    <th scope="col">Secondary in Units</th>
                                    <th scope="col">Prescription Information</th>
                                    <th scope="col">Co-Morbidity Prescription</th>
                                    <th scope="col">Date</th>
                                </tr>
                                </thead>

                                <tbody>
  <?php
                                $serial = 0;
                                if (!empty($data)) {
                                    foreach ($data as $row) {
                                        $serial++;
                                        ?>
                                        <tr>
                                            <td><?php echo $serial ?></td>
                                            <td>
                                                <?php $file_extension = pathinfo($row['image'], PATHINFO_EXTENSION);
                                                $allowed_extensions = array('jpg', 'jpeg', 'png', 'webp', 'gif', 'bmp');
                                                if (in_array(strtolower($file_extension), $allowed_extensions)) {
                                                    echo '<img src="' . base_url() . '/assets/patient_data/' . $row['image'] . '" style="width:100px">';
                                                } else { echo $row['image'];} ?>
                                            </td>
                                            <td><?php echo $row['patient_name']; ?></td>
                                            <td><?php echo $row['phone_no']; ?></td>
                                            <td><?php echo $row['doctor_name']; ?></td>
                                            <td><?php echo $row['strips']; ?></td>
                                            <td><?php echo $row['indication']; ?></td>
                                            <td><?php echo $row['secondary']; ?></td>
                                            <td><?php echo $row['prescription_information']; ?></td>
                                            <td><?php echo $row['co_morbidity_prescription']; ?></td>
                                            <td><?php echo $row['date']; ?></td>
                                        </tr>
                                    <?php }
                                } else { ?>
                                <?php } ?>
                                </tbody>
                            </table>


                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
    function myFunction() {
        return confirm('Are You Sure You Want To Delete This Record');
    }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
        <script>
        document.getElementById('tbltoxl').addEventListener('click', function () {
            var table2excel = new Table2Excel();
            table2excel.export(document.querySelectorAll("#user"));
        })
    </script>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>

</body>

</html>