<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>

<body>
    <?php include ("sidebar.php") ?>
    <div class="content">
        <?php include ("nav.php") ?>
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Registered Users</h3>
                        <a href="<?php echo site_url($controller.'/add_user'); ?>" class="btn btn-info">Add</a>
                        <button id="tbltoxl" class="btn bg-green text-white">Generate Excel</button>
                        <input class="search" type="text" id="searchInput" placeholder="Search ">
                        <div class="row mt-2 mb-2">
                            <?php if($userType>4){ ?>
                                    <div class="dropdown col-sm-4">
                                    <select class="form-select" name="zone" id="zone">
                                        <option value="">Select Zone</option>
                                        <?php
                                            $serial = 0;
                                            if (!empty($zone)) {
                                                foreach ($zone as $zonerow) {
                                                    $serial++;
                                        ?>
                                        <option value="<?php echo $zonerow['ZONEId']; ?>"><?php echo $zonerow['ZONE']; ?></option>
                                        <?php }
                                            } else { ?>
                                        <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                               <?php } 
                                    if($userType>3){
                               ?>
                                    <div class="dropdown col-sm-4">
                                    <select class="form-select" name="region" id="region">
                                        <option value="">Select Region</option>
                                        <?php
                                            $serial = 0;
                                            if (!empty($region)) {
                                                foreach ($region as $regionrow) {
                                                    $serial++;
                                        ?>
                                        <option value="<?php echo $regionrow['REGIONId']; ?>"><?php echo $regionrow['REGION']; ?></option>
                                        <?php }
                                            } else { ?>
                                        <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php  } 
                                    if($userType>2){
                                ?>
                                    <div class="dropdown col-sm-4">
                                    <select class="form-select" name="hq" id="hq">
                                        <option value="">Select Area</option>
                                        <?php
                                            $serial = 0;
                                            if (!empty($hq)) {
                                                foreach ($hq as $hqrow) {
                                                    $serial++;
                                        ?>
                                        <option value="<?php echo $hqrow['HQId']; ?>"><?php echo $hqrow['HQ']; ?></option>
                                        <?php }
                                            } else { ?>
                                        <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php } ?>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <!-- Table header -->
                                <thead>
                                    <tr>
                                        <th scope="">S.No.</th>
                                        <th scope="">Employee Name</th>
                                        <th scope="">Phone</th>
                                        <th scope="">Email</th>
                                        <th scope="">Emp. ID</th>
                                        <!-- <th scope="">User Type</th> -->
                                        <th scope="">Designation</th>
                                        <th scope="">City</th>
                                        <th scope="">Area</th>
                                        <th scope="">Region</th>
                                        <th scope="">Zone</th>
                                        <th scope="">Edit</th>
                                        <th scope="">Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr class="user-row" data-zone="<?php echo $row['ZONE']; ?>"
                                                data-region="<?php echo $row['REGION']; ?>" data-hq="<?php echo $row['HQ']; ?>">
                                                <td>
                                                    <?php echo $serial ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['Name']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['phoneNO']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['mail']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['empNO']; ?>
                                                </td>
                                                <!-- <td><?php //echo $row['userType'];  ?></td> -->
                                                <td>
                                                    <?php echo $row['DESIG']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['city']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['HQ']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['REGION']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['ZONE']; ?>
                                                </td>
                                                <td>
                                                    <a href="<?php echo site_url($controller.'/user_edit/' . $row['UserID']) ?>"
                                                        class="btn btn-primary "><i class="bi bi-pencil-square"></i></a>
                                                </td>
                                                <td>
                                                    <a class="btn btn-danger " onclick="return myFunction()"
                                                        href="<?php echo site_url($controller.'/user_delete/' . $row['UserID']) ?>"
                                                        title="Delete"><i class="bi bi-trash"></i></a>
                                                </td>
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>Record Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                            
                             <?php   if(!empty($data)  && $total>$perPage){ ?>
                        
                              <ul id="pagination-demo" class="pagination-sm"></ul>
                            
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include ("footer.php") ?>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
    <script>
        $(document).ready(function () {
            function setpagination(total) {
                 console.log(total);
                 $('#pagination-demo').pagination('destroy');
                 console.log("setpagination",total);
                  $('#pagination-demo').pagination({
                    items: total,
                    itemsOnPage: $("#pagesize").val(),
                     cssStyle: 'light-theme',
                    onPageClick: function (pageNumber) {
                         $.ajax({ url: '<?php echo base_url("rbm/get_patient_data_by_date"); ?>', type: 'get', 
                            data: { 
                                zone_id: $("#zone").val(),
                                region_id: $("#region").val(),
                                hq_id: $("#hq").val(),
                                startDate: $("#startDatepicker").val(),
                                endDate: $("#endDatepicker").val(),
                                searchText: $("#searchInput").val(),
                                page:pageNumber,
                                pagesize:$("#pagesize").val()
                            }, dataType: 'json', 
                            success: function (response) { 
                                updateTable(response.table_data,pageNumber); 
                                if(pageNumber==1){
                                    setpagination(response.table_data.length)
                                }
                            } 
                        }); 
                    }
                });
             }
            function clearFilter(){
                 $("#startDatepicker").val(null)
                 $("#endDatepicker").val(null);
                 $("#searchInput").val(null)
             }
            $('#tbltoxl').click(function(){ 
                let Str = "";
                if($('#zone').val() && $('#zone').val()!=""){
                    Str="zone="+$('#zone').val()
                }
                if($('#region').val()){
                    Str=Str+"&region="+$('#region').val()
                }
                if($('#hq').val()){
                    Str=Str+"&hq="+$('#hq').val()
                }
                console.log('<?php echo base_url().$controller; ?>/generate_excel_by_user_tbl?'+Str)
                window.open('<?php echo base_url().$controller; ?>/generate_excel_by_user_tbl?'+Str, '_blank')
            });
            $('#zone').change(function () {
                var zoneId = $(this).val();
                if (zoneId) {
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_regions_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#region").empty();
                            $("#region").append('<option value="">Select Region</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['REGIONId'];
                                    var name = response[i]['REGION'];
                                    $("#region").append("<option value='" + id + "'>" + name +
                                        "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_user_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);setpagination(response.total);clearFilter();
                        }
                    });
                } else {
                    window.location.reload();
                }
            });

            $('#region').change(function () {
                var regionId = $(this).val();
                var zoneId = $("#zone").val();
                if (regionId) {
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_hq_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#hq").empty();
                            $("#hq").append('<option value="">Select Area</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['HQId'];
                                    var name = response[i]['HQ'];
                                    $("#hq").append("<option value='" + id + "'>" + name +
                                        "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_user_by_region"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);setpagination(response.total);clearFilter();
                        }
                    });
                } else {
                    var selectedZoneId = $("#zone").val();
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_user_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: selectedZoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);setpagination(response.total);clearFilter();
                        }
                    });
                }
            });

            $('#hq').change(function () {
                var hqId = $(this).val();
                var regionId = $("#region").val();
                var zoneId = $("#zone").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_user_by_hq"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId,
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);setpagination(response.total);clearFilter();
                        }
                    });
                } else {
                    var selectedRegionId = $("#region").val();
                    $.ajax({
                        url: '<?php echo base_url($controller."/get_user_by_region"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: selectedRegionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);setpagination(response.total);clearFilter();
                        }
                    });
                }
            });

            function updateTable(tableData) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var html = "<tr>" +
                            "<td>" + (index + 1) + "</td>" +
                            "<td>" + row.Name + "</td>" +
                            "<td>" + row.phoneNO + "</td>" +
                            "<td>" + row.mail + "</td>" +
                            "<td>" + row.empNO + "</td>" +
                            "<td>" + row.DESIG + "</td>" +
                            "<td>" + row.city + "</td>" +
                            "<td>" + row.HQ + "</td>" +
                            "<td>" + row.REGION + "</td>" +
                            "<td>" + row.ZONE + "</td>" +
                            "<td>" + "<a href='<?php echo site_url($controller.'/user_edit/'); ?>" + row.UserID + "' style='border-radius: 3px;' class='btn bg-green text-white'><i class='bi  bi-pencil-square'></i></a>" +
                            // delete
                            "<td>" +
                        "<a class='btn btn-danger' onclick='return myFunction()' href='<?php echo site_url($controller.'/user_delete/'); ?>" + row.UserID + "' title='Delete'><i class='bi bi-trash'></i></a>" +
                        "</td>" +
                            "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
            
             setpagination(<?php echo $total;?>)
        });
    </script>
    <script>
        document.getElementById('searchInput').addEventListener('input', function() {
            const searchText = this.value.toLowerCase();
            const table = document.querySelector('.table');
            const rows = table.querySelectorAll('tbody tr');
            rows.forEach(function(row) {
                const columns = row.querySelectorAll('td');
                let found = false;
                columns.forEach(function(column) { if (column.textContent.toLowerCase().includes(searchText)) { found = true; } });
                if (found) { row.style.display = ''; } 
                else { row.style.display = 'none'; }
            });
        });    
    </script>
</body>

</html>