<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>

<style>
    .container {
        width: 90%;
        max-width: 400px;
        background: #ffffff;
        backdrop-filter: blur(15px);
        padding: 2rem;
        border-radius: 2rem;
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.4);
        text-align: center;
        animation: fadeSlideUp 1s ease forwards;
        margin: 0 auto;
        /* Center horizontally */
        margin-top: 10px;
    }

    @keyframes fadeSlideUp {
        0% {
            opacity: 0;
            transform: translateY(40px);
        }

        100% {
            opacity: 1;
            transform: translateY(0);
        }
    }

    input[type="file"],
    input[type="text"] {
        width: 100%;
        padding: 0.75rem;
        margin: 0.5rem 0;
        border-radius: 1rem;
        border: none;
        outline: none;
        background: #009c99;
        color: #000;
        transition: 0.3s ease;
    }

    input[type="file"]:hover,
    input[type="text"]:focus {
        background: rgba(0, 156, 153, 0.58);
        transform: scale(1.02);
    }

    input::placeholder {
        color: #000;
    }

    button {
        background: #009c99;
        border: none;
        padding: 0.8rem 1.5rem;
        border-radius: 2rem;
        color: white;
        font-size: 1rem;
        font-weight: bold;
        margin-top: 1rem;
        cursor: pointer;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        width: 100%;
    }

    button:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 20px rgba(0, 156, 153, 0.58);
    }

    .modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.7);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1000;
        visibility: hidden;
        opacity: 0;
        transition: opacity 0.3s ease, visibility 0.3s ease;
    }

    .modal.active {
        visibility: visible;
        opacity: 1;
    }

    .modal-content {
        background: #fff;
        border-radius: 1rem;
        width: 85%;
        max-width: 400px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        /* padding: 1rem; */
    }

    .modal-content img {
        max-width: 100%;
        max-height: 60vh;
        border-radius: 1rem;
        display: block;
        margin: 0 auto;
    }

    .crop-btn {
        margin-top: 1rem;
        width: 100%;
        padding: 1rem;
        background: #009c99;
        border: none;
        border-radius: 1rem;
        color: white;
        font-size: 1.2rem;
        font-weight: bold;
        cursor: pointer;
    }

    .crop-btn:hover {
        background: #009c99;
    }

    canvas {
        margin-top: 1rem;
        border-radius: 1rem;
        background: #111;
        max-width: 100%;
        height: auto;
    }

    #loader-wrapper {
        display: none;
        flex-direction: column;
        align-items: center;
        margin-top: 10px;
    }

    #loader {
        width: 50px;
        height: 50px;
        border: 5px solid rgba(0, 156, 153, 0.58);
        border-top-color: #009c99;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 1rem auto;
    }

    @keyframes spin {
        to {
            transform: rotate(360deg);
        }
    }

    .button-group {
        display: flex;
        gap: 10px;
        margin-top: 1rem;
    }

    .button-group button {
        flex: 1;
    }

    #videoInfo {
        margin-top: 1rem;
        color: #333;
        font-size: 0.9rem;
    }

    #shareStatus {
        margin-top: 1rem;
        color: #333;
        font-weight: bold;
        display: none;
    }

    .video-options {
        display: flex;
        gap: 10px;
        margin: 1rem 0;
    }

    .video-options button {
        margin-top: 0;
    }

    #cameraInput {
        display: none;
    }
</style>

<body>
    <?php include("sidebar.php") ?>
    <!-- Content Start -->
    <div class="content">
        <?php include("nav.php") ?>
        <!-- Sale & Revenue Start -->

        <div class="container pt-4 px-4" id="step1">
            <input type="text" id="name" placeholder="Enter Name">
            <input type="text" id="qualification" placeholder="Enter Credentials">
            <input type="text" id="city" placeholder="Enter City">
            <input type="file" id="upload" accept="image/*">
            <!-- <div class="image-preview" id="preview"></div> -->
            <button onclick="openCropperModal()">Crop Image</button>
            <button onclick="generateFrame()">Generate Frame</button>
        </div>

        <!-- Modal Cropper -->
        <div class="modal" id="cropperModal">
            <div class="modal-content">
                <img id="cropperImage" src="" alt="Cropper Preview">
                <button class="crop-btn" onclick="applyCrop()">Crop & Continue</button>
            </div>
        </div>

        <!-- Preview + Canvas Area -->
        <div class="container" id="preview-container" style="display:none; flex-direction: column;">
            <canvas id="canvas" width="1080" height="1920" style="border-radius: 1rem;"></canvas>
            <button onclick="saveImage()">Download</button>
            <button onclick="shareImage()">Share</button>
        </div>

        <!-- JS Libraries -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

        <script>
            const upload = document.getElementById('upload');
            const preview = document.getElementById('preview');
            const cropperModal = document.getElementById('cropperModal');
            const cropperImage = document.getElementById('cropperImage');
            const canvas = document.getElementById("canvas");
            const ctx = canvas.getContext("2d");
            const frame = new Image();
            frame.src = "<?php echo base_url(); ?>/assets/anniversary_frame/<?php echo $photo_frame["frame_name"]; ?>";

            const cropperContainer = document.getElementById('cropperModal');
            const previewContainer = document.getElementById("preview-container");
            const step1Container = document.getElementById("step1");

            let cropper;
            let croppedImageDataUrl;
            let insertedPosterId = null;
            let isPosterSaved = false;
            let isDownloadUpdated = false;
            let isShareUpdated = false;

            upload.addEventListener('change', function () {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function (e) {
                        cropperImage.src = e.target.result;
                        cropperModal.classList.add('active');
                        if (cropper) cropper.destroy();
                        cropper = new Cropper(cropperImage, {
                            aspectRatio: 1,
                            viewMode: 1,
                            background: false,
                            autoCropArea: 1,
                        });
                    }
                    reader.readAsDataURL(file);
                }
            });

            function openCropperModal() {
                const file = upload.files[0];
                if (!file) return alert("Upload an image first.");
                cropperModal.classList.add('active');
                if (cropper) cropper.destroy();
                cropper = new Cropper(cropperImage, {
                    aspectRatio: 1,
                    viewMode: 1,
                    background: false,
                    autoCropArea: 1,
                });
            }

            function applyCrop() {
                const croppedCanvas = cropper.getCroppedCanvas({
                    width: 670,  // Adjusted to match the size we want in the final frame
                    height: 640  // Adjusted to match the size we want in the final frame
                });
                croppedImageDataUrl = croppedCanvas.toDataURL();
                const croppedImage = new Image();
                croppedImage.onload = function () {
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    ctx.drawImage(croppedImage, 205, 600, 670, 640); // Draw cropped image on canvas
                    cropperModal.classList.remove('active');
                };
                croppedImage.src = croppedImageDataUrl;
                cropper.destroy();
            }

            function generateFrame() {
                const userName = document.getElementById("name").value.trim();
                const qualification = document.getElementById("qualification").value.trim();
                const city = document.getElementById("city").value.trim();

                if (!userName || !qualification || !city) {
                    alert("Please fill in Name, Qualification & City before generating the frame.");
                    return;
                }

                const inputText = userName || "Doctor Name Here";
                const inputQualification = qualification || "Qualification Here";
                const inputCity = city || "City Here";

                // Combine qualification and city with comma
                const credentialsAndCity = `${inputQualification}, ${inputCity}`;

                if (croppedImageDataUrl) {
                    const croppedImage = new Image();
                    croppedImage.onload = function () {
                        ctx.clearRect(0, 0, canvas.width, canvas.height);
                        // Draw the cropped image first
                        ctx.drawImage(croppedImage, 205, 600, 670, 640);
                        // Then draw the frame over it
                        ctx.drawImage(frame, 0, 0, 1080, 1920);

                        // Set text properties
                        ctx.fillStyle = "black";
                        ctx.textAlign = "center"; // Center align text

                        const fontFamily = "Lato";
                        // Position text at 1465px from top (center of canvas is 960px)
                        const textStartY = 1520;
                        const centerX = canvas.width / 2; // Center of the canvas

                        // Name
                        let maxAllowedWidth = 700; // Width available in the frame
                        let nameFontSize = 50;
                        ctx.font = `600 ${nameFontSize}px ${fontFamily}`;
                        while (ctx.measureText(inputText).width > maxAllowedWidth && nameFontSize > 19) {
                            nameFontSize--;
                            ctx.font = `600 ${nameFontSize}px ${fontFamily}`;
                        }
                        ctx.fillText(inputText, centerX, textStartY);

                        // Combined Qualification and City
                        let credentialsFontSize = 40;
                        let credentialsY = textStartY + 50; // Space between name and credentials
                        ctx.font = `500 ${credentialsFontSize}px ${fontFamily}`;
                        while (ctx.measureText(credentialsAndCity).width > maxAllowedWidth && credentialsFontSize > 18) {
                            credentialsFontSize--;
                            ctx.font = `500 ${credentialsFontSize}px ${fontFamily}`;
                        }
                        ctx.fillText(credentialsAndCity, centerX, credentialsY);
                    };
                    croppedImage.src = croppedImageDataUrl;
                }

                previewContainer.style.display = "flex";
                step1Container.style.display = "none";

                if (isPosterSaved) {
                    console.log("Poster already saved. Skipping insert.");
                    return;
                }

                const user_id = '<?php echo $row["UserID"]; ?>';
                const frame_id = '<?php echo $photo_frame["anniversary_frame_id"]; ?>';

                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url($controller . '/add_anniversary_poster') ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.status === "success") {
                                insertedPosterId = response.poster_id;
                                isPosterSaved = true;
                                console.log("Poster saved:", insertedPosterId);
                            }
                        } catch (e) {
                            console.error("Invalid response", e);
                        }
                    }
                };

                const params = 'input_text=' + encodeURIComponent(userName) +
                    '&input_text2=' + encodeURIComponent(qualification) +
                    '&input_text3=' + encodeURIComponent(city) +
                    '&id=' + encodeURIComponent(user_id) +
                    '&frameid=' + encodeURIComponent(frame_id);

                xhr.send(params);
            }
            function saveImage() {
                const imageData = canvas.toDataURL("image/png");
                const link = document.createElement("a");
                link.download = "framed-photo.png";
                link.href = imageData;
                link.click();

                if (insertedPosterId && !isDownloadUpdated) {
                    const xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo site_url($controller . '/anniversary_poster_download_status'); ?>", true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.send('poster_id=' + encodeURIComponent(insertedPosterId));
                    isDownloadUpdated = true;
                } else {
                    console.warn("Download status already updated or poster ID missing.");
                }
            }

            async function shareImage() {
                const blob = await (await fetch(canvas.toDataURL())).blob();
                const file = new File([blob], "framed-photo.png", { type: "image/png" });

                if (navigator.canShare && navigator.canShare({ files: [file] })) {
                    try {
                        await navigator.share({
                            files: [file],
                            title: "Framed with sunshine!",
                            text: "Check out my photo!",
                        });

                        if (insertedPosterId && !isShareUpdated) {
                            const xhr = new XMLHttpRequest();
                            xhr.open("POST", "<?php echo site_url($controller . '/anniversary_poster_share_status'); ?>", true);
                            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                            xhr.send('poster_id=' + encodeURIComponent(insertedPosterId));
                            isShareUpdated = true;
                        } else {
                            console.warn("Share status already updated or poster ID missing.");
                        }
                    } catch (err) {
                        console.error("Share cancelled or failed", err);
                    }
                } else {
                    alert("Sharing not supported on this device. Try downloading the image.");
                }
            }
        </script>
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
</body>

</html>