<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<style>
.frame-container {
    max-width: 400px;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 20px;
    padding: 20px;
    justify-items: center;
}

h1,
h2,
h3,
h4,
h5,
h6 {
    margin-bottom: 1.5rem;
    color: #000000;
    font-weight: 600;
}

.frame-input[type="file"],
.frame-input[type="text"] {
    width: 100%;
    padding: 0.75rem;
    margin: 0.5rem 0;
    border-radius: 1rem;
    border: none;
    outline: none;
    background: #009c99;
    color: #000000;
    transition: 0.3s ease;
}

.frame-input[type="file"]:hover,
.frame-input[type="text"]:focus {
    background: #009c996d;
    color: #000;
    transform: scale(1.02);
}

.frame-input::placeholder {
    color: #ffffff;
}

/* Style for all input types and select */
.frame-input,
select.frame-input {
    width: 100%;
    padding: 0.75rem;
    margin: 0.5rem 0;
    border-radius: 1rem;
    border: none;
    outline: none;
    background: #009c99;
    color: #ffffff;
    transition: 0.3s ease;
    font-family: inherit;
    font-size: inherit;
}

/* Hover/focus states */
.frame-input:hover,
.frame-input:focus,
select.frame-input:hover,
select.frame-input:focus {
    background: #009c996d;
    color: #000000;
    transform: scale(1.02);
}

/* Placeholder text */
.frame-input::placeholder {
    color: #ffffff;
}

/* Custom dropdown arrow - only for select */
select.frame-input {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23ffffff' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 0.75rem center;
    background-size: 16px 12px;
    padding-right: 2rem;
    cursor: pointer;
}

/* Style options */
select.frame-input option {
    background: #009c99;
    color: #ffffff;
    padding: 0.5rem;
}

/* Focus state */
select.frame-input:focus {
    box-shadow: 0 0 0 2px rgba(0, 156, 153, 0.3);
}

.frame-button {
    background: #009c99;
    width: 100%;
    border: none;
    padding: 0.8rem 1.5rem;
    border-radius: 2rem;
    color: white;
    font-size: 1rem;
    font-weight: bold;
    margin-top: 1rem;
    cursor: pointer;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.frame-button:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 20px #009c9979;
}


.modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100vw;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.7);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    visibility: hidden;
    opacity: 0;
    transition: opacity 0.3s ease, visibility 0.3s ease;
}

.modal.active {
    visibility: visible;
    opacity: 1;
}

.modal-content {
    background: #fff;
    /* padding: 1rem; */
    border-radius: 1rem;
    width: 100%;
    max-width: 300px;
    max-height: 100%;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
}

.modal-content img {
    max-width: 100%;
    border-radius: 1rem;
}

.crop-btn {
    margin-top: 1rem;
    width: 100%;
    padding: 1rem;
    background: #009c99;
    border: none;
    border-radius: 1rem;
    color: white;
    font-size: 1.2rem;
    font-weight: bold;
    cursor: pointer;
    transition: background 0.3s ease;
}


canvas {
    margin-top: 1rem;
    border-radius: 1rem;
    background: #111;
    max-width: 100%;
    height: auto;
}

#loader-wrapper {
    display: none;
    flex-direction: column;
    align-items: center;
    margin-top: 10px;
}

#loader {
    width: 50px;
    height: 50px;
    border: 5px solid #207e7c;
    border-top-color: #009c99;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 1rem auto;
}

@keyframes spin {
    to {
        transform: rotate(360deg);
    }
}

.frame_img{
    height: 200px;
}


/* .button-group {
    display: flex;
    gap: 10px;
    margin-top: 1rem;
}

.button-group button {
    flex: 1;
} */

#videoInfo {
    margin-top: 0rem;
    color: #333;
    font-size: 0.9rem;
}

#shareStatus {
    margin-top: 1rem;
    color: #333;
    font-weight: bold;
    display: none;
}

/* .video-options {
    display: flex;
    gap: 10px;
    margin: 1rem 0;
} */

/* .video-options button {
    margin-top: 0;
    width: 100%;
} */

#cameraInput {
    display: none;
}
</style>

<body>
    <?php include("sidebar.php") ?>
    <!-- Content Start -->
    <div class="content">
        <?php include("nav.php") ?>
        <!-- Sale & Revenue Start -->

            <div class="">
                <div class="frame-container" id="step1">
                    <input type="text" class="frame-input" required id="name" placeholder="Enter your name">
                    <input type="text" class="frame-input" required id="qualification" placeholder="Enter Credentials">
                    <input type="text" class="frame-input" required id="city" placeholder="Enter your city">
                    <input type="file" class="frame-input" required id="uploadImage" accept="image/*">

                    <div class="modal" id="cropperModal">
                        <div class="modal-content">
                            <img id="cropperImage" src="" alt="Cropper Preview">
                            <button class="crop-btn" onclick="applyCrop()">Apply</button>
                        </div>
                    </div>

                    <button class="frame-button" onclick="generateVideo()">Generate Video</button>
                </div>

                <div class="frame-container" id="preview-container" style="display:none; flex-direction: column;">
                    <video id="bgVideo" muted playsinline loop style="display: none;"></video>
                    <canvas id="overlayCanvas"></canvas>
                    <div id="loader-wrapper">
                        <div id="loader"></div>
                        <p style="color:#333; font-weight: bold; align-items: center; ">Processing video...</p>
                    </div>
                    <div id="shareStatus"></div>
                    <div class="button-group">
                        <button class="frame-button" id="downloadBtn" onclick="saveVideo()" disabled>Download</button>
                        <button class="frame-button" id="shareBtn" onclick="shareVideo()" disabled>Share</button>
                    </div>
                </div>
            </div>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
        <script>
            const uploadImage = document.getElementById('uploadImage');
            const cropperModal = document.getElementById('cropperModal');
            const cropperImage = document.getElementById('cropperImage');
            const name = document.getElementById('name');
            const qualification = document.getElementById('qualification');
            const city = document.getElementById('city');
            const formContainer = document.getElementById('step1');
            const previewContainer = document.getElementById('preview-container');
            const bgVideo = document.getElementById('bgVideo');
            const overlayCanvas = document.getElementById('overlayCanvas');
            const shareStatus = document.getElementById('shareStatus');
            const ctx = overlayCanvas.getContext('2d');

            let insertedVideoId = null;
            let isVideoSaved = false;
            let isVideoDownloadUpdated = false;
            let isVideoShareUpdated = false;

            let cropper;
            let overlayImg = null;
            let recorder, recordedChunks = [];
            let videoWidth = 1920;
            let videoHeight = 1080;
            let frameThumbnail = new Image();

            frameThumbnail.src = '<?php echo base_url(); ?>/assets/festival_video_frame/<?php echo $video_frame["frame_thumbnail"]; ?>';

            // Predefined video frame
            const predefinedVideoUrl = '<?php echo base_url(); ?>/assets/festival_video_frame/<?php echo $video_frame["frame_name"]; ?>';

            const introDuration = 5000; // 5 seconds
            const outroDuration = 5000; // 5 seconds
            let startTime;
            let isPlayingMainVideo = false;
            let animationFrameId = null;
            let audioCheckInterval = null;
            let videoEnded = false;

            // Fixed spacing values in pixels
            const IMAGE_NAME_GAP = 100;
            const LINE_GAP = 15;
            const MAX_CHARS_PER_LINE = 25;

            uploadImage.addEventListener('change', () => {
                const file = uploadImage.files[0];
                if (!file) return alert("Please upload an image.");
                cropperImage.src = URL.createObjectURL(file);
                cropperModal.classList.add('active');
                if (cropper) cropper.destroy();
                cropper = new Cropper(cropperImage, {
                    aspectRatio: 1,
                    viewMode: 1,
                    autoCropArea: 1,
                });
            });

            function applyCrop() {
                const croppedCanvas = cropper.getCroppedCanvas({ width: 300, height: 300 });
                overlayImg = new Image();
                overlayImg.src = croppedCanvas.toDataURL();
                cropperModal.classList.remove('active');
            }

            function wrapText(text, maxChars) {
                const words = text.split(' ');
                let lines = [];
                let currentLine = words[0] || '';

                for (let i = 1; i < words.length; i++) {
                    const word = words[i];
                    if (currentLine.length + word.length + 1 <= maxChars) {
                        currentLine += ' ' + word;
                    } else {
                        lines.push(currentLine);
                        currentLine = word;
                    }
                }
                lines.push(currentLine);
                return lines;
            }

            function draw() {
                const now = Date.now();
                const elapsed = now - startTime;
                const videoDuration = bgVideo.duration * 1000;
                const totalDuration = introDuration + videoDuration + outroDuration;
                const isIntro = elapsed < introDuration;
                const isVideo = elapsed >= introDuration && elapsed < (introDuration + videoDuration);
                const isOutro = elapsed >= (introDuration + videoDuration);

                ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);

                if (isIntro || isOutro) {
                    // Draw frame thumbnail as background
                    ctx.drawImage(frameThumbnail, 0, 0, overlayCanvas.width, overlayCanvas.height);

                    if (overlayImg) {
                        // Draw user image in exact position and size
                        const imageSize = 365; // Circle diameter
                        const imageX = 340;   // Left position
                        const imageY = 81;     // Top position

                        // Create circular clipping path
                        ctx.save();
                        ctx.beginPath();
                        ctx.arc(imageX + imageSize / 2, imageY + imageSize / 2, imageSize / 2, 0, 2 * Math.PI);
                        ctx.clip();

                        // Draw the image
                        ctx.drawImage(overlayImg, imageX, imageY, imageSize, imageSize);
                        ctx.restore();

                        // Draw white border around the circle
                        ctx.beginPath();
                        ctx.arc(imageX + imageSize / 2, imageY + imageSize / 2, imageSize / 2, 0, 2 * Math.PI);
                        ctx.lineWidth = 8;
                        ctx.strokeStyle = 'white';
                        ctx.stroke();

                        // Text position - moved closer to the image
                        const textX = 770;               // Left position (reduced from 111)
                        const textY = 180;              // Top position (reduced from 144)
                        const maxTextWidth = 900;        // Fixed maximum width of 900px
                        const lineHeightMultiplier = 1.2; // For spacing between lines

                        ctx.textAlign = 'left';          // Changed to left align
                        ctx.fillStyle = 'white';

                        // Draw Name
                        let userName = name.value.trim();
                        let nameFontSize = 52; // Starting font size
                        ctx.font = `bold ${nameFontSize}px Lato`;

                        // Adjust font size if needed to fit
                        while (ctx.measureText(userName).width > maxTextWidth && nameFontSize > 12) {
                            nameFontSize -= 2;
                            ctx.font = `bold ${nameFontSize}px Lato`;
                        }

                        ctx.fillText(userName, textX, textY + nameFontSize);

                        let currentY = textY + nameFontSize * lineHeightMultiplier;

                        // Draw Qualification
                        let qualificationText = qualification.value.trim();
                        if (qualificationText) {
                            let qualFontSize = 42; // Starting font size
                            ctx.font = `bold ${qualFontSize}px Lato`;

                            while (ctx.measureText(qualificationText).width > maxTextWidth && qualFontSize > 10) {
                                qualFontSize -= 2;
                                ctx.font = `bold ${qualFontSize}px Lato`;
                            }

                            ctx.fillText(qualificationText, textX, currentY + qualFontSize);
                            currentY += qualFontSize * lineHeightMultiplier;
                        }

                        // Draw City
                        let cityText = city.value.trim();
                        if (cityText) {
                            let cityFontSize = 42; // Starting font size
                            ctx.font = `bold ${cityFontSize}px Lato`;

                            while (ctx.measureText(cityText).width > maxTextWidth && cityFontSize > 10) {
                                cityFontSize -= 2;
                                ctx.font = `bold ${cityFontSize}px Lato`;
                            }

                            ctx.fillText(cityText, textX, currentY + cityFontSize);
                        }
                    }
                }

                if (isVideo) {
                    // Draw the video full size
                    ctx.drawImage(bgVideo, 0, 0, overlayCanvas.width, overlayCanvas.height);

                    // Draw user details on TOP LEFT with left alignment
                    ctx.textAlign = 'left';
                    ctx.textBaseline = 'top';

                    const maxTextWidth = 500; // Maximum text width
                    const sideMargin = 0; // Margin on both sides
                    const backgroundPadding = 20; // Padding inside background box
                    let baseFontSize = overlayCanvas.height / 20; // Larger initial base size

                    // Function to calculate appropriate font size
                    function getAdjustedFontSize(text, initialSize) {
                        let fontSize = initialSize;
                        ctx.font = `bold ${fontSize}px Lato`;
                        let textWidth = ctx.measureText(text).width;

                        // Reduce font size until text fits or minimum size reached
                        while (textWidth > maxTextWidth && fontSize > 12) {
                            fontSize -= 1;
                            ctx.font = `bold ${fontSize}px Lato`;
                            textWidth = ctx.measureText(text).width;
                        }
                        return fontSize;
                    }

                    // Process name
                    let nameFontSize = baseFontSize + 8;
                    let nameText = name.value.trim();
                    if (nameText) {
                        nameFontSize = getAdjustedFontSize(nameText, nameFontSize);
                    }

                    // Process qualification and city - always 3px smaller than name font size
                    let qualCityFontSize = Math.max(nameFontSize - 3, 12); // Ensure minimum 12px
                    let qualCityText = [];
                    if (qualification.value.trim()) qualCityText.push(qualification.value.trim());
                    if (city.value.trim()) qualCityText.push(city.value.trim());
                    let combinedQualCity = qualCityText.join(", ");

                    // Adjust qualCity font size if needed (though it should already be smaller)
                    if (combinedQualCity) {
                        ctx.font = `bold ${qualCityFontSize}px Lato`;
                        let qualCityWidth = ctx.measureText(combinedQualCity).width;
                        while (qualCityWidth > maxTextWidth && qualCityFontSize > 12) {
                            qualCityFontSize -= 1;
                            ctx.font = `bold ${qualCityFontSize}px Lato`;
                            qualCityWidth = ctx.measureText(combinedQualCity).width;
                        }
                    }

                    // Calculate total height needed
                    const lineSpacing = 12;
                    let totalHeight = backgroundPadding * 2;
                    if (nameText) totalHeight += nameFontSize;
                    if (combinedQualCity) totalHeight += qualCityFontSize + (nameText ? lineSpacing : 0);

                    // Draw semi-transparent background box
                    const backgroundWidth = maxTextWidth + (backgroundPadding * 2);
                    ctx.fillStyle = '#65656567';
                    ctx.fillRect(sideMargin, sideMargin, backgroundWidth, totalHeight);

                    // Draw text
                    let currentY = sideMargin + backgroundPadding;
                    const textX = sideMargin + backgroundPadding;

                    // Draw name
                    if (nameText) {
                        ctx.font = `bold ${nameFontSize}px Lato`;
                        ctx.fillStyle = '#ffffff';
                        ctx.fillText(nameText, textX, currentY);
                        currentY += nameFontSize + lineSpacing;
                    }

                    // Draw qualification and city
                    if (combinedQualCity) {
                        ctx.font = `${qualCityFontSize}px Lato`;
                        ctx.fillStyle = '#ffffff';
                        ctx.fillText(combinedQualCity, textX, currentY);
                    }
                }

                else {
                    if (isPlayingMainVideo) {
                        isPlayingMainVideo = false;
                        bgVideo.muted = true;
                    }
                }

                if (elapsed < totalDuration) {
                    animationFrameId = requestAnimationFrame(draw);
                } else {
                    bgVideo.pause();
                    bgVideo.currentTime = 0;
                    videoEnded = true;
                }
            }

            async function generateVideo() {
                if (!overlayImg) return alert("Please crop and select an image first!");

                try {
                    // Use the predefined video URL instead of user-uploaded video
                    bgVideo.src = predefinedVideoUrl;

                    formContainer.style.display = 'none';
                    previewContainer.style.display = 'flex';

                    const loaderWrapper = document.getElementById('loader-wrapper');
                    const downloadBtn = document.getElementById('downloadBtn');
                    const shareBtn = document.getElementById('shareBtn');

                    loaderWrapper.style.display = 'flex';
                    downloadBtn.disabled = true;
                    shareBtn.disabled = true;
                    videoEnded = false;

                    // Wait for video metadata to load
                    await new Promise((resolve, reject) => {
                        bgVideo.onloadedmetadata = () => {
                            // Set canvas size to match video dimensions
                            videoWidth = bgVideo.videoWidth;
                            videoHeight = bgVideo.videoHeight;
                            overlayCanvas.width = videoWidth;
                            overlayCanvas.height = videoHeight;
                            resolve();
                        };

                        bgVideo.onerror = () => {
                            reject(new Error("Failed to load video"));
                        };

                        // For very large videos, we need a longer timeout
                        setTimeout(() => {
                            if (bgVideo.readyState < 2) {
                                reject(new Error("Video loading timed out. The video might be too large."));
                            }
                        }, 30000); // 30 seconds timeout for large videos
                    });

                    // Start with muted audio (we'll handle audio separately)
                    bgVideo.muted = false;
                    isPlayingMainVideo = false;

                    startTime = Date.now();

                    // Create canvas stream (video only)
                    const canvasStream = overlayCanvas.captureStream(30);

                    // Create audio context to handle audio mixing
                    const audioContext = new (window.AudioContext || window.webkitAudioContext)();
                    const destination = audioContext.createMediaStreamDestination();

                    // Create audio track from video
                    const videoAudioSource = audioContext.createMediaElementSource(bgVideo);
                    videoAudioSource.connect(destination);

                    // Combine streams - now including the original audio
                    const combinedStream = new MediaStream([
                        ...canvasStream.getVideoTracks(),
                        ...destination.stream.getAudioTracks()
                    ]);

                    // Use mp4 format if supported for better mobile compatibility
                    const mimeType = MediaRecorder.isTypeSupported('video/mp4') ?
                        'video/mp4; codecs="avc1.42E01E, mp4a.40.2"' :
                        'video/webm; codecs="vp9, opus"';

                    recorder = new MediaRecorder(combinedStream, {
                        mimeType: mimeType,
                        videoBitsPerSecond: 2500000
                    });
                    recordedChunks = [];

                    recorder.ondataavailable = e => {
                        if (e.data.size > 0) {
                            recordedChunks.push(e.data);
                        }
                    };

                    recorder.onstop = () => {
                        cancelAnimationFrame(animationFrameId);
                        clearInterval(audioCheckInterval);
                        loaderWrapper.style.display = 'none';
                        downloadBtn.disabled = false;
                        shareBtn.disabled = false;

                        // Save video metadata to server before processing starts
                        saveVideoMetadata();

                        // Clean up
                        if (audioContext.state !== 'closed') {
                            audioContext.close();
                        }
                    };

                    recorder.onerror = (e) => {
                        console.error("Recorder error:", e);
                        alert("Error recording video. Please try again.");
                        location.reload();
                    };

                    // Start recording with 100ms timeslice for smoother recording
                    recorder.start(100);
                    animationFrameId = requestAnimationFrame(draw);

                    // Play the video when it's time (during the main video section)
                    audioCheckInterval = setInterval(() => {
                        const now = Date.now();
                        const elapsed = now - startTime;
                        const videoDuration = bgVideo.duration * 1000;

                        if (elapsed >= introDuration && elapsed < (introDuration + videoDuration)) {
                            // Main video section - play the video with audio
                            if (!isPlayingMainVideo) {
                                bgVideo.currentTime = 0;
                                bgVideo.play().catch(e => console.log("Video play error:", e));
                                isPlayingMainVideo = true;
                            }
                        } else {
                            // Intro/outro section - pause the video
                            if (isPlayingMainVideo) {
                                bgVideo.pause();
                                isPlayingMainVideo = false;
                            }
                        }

                        // For very long videos, check if we're near the end
                        if (bgVideo.currentTime > bgVideo.duration - 0.5 && !videoEnded) {
                            videoEnded = true;
                        }
                    }, 100);

                    // Stop recording when complete
                    const totalDuration = introDuration + (bgVideo.duration * 1000) + outroDuration;

                    // For very long videos, we need to monitor progress differently
                    if (bgVideo.duration > 300) { // If video is longer than 5 minutes
                        const progressInterval = setInterval(() => {
                            if (videoEnded) {
                                clearInterval(progressInterval);
                                if (recorder.state === 'recording') {
                                    recorder.stop();
                                }
                            }
                        }, 1000);
                    } else {
                        setTimeout(() => {
                            if (recorder.state === 'recording') {
                                recorder.stop();
                            }
                        }, totalDuration);
                    }

                } catch (error) {
                    console.error("Error generating video:", error);
                    alert("Error generating video: " + error.message);
                    location.reload();
                }
            }

            function saveVideoMetadata() {
                if (isVideoSaved) return;

                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url($controller . '/add_festival_video'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                const userName = name.value.trim();
                const qualificationText = qualification.value.trim();
                const cityText = city.value.trim();
                const UserID = '<?php echo $row["UserID"]; ?>';
                const frame_id = '<?php echo $video_frame["video_frame_id"]; ?>';

                const params = 'input_text=' + encodeURIComponent(userName) +
                    '&input_text2=' + encodeURIComponent(qualificationText) +
                    '&input_text3=' + encodeURIComponent(cityText) +
                    '&id=' + encodeURIComponent(UserID) +
                    '&frame_id=' + encodeURIComponent(frame_id);

                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4) {
                        if (xhr.status === 200) {
                            try {
                                const response = JSON.parse(xhr.responseText);
                                if (response.status === "success") {
                                    insertedVideoId = response.video_id;
                                    isVideoSaved = true;
                                    console.log("Video metadata saved. ID:", insertedVideoId);
                                } else {
                                    console.error("Failed to save video metadata:", response.message);
                                }
                            } catch (e) {
                                console.error("Invalid response", e);
                            }
                        } else {
                            console.error("Error saving video metadata. Status:", xhr.status);
                        }
                    }
                };

                xhr.onerror = function () {
                    console.error("Request failed to save video metadata");
                };

                xhr.send(params);
            }

            function saveVideo() {
                const blob = new Blob(recordedChunks, { type: recordedChunks[0].type });
                const url = URL.createObjectURL(blob);
                const a = document.createElement('a');
                a.href = url;
                a.download = `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`;
                document.body.appendChild(a);
                a.click();
                document.body.removeChild(a);
                URL.revokeObjectURL(url);

                if (insertedVideoId && !isVideoDownloadUpdated) {
                    const xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo site_url($controller . '/festival_video_download_status'); ?>", true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.send('video_id=' + encodeURIComponent(insertedVideoId));
                    isVideoDownloadUpdated = true;
                } else {
                    console.warn("Download status already updated or video ID missing.");
                }
            }

            async function shareVideo() {
                try {
                    const blob = new Blob(recordedChunks, {
                        type: recordedChunks[0].type.includes('mp4') ? 'video/mp4' : 'video/webm'
                    });

                    // Create a smaller file if needed (some mobile devices have size limits)
                    const maxSize = 25 * 1024 * 1024; // 25MB
                    let fileToShare;

                    if (blob.size > maxSize) {
                        // Compress the video if it's too large
                        alert('Video is large - compressing for sharing...');
                        fileToShare = await compressVideo(blob);
                    } else {
                        fileToShare = new File([blob], `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`, {
                            type: blob.type
                        });
                    }

                    // Check if sharing is supported
                    if (navigator.share && navigator.canShare && navigator.canShare({ files: [fileToShare] })) {
                        await navigator.share({
                            files: [fileToShare],
                            title: 'Check out my Video!',
                            text: 'Check out my Video!',
                        });

                        // Update share status if successful
                        if (insertedVideoId && !isVideoShareUpdated) {
                            await updateShareStatus(insertedVideoId);
                            isVideoShareUpdated = true;
                        }
                    } else {
                        // Fallback for browsers that don't support file sharing
                        fallbackShare();
                    }
                } catch (error) {
                    console.error('Sharing error:', error);

                    // More specific error messages
                    if (error.name === 'AbortError') {
                        alert('Sharing was cancelled by the user.');
                    } else if (error.name === 'NotAllowedError') {
                        alert('Permission to share was denied.');
                    } else if (error.message.includes('too large')) {
                        alert('Video is too large to share. Please try downloading instead.');
                    } else {
                        // Try fallback method if direct sharing fails
                        fallbackShare();
                    }
                }
            }

            // Helper function to compress video
            async function compressVideo(blob) {
                // In a real implementation, you would use a video processing library
                // or service to properly compress the video
                // This is just a placeholder implementation

                console.warn('Actual video compression should be implemented here');
                return new File([blob], `compressed_video_${Date.now()}.mp4`, {
                    type: 'video/mp4'
                });
            }

            // Helper function to update share status
            function updateShareStatus(videoId) {
                return new Promise((resolve, reject) => {
                    const xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo site_url($controller . '/festival_video_share_status'); ?>", true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                    xhr.onload = () => {
                        if (xhr.status === 200) {
                            resolve();
                        } else {
                            reject(new Error('Failed to update share status'));
                        }
                    };

                    xhr.onerror = () => reject(new Error('Request failed'));
                    xhr.send('video_id=' + encodeURIComponent(videoId));
                });
            }

            // Fallback sharing method
            function fallbackShare() {
                const blob = new Blob(recordedChunks, {
                    type: recordedChunks[0].type
                });
                const url = URL.createObjectURL(blob);

                // Create a temporary link for download
                const link = document.createElement('a');
                link.href = url;
                link.download = `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`;
                document.body.appendChild(link);

                // Try to show a custom share dialog
                if (confirm('Direct sharing not available. Do you want to download the video first, then share it through another app?')) {
                    link.click();
                }

                // Clean up
                setTimeout(() => {
                    document.body.removeChild(link);
                    URL.revokeObjectURL(url);
                }, 100);
            }
        </script>

        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
</body>

</html>