<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<style>
    
.btn-link {
    display: inline-block;
    margin-top: 1.5rem;
    padding: 10px 20px;
    background: #009c99;
    color: #fff;
    text-decoration: none;
    border-radius: 25px;
    font-weight: 600;
    transition: background 0.3s ease;
}

.btn-link:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 20px #009c9979;
}

.dropdown {
    position: relative;
    width: 250px;
    justify-self: center;
    text-align: left;

}

.dropdown-toggle {
    background-color: #009c99;
    color: white;
    padding: 12px 20px;
    font-size: 16px;
    border: none;
    border-radius: 6px;
    width: 100%;
    text-align: left;
    cursor: pointer;
    display: flex;
    justify-content: space-between;
    transition: background 0.3s ease;
}

.dropdown-toggle:hover {
    background-color: #009c9979;
}

.dropdown-toggle:after {
    content: "▼";
    font-size: 12px;
    margin-left: 10px;
}

.dropdown-menu {
    position: absolute;
    top: 110%;
    left: 0;
    right: 0;
    background-color: #ffffff;
    border-radius: 6px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.407);
    overflow: hidden;
    max-height: 0;
    transition: max-height 0.3s ease;
    z-index: 1000;
    color: #282828;
}

.dropdown-menu.show {
    max-height: 500px;
}

.dropdown-menu a {
    display: block;
    padding: 6px 20px;
    color: #333;
    text-decoration: none;
    transition: background 0.2s;
}

.dropdown-menu a:hover {
    background-color: #f0f0f0;
}

@media screen and (max-width: 480px) {
    -dropdown {
        width: 90%;
    }
}
</style>
<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>
        <div class="box-container text-center ">

            <div class="dropdown">
                <button class="dropdown-toggle" onclick="toggleDropdown()">Select Language</button>
                <div class="dropdown-menu" id="dropdownMenu">
                    <?php foreach ($language as $row): ?>
                        <a href="#" onclick="fetchCampaigns(<?= $row['language_id']; ?>)">
                            <?= esc($row['language']); ?>
                        </a>
                    <?php endforeach; ?>
                </div>

                <div id="campaignLinks" style="margin-top: 0px;"></div>
            </div>

        </div>

    <script>
        function toggleDropdown() {
            const dropdownMenu = document.getElementById("dropdownMenu");
            const isShowing = dropdownMenu.classList.contains("show");
            
            // Clear campaigns if dropdown is being shown
            if (!isShowing) {
                document.getElementById("campaignLinks").innerHTML = "";
            }
            
            dropdownMenu.classList.toggle("show");
        }

        window.onclick = function (event) {
            if (!event.target.matches('.dropdown-toggle')) {
                var dropdowns = document.getElementsByClassName("dropdown-menu");
                for (var i = 0; i < dropdowns.length; i++) {
                    dropdowns[i].classList.remove('show');
                }
            }
        }

        function fetchCampaigns(languageid) {
            fetch("<?= base_url('user/get_campaigns_by_language/') ?>" + languageid)
                .then(response => response.json())
                .then(data => {
                    let html = '';
                    if (data.length > 0) {
                        data.forEach(row => {
                            html += `<div style="margin-bottom: 10px;">
                        <a href="<?= base_url($controller .'/poster_maker') ?>/${row.frame_id}" class="btn-link">
                           ${row.campaign_name}
                        </a><br>
                        <img src="<?= base_url(); ?>/assets/frame/${row.frame_name}" style="height:320px; margin-top:10px; Box-shadow: 0 4px 12px rgba(0, 0, 0, 0.407);">
                    </div>`;
                        });
                    } else {
                        html = '<p style="color: #000">No campaigns found for selected language.</p>';
                    }

                    document.getElementById('campaignLinks').innerHTML = html;
                })
                .catch(error => {
                    console.error('Error fetching campaigns:', error);
                });
        }
    </script>
 </div>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include("footer.php") ?>
</body>
</html>