<!DOCTYPE html>
<html lang="en">

<?php include("head.php") ?>

<body>
    <?php
    header('Cross-Origin-Opener-Policy: same-origin');
    header('Cross-Origin-Embedder-Policy: require-corp');
    ?>
    <section class="section pt-0" id="about">
        <?php include("nav.php") ?>
        <div class=" ">
            <div class="">
                <div class="frame-container" id="step1">
                    <input type="text" class="frame-input" id="name" placeholder="Enter your name">
                    <input type="text" class="frame-input" id="qualification" placeholder="Enter Credentials">
                    <input type="text" class="frame-input" id="city" placeholder="Enter your city">
                    <input type="file" class="frame-input" id="uploadImage" accept="image/*">
                    <div class="modal" id="cropperModal">
                        <div class="modal-content">
                            <img id="cropperImage" src="" alt="Cropper Preview">
                            <button class="crop-btn" onclick="applyCrop()">Apply</button>
                        </div>
                    </div>
                    <button class="frame-button" onclick="generateVideo()">Generate Video</button>
                </div>
                <div class="frame-container" id="preview-container" style="display:none; flex-direction: column;">
                    <video id="bgVideo" muted playsinline loop style="display: none;"></video>
                    <canvas id="overlayCanvas"></canvas>
                    <div id="loader-wrapper">
                        <div id="loader"></div>
                        <p style="color:#333; font-weight: bold; align-items: center; ">Processing Video...</p>
                    </div>
                    <div id="shareStatus"></div>
                    <div class="button-group">
                        <button class="frame-button" id="downloadBtn" onclick="saveVideo()" disabled>Download</button>
                        <button class="frame-button" id="shareBtn" onclick="shareVideo()" disabled>Share</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="chr-box"><img src="<?php echo base_url(); ?>asset/imgs/character.png" class="chr" alt=" character">
        </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <script>
        const uploadImage = document.getElementById('uploadImage');
        const cropperModal = document.getElementById('cropperModal');
        const cropperImage = document.getElementById('cropperImage');
        const name = document.getElementById('name');
        const qualification = document.getElementById('qualification');
        const city = document.getElementById('city');
        const formContainer = document.getElementById('step1');
        const previewContainer = document.getElementById('preview-container');
        const bgVideo = document.getElementById('bgVideo');
        const overlayCanvas = document.getElementById('overlayCanvas');
        const shareStatus = document.getElementById('shareStatus');
        const ctx = overlayCanvas.getContext('2d');

        let insertedVideoId = null;
        let isVideoSaved = false;
        let isVideoDownloadUpdated = false;
        let isVideoShareUpdated = false;

        let cropper;
        let overlayImg = null;
        let recorder, recordedChunks = [];
        let videoWidth = 1920;
        let videoHeight = 1080;
        let convertedMp4Blob = null;

            const predefinedVideoUrl =
            '<?php echo base_url(); ?>/assets/anniversary_video_frame/<?php echo $video_frame["frame_name"]; ?>';

        const introDuration = 5000;
        const outroDuration = 5000;
        let startTime;
        let isPlayingMainVideo = false;
        let animationFrameId = null;
        let audioCheckInterval = null;
        let videoEnded = false;

        // Fixed spacing values in pixels
        const IMAGE_NAME_GAP = 100;
        const LINE_GAP = 15;
        const MAX_CHARS_PER_LINE = 25;

        uploadImage.addEventListener('change', () => {
            const file = uploadImage.files[0];
            if (!file) return alert("Please upload an image.");
            cropperImage.src = URL.createObjectURL(file);
            cropperModal.classList.add('active');
            if (cropper) cropper.destroy();
            cropper = new Cropper(cropperImage, {
                aspectRatio: 1,
                viewMode: 1,
                autoCropArea: 1,
            });
        });

        function applyCrop() {
            const croppedCanvas = cropper.getCroppedCanvas({
                width: 300,
                height: 300
            });
            overlayImg = new Image();
            overlayImg.src = croppedCanvas.toDataURL();
            cropperModal.classList.remove('active');
        }

        function wrapText(text, maxChars) {
            const words = text.split(' ');
            let lines = [];
            let currentLine = words[0] || '';

            for (let i = 1; i < words.length; i++) {
                const word = words[i];
                if (currentLine.length + word.length + 1 <= maxChars) {
                    currentLine += ' ' + word;
                } else {
                    lines.push(currentLine);
                    currentLine = word;
                }
            }
            lines.push(currentLine);
            return lines;
        }

        function draw() {
            const now = Date.now();
            const elapsed = now - startTime;
            const videoDuration = bgVideo.duration * 1000;
            const totalDuration = introDuration + videoDuration + outroDuration;
            const isIntro = elapsed < introDuration;
            const isVideo = elapsed >= introDuration && elapsed < (introDuration + videoDuration);
            const isOutro = elapsed >= (introDuration + videoDuration);

            ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);

            if (isIntro || isOutro) {
                // First 1 second: Show logo full screen

                const gradient = ctx.createLinearGradient(0, 0, overlayCanvas.width, overlayCanvas.height);
                gradient.addColorStop(0, "#82d0ca");
                gradient.addColorStop(1, "#347d96");
                ctx.fillStyle = gradient;
                ctx.fillRect(0, 0, overlayCanvas.width, overlayCanvas.height);

                if (overlayImg) {
                    const size = Math.min(overlayCanvas.width, overlayCanvas.height) * 0.4;
                    const x = (overlayCanvas.width - size) / 2;
                    const y = (overlayCanvas.height - size) / 2 - (size * 0.2);
                    ctx.save();
                    ctx.beginPath();
                    ctx.arc(x + size / 2, y + size / 2, size / 2, 0, 2 * Math.PI);
                    ctx.clip();
                    ctx.drawImage(overlayImg, x, y, size, size);
                    ctx.restore();

                    const textStartY = y + size + IMAGE_NAME_GAP;
                    ctx.textAlign = 'center';
                    ctx.fillStyle = 'white';

                    const maxTextWidth = overlayCanvas.width * 0.8;

                    // Draw Name
                    let userName = name.value.trim();
                    let nameFontSize = Math.min(overlayCanvas.width / 15, overlayCanvas.height / 12);
                    ctx.font = `bold ${nameFontSize}px Lato`;
                    while (ctx.measureText(userName).width > maxTextWidth && nameFontSize > 10) {
                        nameFontSize -= 1;
                        ctx.font = `bold ${nameFontSize}px Lato`;
                    }
                    ctx.fillText(userName, overlayCanvas.width / 2, textStartY);
                    let currentY = textStartY + nameFontSize + LINE_GAP;

                    // Draw Qualification
                    let qualificationText = qualification.value.trim();
                    if (qualificationText) {
                        let qualFontSize = Math.min(overlayCanvas.width / 25, overlayCanvas.height / 15);
                        ctx.font = `bold ${qualFontSize}px Lato`;
                        while (ctx.measureText(qualificationText).width > maxTextWidth && qualFontSize > 8) {
                            qualFontSize -= 1;
                            ctx.font = `bold ${qualFontSize}px Lato`;
                        }
                        ctx.fillText(qualificationText, overlayCanvas.width / 2, currentY);
                        currentY += qualFontSize + LINE_GAP;
                    }

                    // Draw City
                    let cityText = city.value.trim();
                    if (cityText) {
                        let cityFontSize = Math.min(overlayCanvas.width / 25, overlayCanvas.height / 15);
                        ctx.font = `bold ${cityFontSize}px Lato`;
                        while (ctx.measureText(cityText).width > maxTextWidth && cityFontSize > 8) {
                            cityFontSize -= 1;
                            ctx.font = `bold ${cityFontSize}px Lato`;
                        }
                        ctx.fillText(cityText, overlayCanvas.width / 2, currentY);
                    }
                }

            }

            if (isVideo) {
                // Draw the video full size
                ctx.drawImage(bgVideo, 0, 0, overlayCanvas.width, overlayCanvas.height);

                // Draw user details on TOP LEFT with left alignment
                ctx.textAlign = 'left';
                ctx.textBaseline = 'top';

                const maxTextWidth = 500; // Maximum text width
                const sideMargin = 0; // Margin on both sides
                const backgroundPadding = 20; // Padding inside background box
                let baseFontSize = overlayCanvas.height / 20; // Larger initial base size

                // Function to calculate appropriate font size
                function getAdjustedFontSize(text, initialSize) {
                    let fontSize = initialSize;
                    ctx.font = `bold ${fontSize}px Lato`;
                    let textWidth = ctx.measureText(text).width;

                    // Reduce font size until text fits or minimum size reached
                    while (textWidth > maxTextWidth && fontSize > 12) {
                        fontSize -= 1;
                        ctx.font = `bold ${fontSize}px Lato`;
                        textWidth = ctx.measureText(text).width;
                    }
                    return fontSize;
                }

                // Process name
                let nameFontSize = baseFontSize + 8;
                let nameText = name.value.trim();
                if (nameText) {
                    nameFontSize = getAdjustedFontSize(nameText, nameFontSize);
                }

                // Process qualification and city - always 3px smaller than name font size
                let qualCityFontSize = Math.max(nameFontSize - 3, 12); // Ensure minimum 12px
                let qualCityText = [];
                if (qualification.value.trim()) qualCityText.push(qualification.value.trim());
                if (city.value.trim()) qualCityText.push(city.value.trim());
                let combinedQualCity = qualCityText.join(", ");

                // Adjust qualCity font size if needed (though it should already be smaller)
                if (combinedQualCity) {
                    ctx.font = `bold ${qualCityFontSize}px Lato`;
                    let qualCityWidth = ctx.measureText(combinedQualCity).width;
                    while (qualCityWidth > maxTextWidth && qualCityFontSize > 12) {
                        qualCityFontSize -= 1;
                        ctx.font = `bold ${qualCityFontSize}px Lato`;
                        qualCityWidth = ctx.measureText(combinedQualCity).width;
                    }
                }

                // Calculate total height needed
                const lineSpacing = 12;
                let totalHeight = backgroundPadding * 2;
                if (nameText) totalHeight += nameFontSize;
                if (combinedQualCity) totalHeight += qualCityFontSize + (nameText ? lineSpacing : 0);

                // Draw semi-transparent background box
                const backgroundWidth = maxTextWidth + (backgroundPadding * 2);
                ctx.fillStyle = '#65656567';
                ctx.fillRect(sideMargin, sideMargin, backgroundWidth, totalHeight);

                // Draw text
                let currentY = sideMargin + backgroundPadding;
                const textX = sideMargin + backgroundPadding;

                // Draw name
                if (nameText) {
                    ctx.font = `bold ${nameFontSize}px Lato`;
                    ctx.fillStyle = '#ffffff';
                    ctx.fillText(nameText, textX, currentY);
                    currentY += nameFontSize + lineSpacing;
                }

                // Draw qualification and city
                if (combinedQualCity) {
                    ctx.font = `${qualCityFontSize}px Lato`;
                    ctx.fillStyle = '#ffffff';
                    ctx.fillText(combinedQualCity, textX, currentY);
                }
            }

            else {
                if (isPlayingMainVideo) {
                    isPlayingMainVideo = false;
                    bgVideo.muted = true;
                }
            }

            if (elapsed < totalDuration) {
                animationFrameId = requestAnimationFrame(draw);
            } else {
                bgVideo.pause();
                bgVideo.currentTime = 0;
            }
        }

         async function generateVideo() {
            if (!overlayImg) return alert("Please crop and select an image first!");

            try {
                // Use the predefined video URL instead of user-uploaded video
                bgVideo.src = predefinedVideoUrl;

                formContainer.style.display = 'none';
                previewContainer.style.display = 'flex';

                const loaderWrapper = document.getElementById('loader-wrapper');
                const downloadBtn = document.getElementById('downloadBtn');
                const shareBtn = document.getElementById('shareBtn');

                loaderWrapper.style.display = 'flex';
                downloadBtn.disabled = true;
                shareBtn.disabled = true;
                videoEnded = false;

                // Wait for video metadata to load
                await new Promise((resolve, reject) => {
                    bgVideo.onloadedmetadata = () => {
                        // Set canvas size to match video dimensions
                        videoWidth = bgVideo.videoWidth;
                        videoHeight = bgVideo.videoHeight;
                        overlayCanvas.width = videoWidth;
                        overlayCanvas.height = videoHeight;
                        resolve();
                    };

                    bgVideo.onerror = () => {
                        reject(new Error("Failed to load video"));
                    };

                    setTimeout(() => {
                        if (bgVideo.readyState < 2) {
                            reject(new Error("Video loading timed out. The video might be too large."));
                        }
                    }, 30000);
                });

                // Start with muted audio (we'll handle audio separately)
                bgVideo.muted = false;
                isPlayingMainVideo = false;

                startTime = Date.now();

                // Create canvas stream (video only)
                const canvasStream = overlayCanvas.captureStream(30);

                // Create audio context to handle audio mixing
                const audioContext = new (window.AudioContext || window.webkitAudioContext)();
                const destination = audioContext.createMediaStreamDestination();

                // Create audio track from video
                const videoAudioSource = audioContext.createMediaElementSource(bgVideo);
                videoAudioSource.connect(destination);

                // Combine streams - now including the original audio
                const combinedStream = new MediaStream([
                    ...canvasStream.getVideoTracks(),
                    ...destination.stream.getAudioTracks()
                ]);

                // Use the most compatible format for the device
                let mimeType;
                if (MediaRecorder.isTypeSupported('video/mp4')) {
                    mimeType = 'video/mp4; codecs="avc1.42E01E, mp4a.40.2"';
                } else if (MediaRecorder.isTypeSupported('video/webm; codecs=vp9,opus')) {
                    mimeType = 'video/webm; codecs=vp9,opus';
                } else {
                    mimeType = 'video/webm'; // Fallback to basic webm
                }

                // Use these settings in your generateVideo() function
                const recorder = new MediaRecorder(combinedStream, {
                    mimeType: 'video/webm;codecs=vp9', // VP9 is faster to encode
                    videoBitsPerSecond: 2500000, // 2.5 Mbps
                    audioBitsPerSecond: 128000, // 128 kbps
                    bitsPerSecond: 2628000 // Total bitrate
                });
                recordedChunks = [];

                recorder.ondataavailable = e => {
                    if (e.data.size > 0) {
                        recordedChunks.push(e.data);
                    }
                };

                recorder.onstop = async () => {
                    cancelAnimationFrame(animationFrameId);
                    clearInterval(audioCheckInterval);

                    try {
                        // Convert to MP4 immediately after recording
                        loaderWrapper.querySelector('p').textContent = 'Processing Video...';
                        const webmBlob = new Blob(recordedChunks, {
                            type: recordedChunks[0].type
                        });
                        convertedMp4Blob = await convertToMP4(webmBlob);

                        // Test the converted video
                        await testVideoPlayback(convertedMp4Blob);

                        // Save video metadata to server
                        saveVideoMetadata();

                        // Enable buttons
                        loaderWrapper.style.display = 'none';
                        downloadBtn.disabled = false;
                        shareBtn.disabled = false;
                    } catch (error) {
                        console.error("Post-processing error:", error);
                        alert("Error processing video. Please try again.");
                        location.reload();
                    } finally {
                        if (audioContext.state !== 'closed') {
                            audioContext.close();
                        }
                    }
                };

                recorder.onerror = (e) => {
                    console.error("Recorder error:", e);
                    alert("Error recording video. Please try again.");
                    location.reload();
                };

                // Start recording with 100ms timeslice for smoother recording
                recorder.start(100);
                animationFrameId = requestAnimationFrame(draw);

                // Play the video when it's time (during the main video section)
                audioCheckInterval = setInterval(() => {
                    const now = Date.now();
                    const elapsed = now - startTime;
                    const videoDuration = bgVideo.duration * 1000;

                    if (elapsed >= introDuration && elapsed < (introDuration + videoDuration)) {
                        if (!isPlayingMainVideo) {
                            bgVideo.currentTime = 0;
                            bgVideo.play().catch(e => console.log("Video play error:", e));
                            isPlayingMainVideo = true;
                        }
                    } else {
                        if (isPlayingMainVideo) {
                            bgVideo.pause();
                            isPlayingMainVideo = false;
                        }
                    }

                    if (bgVideo.currentTime > bgVideo.duration - 0.5 && !videoEnded) {
                        videoEnded = true;
                    }
                }, 100);

                // Stop recording when complete
                const totalDuration = introDuration + (bgVideo.duration * 1000) + outroDuration;

                if (bgVideo.duration > 300) {
                    const progressInterval = setInterval(() => {
                        if (videoEnded) {
                            clearInterval(progressInterval);
                            if (recorder.state === 'recording') {
                                recorder.stop();
                            }
                        }
                    }, 1000);
                } else {
                    setTimeout(() => {
                        if (recorder.state === 'recording') {
                            recorder.stop();
                        }
                    }, totalDuration);
                }

            } catch (error) {
                console.error("Error generating video:", error);
                alert("Error generating video: " + error.message);
                location.reload();
            }
        }
        // Pre-load FFmpeg.wasm if available
        if (typeof FFmpeg !== 'undefined') {
            const {
                createFFmpeg
            } = FFmpeg;
            const ffmpeg = createFFmpeg({
                log: false
            });
            ffmpeg.load().catch(e => console.log('FFmpeg pre-load failed', e));
        }

        async function convertToMP4(webmBlob) {
            const loaderText = document.getElementById('loader-wrapper').querySelector('p');
            loaderText.textContent = 'Converting to MP4...';

            let mp4Blob;

            try {
                if (typeof FFmpeg !== 'undefined') {
                    mp4Blob = await convertWithFFmpegWasm(webmBlob);
                } else {
                    mp4Blob = await convertWithOptimizedCanvas(webmBlob);
                }

                // ➕ Add compression step
                loaderText.textContent = 'Compressing Video...';
                const compressedBlob = await compressMp4Blob(mp4Blob);

                return compressedBlob; // Return final compressed video
            } catch (error) {
                console.error('Conversion error:', error);
                throw error;
            }
        }


        async function convertWithFFmpegWasm(webmBlob) {
            const {
                createFFmpeg,
                fetchFile
            } = FFmpeg;
            const ffmpeg = createFFmpeg({
                log: false, // Disable logging for better performance
                corePath: 'https://unpkg.com/@ffmpeg/core@0.11.0/dist/ffmpeg-core.js'
            });

            await ffmpeg.load();

            // Write input file
            ffmpeg.FS('writeFile', 'input.webm', await fetchFile(webmBlob));

            // Run optimized FFmpeg command
            await ffmpeg.run(
                '-i', 'input.webm',
                '-c:v', 'libx264', // H.264 codec
                '-preset', 'ultrafast', // Fastest encoding preset
                '-crf', '23', // Good quality with reasonable size
                '-movflags', '+faststart', // Enable streaming
                '-pix_fmt', 'yuv420p', // Widely compatible pixel format
                '-vf', 'fps=30', // Force 30 FPS output
                '-threads', '4', // Use multiple threads
                'output.mp4'
            );

            // Read output file
            const data = ffmpeg.FS('readFile', 'output.mp4');
            return new Blob([data.buffer], {
                type: 'video/mp4'
            });
        }

        async function convertWithOptimizedCanvas(webmBlob) {
            return new Promise((resolve) => {
                const video = document.createElement('video');
                video.src = URL.createObjectURL(webmBlob);
                video.muted = true; // Mute to avoid audio issues
                video.playsInline = true;

                video.onloadedmetadata = () => {
                    const canvas = document.createElement('canvas');
                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                    const ctx = canvas.getContext('2d', {
                        willReadFrequently: false
                    });

                    // Use the most efficient mime type available
                    const mimeType = MediaRecorder.isTypeSupported('video/mp4') ?
                        'video/mp4' : 'video/webm';

                    // Optimized MediaRecorder settings
                    const options = {
                        mimeType: mimeType,
                        videoBitsPerSecond: 2500000, // 2.5 Mbps
                        audioBitsPerSecond: 128000 // 128 kbps
                    };

                    const stream = canvas.captureStream(30);
                    const recorder = new MediaRecorder(stream, options);
                    const chunks = [];

                    recorder.ondataavailable = (e) => {
                        if (e.data.size > 0) {
                            chunks.push(e.data);
                        }
                    };

                    recorder.onstop = () => {
                        resolve(new Blob(chunks, {
                            type: mimeType
                        }));
                        URL.revokeObjectURL(video.src);
                    };

                    // Start recording first
                    recorder.start(100); // 100ms timeslice for smoother recording

                    // Then start playing
                    video.play().catch(e => console.error('Video play error:', e));

                    let lastTime = 0;
                    const frameRate = 30; // Target 30 FPS
                    const frameDelay = 1000 / frameRate;

                    function drawFrame(timestamp) {
                        if (!timestamp) timestamp = performance.now();

                        if (video.readyState >= HTMLMediaElement.HAVE_CURRENT_DATA) {
                            const elapsed = timestamp - lastTime;

                            if (elapsed >= frameDelay) {
                                ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                                lastTime = timestamp;
                            }
                        }

                        if (!video.ended) {
                            requestAnimationFrame(drawFrame);
                        } else {
                            recorder.stop();
                        }
                    }

                    requestAnimationFrame(drawFrame);
                };

                video.onerror = () => {
                    URL.revokeObjectURL(video.src);
                    throw new Error('Video loading failed');
                };
            });
        }

        async function testVideoPlayback(videoBlob) {
            return new Promise((resolve, reject) => {
                const testVideo = document.createElement('video');
                testVideo.src = URL.createObjectURL(videoBlob);
                testVideo.preload = 'metadata';

                testVideo.onloadedmetadata = () => {
                    URL.revokeObjectURL(testVideo.src);
                    resolve();
                };

                testVideo.onerror = () => {
                    URL.revokeObjectURL(testVideo.src);
                    reject(new Error('Video playback test failed'));
                };

                // Timeout if metadata takes too long to load
                setTimeout(() => {
                    if (!testVideo.readyState) {
                        URL.revokeObjectURL(testVideo.src);
                        reject(new Error('Video test timed out'));
                    }
                }, 5000);
            });
        }

        async function compressMp4Blob(inputBlob) {
            const { createFFmpeg, fetchFile } = FFmpeg;
            const ffmpeg = createFFmpeg({
                log: false,
                corePath: 'https://unpkg.com/@ffmpeg/core@0.11.0/dist/ffmpeg-core.js'
            });

            await ffmpeg.load();

            ffmpeg.FS('writeFile', 'input.mp4', await fetchFile(inputBlob));

            // Compress with fast preset and lower bitrate
            await ffmpeg.run(
                '-i', 'input.mp4',
                '-vcodec', 'libx264',
                '-b:v', '1200k',  // Reduce bitrate for compression
                '-preset', 'ultrafast',
                '-acodec', 'aac',
                '-b:a', '96k',
                '-movflags', '+faststart',
                'compressed.mp4'
            );

            const compressedData = ffmpeg.FS('readFile', 'compressed.mp4');
            return new Blob([compressedData.buffer], { type: 'video/mp4' });
        }


        function saveVideoMetadata() {
            if (isVideoSaved) return;

            const xhr = new XMLHttpRequest();
            xhr.open("POST", "<?php echo site_url('/user/add_anniversary_video'); ?>", true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

            const userName = name.value.trim();
            const qualificationText = qualification.value.trim();
            const cityText = city.value.trim();
            const UserID = '<?php echo $row["UserID"]; ?>';
            const frame_id = '<?php echo $video_frame["video_frame_id"]; ?>';

            const params = 'input_text=' + encodeURIComponent(userName) +
                '&input_text2=' + encodeURIComponent(qualificationText) +
                '&input_text3=' + encodeURIComponent(cityText) +
                '&id=' + encodeURIComponent(UserID) +
                '&frame_id=' + encodeURIComponent(frame_id);

            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.status === "success") {
                                insertedVideoId = response.video_id;
                                isVideoSaved = true;
                                console.log("Video metadata saved. ID:", insertedVideoId);
                            } else {
                                console.error("Failed to save video metadata:", response.message);
                            }
                        } catch (e) {
                            console.error("Invalid response", e);
                        }
                    } else {
                        console.error("Error saving video metadata. Status:", xhr.status);
                    }
                }
            };

            xhr.onerror = function () {
                console.error("Request failed to save video metadata");
            };

            xhr.send(params);
        }


        async function saveVideo() {
            try {
                if (!convertedMp4Blob) {
                    throw new Error("No converted video available");
                }

                const loaderWrapper = document.getElementById('loader-wrapper');
                const downloadBtn = document.getElementById('downloadBtn');

                // Show loading state briefly (even though video is already converted)
                loaderWrapper.style.display = 'flex';
                loaderWrapper.querySelector('p').textContent = 'Preparing download...';
                downloadBtn.disabled = true;

                // Create download link for the pre-converted MP4
                const url = URL.createObjectURL(convertedMp4Blob);
                const a = document.createElement('a');
                a.href = url;
                a.download = `video_${Date.now()}.mp4`;
                document.body.appendChild(a);
                a.click();

                // Clean up
                setTimeout(() => {
                    document.body.removeChild(a);
                    URL.revokeObjectURL(url);
                    loaderWrapper.style.display = 'none';
                    downloadBtn.disabled = false;
                }, 100);

                // Update download status
                if (insertedVideoId && !isVideoDownloadUpdated) {
                    const xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo site_url('/user/anniversary_video_download_status'); ?>", true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.send('video_id=' + encodeURIComponent(insertedVideoId));
                    isVideoDownloadUpdated = true;
                }
            } catch (error) {
                console.error('Download error:', error);
                alert('Error preparing video for download. Please try again.');
                document.getElementById('loader-wrapper').style.display = 'none';
                document.getElementById('downloadBtn').disabled = false;
            }
        }

        async function shareVideo() {
            try {
                if (!convertedMp4Blob) {
                    throw new Error("No converted video available");
                }

                const fileToShare = new File([convertedMp4Blob], `video_${Date.now()}.mp4`, {
                    type: 'video/mp4'
                });

                // Check if sharing is supported
                if (navigator.share && navigator.canShare && navigator.canShare({
                    files: [fileToShare]
                })) {
                    await navigator.share({
                        files: [fileToShare],
                        title: 'Check out my Video!',
                        text: 'Check out my Video!',
                    });

                    // Update share status if successful
                    if (insertedVideoId && !isVideoShareUpdated) {
                        await updateShareStatus(insertedVideoId);
                        isVideoShareUpdated = true;
                    }
                } else {
                    // Fallback for browsers that don't support file sharing
                    fallbackShare();
                }
            } catch (error) {
                console.error('Sharing error:', error);

                // More specific error messages
                if (error.name === 'AbortError') {
                    alert('Sharing was cancelled by the user.');
                } else if (error.name === 'NotAllowedError') {
                    alert('Permission to share was denied.');
                } else if (error.message.includes('too large')) {
                    alert('Video is too large to share. Please try downloading instead.');
                } else {
                    // Try fallback method if direct sharing fails
                    fallbackShare();
                }
            }
        }

        function fallbackShare() {
            if (!convertedMp4Blob) return;

            const url = URL.createObjectURL(convertedMp4Blob);
            const link = document.createElement('a');
            link.href = url;
            link.download = `video_${Date.now()}.mp4`;
            document.body.appendChild(link);

            if (confirm(
                'Direct sharing not available. Do you want to download the video first, then share it through another app?'
            )) {
                link.click();
            }

            setTimeout(() => {
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            }, 100);
        }

        // Helper function to update share status
        function updateShareStatus(videoId) {
            return new Promise((resolve, reject) => {
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url('/user/anniversary_video_share_status'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                xhr.onload = () => {
                    if (xhr.status === 200) {
                        resolve();
                    } else {
                        reject(new Error('Failed to update share status'));
                    }
                };

                xhr.onerror = () => reject(new Error('Request failed'));
                xhr.send('video_id=' + encodeURIComponent(videoId));
            });
        }
    
        
    </script>

</html>