<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>

<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php") ?>
        <div class=" ">
            <div class="">
                <div class="frame-container" id="step1">
                    <input type="text" class="frame-input" required id="name" placeholder="Enter your name">
                    <input type="text" class="frame-input" required id="qualification" placeholder="Enter Credentials">
                    <input type="text" class="frame-input" required id="city" placeholder="Enter your city">
                    <input type="file" class="frame-input" required id="uploadImage" accept="image/*">

                    <div class="modal" id="cropperModal">
                        <div class="modal-content">
                            <img id="cropperImage" src="" alt="Cropper Preview">
                            <button class="crop-btn" onclick="applyCrop()">Apply</button>
                        </div>
                    </div>

                    <button class="frame-button" onclick="generateVideo()">Generate Video</button>
                </div>

                <div class="frame-container" id="preview-container" style="display:none; flex-direction: column;">
                    <video id="bgVideo" muted playsinline loop style="display: none;"></video>
                    <canvas id="overlayCanvas"></canvas>
                    <div id="loader-wrapper">
                        <div id="loader"></div>
                        <p style="color:#333; font-weight: bold; align-items: center; ">Processing video...</p>
                    </div>
                    <div id="shareStatus"></div>
                    <div class="button-group">
                        <button class="frame-button" id="downloadBtn" onclick="saveVideo()" disabled>Download</button>
                        <button class="frame-button" id="shareBtn" onclick="shareVideo()" disabled>Share</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="chr-box"><img src="<?php echo base_url(); ?>asset/imgs/character.png" class="chr" alt=" character">
        </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <script>
        const uploadImage = document.getElementById('uploadImage');
        const cropperModal = document.getElementById('cropperModal');
        const cropperImage = document.getElementById('cropperImage');
        const name = document.getElementById('name');
        const qualification = document.getElementById('qualification');
        const city = document.getElementById('city');
        const formContainer = document.getElementById('step1');
        const previewContainer = document.getElementById('preview-container');
        const bgVideo = document.getElementById('bgVideo');
        const overlayCanvas = document.getElementById('overlayCanvas');
        const shareStatus = document.getElementById('shareStatus');
        const ctx = overlayCanvas.getContext('2d');
        const loaderWrapper = document.getElementById('loader-wrapper');
        const downloadBtn = document.getElementById('downloadBtn');
        const shareBtn = document.getElementById('shareBtn');

        let insertedVideoId = null;
        let isVideoSaved = false;
        let isVideoDownloadUpdated = false;
        let isVideoShareUpdated = false;

        let cropper;
        let overlayImg = null;
        let recorder, recordedChunks = [];
        let videoWidth = 1920;
        let videoHeight = 1080;

        let convertedMp4Url = null;

        // Predefined video frame
        const predefinedVideoUrl = '<?php echo base_url(); ?>/assets/birthday_video_frame/<?php echo $video_frame["frame_name"]; ?>';

        const introDuration = 5000; // 5 seconds
        const outroDuration = 5000; // 5 seconds
        let startTime;
        let isPlayingMainVideo = false;
        let animationFrameId = null;
        let audioCheckInterval = null;

        // Fixed spacing values in pixels
        const IMAGE_NAME_GAP = 100;
        const LINE_GAP = 15;
        const MAX_CHARS_PER_LINE = 25;

        uploadImage.addEventListener('change', () => {
            const file = uploadImage.files[0];
            if (!file) return alert("Please upload an image.");
            cropperImage.src = URL.createObjectURL(file);
            cropperModal.classList.add('active');
            if (cropper) cropper.destroy();
            cropper = new Cropper(cropperImage, {
                aspectRatio: 1,
                viewMode: 1,
                autoCropArea: 1,
            });
        });

        function applyCrop() {
            const croppedCanvas = cropper.getCroppedCanvas({ width: 300, height: 300 });
            overlayImg = new Image();
            overlayImg.src = croppedCanvas.toDataURL();
            cropperModal.classList.remove('active');
        }

        function wrapText(text, maxChars) {
            const words = text.split(' ');
            let lines = [];
            let currentLine = words[0] || '';

            for (let i = 1; i < words.length; i++) {
                const word = words[i];
                if (currentLine.length + word.length + 1 <= maxChars) {
                    currentLine += ' ' + word;
                } else {
                    lines.push(currentLine);
                    currentLine = word;
                }
            }
            lines.push(currentLine);
            return lines;
        }

        function draw() {
            const now = Date.now();
            const elapsed = now - startTime;
            const videoDuration = bgVideo.duration * 1000;
            const totalDuration = introDuration + videoDuration + outroDuration;
            const isIntro = elapsed < introDuration;
            const isVideo = elapsed >= introDuration && elapsed < (introDuration + videoDuration);
            const isOutro = elapsed >= (introDuration + videoDuration);

            ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);

            if (isIntro || isOutro) {
                const gradient = ctx.createLinearGradient(0, 0, overlayCanvas.width, overlayCanvas.height);
                gradient.addColorStop(0, "#82d0ca");
                gradient.addColorStop(1, "#347d96");
                ctx.fillStyle = gradient;
                ctx.fillRect(0, 0, overlayCanvas.width, overlayCanvas.height);

                if (overlayImg) {
                    const size = Math.min(overlayCanvas.width, overlayCanvas.height) * 0.4;
                    const x = (overlayCanvas.width - size) / 2;
                    const y = (overlayCanvas.height - size) / 2 - (size * 0.2);
                    ctx.save();
                    ctx.beginPath();
                    ctx.arc(x + size / 2, y + size / 2, size / 2, 0, 2 * Math.PI);
                    ctx.clip();
                    ctx.drawImage(overlayImg, x, y, size, size);
                    ctx.restore();

                    const textStartY = y + size + IMAGE_NAME_GAP;
                    ctx.textAlign = 'center';
                    ctx.fillStyle = 'white';

                    const maxTextWidth = overlayCanvas.width * 0.8;

                    // Draw Name
                    let userName = name.value.trim();
                    let nameFontSize = Math.min(overlayCanvas.width / 15, overlayCanvas.height / 12);
                    ctx.font = `bold ${nameFontSize}px Lato`;
                    while (ctx.measureText(userName).width > maxTextWidth && nameFontSize > 10) {
                        nameFontSize -= 1;
                        ctx.font = `bold ${nameFontSize}px Lato`;
                    }
                    ctx.fillText(userName, overlayCanvas.width / 2, textStartY);
                    let currentY = textStartY + nameFontSize + LINE_GAP;

                    // Draw Qualification
                    let qualificationText = qualification.value.trim();
                    if (qualificationText) {
                        let qualFontSize = Math.min(overlayCanvas.width / 25, overlayCanvas.height / 15);
                        ctx.font = `bold ${qualFontSize}px Lato`;
                        while (ctx.measureText(qualificationText).width > maxTextWidth && qualFontSize > 8) {
                            qualFontSize -= 1;
                            ctx.font = `bold ${qualFontSize}px Lato`;
                        }
                        ctx.fillText(qualificationText, overlayCanvas.width / 2, currentY);
                        currentY += qualFontSize + LINE_GAP;
                    }

                    // Draw City
                    let cityText = city.value.trim();
                    if (cityText) {
                        let cityFontSize = Math.min(overlayCanvas.width / 25, overlayCanvas.height / 15);
                        ctx.font = `bold ${cityFontSize}px Lato`;
                        while (ctx.measureText(cityText).width > maxTextWidth && cityFontSize > 8) {
                            cityFontSize -= 1;
                            ctx.font = `bold ${cityFontSize}px Lato`;
                        }
                        ctx.fillText(cityText, overlayCanvas.width / 2, currentY);
                    }
                }

            }

            if (isVideo) {
                ctx.drawImage(bgVideo, 0, 0, overlayCanvas.width, overlayCanvas.height);

                ctx.textAlign = 'left';
                ctx.textBaseline = 'top';

                const maxTextWidth = 500;
                const sideMargin = 0;
                const backgroundPadding = 20;
                let baseFontSize = overlayCanvas.height / 20;

                function getAdjustedFontSize(text, initialSize) {
                    let fontSize = initialSize;
                    ctx.font = `bold ${fontSize}px Lato`;
                    let textWidth = ctx.measureText(text).width;

                    while (textWidth > maxTextWidth && fontSize > 12) {
                        fontSize -= 1;
                        ctx.font = `bold ${fontSize}px Lato`;
                        textWidth = ctx.measureText(text).width;
                    }
                    return fontSize;
                }

                let nameFontSize = baseFontSize + 8;
                let nameText = name.value.trim();
                if (nameText) {
                    nameFontSize = getAdjustedFontSize(nameText, nameFontSize);
                }

                let qualCityFontSize = Math.max(nameFontSize - 3, 12);
                let qualCityText = [];
                if (qualification.value.trim()) qualCityText.push(qualification.value.trim());
                if (city.value.trim()) qualCityText.push(city.value.trim());
                let combinedQualCity = qualCityText.join(", ");

                if (combinedQualCity) {
                    ctx.font = `bold ${qualCityFontSize}px Lato`;
                    let qualCityWidth = ctx.measureText(combinedQualCity).width;
                    while (qualCityWidth > maxTextWidth && qualCityFontSize > 12) {
                        qualCityFontSize -= 1;
                        ctx.font = `bold ${qualCityFontSize}px Lato`;
                        qualCityWidth = ctx.measureText(combinedQualCity).width;
                    }
                }

                const lineSpacing = 12;
                let totalHeight = backgroundPadding * 2;
                if (nameText) totalHeight += nameFontSize;
                if (combinedQualCity) totalHeight += qualCityFontSize + (nameText ? lineSpacing : 0);

                const backgroundWidth = maxTextWidth + (backgroundPadding * 2);
                ctx.fillStyle = '#65656567';
                ctx.fillRect(sideMargin, sideMargin, backgroundWidth, totalHeight);

                let currentY = sideMargin + backgroundPadding;
                const textX = sideMargin + backgroundPadding;

                if (nameText) {
                    ctx.font = `bold ${nameFontSize}px Lato`;
                    ctx.fillStyle = '#ffffff';
                    ctx.fillText(nameText, textX, currentY);
                    currentY += nameFontSize + lineSpacing;
                }

                if (combinedQualCity) {
                    ctx.font = `${qualCityFontSize}px Lato`;
                    ctx.fillStyle = '#ffffff';
                    ctx.fillText(combinedQualCity, textX, currentY);
                }
            }

            else {
                if (isPlayingMainVideo) {
                    isPlayingMainVideo = false;
                    bgVideo.muted = true;
                }
            }

            if (elapsed < totalDuration) {
                animationFrameId = requestAnimationFrame(draw);
            } else {
                bgVideo.pause();
                bgVideo.currentTime = 0;
            }
        }

        async function generateVideo() {
            if (!overlayImg) return alert("Please crop and select an image first!");

            try {
                bgVideo.src = predefinedVideoUrl;

                formContainer.style.display = 'none';
                previewContainer.style.display = 'flex';

                loaderWrapper.style.display = 'flex';
                downloadBtn.disabled = true;
                shareBtn.disabled = true;
                videoEnded = false;

                await new Promise((resolve, reject) => {
                    bgVideo.onloadedmetadata = () => {
                        videoWidth = bgVideo.videoWidth;
                        videoHeight = bgVideo.videoHeight;
                        overlayCanvas.width = videoWidth;
                        overlayCanvas.height = videoHeight;
                        resolve();
                    };

                    bgVideo.onerror = () => {
                        reject(new Error("Failed to load video"));
                    };

                    setTimeout(() => {
                        if (bgVideo.readyState < 2) {
                            reject(new Error("Video loading timed out. The video might be too large."));
                        }
                    }, 30000);
                });

                bgVideo.muted = false;
                isPlayingMainVideo = false;

                startTime = Date.now();

                const canvasStream = overlayCanvas.captureStream(30);
                const audioContext = new (window.AudioContext || window.webkitAudioContext)();
                const destination = audioContext.createMediaStreamDestination();
                const videoAudioSource = audioContext.createMediaElementSource(bgVideo);
                videoAudioSource.connect(destination);

                const combinedStream = new MediaStream([
                    ...canvasStream.getVideoTracks(),
                    ...destination.stream.getAudioTracks()
                ]);

                const mimeType = MediaRecorder.isTypeSupported('video/mp4') ?
                    'video/mp4; codecs="avc1.42E01E, mp4a.40.2"' :
                    'video/webm; codecs="vp9, opus"';

                recorder = new MediaRecorder(combinedStream, {
                    mimeType: mimeType,
                    videoBitsPerSecond: 2500000
                });
                recordedChunks = [];

                recorder.ondataavailable = e => {
                    if (e.data.size > 0) {
                        recordedChunks.push(e.data);
                    }
                };

                recorder.onstop = () => {
                    cancelAnimationFrame(animationFrameId);
                    clearInterval(audioCheckInterval);
                    
                    // Don't hide loader here - we'll hide it after MP4 conversion
                    saveVideoMetadata();

                    if (audioContext.state !== 'closed') {
                        audioContext.close();
                    }

                    const blob = new Blob(recordedChunks, { type: 'video/webm' });
                    uploadToServer(blob);
                };

                recorder.onerror = (e) => {
                    console.error("Recorder error:", e);
                    alert("Error recording video. Please try again.");
                    location.reload();
                };

                recorder.start(100);
                animationFrameId = requestAnimationFrame(draw);

                audioCheckInterval = setInterval(() => {
                    const now = Date.now();
                    const elapsed = now - startTime;
                    const videoDuration = bgVideo.duration * 1000;

                    if (elapsed >= introDuration && elapsed < (introDuration + videoDuration)) {
                        if (!isPlayingMainVideo) {
                            bgVideo.currentTime = 0;
                            bgVideo.play().catch(e => console.log("Video play error:", e));
                            isPlayingMainVideo = true;
                        }
                    } else {
                        if (isPlayingMainVideo) {
                            bgVideo.pause();
                            isPlayingMainVideo = false;
                        }
                    }

                    if (bgVideo.currentTime > bgVideo.duration - 0.5 && !videoEnded) {
                        videoEnded = true;
                    }
                }, 100);

                const totalDuration = introDuration + (bgVideo.duration * 1000) + outroDuration;

                if (bgVideo.duration > 300) {
                    const progressInterval = setInterval(() => {
                        if (videoEnded) {
                            clearInterval(progressInterval);
                            if (recorder.state === 'recording') {
                                recorder.stop();
                            }
                        }
                    }, 1000);
                } else {
                    setTimeout(() => {
                        if (recorder.state === 'recording') {
                            recorder.stop();
                        }
                    }, totalDuration);
                }

            } catch (error) {
                console.error("Error generating video:", error);
                alert("Error generating video: " + error.message);
                location.reload();
            }
        }

        function uploadToServer(blob) {
            const formData = new FormData();
            formData.append("video", blob, "video.webm");
            formData.append("user_id", insertedVideoId);

            fetch("<?= site_url('/upload_generated_video') ?>", {
                method: "POST",
                body: formData
            })
                .then(res => res.json())
                .then(data => {
                    if (data.status === 'success') {
                        convertedMp4Url = data.download_url;
                        // Only hide loader and enable buttons after MP4 conversion is complete
                        loaderWrapper.style.display = 'none';
                        downloadBtn.disabled = false;
                        shareBtn.disabled = false;
                    } else {
                        alert("Upload failed");
                        loaderWrapper.style.display = 'none';
                    }
                })
                .catch(error => {
                    console.error("Upload error:", error);
                    alert("Upload failed");
                    loaderWrapper.style.display = 'none';
                });
        }

        function saveVideoMetadata() {
            if (isVideoSaved) return;

            const xhr = new XMLHttpRequest();
            xhr.open("POST", "<?php echo site_url('/user/add_birthday_video'); ?>", true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

            const userName = name.value.trim();
            const qualificationText = qualification.value.trim();
            const cityText = city.value.trim();
            const UserID = '<?php echo $row["UserID"]; ?>';
            const frame_id = '<?php echo $video_frame["video_frame_id"]; ?>';

            const params = 'input_text=' + encodeURIComponent(userName) +
                '&input_text2=' + encodeURIComponent(qualificationText) +
                '&input_text3=' + encodeURIComponent(cityText) +
                '&id=' + encodeURIComponent(UserID) +
                '&frame_id=' + encodeURIComponent(frame_id);

            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.status === "success") {
                                insertedVideoId = response.video_id;
                                isVideoSaved = true;
                                console.log("Video metadata saved. ID:", insertedVideoId);
                            } else {
                                console.error("Failed to save video metadata:", response.message);
                            }
                        } catch (e) {
                            console.error("Invalid response", e);
                        }
                    } else {
                        console.error("Error saving video metadata. Status:", xhr.status);
                    }
                }
            };

            xhr.onerror = function() {
                console.error("Request failed to save video metadata");
            };

            xhr.send(params);
        }

        function saveVideo() {
            if (!convertedMp4Url) {
                alert("MP4 video not ready for download. Please wait a moment and try again.");
                return;
            }

            console.log("Attempting to download:", convertedMp4Url);

            const a = document.createElement('a');
            a.href = convertedMp4Url;
            a.download = `doctor_video_${Date.now()}.mp4`;
            a.style.display = 'none';
            document.body.appendChild(a);
            a.click();

            setTimeout(() => {
                document.body.removeChild(a);
            }, 100);
        }

        async function shareVideo() {
            if (!convertedMp4Url) {
                alert("MP4 video is not ready for sharing. Please wait a moment and try again.");
                return;
            }

            try {
                if (navigator.share) {
                    const response = await fetch(convertedMp4Url);
                    const blob = await response.blob();

                    if (blob.size > 10 * 1024 * 1024) {
                        alert("Video is too large to share directly. Please download it first.");
                        return;
                    }

                    const file = new File([blob], `doctor_video_${Date.now()}.mp4`, { type: 'video/mp4' });

                    if (navigator.canShare && navigator.canShare({ files: [file] })) {
                        await navigator.share({
                            files: [file],
                            title: 'Check out my Doctor Video!',
                            text: 'I created this video using Doctor Video Maker'
                        });

                        if (insertedVideoId && !isVideoShareUpdated) {
                            await updateShareStatus(insertedVideoId);
                            isVideoShareUpdated = true;
                        }
                        return;
                    }
                }

                fallbackShare();
            } catch (err) {
                console.error("Sharing failed:", err);
                fallbackShare();
            }
        }

        async function compressVideo(blob) {
            console.warn('Actual video compression should be implemented here');
            return new File([blob], `compressed_video_${Date.now()}.mp4`, {
                type: 'video/mp4'
            });
        }

        function updateShareStatus(videoId) {
            return new Promise((resolve, reject) => {
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url('/user/birthday_video_share_status'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                xhr.onload = () => {
                    if (xhr.status === 200) {
                        resolve();
                    } else {
                        reject(new Error('Failed to update share status'));
                    }
                };

                xhr.onerror = () => reject(new Error('Request failed'));
                xhr.send('video_id=' + encodeURIComponent(videoId));
            });
        }

        function fallbackShare() {
            const blob = new Blob(recordedChunks, {
                type: recordedChunks[0].type
            });
            const url = URL.createObjectURL(blob);

            const link = document.createElement('a');
            link.href = url;
            link.download = `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`;
            document.body.appendChild(link);

            if (confirm('Direct sharing not available. Do you want to download the video first, then share it through another app?')) {
                link.click();
            }

            setTimeout(() => {
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            }, 100);
        }
    </script>

</html>