<?php
$uploadDir = 'uploads/';
$convertedDir = 'converted/';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['video'])) {
    $videoId = $_POST['video_id'] ?? uniqid();
    $tmpName = $_FILES['video']['tmp_name'];
    $originalName = basename($_FILES['video']['name']);
    $webmPath = $uploadDir . $videoId . '.webm';
    $mp4Path = $convertedDir . $videoId . '.mp4';

    // Move uploaded webm
    if (!move_uploaded_file($tmpName, $webmPath)) {
        echo json_encode(['status' => 'error', 'message' => 'Upload failed']);
        exit;
    }

    // Convert to mp4 using ffmpeg
    $cmd = "ffmpeg -y -i $webmPath -c:v libx264 -c:a aac -strict experimental $mp4Path 2>&1";
    exec($cmd, $output, $return_var);

    if ($return_var === 0 && file_exists($mp4Path)) {
        echo json_encode([
            'status' => 'success',
            'download_url' => "/$mp4Path"
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'FFmpeg conversion failed'
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}
?>
