<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>


<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php") ?>
        <div class=" ">
            <div class="">
                <div class="frame-container" id="step1">
                    <input type="text" class="frame-input" id="name" placeholder="Enter your name">
                    <input type="text" class="frame-input" id="qualification" placeholder="Enter Credentials">
                    <input type="text" class="frame-input" id="city" placeholder="Enter your city">
                    <input type="file" class="frame-input" id="uploadImage" accept="image/*">

                    <div class="video-options">
                        <button class="frame-button" onclick="document.getElementById('cameraInput').click()">Record
                            Video</button>
                        <button class="frame-button" onclick="selectVideo()">Select Video</button>
                    </div>

                    <input type="file" id="uploadVideo" accept="video/*" style="display: none;">
                    <input type="file" id="cameraInput" accept="video/*" capture="user">
                    <div id="videoInfo"></div>
                    <button class="frame-button" onclick="generateVideo()">Generate Video</button>

                </div>

                <div class="modal" id="cropperModal">
                    <div class="modal-content">
                        <img id="cropperImage" src="" alt="Cropper Preview">
                        <button class="crop-btn" onclick="applyCrop()">Apply</button>
                    </div>
                </div>

                <div class="frame-container" id="preview-container" style="display:none; flex-direction: column;">
                    <video id="bgVideo" muted playsinline loop style="display: none;"></video>
                    <canvas id="overlayCanvas"></canvas>
                    <div id="loader-wrapper">
                        <div id="loader"></div>
                        <p style="color:#333; font-weight: bold; align-items: center; ">Processing video...</p>
                    </div>
                    <div id="shareStatus"></div>
                    <div class="button-group">
                        <button class="frame-button" id="downloadBtn" onclick="saveVideo()" disabled>Download</button>
                        <button class="frame-button" id="shareBtn" onclick="shareVideo()" disabled>Share</button>
                    </div>
                </div>

            </div>
        </div>
        <div class="chr-box"><img src="<?php echo base_url(); ?>asset/imgs/character.png" class="chr" alt=" character">
        </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <script>
        const uploadImage = document.getElementById('uploadImage');
        const uploadVideo = document.getElementById('uploadVideo');
        const cameraInput = document.getElementById('cameraInput');
        const cropperModal = document.getElementById('cropperModal');
        const cropperImage = document.getElementById('cropperImage');
        const name = document.getElementById('name');
        const qualification = document.getElementById('qualification');
        const city = document.getElementById('city');
        const formContainer = document.getElementById('step1');
        const previewContainer = document.getElementById('preview-container');
        const bgVideo = document.getElementById('bgVideo');
        const overlayCanvas = document.getElementById('overlayCanvas');
        const videoInfo = document.getElementById('videoInfo');
        const shareStatus = document.getElementById('shareStatus');
        const ctx = overlayCanvas.getContext('2d');

        let insertedVideoId = null;
        let isVideoSaved = false;
        let isVideoDownloadUpdated = false;
        let isVideoShareUpdated = false;

        let cropper;
        let overlayImg = null;
        let recorder, recordedChunks = [];
        let videoWidth = 1920;
        let videoHeight = 1080;
        let videoFile = null;
        let mediaRecorder;
        let cameraStream = null;
        let frameImage = new Image();

        frameImage.src = '<?php echo base_url(); ?>/assets/img/bg-frame.png';

        const introDuration = 5000; // 5 seconds
        const outroDuration = 5000; // 5 seconds
        let startTime;
        let isPlayingMainVideo = false;
        let animationFrameId = null;
        let audioCheckInterval = null;

        // Fixed spacing values in pixels
        const IMAGE_NAME_GAP = 100;
        const LINE_GAP = 15;
        const MAX_CHARS_PER_LINE = 25;

        uploadImage.addEventListener('change', () => {
            const file = uploadImage.files[0];
            if (!file) return alert("Please upload an image.");
            cropperImage.src = URL.createObjectURL(file);
            cropperModal.classList.add('active');
            if (cropper) cropper.destroy();
            cropper = new Cropper(cropperImage, {
                aspectRatio: 1,
                viewMode: 1,
                autoCropArea: 1,
            });
        });

        uploadVideo.addEventListener('change', (e) => {
            videoFile = e.target.files[0];
            if (videoFile) {
                videoInfo.textContent = `Selected: ${videoFile.name} (${formatFileSize(videoFile.size)})`;
            }
        });

        cameraInput.addEventListener('change', (e) => {
            videoFile = e.target.files[0];
            if (videoFile) {
                videoInfo.textContent = `Recorded: ${videoFile.name} (${formatFileSize(videoFile.size)})`;
            }
        });

        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }

        function selectVideo() {
            uploadVideo.click();
        }

        function applyCrop() {
            const croppedCanvas = cropper.getCroppedCanvas({ width: 300, height: 300 });
            overlayImg = new Image();
            overlayImg.src = croppedCanvas.toDataURL();
            cropperModal.classList.remove('active');
        }

        function wrapText(text, maxChars) {
            const words = text.split(' ');
            let lines = [];
            let currentLine = words[0] || '';

            for (let i = 1; i < words.length; i++) {
                const word = words[i];
                if (currentLine.length + word.length + 1 <= maxChars) {
                    currentLine += ' ' + word;
                } else {
                    lines.push(currentLine);
                    currentLine = word;
                }
            }
            lines.push(currentLine);
            return lines;
        }

        function draw() {
            const now = Date.now();
            const elapsed = now - startTime;
            const videoDuration = bgVideo.duration * 1000;
            const totalDuration = introDuration + videoDuration + outroDuration;
            const isIntro = elapsed < introDuration;
            const isVideo = elapsed >= introDuration && elapsed < (introDuration + videoDuration);
            const isOutro = elapsed >= (introDuration + videoDuration);

            ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);

            if (isIntro || isOutro) {
                // First 1 second: Show logo full screen

                const gradient = ctx.createLinearGradient(0, 0, overlayCanvas.width, overlayCanvas.height);
                gradient.addColorStop(0, "#82d0ca");
                gradient.addColorStop(1, "#347d96");
                ctx.fillStyle = gradient;
                ctx.fillRect(0, 0, overlayCanvas.width, overlayCanvas.height);

                if (overlayImg) {
                    const size = Math.min(overlayCanvas.width, overlayCanvas.height) * 0.4;
                    const x = (overlayCanvas.width - size) / 2;
                    const y = (overlayCanvas.height - size) / 2 - (size * 0.2);
                    ctx.save();
                    ctx.beginPath();
                    ctx.arc(x + size / 2, y + size / 2, size / 2, 0, 2 * Math.PI);
                    ctx.clip();
                    ctx.drawImage(overlayImg, x, y, size, size);
                    ctx.restore();

                    const textStartY = y + size + IMAGE_NAME_GAP;
                    ctx.textAlign = 'center';
                    ctx.fillStyle = 'white';

                    const maxTextWidth = overlayCanvas.width * 0.8;

                    // Draw Name
                    let userName = name.value.trim();
                    let nameFontSize = Math.min(overlayCanvas.width / 15, overlayCanvas.height / 12);
                    ctx.font = `bold ${nameFontSize}px Lato`;
                    while (ctx.measureText(userName).width > maxTextWidth && nameFontSize > 10) {
                        nameFontSize -= 1;
                        ctx.font = `bold ${nameFontSize}px Lato`;
                    }
                    ctx.fillText(userName, overlayCanvas.width / 2, textStartY);
                    let currentY = textStartY + nameFontSize + LINE_GAP;

                    // Draw Qualification
                    let qualificationText = qualification.value.trim();
                    if (qualificationText) {
                        let qualFontSize = Math.min(overlayCanvas.width / 25, overlayCanvas.height / 15);
                        ctx.font = `bold ${qualFontSize}px Lato`;
                        while (ctx.measureText(qualificationText).width > maxTextWidth && qualFontSize > 8) {
                            qualFontSize -= 1;
                            ctx.font = `bold ${qualFontSize}px Lato`;
                        }
                        ctx.fillText(qualificationText, overlayCanvas.width / 2, currentY);
                        currentY += qualFontSize + LINE_GAP;
                    }

                    // Draw City
                    let cityText = city.value.trim();
                    if (cityText) {
                        let cityFontSize = Math.min(overlayCanvas.width / 25, overlayCanvas.height / 15);
                        ctx.font = `bold ${cityFontSize}px Lato`;
                        while (ctx.measureText(cityText).width > maxTextWidth && cityFontSize > 8) {
                            cityFontSize -= 1;
                            ctx.font = `bold ${cityFontSize}px Lato`;
                        }
                        ctx.fillText(cityText, overlayCanvas.width / 2, currentY);
                    }
                }

            }

            if (isVideo) {
                ctx.drawImage(frameImage, 0, 0, overlayCanvas.width, overlayCanvas.height);

                // Calculate padding based on video aspect ratio
                let framePadding;
                const videoAspectRatio = bgVideo.videoWidth / bgVideo.videoHeight;

                // For landscape videos (16:9 or wider)
                if (videoAspectRatio >= 16 / 9) {
                    framePadding = 80; // Less padding for wide videos
                }
                // For portrait videos (9:16 or taller)
                else if (videoAspectRatio <= 9 / 16) {
                    // Keep original padding (100px) for portrait videos
                    framePadding = 80;
                }
                // For in-between aspect ratios (square-ish)
                else {
                    // Scale padding proportionally between 90 and 100
                    const ratio = (videoAspectRatio - 9 / 16) / (16 / 9 - 9 / 16);
                    framePadding = 100 - (10 * ratio);
                }

                const frameWidth = overlayCanvas.width - (framePadding * 2);
                const frameHeight = overlayCanvas.height - (framePadding * 2);
                const frameAspectRatio = frameWidth / frameHeight;

                let drawWidth, drawHeight, drawX, drawY;
                if (videoAspectRatio > frameAspectRatio) {
                    drawWidth = frameWidth;
                    drawHeight = frameWidth / videoAspectRatio;
                    drawX = framePadding;
                    drawY = framePadding + (frameHeight - drawHeight) / 2;
                } else {
                    drawHeight = frameHeight;
                    drawWidth = frameHeight * videoAspectRatio;
                    drawX = framePadding + (frameWidth - drawWidth) / 2;
                    drawY = framePadding;
                }

                ctx.drawImage(bgVideo, drawX, drawY, drawWidth, drawHeight);


               // Draw user details on bottom center - 10px from bottom
                ctx.textAlign = 'center';
                ctx.textBaseline = 'alphabetic';

                const maxBoxWidth = overlayCanvas.width * 0.8;
                let baseFontSize = overlayCanvas.height / 45;

                // Different font sizes for name vs qualification/city
                let nameFontSize = baseFontSize + 8; 
                let qualCityFontSize = baseFontSize + 3;
                ctx.font = `bold ${nameFontSize}px Lato`;

                let lines = [];

                if (name.value.trim()) {
                    lines.push({
                        text: name.value.trim(),
                        isName: true
                    });
                }

                let qualCityLine = [];
                if (qualification.value.trim()) qualCityLine.push(qualification.value.trim());
                if (city.value.trim()) qualCityLine.push(city.value.trim());

                if (qualCityLine.length > 0) {
                    lines.push({
                        text: qualCityLine.join(", "),
                        isName: false
                    });
                }

                // Check width for both fonts
                let longestLine = '';
                let maxLineWidth = 0;
                lines.forEach(line => {
                    ctx.font = `bold ${line.isName ? nameFontSize : qualCityFontSize}px Lato`;
                    const width = ctx.measureText(line.text).width;
                    if (width > maxLineWidth) {
                        maxLineWidth = width;
                        longestLine = line.text;
                    }
                });

                // Adjust font sizes if needed
                while (maxLineWidth > maxBoxWidth && (nameFontSize > 12 || qualCityFontSize > 12)) {
                    if (nameFontSize > 12) nameFontSize -= 1;
                    if (qualCityFontSize > 12) qualCityFontSize -= 1;

                    maxLineWidth = 0;
                    lines.forEach(line => {
                        ctx.font = `bold ${line.isName ? nameFontSize : qualCityFontSize}px Lato`;
                        const width = ctx.measureText(line.text).width;
                        if (width > maxLineWidth) {
                            maxLineWidth = width;
                            longestLine = line.text;
                        }
                    });
                }

                const lineSpacing = 8;
                const paddingX = 15;
                const paddingY = 15;
                const boxWidth = maxLineWidth + paddingX * 2;

                // Calculate box height considering different font sizes
                let boxHeight = paddingY * 2;
                lines.forEach(line => {
                    boxHeight += (line.isName ? nameFontSize : qualCityFontSize) + lineSpacing;
                });
                boxHeight -= lineSpacing; // Remove extra spacing after last line

                const marginBottom = 5; // Changed from 35 to 10px as requested
                const textX = (overlayCanvas.width - boxWidth) / 2;
                const textY = overlayCanvas.height - marginBottom - boxHeight;

                // Draw the box first (transparent in your code, changed to white for demo)
                ctx.fillStyle = '#ffffff00';
                ctx.fillRect(textX, textY, boxWidth, boxHeight);

                // Calculate text position within the box
                let currentY = textY + paddingY;
                const centerX = overlayCanvas.width / 2;

                // Draw each line of text with appropriate font size
                lines.forEach(line => {
                    ctx.font = `bold ${line.isName ? nameFontSize : qualCityFontSize}px Lato`;
                    ctx.fillStyle = '#ffffff';

                    // Adjust baseline for the current font size
                    currentY += line.isName ? nameFontSize : qualCityFontSize;
                    ctx.fillText(line.text, centerX, currentY);
                    currentY += lineSpacing;
                });
            } else {
                if (isPlayingMainVideo) {
                    isPlayingMainVideo = false;
                    bgVideo.muted = true;
                }
            }

            if (elapsed < totalDuration) {
                animationFrameId = requestAnimationFrame(draw);
            } else {
                bgVideo.pause();
                bgVideo.currentTime = 0;
            }
        }

        async function generateVideo() {
            if (!overlayImg) return alert("Please crop and select an image first!");
            if (!videoFile) return alert("Please upload or record a video first.");

            try {
                // Use the predefined video URL instead of user-uploaded video
                const videoURL = videoFile instanceof Blob ? URL.createObjectURL(videoFile) : URL.createObjectURL(
                    new Blob([videoFile]));
                bgVideo.src = videoURL;

                formContainer.style.display = 'none';
                previewContainer.style.display = 'flex';

                const loaderWrapper = document.getElementById('loader-wrapper');
                const downloadBtn = document.getElementById('downloadBtn');
                const shareBtn = document.getElementById('shareBtn');

                loaderWrapper.style.display = 'flex';
                downloadBtn.disabled = true;
                shareBtn.disabled = true;
                videoEnded = false;

                // Wait for video metadata to load
                await new Promise((resolve, reject) => {
                    bgVideo.onloadedmetadata = () => {
                        // Set canvas size to match video dimensions
                        videoWidth = bgVideo.videoWidth;
                        videoHeight = bgVideo.videoHeight;
                        overlayCanvas.width = videoWidth;
                        overlayCanvas.height = videoHeight;
                        resolve();
                    };

                    bgVideo.onerror = () => {
                        reject(new Error("Failed to load video"));
                    };

                    // For very large videos, we need a longer timeout
                    setTimeout(() => {
                        if (bgVideo.readyState < 2) {
                            reject(new Error("Video loading timed out. The video might be too large."));
                        }
                    }, 30000); // 30 seconds timeout for large videos
                });

                // Start with muted audio (we'll handle audio separately)
                bgVideo.muted = false;
                isPlayingMainVideo = false;

                startTime = Date.now();

                // Create canvas stream (video only)
                const canvasStream = overlayCanvas.captureStream(30);

                // Create audio context to handle audio mixing
                const audioContext = new (window.AudioContext || window.webkitAudioContext)();
                const destination = audioContext.createMediaStreamDestination();

                // Create audio track from video
                const videoAudioSource = audioContext.createMediaElementSource(bgVideo);
                videoAudioSource.connect(destination);

                // Combine streams - now including the original audio
                const combinedStream = new MediaStream([
                    ...canvasStream.getVideoTracks(),
                    ...destination.stream.getAudioTracks()
                ]);

                // Use mp4 format if supported for better mobile compatibility
                const mimeType = MediaRecorder.isTypeSupported('video/mp4') ?
                    'video/mp4; codecs="avc1.42E01E, mp4a.40.2"' :
                    'video/webm; codecs="vp9, opus"';

                recorder = new MediaRecorder(combinedStream, {
                    mimeType: mimeType,
                    videoBitsPerSecond: 2500000
                });
                recordedChunks = [];

                recorder.ondataavailable = e => {
                    if (e.data.size > 0) {
                        recordedChunks.push(e.data);
                    }
                };

                recorder.onstop = () => {
                    cancelAnimationFrame(animationFrameId);
                    clearInterval(audioCheckInterval);
                    loaderWrapper.style.display = 'none';
                    downloadBtn.disabled = false;
                    shareBtn.disabled = false;

                    // Save video metadata to server before processing starts
                    saveVideoMetadata();

                    // Clean up
                    if (audioContext.state !== 'closed') {
                        audioContext.close();
                    }
                };

                recorder.onerror = (e) => {
                    console.error("Recorder error:", e);
                    alert("Error recording video. Please try again.");
                    location.reload();
                };

                // Start recording with 100ms timeslice for smoother recording
                recorder.start(100);
                animationFrameId = requestAnimationFrame(draw);

                // Play the video when it's time (during the main video section)
                audioCheckInterval = setInterval(() => {
                    const now = Date.now();
                    const elapsed = now - startTime;
                    const videoDuration = bgVideo.duration * 1000;

                    if (elapsed >= introDuration && elapsed < (introDuration + videoDuration)) {
                        // Main video section - play the video with audio
                        if (!isPlayingMainVideo) {
                            bgVideo.currentTime = 0;
                            bgVideo.play().catch(e => console.log("Video play error:", e));
                            isPlayingMainVideo = true;
                        }
                    } else {
                        // Intro/outro section - pause the video
                        if (isPlayingMainVideo) {
                            bgVideo.pause();
                            isPlayingMainVideo = false;
                        }
                    }

                    // For very long videos, check if we're near the end
                    if (bgVideo.currentTime > bgVideo.duration - 0.5 && !videoEnded) {
                        videoEnded = true;
                    }
                }, 100);

                // Stop recording when complete
                const totalDuration = introDuration + (bgVideo.duration * 1000) + outroDuration;

                // For very long videos, we need to monitor progress differently
                if (bgVideo.duration > 300) { // If video is longer than 5 minutes
                    const progressInterval = setInterval(() => {
                        if (videoEnded) {
                            clearInterval(progressInterval);
                            if (recorder.state === 'recording') {
                                recorder.stop();
                            }
                        }
                    }, 1000);
                } else {
                    setTimeout(() => {
                        if (recorder.state === 'recording') {
                            recorder.stop();
                        }
                    }, totalDuration);
                }

            } catch (error) {
                console.error("Error generating video:", error);
                alert("Error generating video: " + error.message);
                location.reload();
            }
        }

        function saveVideoMetadata() {
            if (isVideoSaved) return;

            const xhr = new XMLHttpRequest();
            xhr.open("POST", "<?php echo site_url('/user/add_video'); ?>", true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

            const userName = name.value.trim();
            const qualificationText = qualification.value.trim();
            const cityText = city.value.trim();
            const UserID = '<?php echo $row["UserID"]; ?>';

            const params = 'input_text=' + encodeURIComponent(userName) +
                '&input_text2=' + encodeURIComponent(qualificationText) +
                '&input_text3=' + encodeURIComponent(cityText) +
                '&id=' + encodeURIComponent(UserID);

            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.status === "success") {
                                insertedVideoId = response.video_id;
                                isVideoSaved = true;
                                console.log("Video metadata saved. ID:", insertedVideoId);
                            } else {
                                console.error("Failed to save video metadata:", response.message);
                            }
                        } catch (e) {
                            console.error("Invalid response", e);
                        }
                    } else {
                        console.error("Error saving video metadata. Status:", xhr.status);
                    }
                }
            };

            xhr.onerror = function () {
                console.error("Request failed to save video metadata");
            };

            xhr.send(params);
        }

        function saveVideo() {
            const blob = new Blob(recordedChunks, { type: recordedChunks[0].type });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`;
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);

            if (insertedVideoId && !isVideoDownloadUpdated) {
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url('/user/video_download_status'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.send('video_id=' + encodeURIComponent(insertedVideoId));
                isVideoDownloadUpdated = true;
            } else {
                console.warn("Download status already updated or video ID missing.");
            }
        }

        async function shareVideo() {
            try {
                const blob = new Blob(recordedChunks, {
                    type: recordedChunks[0].type.includes('mp4') ? 'video/mp4' : 'video/webm'
                });

                // Create a smaller file if needed (some mobile devices have size limits)
                const maxSize = 25 * 1024 * 1024; // 25MB
                let fileToShare;

                if (blob.size > maxSize) {
                    // Compress the video if it's too large
                    alert('Video is large - compressing for sharing...');
                    fileToShare = await compressVideo(blob);
                } else {
                    fileToShare = new File([blob], `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`, {
                        type: blob.type
                    });
                }

                // Check if sharing is supported
                if (navigator.share && navigator.canShare && navigator.canShare({ files: [fileToShare] })) {
                    await navigator.share({
                        files: [fileToShare],
                        title: 'Check out my Video!',
                        text: 'Check out my Video!',
                    });

                    // Update share status if successful
                    if (insertedVideoId && !isVideoShareUpdated) {
                        await updateShareStatus(insertedVideoId);
                        isVideoShareUpdated = true;
                    }
                } else {
                    // Fallback for browsers that don't support file sharing
                    fallbackShare();
                }
            } catch (error) {
                console.error('Sharing error:', error);

                // More specific error messages
                if (error.name === 'AbortError') {
                    alert('Sharing was cancelled by the user.');
                } else if (error.name === 'NotAllowedError') {
                    alert('Permission to share was denied.');
                } else if (error.message.includes('too large')) {
                    alert('Video is too large to share. Please try downloading instead.');
                } else {
                    // Try fallback method if direct sharing fails
                    fallbackShare();
                }
            }
        }

        // Helper function to compress video
        async function compressVideo(blob) {
            // In a real implementation, you would use a video processing library
            // or service to properly compress the video
            // This is just a placeholder implementation

            console.warn('Actual video compression should be implemented here');
            return new File([blob], `compressed_video_${Date.now()}.mp4`, {
                type: 'video/mp4'
            });
        }

        // Helper function to update share status
        function updateShareStatus(videoId) {
            return new Promise((resolve, reject) => {
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url('/user/video_share_status'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                xhr.onload = () => {
                    if (xhr.status === 200) {
                        resolve();
                    } else {
                        reject(new Error('Failed to update share status'));
                    }
                };

                xhr.onerror = () => reject(new Error('Request failed'));
                xhr.send('video_id=' + encodeURIComponent(videoId));
            });
        }

        // Fallback sharing method
        function fallbackShare() {
            const blob = new Blob(recordedChunks, {
                type: recordedChunks[0].type
            });
            const url = URL.createObjectURL(blob);

            // Create a temporary link for download
            const link = document.createElement('a');
            link.href = url;
            link.download = `video_${Date.now()}.${blob.type.includes('mp4') ? 'mp4' : 'webm'}`;
            document.body.appendChild(link);

            // Try to show a custom share dialog
            if (confirm('Direct sharing not available. Do you want to download the video first, then share it through another app?')) {
                link.click();
            }

            // Clean up
            setTimeout(() => {
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            }, 100);
        }
    </script>

</html>