<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">Total Data by Date</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green  text-white">Generate Excel</button>
                            <input class="search" type="text" id="searchInput" placeholder="Search ">
                            <div class="row mt-2 mb-2">
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="zone" id="zone">
                                        <option>Select Zone</option>
                                        <?php
                                            $serial = 0;
                                            if (!empty($zone)) {
                                                foreach ($zone as $zonerow) {
                                                    $serial++;
                                        ?>
                                        <option value="<?php echo $zonerow['ZONEId']; ?>"><?php echo $zonerow['ZONE']; ?></option>
                                        <?php }
                                            } else { ?>
                                        <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="region" id="region">
                                        <option value="">Select Region</option>
                                        <?php
                                            $serial = 0;
                                            if (!empty($region)) {
                                                foreach ($region as $regionrow) {
                                                    $serial++;
                                        ?>
                                        <option value="<?php echo $regionrow['REGIONId']; ?>"><?php echo $regionrow['REGION']; ?></option>
                                        <?php }
                                            } else { ?>
                                        <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="hq" id="hq">
                                        <option value="">Select Area</option>
                                        <?php
                                            $serial = 0;
                                            if (!empty($hq)) {
                                                foreach ($hq as $hqrow) {
                                                    $serial++;
                                        ?>
                                        <option value="<?php echo $hqrow['HQId']; ?>"><?php echo $hqrow['HQ']; ?></option>
                                        <?php }
                                            } else { ?>
                                        <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <table class="table" id="myTable" style="">
                                <thead>
                                    <tr class="">
                                        <th scope="col">S. No.</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Total No. of Doctors</th>
                                        <th scope="col">Total No. of Patients</th>
                                        <th scope="col">Total No. of Telminorm Rx</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $serial = 0;
                                    if(!empty($data)){ 
                                        foreach($data as $row){ 
                                        $serial++;
                                        ?>
                                    <tr>
                                        <td><?php echo $serial ?></td>
                                        <td><?php echo $row['rx_date'] ?></td>
                                        <td><?php echo $row['total_doctors'] ?></td>
                                        <td><?php echo $row['total_patients'] ?></td>
                                        <td><?php echo $row['total_rx'] ?></td>
                                    </tr>
                                    <?php }  } else{ ?>
                                        <tr><td colspan="10">No Data Available</td></tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" ">
                <br>
            </div>
        </div>
    </div>

    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
    <script>
        $(document).ready(function () {
            $('#zone').change(function () { var zoneId = $(this).val(); if (zoneId) { $.ajax({ url: '<?php echo base_url("admin/get_regions_by_zone"); ?>', type: 'post', data: { zone_id: zoneId }, dataType: 'json', success: function (response) { var len = response.length; $("#region").empty(); $("#region").append('<option value="">Select Region</option>'); if (len > 0) { for (var i = 0; i < len; i++) { var id = response[i]['REGIONId']; var name = response[i]['REGION']; $("#region").append("<option value='" + id + "'>" + name + "</option>"); } } } }); $.ajax({ url: '<?php echo base_url("admin/get_total_data_by_zone"); ?>', type: 'post', data: { zone_id: zoneId }, dataType: 'json', success: function (response) { updateTable(response.table_data); } }); } else { window.location.reload(); } });
     
            $('#region').change(function () { var regionId = $(this).val(); var zoneId = $("#zone").val(); if (regionId) { $.ajax({ url: '<?php echo base_url("admin/get_hq_by_region"); ?>', type: 'post', data: { region_id: regionId }, dataType: 'json', success: function (response) { var len = response.length; $("#hq").empty(); $("#hq").append('<option value="">Select Area</option>'); if (len > 0) { for (var i = 0; i < len; i++) { var id = response[i]['HQId']; var name = response[i]['HQ']; $("#hq").append("<option value='" + id + "'>" + name + "</option>"); } } } }); $.ajax({ url: '<?php echo base_url("admin/get_total_data_by_region"); ?>', type: 'post', data: { zone_id: zoneId, region_id: regionId }, dataType: 'json', success: function (response) { updateTable(response.table_data); } }); } else { var selectedZoneId = $("#zone").val(); $.ajax({ url: '<?php echo base_url("admin/get_total_data_by_zone"); ?>', type: 'post', data: { zone_id: selectedZoneId }, dataType: 'json', success: function (response) { updateTable(response.table_data); } }); } });
    
            $('#hq').change(function () { var hqId = $(this).val(); var regionId = $("#region").val(); var zoneId = $("#zone").val(); if (hqId) { $.ajax({ url: '<?php echo base_url("admin/get_total_data_by_hq"); ?>', type: 'post', data: { zone_id: zoneId, region_id: regionId, hq_id: hqId }, dataType: 'json', success: function (response) { updateTable(response.table_data); } }); } else { var selectedRegionId = $("#region").val(); $.ajax({ url: '<?php echo base_url("admin/get_total_data_by_region"); ?>', type: 'post', data: { zone_id: zoneId, region_id: selectedRegionId }, dataType: 'json', success: function (response) { updateTable(response.table_data); } }); } });
    
            function updateTable(tableData) { $("#myTable tbody").empty(); if (tableData.length > 0) { $.each(tableData, function (index, row) { var html = "<tr>" + "<td>" + (index + 1) + "</td>" + "<td>" + row.rx_date + "</td>" + "<td>" + row.total_doctors + "</td>" + "<td>" + row.total_patients + "</td>" +  "<td>" + row.total_rx + "</td>" + "</tr>"; $("#myTable tbody").append(html); }); } else { $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>"); } }
        });
    </script>
</body>
</html>