<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>

<body>
    <?php include ("sidebar.php") ?>
    <div class="content">
        <?php include ("nav.php") ?>
        <div class="container-fluid "><br>
            <div class="row">
                <div class="col-sm-12 ">
                    <div class="bg-white rounded h-100 p-4">
                        <h3 class="mb-4"> Employee Details Form </h3>
                        <form role="form" action="<?php echo site_url('/admin/user_update') ?>" method="post"
                            onsubmit="return submitForm(this);" enctype="multipart/form-data">
                            <div class="col-sm-12 row">
                                <input type="hidden" value="<?php echo $user['UserID']; ?>" name="UserID" class="form-control">
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Employee Name</label>
                                    <input required type="text" class="form-control" placeholder="Employee Name" value="<?php echo $user['Name']; ?>" name="name">
                                    <br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Employee Mobile</label>
                                    <input type="tel" class="form-control" pattern="[6-9]{1}[0-9]{9}" placeholder="9 * * * * * * * * 0" value="<?php echo $user['phoneNO']; ?>" name="phone">
                                    <br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Employee E-mail</label>
                                    <input type="email" value="<?php echo $user['mail']; ?>"
                                        class="form-control" placeholder="Employee E-mail" name="email">
                                    <br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> Employee ID</label>
                                    <input required type="text" value="<?php echo $user['empNO']; ?>"
                                        class="form-control" placeholder="Employee ID" name="emp_no">
                                    <br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label">Designation</label><br>
                                    <select class="form-select col-1" name="user_type" required>
                                        <option value="1">BO</option>
                                        <option value="2">ABM</option>
                                        <option value="3">RBM</option>
                                        <option value="4">ZBM</option>
                                        <br>
                                    </select>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label"> City</label>
                                    <input required type="text" class="form-control" value="<?php echo $user['city']; ?>" placeholder="City" name="city">
                                    <br>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label">Zone</label><br>
                                    <select class="form-select" name="zone" id="zone" required>
                                        <option>Select Zone</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($zone)) {
                                            foreach ($zone as $zonerow) {
                                                $serial++; ?>
                                                <option value="<?php echo $zonerow['ZONEId']; ?>"><?php echo $zonerow['ZONE']; ?></option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label">Region</label><br>
                                    <select class="form-select" name="region" id="region" required>
                                        <option value="">Select Region</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($region)) {
                                            foreach ($region as $regionrow) {
                                                $serial++; ?>
                                                <option value="<?php echo $regionrow['REGIONId']; ?>"><?php echo $regionrow['REGION']; ?></option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-sm-4">
                                    <label for="" class="form-label">Area</label><br>
                                    <select class="form-select" name="hq" id="hq" required>
                                        <option value="">Select Area</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $hqrow) {
                                                $serial++; ?>
                                                <option value="<?php echo $hqrow['HQId']; ?>"><?php echo $hqrow['HQ']; ?></option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <center>
                                <div class="col-xs-12 "><br>
                                    <input type="submit" class="btn btn-primary" name="submit" value="submit">
                                </div>
                            </center>
                        </form>
                    </div>
                </div>
            </div>
            <div class=" ">
                <br>
            </div>
        </div>
    </div>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include ("footer.php") ?>

    <script>
        $(document).ready(function () {
            $('#zone').change(function () {
                var zoneId = $(this).val();
                if (zoneId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_regions_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#region").empty();
                            $("#region").append('<option value="">Select Region</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['REGIONId'];
                                    var name = response[i]['REGION'];
                                    $("#region").append("<option value='" + id + "'>" + name +
                                        "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                    window.location.reload();
                }
            });

            $('#region').change(function () {
                var regionId = $(this).val();
                var zoneId = $("#zone").val();
                if (regionId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_hq_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#hq").empty();
                            $("#hq").append('<option value="">Select Area</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['HQId'];
                                    var name = response[i]['HQ'];
                                    $("#hq").append("<option value='" + id + "'>" + name + "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_region"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else { }
            });

            $('#hq').change(function () {
                var hqId = $(this).val();
                var regionId = $("#region").val();
                var zoneId = $("#zone").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_hq"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId,
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else { }
            });
        });
    </script>
</body>

</html>