<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>

<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php") ?>
        <div class="container my-4">
            <div class="row g-4">
                <?php $serial = 0;
                if (!empty($data)) {
                    foreach ($data as $row) {
                        $serial++; ?>
                        <div class="col-6 col-md-3 text-center">
                            <div class="video-frame-container">
                                <div class="video-thumbnail only-icon"
                                    data-video-src="<?php echo base_url(); ?>assets/birthday_video_frame/<?php echo $row['frame_name']; ?>">
                                    <div class="video-play-icon large-icon">
                                        <img src="<?php echo base_url(); ?>/asset/imgs/play-icon.png" alt="Play Video">
                                    </div>
                                </div>
                                <a href="<?php echo site_url('/user/birthday_video_maker/' . $row['video_frame_id']); ?>"
                                    class="video-frame-title">
                                    <p><?php echo $row['frame_title']; ?></p>
                                </a>
                            </div>
                        </div>
                    <?php }
                } else { ?>
                    <td>Record Not Found</td><?php } ?>
            </div>
        </div>

        <!-- Video Modal (with scoped styles) -->
        <div id="videoFrameModal" class="video-frame-modal">
            <div class="video-frame-modal-content">
                <span class="video-frame-close">&times;</span>
                <video id="videoFramePlayer" controls>
                    Your browser does not support the video tag.
                </video>
            </div>
        </div>

        <div class="chr-box"><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt="character">
        </div>
    </section>
    <?php include("footer.php") ?>

    <!-- Scoped CSS for video frames only -->
    <style>
        /* Video Frame Container Styles (scoped) */
        .video-frame-container {
            position: relative;
            margin-bottom: 15px;
            display: flex;
            flex-direction: column;
            align-items: center; /* This centers the child elements horizontally */
        }

        /* Hide thumbnail image style */
        .video-thumbnail.only-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 130px;
            width: 130px;
            background-color:rgba(241, 241, 241, 0);
            border-radius: 10px;
            position: relative;
            /* box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); */
            margin: 0 auto; /* Additional centering */
        }

        /* Enlarged Play Icon */
        .video-play-icon.large-icon {
            width: 150;
            height: 150;
            background: rgba(146, 146, 146, 0);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
        }

        .video-play-icon.large-icon img {
            width: 135px;
            height: 135px;
        }

          .video-thumbnail.only-icon:hover {
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.22);
        }

        .video-frame-title p {
            margin-top: 10px;
            font-weight: 600;
            color: #333;
            transition: color 0.3s;
            text-align: center; /* Ensure text is centered */
        }

        .video-frame-title:hover p {
            color: #009c99;
        }

        /* Video Modal Styles (scoped) */
        .video-frame-modal {
            display: none;
            position: fixed;
            z-index: 10000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.9);
            transition: opacity 0.3s;
        }

        .video-frame-modal-content {
            position: relative;
            margin: auto;
            padding: 20px;
            width: 90%;
            max-width: 800px;
            top: 50%;
            transform: translateY(-50%);
        }

        #videoFramePlayer {
            width: 100%;
            max-height: 80vh;
            outline: none;
        }

        .video-frame-close {
            position: absolute;
            right: 25px;
            top: 10px;
            color: #fff;
            font-size: 35px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.3s;
            z-index: 10001; /* Ensure it's above the modal content */
        }

        .video-frame-close:hover {
            color: #009c99;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Get modal elements
            const modal = document.getElementById('videoFrameModal');
            const modalVideo = document.getElementById('videoFramePlayer');
            const closeBtn = document.querySelector('.video-frame-close');

            // Get all video thumbnails
            const videoThumbnails = document.querySelectorAll('.video-thumbnail');

            // Add click event to each thumbnail
            videoThumbnails.forEach(thumbnail => {
                thumbnail.addEventListener('click', function (e) {
                    // Prevent event bubbling to window click handler
                    e.stopPropagation();
                    const videoSrc = this.getAttribute('data-video-src');
                    modalVideo.src = videoSrc;
                    modal.style.display = 'block';
                    modalVideo.play();
                });
            });

            // Close modal when X is clicked
            closeBtn.addEventListener('click', function (e) {
                e.stopPropagation(); // Prevent event bubbling
                closeModal();
            });

            // Close modal function
            function closeModal() {
                modal.style.display = 'none';
                modalVideo.pause();
                modalVideo.currentTime = 0;
            }

            // Close modal when clicking outside
            window.addEventListener('click', function (event) {
                if (event.target === modal) {
                    closeModal();
                }
            });

            // Close modal with ESC key
            document.addEventListener('keydown', function (event) {
                if (event.key === 'Escape') {
                    closeModal();
                }
            });
        });
    </script>
</body>
</html>