<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
    <style>
        .hidden { display: none; }
        .hide-sec { display: none; }
    </style>
<body>
    <section class="section pt-0" id="about">
        <?php include ("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <h5>Patient / Volunteer Data</h5>
                    <form action="<?php echo site_url('/user/patient_data') ?>" method="post"
                        onsubmit="return validateForm()">
                        <div class="sec-1">
                            <input onkeyup="validateName(this)" class="input" type="text" id="searchInput" required oninput="filterOptions()" name="name" placeholder="Name">
                            <select id="selectOptions" style="display: none;" onchange="fillInputField()"><?php $serial = 0; if (!empty($patients)) { foreach ($patients as $patients_row) { $serial++; ?> 
                                <option value="<?php echo $patients_row['name']; ?>" data-id="<?php echo $patients_row['id']; ?>" data-phone="<?php echo $patients_row['phone']; ?>" data-age="<?php echo $patients_row['age']; ?>" data-place="<?php echo $patients_row['place']; ?>" data-examination="<?php echo $patients_row['examination']; ?>" data-gender="<?php echo $patients_row['gender']; ?>" data-hypertension="<?php echo $patients_row['hypertension']; ?>" data-drugs="<?php echo $patients_row['hypertension_drugs']; ?>" data-combination="<?php echo $patients_row['drugs_combination']; ?>" data-arb="<?php echo $patients_row['arb']; ?>" data-arb_dose="<?php echo $patients_row['arb_dose']; ?>" data-ace_i="<?php echo $patients_row['ace_i']; ?>" data-ace_i_dose="<?php echo $patients_row['ace_i_dose']; ?>" data-bb="<?php echo $patients_row['bb']; ?>" data-bb_dose="<?php echo $patients_row['bb_dose']; ?>" data-ccb="<?php echo $patients_row['ccb']; ?>" data-ccb_dose="<?php echo $patients_row['ccb_dose']; ?>" data-diuretic="<?php echo $patients_row['diuretic']; ?>" data-diuretic_dose="<?php echo $patients_row['diuretic_dose']; ?>" data-other="<?php echo $patients_row['other']; ?>" data-other_dose="<?php echo $patients_row['other_dose']; ?>" data-sbp1="<?php echo $patients_row['sbp1']; ?>" data-dbp1="<?php echo $patients_row['dbp1']; ?>" data-sbp2="<?php echo $patients_row['sbp2']; ?>" data-dbp2="<?php echo $patients_row['dbp2']; ?>" data-sbp3="<?php echo $patients_row['sbp3']; ?>" data-dbp3="<?php echo $patients_row['dbp3']; ?>" data-average_sbp="<?php echo $patients_row['average_sbp']; ?>" data-average_dbp="<?php echo $patients_row['average_dbp']; ?>" data-co_morbid_conditions="<?php echo $patients_row['co_morbid_conditions']; ?>" data-drugs_co_morbidity="<?php echo $patients_row['drugs_co_morbidity']; ?>" ><?php echo $patients_row['name']; ?> <?php echo $patients_row['date']; ?> </option><?php } } else { ?> <?php } ?> 
                            </select>
                            
                            <input onkeyup="validatePhone(this)" class="input" type="tel" id="phoneInput" name="phone" pattern="[6-9]{1}[0-9]{9}" placeholder="Phone ">
                            <input onkeyup="validateAge(this)" class="input" type="number" id="ageInput" required name="age" placeholder="Age">
                            <input class="input" type="text" id="placeInput" required name="place" onkeyup="validateName(this)" placeholder="Place">
                            <br><label>Date of Examination </label>
                            <input class="input" type="date" id="examinationInput" required name="examination" placeholder="Date of Examination">
                            <br><label>Gender : </label><br>
                            <label class="radio-inline input">Male <input type="radio" name="gender" required value="Male"></label>
                            <label class="radio-inline input">Female <input type="radio" name="gender" required value="Female"></label>
                            <label class="radio-inline input">Other <input type="radio" name="gender" required value="Other"></label>
                            <input class="input" type="hidden" required name="id" id="idInput">
                            <input class="input" type="hidden" required name="dr_id" value="<?= $row['id']; ?>">
                            <input class="input" type="hidden" required name="user_id" value="<?= $row['user_id']; ?>">
                            <input class="input" type="hidden" required name="user" value="<?= $row['user']; ?>">
                            <input class="input" type="hidden" required name="empno" value="<?= $row['empno']; ?>">
                            <input class="input" type="hidden" required name="hq_id" value="<?= $row['hq_id']; ?>">
                            <input class="input" type="hidden" required name="region_id" value="<?= $row['region_id']; ?>">
                            <input class="input" type="hidden" required name="zone_id" value="<?= $row['zone_id']; ?>">
                            <br><br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-1', 'sec-1')">Back</button>
                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-1', 'sec-2')">Next</button>
                            </div>
                        </div>
                        <div class="sec-2 hide-sec">
                            <label>Known case of Hypertension</label><br>
                            <label class="radio-inline  input">Yes <input type="radio" name="hypertension" required value="Yes" onclick="showInputField()"></label>
                            <label class="radio-inline  input">No <input type="radio" name="hypertension" required value="No" onclick="hideInputField()"></label><br>
                            <div class="radio-inline hidden"> What therapy? <br>
                                <label class="ahd">Mono<input type="radio" name="drugs" required value="Mono"></label>
                                <label class="ahd">Dual<input type="radio" name="drugs" required value="Dual"></label>
                                <label class="ahd">Triple<input type="radio" name="drugs" required value="Triple"></label>
                            </div>
                            <br>
                            <div class="Combination hidden">Which Combination: <br>
                                <div class="Combination-Drugs">
                                    <label class="ARB-Main drugs-main  ">ARB <input type="checkbox" name="combination[]" value="ARB"></label><br>
                                    <div class="ARB-additional drugs-additional hidden">
                                        <label>Telmisartan <input type="checkbox" name="ARB[]" value="Telmisartan"></label>
                                        <label>Olmesartan <input type="checkbox" name="ARB[]" value="Olmesartan"></label>
                                        <label>Losartan <input type="checkbox" name="ARB[]" value="Losartan"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input onkeyup="validateOther(this)" class="input other" type="text" id="input_style" name="ARB_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="ARB_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="ACE-I-Main drugs-main "> ACE-I <input type="checkbox" name="combination[]" value="ACE-I"></label><br>
                                    <div class="ACE-I-additional drugs-additional hidden">
                                        <label>Ramipril <input type="checkbox" name="ACE-I[]" value="Ramipril"></label>
                                        <label>Lisinopril <input type="checkbox" name="ACE-I[]" value="Lisinopril"></label>
                                        <label>Perindopril <input type="checkbox" name="ACE-I[]" value="Perindopril"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input onkeyup="validateOther(this)" class="input other" type="text" id="input_style" name="ACE_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="ACE_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="BB-Main drugs-main ">BB <input type="checkbox" name="combination[]" value="BB"></label><br>
                                    <div class="BB-additional drugs-additional hidden">
                                        <label>Metoprolol <input type="checkbox" name="BB[]" value="Metoprolol"></label>
                                        <label>Bisoprolol <input type="checkbox" name="BB[]" value="Bisoprolol"></label>
                                        <label>Atenolol <input type="checkbox" name="BB[]" value="Atenolol"></label>
                                        <label>Carvedilol <input type="checkbox" name="BB[]" value="Carvedilol"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input onkeyup="validateOther(this)" class="input other" type="text" id="input_style" name="BB_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="BB_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="CCB-Main drugs-main ">CCB <input type="checkbox" name="combination[]" value="CCB"></label><br>
                                    <div class="CCB-additional drugs-additional hidden">
                                        <label>Amlodipine <input type="checkbox" name="CCB[]" value="Amlodipine"></label>
                                        <label>Cilnidipine <input type="checkbox" name="CCB[]" value="Cilnidipine"></label>
                                        <label>Azelnidipine <input type="checkbox" name="CCB[]" value="Azelnidipine"></label>
                                        <label>Nifedipine <input type="checkbox" name="CCB[]" value="Nifedipine"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input onkeyup="validateOther(this)" class="input other" type="text" id="input_style" name="CCB_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="CCB_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="Diuretic-Main drugs-main ">Diuretic <input type="checkbox" name="combination[]" value="Diuretic"></label><br>
                                    <div class="Diuretic-additional drugs-additional hidden">
                                        <label>Chlorthalidone <input type="checkbox" name="Diuretic[]" value="Chlorthalidone"></label>
                                        <label>HCTZ <input type="checkbox" name="Diuretic[]" value="HCTZ"></label><br>
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input onkeyup="validateOther(this)" class="input other" type="text" id="input_style" name="Diuretic_other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="Diuretic_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                                <div class="Combination-Drugs">
                                    <label class="Other-Main drugs-main ">Other <input type="checkbox" name="combination[]" value="Other"></label><br>
                                    <div class="Other-additional drugs-additional hidden">
                                        <label style="padding-left:10px margin-bottom:10px">Other</label>
                                        <input onkeyup="validateOther(this)" class="input other" type="text" id="other" name="Other" placeholder="Other"><br>
                                        <label style="padding-left:10px margin-bottom:10px">Dose</label>
                                        <input class="input dose" type="number" id="input_style" name="Other_dose" placeholder="Dose">
                                    </div><br>
                                </div>
                            </div><br>
                            <div class="text-center pt-3">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-2', 'sec-1')">Back</button>
                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-2', 'sec-3')">Next</button>
                            </div>
                        </div>
                        <div class="sec-3 hide-sec">
                            <h6>Take 3 BP Readings with 2 minutes gap</h6>
                            <label style="margin-bottom:0px">Reading 1</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="sbp1" id="sbp1" required placeholder="mmHg"></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="dbp1" id="dbp1" required placeholder="mmHg"></label>
                            <label style="margin-top:8px; margin-bottom:0px">Reading 2</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="sbp2" id="sbp2" required placeholder="mmHg"></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="dbp2" id="dbp2" required placeholder="mmHg"></label>
                            <label style="margin-top:8px; margin-bottom:0px">Reading 3</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="sbp3" id="sbp3" required placeholder="mmHg"></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="dbp3" id="dbp3" required placeholder="mmHg"></label>
                            <label style="margin-top:8px; margin-bottom:0px">Average Reading</label>
                            <label style="margin:0px" class="radio-inline  ">SBP <input type="number" class="input" name="average_sbp" id="average_sbp" required placeholder="mmHg" readonly></label>
                            <label style="margin:0px" class="radio-inline  ">DBP <input type="number" class="input" name="average_dbp" id="average_dbp" required placeholder="mmHg" readonly></label>
                            <br><br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-3', 'sec-2')">Back</button>
                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-3', 'sec-4')">Next</button>
                            </div>
                            <p><b>Note:</b><br>1. If increase in BP, he or she needs to seek repeat examination after a week. 
                               <br>2. <b>DBP</b> can not be higher then <b>SBP</b>
                               <br>3. Take 3 readings with a gap of 2 minutes
                            </p>
                        </div>
                        <div class="sec-4 hide-sec">
                            <h6 >Co-morbid Conditions if any:</h6>
                            <label style="padding-left:10px">Diabetes <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="Diabetes"></label>
                            <label style="padding-left:10px">Established-ASCVD <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="Established-ASCVD"></label>
                            <label style="padding-left:10px">CKD <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="CKD"></label>
                            <label style="padding-left:10px">Previous Stroke <input type="checkbox" class="co-morbid" name="comorbid_con[]" value="Previous Stroke"></label>
                            <label style="padding-left:10px margin-bottom:10px">Other:</label>
                            <input class="input" type="text" id="input_style" name="comorbid_other" class="co-morbid" placeholder="Other"><br>
                            <label style="margin-bottom:10px">Drugs for co-morbidity </label>
                            <label style="margin:0px" class="radio-inline  "><input type="text" class="input" name="drg_comorbid" id="drugs_co_morbidity" placeholder="Drugs for co-morbidity "></label>
                            <br><br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn" onclick="showPreviousSection('sec-4', 'sec-3')">Back</button>
                                <button type="submit" class="btn sub-btn" onclick="checkComorbidConditions()">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class=""><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt=" "></div>
    </section>
    <?php include ("footer.php") ?>
    <script>
        function validateForm(section) {
            if (section === 'sec-1') {
                var name = document.querySelector('input[name="name"]').value.trim();
                var phone = document.querySelector('input[name="phone"]').value.trim();
                var place = document.querySelector('input[name="place"]').value.trim();
                var examination = document.querySelector('input[name="examination"]').value.trim();
                var age = document.querySelector('input[name="age"]').value.trim();
                var gender = document.querySelector('input[name="gender"]:checked');
                if (name === '' || place === '' || examination === '' || age === '' || !gender) {
                    alert('Please fill in all fields ');
                    return false;
                }
                if (phone !== '') {
                    var phonePattern = /^[6-9]\d{9}$/;
                    if (!phonePattern.test(phone)) {
                        alert('Please enter a valid phone number');
                        return false;
                    }
                }
            } else if (section === 'sec-2') {
                var hypertension = document.querySelector('input[name="hypertension"]:checked');
                if (!hypertension) {
                    alert('Please Choose one option for Hypertension');
                    return false;
                } else if (hypertension.value === 'Yes') {
                    var drugsRadio = document.querySelector('input[name="drugs"]:checked');
                    if (!drugsRadio) {
                        alert("Its Mandatory to select the type of Hypertension Therapy ");
                        return false;
                    }
                    var checkboxes = document.querySelectorAll('input[name="combination[]"]:checked');
                    var maxChecked = parseInt(drugsRadio.value);
                    if (drugsRadio.value === 'Mono') {
                        if (checkboxes.length !== 1) {
                            alert("Anti-Hypertensive class of drug mandatory to be selected");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Dual') {
                        if (checkboxes.length !== 2) {
                            alert("Anti-Hypertensive 2 classes of drug mandatory to be selected");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Triple') {
                        if (checkboxes.length < 3) {
                            alert("Anti-Hypertensive 3 classes of drug mandatory to be selected");
                            return false;
                        }
                    }
                    var combinationDrugs = document.querySelectorAll('.Combination-Drugs');
                    for (var i = 0; i < combinationDrugs.length; i++) {
                        var mainCheckbox = combinationDrugs[i].querySelector('.drugs-main input[type="checkbox"]');
                        var additionalCheckboxes = combinationDrugs[i].querySelectorAll('.drugs-additional input[type="checkbox"]');
                        var additionalDoseInputs = combinationDrugs[i].querySelectorAll('.drugs-additional input[type="number"].dose');
                        var otherInput = combinationDrugs[i].querySelector('.drugs-additional input[type="text"].input.other'); // Selector for the other input field                    
                        if (mainCheckbox.checked) {
                            var additionalChecked = Array.from(additionalCheckboxes).some(function(checkbox) {
                                return checkbox.checked;
                            });                    
                            var otherInputFilled = otherInput && otherInput.value.trim() !== "";                    
                            if (additionalChecked || otherInputFilled) {
                                var doseFilled = false;                    
                                for (var j = 0; j < additionalCheckboxes.length; j++) {
                                    if (additionalCheckboxes[j].checked) {
                                        var parentElement = additionalCheckboxes[j].closest('.drugs-additional');
                                        var correspondingDoseInput = parentElement.querySelector('input[type="number"].dose');
                                        if (!correspondingDoseInput || !correspondingDoseInput.value.trim()) {
                                            alert("It's Mandatory to Fill 'Dose' Input Field for " + additionalCheckboxes[j].parentNode.textContent.trim());
                                            return false;
                                        } else {
                                            doseFilled = true; 
                                        }
                                    }
                                }                    
                                if (otherInputFilled && !doseFilled) {
                                    for (var k = 0; k < additionalDoseInputs.length; k++) {
                                        if (additionalDoseInputs[k].value.trim()) {
                                            doseFilled = true;
                                            break;
                                        }
                                    }                    
                                    if (!doseFilled) {
                                        alert("It's Mandatory to Fill 'Dose' input field for " + mainCheckbox.parentNode.textContent.trim());
                                        return false;
                                    }
                                }
                            } else {
                                alert('Select class of drugs or fill the other input field for ' + mainCheckbox.parentNode.textContent.trim());
                                return false;
                            }
                        }
                    }

                }
            } else if (section === 'sec-3') {
                var sbp1 = parseInt(document.querySelector('input[name="sbp1"]').value);
                var dbp1 = parseInt(document.querySelector('input[name="dbp1"]').value);
                var sbp2 = parseInt(document.querySelector('input[name="sbp2"]').value);
                var dbp2 = parseInt(document.querySelector('input[name="dbp2"]').value);
                var sbp3 = parseInt(document.querySelector('input[name="sbp3"]').value);
                var dbp3 = parseInt(document.querySelector('input[name="dbp3"]').value);
                if (isNaN(sbp1) || isNaN(dbp1) || isNaN(sbp2) || isNaN(dbp2) || isNaN(sbp3) || isNaN(dbp3)) {
                    alert('Please enter valid BP readings ');
                    return false;
                }
                if (sbp1 < dbp1 || sbp2 < dbp2 || sbp3 < dbp3) {
                    alert('SBP cannot be less than DBP ');
                    return false;
                }
                calculateAverage(); 
            } else if (section === 'sec-4') {
                var coMorbidCheckboxes = document.querySelectorAll('.co-morbid[type="checkbox"]:checked');
                var coMorbidOtherInput = document.querySelector('.co-morbid[type="text"]');
                var isCoMorbidChecked = false;
                for (var i = 0; i < coMorbidCheckboxes.length; i++) {
                    if (coMorbidCheckboxes[i].value !== 'Other') {
                        isCoMorbidChecked = true;
                        break;
                    }
                }
                if (isCoMorbidChecked || coMorbidOtherInput.value.trim() !== '') {
                    return true;
                } else {
                    alert('Please select at least one co-morbid condition or fill in the "Other" field');
                    return false;
                }
            }
            return true;
        }
        function checkComorbidConditions() {
            var checkboxes = document.querySelectorAll('.co-morbid');
            var otherInput = document.querySelector('input[name="comorbid_other"]');
            var isChecked = false;
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    isChecked = true;
                    break;
                }
            }
            if (!isChecked && otherInput.value.trim() === "") {
                alert('Please select at least one co-morbid condition or fill "Other" field.');
                event.preventDefault();
            }
        }
        function calculateAverage() {
            var sbp1 = parseInt(document.getElementById("sbp1").value);
            var dbp1 = parseInt(document.getElementById("dbp1").value);
            var sbp2 = parseInt(document.getElementById("sbp2").value);
            var dbp2 = parseInt(document.getElementById("dbp2").value);
            var sbp3 = parseInt(document.getElementById("sbp3").value);
            var dbp3 = parseInt(document.getElementById("dbp3").value);
            var avg_sbp = ( sbp2 + sbp3) / 2;
            var avg_dbp = ( dbp2 + dbp3) / 2;
            document.getElementById("average_sbp").value = isNaN(avg_sbp) ? '' : avg_sbp.toFixed(2);
            document.getElementById("average_dbp").value = isNaN(avg_dbp) ? '' : avg_dbp.toFixed(2);
        }
        document.getElementById("sbp1").addEventListener("input", calculateAverage);
        document.getElementById("dbp1").addEventListener("input", calculateAverage);
        document.getElementById("sbp2").addEventListener("input", calculateAverage);
        document.getElementById("dbp2").addEventListener("input", calculateAverage);
        document.getElementById("sbp3").addEventListener("input", calculateAverage);
        document.getElementById("dbp3").addEventListener("input", calculateAverage);

        function showNextSection(currentSec, nextSec) {
            if (validateForm(currentSec)) {
                if (currentSec === 'sec-2') {
                    var hypertensionValue = document.querySelector('input[name="hypertension"]:checked').value;
                    if (hypertensionValue === 'Yes') {
                        hideAndUnhide(currentSec, 'sec-3');
                        return;
                    }
                }
                hideAndUnhide(currentSec, nextSec);
            }
        }
        function hideAndUnhide(currentSec, nextSec) {
            document.querySelector('.' + currentSec).style.display = 'none';
            document.querySelector('.' + nextSec).style.display = 'block';
            if (nextSec === 'sec-2') {
                enableCheckboxes(1); 
            }
        }
        function showPreviousSection(currentSec, prevSec) {
            hideAndUnhide(currentSec, prevSec);
            currentSection = prevSec;
        }
        function showInputField() {
            var inputs = document.querySelectorAll('.hidden');
            for (var i = 0; i < inputs.length; i++) {
                inputs[i].style.display = 'inline-block';
                if (inputs[i].getAttribute('type') === 'radio') {
                    inputs[i].setAttribute('required', 'required');
                }
            }
        }
        function hideInputField() {
            var drugsRadios = document.querySelectorAll('input[name="drugs"]');
            for (var j = 0; j < drugsRadios.length; j++) {
                if (drugsRadios[j].value === 'Mono') {
                    drugsRadios[j].setAttribute('value', 'No');
                    drugsRadios[j].checked = true;
                } else {
                    drugsRadios[j].disabled = true;
                }
            }
            var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var k = 0; k < combinationCheckboxes.length; k++) {
                if (combinationCheckboxes[k].value === 'ARB') {
                    combinationCheckboxes[k].checked = false;
                    combinationCheckboxes[k].value = 'NO'; 
                } else {
                    combinationCheckboxes[k].disabled = true;
                }
            }
        }
        function enableCheckboxes(maxChecked) {
            var checkboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].disabled = false;
            }
        }
        function validateName(input) {
            var namePattern = /^[a-zA-Z ]+$/;
            if (!input.value.match(namePattern)) {
                alert('Please enter Valid Name');
                input.value = '';
                return false;
            }
            return true;
        }
        function validatePhone(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^[6-9]\d{9}$/;
            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, '');
                if (input.value.length > 10) {
                    input.value = input.value.slice(0, 10);
                }
            }
        }
        function validateAge(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^\d{2}$/;
            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, '');
                if (input.value.length > 2) {
                    input.value = input.value.slice(0, 2);
                }
            }
        }   
        function validateOther(input) {
            var namePattern = /^[a-zA-Z ]+$/;
            if (!input.value.match(namePattern)) {
                alert('Please enter Valid Name');
                input.value = '';
                return false;
            }
            return true;
        }     
    </script>
    <script>
        function filterOptions() {
            var input = document.getElementById("searchInput").value.toLowerCase();
            var select = document.getElementById("selectOptions");
            var options = select.getElementsByTagName("option");
            for (var i = 0; i < options.length; i++) {
                var optionValue = options[i].value.toLowerCase();
                if (optionValue.includes(input)) {
                    options[i].style.display = "";
                } else {
                    options[i].style.display = "none";
                }
            }
            if (input.length >= 3) {
                select.style.display = "";
                select.setAttribute("size", "5");
            } else {
                select.style.display = "none";
            }
        }
    
        function fillInputField() {
            var select = document.getElementById("selectOptions");
            var selectedOption = select.options[select.selectedIndex];
            if (selectedOption) {
                // Sec-1 
                document.getElementById("searchInput").value = selectedOption.value;
                document.getElementById("idInput").value = selectedOption.getAttribute('data-id');
                document.getElementById("phoneInput").value = selectedOption.getAttribute('data-phone');
                document.getElementById("ageInput").value = selectedOption.getAttribute('data-age');
                document.getElementById("placeInput").value = selectedOption.getAttribute('data-place');
                document.getElementById("examinationInput").value = selectedOption.getAttribute('data-examination');
                var gender = selectedOption.getAttribute('data-gender');
                document.querySelector('input[name="gender"][value="' + gender + '"]').checked = true;
                // Sec-2 
                // var hypertension = selectedOption.getAttribute('data-hypertension');
                // document.querySelector('input[name="hypertension"][value="' + hypertension + '"]').checked = true;
                //     if (hypertension === 'Yes') {
                //         document.querySelector('.Combination').style.display = ''; 
                //         var drugs = selectedOption.getAttribute('data-drugs');
                //         document.querySelector('input[name="drugs"][value="' + drugs + '"]').checked = true;
                //         var combinations = selectedOption.getAttribute('data-combination').split(', ');
                //         combinations.forEach(combination => {
                //             var checkbox = document.querySelector('input[name="combination[]"][value="' + combination + '"]');
                //             if (checkbox) {
                //                 checkbox.checked = true;
                //             }
                //         });
                //     var arbValues = selectedOption.getAttribute("data-arb").split(', ');
                //     var otherArbValues = []; 
                //     arbValues.forEach(value => {
                //         var checkbox = document.querySelector('.ARB-additional [name="ARB[]"][value="' + value + '"]');
                //         if (checkbox) {
                //             checkbox.checked = true;
                //         } else {
                //             otherArbValues.push(value); 
                //         }
                //     });
                //     if (otherArbValues.length > 0) {
                //         var otherField = document.querySelector('.ARB-additional [name="ARB_other"]');
                //         if (otherField) {
                //             otherField.value = otherArbValues.join(', '); 
                //         }
                //     }                    
                //     document.querySelector('.ARB-additional [name="ARB_dose"]').value = selectedOption.getAttribute("data-arb_dose");
                //     var aceiValues = selectedOption.getAttribute("data-ace_i").split(', ');
                //     var otherAceiValues = []; 
                //     aceiValues.forEach(value => {
                //         var checkbox = document.querySelector('.ACE-I-additional [name="ACE-I[]"][value="' + value + '"]');
                //         if (checkbox) {
                //             checkbox.checked = true;
                //         } else {
                //             otherAceiValues.push(value);
                //         }
                //     });
                //     if (otherAceiValues.length > 0) {
                //         var otherField = document.querySelector('.ACE-I-additional [name="ACE_other"]');
                //         if (otherField) {
                //             otherField.value = otherAceiValues.join(', '); 
                //         }
                //     }
                //     document.querySelector('.ACE-I-additional [name="ACE_dose"]').value = selectedOption.getAttribute("data-ace_i_dose");
                //     var bbValues = selectedOption.getAttribute("data-bb").split(', ');
                //     var otherValues = [];
                //     bbValues.forEach(value => {
                //         var checkbox = document.querySelector('.BB-additional [name="BB[]"][value="' + value + '"]');
                //         if (checkbox) {
                //             checkbox.checked = true;
                //         } else {
                //             otherValues.push(value); 
                //         }
                //     });
                //     if (otherValues.length > 0) {
                //         var otherField = document.querySelector('[name="BB_other"]');
                //         if (otherField) {
                //             otherField.value = otherValues.join(', ');
                //         }
                //     }
                //     document.querySelector('.BB-additional [name="BB_dose"]').value = selectedOption.getAttribute("data-bb_dose");
                //     var ccbValues = selectedOption.getAttribute("data-ccb").split(', ');
                //     var otherCcbValues = []; 
                //     ccbValues.forEach(value => {
                //         var checkbox = document.querySelector('.CCB-additional [name="CCB[]"][value="' + value + '"]');
                //         if (checkbox) {
                //             checkbox.checked = true;
                //         } else {
                //             otherCcbValues.push(value); 
                //         }
                //     });
                //     if (otherCcbValues.length > 0) {
                //         var otherField = document.querySelector('.CCB-additional [name="CCB_other"]');
                //         if (otherField) {
                //             otherField.value = otherCcbValues.join(', ');
                //         }
                //     }
                //     document.querySelector('.CCB-additional [name="CCB_dose"]').value = selectedOption.getAttribute("data-ccb_dose");
                //     var diureticValues = selectedOption.getAttribute("data-diuretic").split(', ');
                //     var otherDiureticValues = [];                    
                //     diureticValues.forEach(value => {
                //         var checkbox = document.querySelector('.Diuretic-additional [name="Diuretic[]"][value="' + value + '"]');
                //         if (checkbox) {
                //             checkbox.checked = true;
                //         } else {
                //             otherDiureticValues.push(value);
                //         }
                //     });                    
                //     if (otherDiureticValues.length > 0) {
                //         var otherField = document.querySelector('.Diuretic-additional [name="Diuretic_other"]');
                //         if (otherField) {
                //             otherField.value = otherDiureticValues.join(', ');
                //         }
                //     }                    
                //     document.querySelector('.Diuretic-additional [name="Diuretic_dose"]').value = selectedOption.getAttribute("data-diuretic_dose");
                //     document.getElementById("other").value = selectedOption.getAttribute('data-other');
                //     document.querySelector('.Other-additional [name="Other_dose"]').value = selectedOption.getAttribute("data-other_dose");
                // } else {
                //     // Execute this code block if hypertension === 'No'
                //     var drugsRadios = document.querySelectorAll('input[name="drugs"]');
                //     for (var j = 0; j < drugsRadios.length; j++) {
                //         if (drugsRadios[j].value === 'Mono') {
                //             drugsRadios[j].setAttribute('value', 'No');
                //             drugsRadios[j].checked = true;
                //         } else {
                //             drugsRadios[j].disabled = true;
                //         }
                //     }
                //     var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
                //     for (var k = 0; k < combinationCheckboxes.length; k++) {
                //         if (combinationCheckboxes[k].value === 'ARB') {
                //             combinationCheckboxes[k].checked = false;
                //             combinationCheckboxes[k].value = 'NO'; // Corrected value assignment
                //         } else {
                //             combinationCheckboxes[k].disabled = true;
                //         }
                //     }
                //     document.querySelector('.Combination').style.display = 'none';
                // }

                // Assuming selectedOption is defined elsewhere in your code
                var hypertension = selectedOption.getAttribute('data-hypertension');
                
                if (hypertension === 'Yes') {
                    document.querySelector('.Combination').style.display = ''; 
                
                    // Reset drugs radio buttons
                    var drugsRadios = document.querySelectorAll('input[name="drugs"]');
                    drugsRadios.forEach(radio => {
                        radio.disabled = false;  // Enable all radios first
                        if (radio.value === 'Mono') {
                            radio.checked = true; // Default to 'Mono'
                        } else {
                            radio.checked = false;
                        }
                    });
                
                    // Select appropriate drugs radio based on selectedOption
                    var drugs = selectedOption.getAttribute('data-drugs');
                    if (drugs) {
                        var drugsRadio = document.querySelector('input[name="drugs"][value="' + drugs + '"]');
                        if (drugsRadio) {
                            drugsRadio.checked = true;
                        }
                    }
                
                    // Reset combination checkboxes
                    var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
                    combinationCheckboxes.forEach(checkbox => {
                        checkbox.disabled = false;  // Enable all checkboxes first
                        checkbox.checked = false;   // Uncheck all checkboxes by default
                        if (checkbox.value === 'ARB') {
                            checkbox.checked = true;  // Default to checking 'ARB'
                        }
                    });
                
                    // Select appropriate combination checkboxes based on selectedOption
                    var combinations = selectedOption.getAttribute('data-combination').split(', ');
                    combinations.forEach(combination => {
                        var checkbox = document.querySelector('input[name="combination[]"][value="' + combination + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        }
                    });
                
                    // Handle ARB additional values
                    var arbValues = selectedOption.getAttribute('data-arb').split(', ');
                    var otherArbValues = []; 
                    arbValues.forEach(value => {
                        var checkbox = document.querySelector('.ARB-additional [name="ARB[]"][value="' + value + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        } else {
                            otherArbValues.push(value); 
                        }
                    });
                    if (otherArbValues.length > 0) {
                        var otherField = document.querySelector('.ARB-additional [name="ARB_other"]');
                        if (otherField) {
                            otherField.value = otherArbValues.join(', '); 
                        }
                    }                    
                    document.querySelector('.ARB-additional [name="ARB_dose"]').value = selectedOption.getAttribute('data-arb_dose');
                
                    // Handle ACE-I additional values
                    var aceiValues = selectedOption.getAttribute('data-ace_i').split(', ');
                    var otherAceiValues = []; 
                    aceiValues.forEach(value => {
                        var checkbox = document.querySelector('.ACE-I-additional [name="ACE-I[]"][value="' + value + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        } else {
                            otherAceiValues.push(value);
                        }
                    });
                    if (otherAceiValues.length > 0) {
                        var otherField = document.querySelector('.ACE-I-additional [name="ACE_other"]');
                        if (otherField) {
                            otherField.value = otherAceiValues.join(', '); 
                        }
                    }
                    document.querySelector('.ACE-I-additional [name="ACE_dose"]').value = selectedOption.getAttribute('data-ace_i_dose');
                
                    // Handle BB additional values
                    var bbValues = selectedOption.getAttribute('data-bb').split(', ');
                    var otherValues = [];
                    bbValues.forEach(value => {
                        var checkbox = document.querySelector('.BB-additional [name="BB[]"][value="' + value + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        } else {
                            otherValues.push(value); 
                        }
                    });
                    if (otherValues.length > 0) {
                        var otherField = document.querySelector('[name="BB_other"]');
                        if (otherField) {
                            otherField.value = otherValues.join(', ');
                        }
                    }
                    document.querySelector('.BB-additional [name="BB_dose"]').value = selectedOption.getAttribute('data-bb_dose');
                
                    // Handle CCB additional values
                    var ccbValues = selectedOption.getAttribute('data-ccb').split(', ');
                    var otherCcbValues = []; 
                    ccbValues.forEach(value => {
                        var checkbox = document.querySelector('.CCB-additional [name="CCB[]"][value="' + value + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        } else {
                            otherCcbValues.push(value); 
                        }
                    });
                    if (otherCcbValues.length > 0) {
                        var otherField = document.querySelector('.CCB-additional [name="CCB_other"]');
                        if (otherField) {
                            otherField.value = otherCcbValues.join(', ');
                        }
                    }
                    document.querySelector('.CCB-additional [name="CCB_dose"]').value = selectedOption.getAttribute('data-ccb_dose');
                
                    // Handle Diuretic additional values
                    var diureticValues = selectedOption.getAttribute('data-diuretic').split(', ');
                    var otherDiureticValues = [];                    
                    diureticValues.forEach(value => {
                        var checkbox = document.querySelector('.Diuretic-additional [name="Diuretic[]"][value="' + value + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        } else {
                            otherDiureticValues.push(value);
                        }
                    });                    
                    if (otherDiureticValues.length > 0) {
                        var otherField = document.querySelector('.Diuretic-additional [name="Diuretic_other"]');
                        if (otherField) {
                            otherField.value = otherDiureticValues.join(', ');
                        }
                    }                    
                    document.querySelector('.Diuretic-additional [name="Diuretic_dose"]').value = selectedOption.getAttribute('data-diuretic_dose');
                
                    // Set other fields
                    document.getElementById('other').value = selectedOption.getAttribute('data-other');
                    document.querySelector('.Other-additional [name="Other_dose"]').value = selectedOption.getAttribute('data-other_dose');
                
                } else {
                    // Execute this code block if hypertension === 'No'
                    var drugsRadios = document.querySelectorAll('input[name="drugs"]');
                    drugsRadios.forEach(radio => {
                        if (radio.value === 'Mono') {
                            radio.checked = true;
                        } else {
                            radio.disabled = true;
                        }
                    });
                
                    var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
                    combinationCheckboxes.forEach(checkbox => {
                        if (checkbox.value === 'ARB') {
                            checkbox.checked = false;
                        }
                        checkbox.disabled = true;
                    });
                
                    document.querySelector('.Combination').style.display = 'none';
                }

                // Sec-3 
                document.getElementById("sbp1").value = selectedOption.getAttribute('data-sbp1');
                document.getElementById("dbp1").value = selectedOption.getAttribute('data-dbp1');
                document.getElementById("sbp2").value = selectedOption.getAttribute('data-sbp2');
                document.getElementById("dbp2").value = selectedOption.getAttribute('data-dbp2');
                document.getElementById("sbp3").value = selectedOption.getAttribute('data-sbp3');
                document.getElementById("dbp3").value = selectedOption.getAttribute('data-dbp3');
                document.getElementById("average_sbp").value = selectedOption.getAttribute('data-average_sbp');
                document.getElementById("average_dbp").value = selectedOption.getAttribute('data-average_dbp');
                // Sec-4 
                var co_morbid_conditionsValues = selectedOption.getAttribute("data-co_morbid_conditions").split(', ');
                var otherComorbidConditionsValues = [];
                co_morbid_conditionsValues.forEach(value => {
                    var checkbox = document.querySelector('input[name="comorbid_con[]"][value="' + value + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    } else {
                        otherComorbidConditionsValues.push(value);
                    }
                });                
                if (otherComorbidConditionsValues.length > 0) {
                    var otherField = document.querySelector('input[name="comorbid_other"]');
                    if (otherField) {
                        otherField.value = otherComorbidConditionsValues.join(', ');
                    }
                }          
                document.getElementById("drugs_co_morbidity").value = selectedOption.getAttribute('data-drugs_co_morbidity');
                select.style.display = "none";
            }
        }    
        document.getElementById("selectOptions").addEventListener("click", fillInputField);
    </script>
</body>
</html>