<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Video_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Area_controller extends BaseController
{

    public function a_dashboard()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $patient = new Patient_Model;
            $rx = new Rx_Model;
            $posterModel = new Poster_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }
            $hq = $hq_id;
            $data = [
                'totalUsers' => $user->where('HQ', $hq)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUsers(),
                'totalDoctors' => $doctor->where('hq_id', $hq_id)->getTotalDoctors(),
                'totalPatients' => $patient->where('hq_id', $hq_id)->getTotalPatient(),
                'totalrx' => $rx->where('hq_id', $hq_id)->getTotalRxUser(),
                'totalPosters' => $posterModel->getTotalPostersByHq($hq_id),
                'totalVideos' => $videosModel->getTotalVideosByHq($hq_id),

            ];
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function a_user_tbl()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                $user_array = $user->where('tbl_user.HQ', $hq_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUser();
                $data['data'] = $user_array;

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('abm/user_table', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function a_total_doctors()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $doctor = new Doctor_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                $data['data'] = $doctor->where('doctor_data.hq_id', $hq_id)->getTotalDoctor();

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('abm/total_doctors', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }


    public function a_total_Patients()
    {
        $session = session();
        if ($session->has('UserID')) {

            $user = new User_Model;
            $patient = new Patient_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }

                $data['data'] = $patient->where('patient_data.hq_id', $hq_id)->getTotalPatients();

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('abm/total_patient', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function a_doctor_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $doctor = new Doctor_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $doctor->where('hq_id', $hq_id)->gettotalDoctorEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/usercount_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_patient_users_count()
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $patient->where('hq_id', $hq_id)->gettotalPatientEentry();
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/usercount_patient', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_doctor_patients($Did)
    {
        $session = session();
        if ($session->has('UserID')) {
            $patient = new Patient_Model;
            $user = new User_Model;
            $id = $session->get('UserID');

            $data['data'] = $patient->where('dr_id', $Did)->getTotalPatients();
            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/patient_doctor', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_admin_profile()
    {
        $session = session();
        if ($session->has('UserID')) {
            $id = $session->get('UserID');
            $user = new User_Model;
            $data['admin'] = $user->where('UserID', $id)->getProfile();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }
    public function a_add_user()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            if (!empty($row)) {

                $id = $session->get('UserID');
                $data['data'] = $user->where('UserID', $id)->getRecords();

                $data['Name'] = $user->where('UserID', $id)->first();

                $FrameModel = new Frame_Model();
                $campaign = $FrameModel->getAllCampaignsWithFrames();
                $data['campaigns'] = $campaign;

                return view('abm/add_user', $data);
            } else {
                return redirect()->to('/index');
            }
        }
    }

    public function a_user_insert()
    {
        $user_insert = new User_Model;

        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'HQ' => $this->request->getVar('hq'),
            'DESIG' => 'BO',
            'REGIONId' => $this->request->getVar('region'),
            'zoneId' => $this->request->getVar('zone'),
            'pass' => 'telminorm',
        ];
        $user_insert->save($data);
        return redirect()->to('abm/add_user');
    }

    public function a_user_edit($id)
    {
        $user = new User_Model;
        $data['row'] = $user->where('UserID', $id)->first();

        $data['Name'] = $user->where('UserID', $id)->first();

        $FrameModel = new Frame_Model();
        $campaign = $FrameModel->getAllCampaignsWithFrames();
        $data['campaigns'] = $campaign;

        return view('abm/user_edit', $data);
    }

    public function a_user_update()
    {
        $user = new user_Model;
        $UserID = $this->request->getVar('UserID');
        $data = [
            'Name' => $this->request->getVar('name'),
            'phoneNO' => $this->request->getVar('phone'),
            'mail' => $this->request->getVar('email'),
            'userType' => $this->request->getVar('user_type'),
            'empNO' => $this->request->getVar('emp_no'),
            'city' => $this->request->getVar('city'),
            'DESIG' => $this->request->getVar('desig'),
            'pass' => 'telminorm',

        ];
        $user->where('UserID', $UserID)->set($data)->update();
        return redirect()->to('abm/user_tbl');
    }
    public function a_user_delete($id)
    {
        $user = new User_Model;
        $user->where('UserID', $id)->delete();
        return redirect()->to('abm/user_tbl');
    }

    public function total_rx()
    {
        $session = session();
        if ($session->has('UserID')) {
            $rx = new rx_Model;
            $user = new User_Model;
            $id = $session->get('UserID');
            $row['row'] = $user->where('UserID', $id)->first();
            foreach ($row as $zrow) {
                $hq_id = $zrow['HQ'];
            }

            $data['data'] = $rx->where('rx_data.hq_id', $hq_id)->getTotalPatientsrx();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/total_rx', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function a_totel_poster()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $posterModel->getPosterWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function a_totel_videos()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $videosModel = new Video_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $videosModel->getVideosWithUsersDetailsByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/videos', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function a_users_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            // Fetch user count data for the same region
            $data['data'] = $posterModel->getUserCountByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function a_users_date_count()
    {
        $session = session();

        if ($session->has('UserID')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $id = $session->get('UserID');
            $row['row'] = $userModel->where('UserID', $id)->first();
            if (!empty($row)) {
                foreach ($row as $zrow) {
                    $hq_id = $zrow['HQ'];
                }
            }

            $data['data'] = $posterModel->getEntryByDateByHq($hq_id);

            $data['Name'] = $userModel->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function poster_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }


    public function video_maker()
    {
        $session = session();
        if ($session->has('UserID')) {
            $user = new User_Model;

            $id = $session->get('UserID');
            $data['row'] = $user->where('UserID', $id)->first();

            $data['Name'] = $user->where('UserID', $id)->first();

            $FrameModel = new Frame_Model();
            $campaign = $FrameModel->getAllCampaignsWithFrames();
            $data['campaigns'] = $campaign;

            return view('abm/video_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_video()
    {
        $video = new Video_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'date' => date('Y-m-d'),
        ];

        $video->save($data);
        $videoId = $video->insertID();

        return $this->response->setJSON(['status' => 'success', 'video_id' => $videoId]);
    }

    public function video_download_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function video_share_status()
    {
        $poster = new Video_Model();
        $video_id = $this->request->getPost('video_id');

        if ($video_id) {
            $poster->update($video_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

}