<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\API\ResponseTrait;
use App\Models\DoctorModel;
use App\Models\User_Model;
use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;

use App\Models\Doctor_Model;
use App\Models\Patient_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Rx_Model;

class Doctor extends BaseController
{
     use ResponseTrait;
    public function index()
    {
        //
    }
    
 
    public function list()
    {
        try {
            $doctor = new DoctorModel;
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            $role_id = $decoded->role_id;
            
    
            
            if($role_id=="1"){
                return $this->respond($doctor->where('user_id',$userId)->orderBy('id', 'DESC')->findAll(), 200);
            }else if($role_id=="2"){
                 return $this->respond($doctor->getDocterByUserHQ($userId), 200);
            }else if($role_id=="3"){
                return $this->respond($doctor->getDocterByUserRegion($userId), 200);
            }else if($role_id=="4"){
                return $this->respond($doctor->getDocterByUserZone($userId), 200);
            }else{
              return $this->respond($doctor->orderBy('id', 'DESC')->findAll(), 200);
            }
           


        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                200
            );
        }
    }

    public function delete($id)
    {
        try {
            $camp = new DoctorModel;
            if($camp->delete($id)){
                return $this->respond(
                    [
                        'message' => 'Camp delete successfully'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    public function create()
    {
          try {
            $camp = new DoctorModel;
            $input = $this->getRequestInput($this->request);
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $userId = $decoded->email;
            $User = new User_Model;
            $row = $User->getRow($userId);
            
            $input['user'] = $row['Name'];
            $input['user_id'] = $row['UserID'];
            $input['empno'] = $row['empNO'];
            $input['hq_id'] = $row['HQ'];
            $input['region_id'] = $row['REGIONId'];
            $input['zone_id'] = $row['zoneId'];
            
            if($camp->save($input)){
                return $this->respond(
                    [
                        'message' => 'save Docter'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    public function update($id)
    {
        try {
            $camp = new DoctorModel;
            $input = $this->getRequestInput($this->request);
            if($camp->update($id,$input)){
                return $this->respond(
                    [
                        'message' => 'Update Doctor'
                    ],
                    200
                );
            }else{
                return $this->respond(
                    [
                        'message' => 'try camp not save successfully'
                    ],
                    200
                );
            }
         } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                ResponseInterface::HTTP_NOT_FOUND
            );
        }
    }
    
    public function dashboard()
    {
        try {
            $doctor = new DoctorModel;
            
            $key = getenv('JWT_SECRET');
            $header = $this->request->getHeader("Authorization");
            if(!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            $id = $decoded->email;
            $role_id = $decoded->role_id;
             
            $user = new User_Model;
            $doctor = new Doctor_Model;
            $patient = new Patient_Model;
            $rx = new Rx_Model;

            $row = $user->where('UserID', $id)->first();
            
            $hq_id = $row['HQ'];
            $Region_id = $row['REGIONId'];
            $zone_id = $row['zoneId'];
            
            if($role_id=="1"){ 
                
               $data = [
                    'row' => $user->where('UserID', $id)->first(),
                    'totalDoctors' => $doctor->where('user_id', $id)->countAllResults(),
                    'totalPatients' => $patient->where('user_id', $id)->countAllResults(),
                    'totalrx' => $rx->where('user_id', $id)->countAllResults()
    
                ]; 
            }else if($role_id=="2"){ 
               $data = [
                    'totalUsers' => $user->where('HQ', $hq_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM', 'RBM'])->getTotalUsers(),
                    'totalDoctors' => $doctor->where('hq_id', $hq_id)->countAllResults(),
                    'totalPatients' => $patient->where('hq_id', $hq_id)->countAllResults(),
                    'totalrx' => $rx->where('hq_id', $hq_id)->countAllResults(),
    
                ]; 
            }else if($role_id=="3"){ 
                $data = [
                    'totalUsers' => $user->where('REGIONId', $Region_id)->where('UserID !=', $id)->whereNotIn('DESIG', ['ZBM'])->getTotalUsers(),
                    'totalDoctors' => $doctor->where('region_id', $Region_id)->countAllResults(),
                    'totalPatients' => $patient->where('region_id', $Region_id)->countAllResults(),
                    'totalrx' => $rx->where('region_id', $Region_id)->countAllResults()
    
                ]; 
            }else if($role_id=="4"){ 
                $data = [
                    'totalUsers' => $user->where('zoneId', $zone_id)->where('UserID !=', $id)->getTotalUsers(),
                    'totalDoctors' => $doctor->where('zone_id', $zone_id)->countAllResults(),
                    'totalPatients' => $patient->where('zone_id', $zone_id)->countAllResults(),
                    'totalrx' => $rx->where('zone_id', $zone_id)->countAllResults()
    
                ]; 
            }else if($role_id=="5"){ 
                $data = [
                    'totalUsers' => $user->where('UserID !=', $id)->getTotalUsers(),
                    'totalDoctors' => $doctor->countAllResults(),
                    'totalPatients' => $patient->countAllResults(),
                    'totalrx' => $rx->countAllResults()
    
                ]; 
            }
            
            
           return $this->respond(
                    $data,
                    200
                );


        } catch (Exception $e) {
            return $this->respond(
                [
                    'message' => 'Could not find client for specified ID'
                ],
                200
            );
        }
    }
    
}
