<?php

namespace App\Models;

use CodeIgniter\Model;

class Birthday_Video_Model extends Model
{
    protected $table = 'birthday_video_tbl';
    protected $primaryKey = 'bday_video_id';

    protected $allowedFields = ['bday_video_id', 'doctor_name', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];


    public function getTotalVideos()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('birthday_video_tbl.*, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'birthday_video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('birthday_video_tbl.fk_user_id', $id)
            ->groupBy('birthday_video_tbl.doctor_name, birthday_video_tbl.qualification, birthday_video_tbl.city, birthday_video_tbl.date')
            ->orderBy('birthday_video_tbl.bday_video_id', 'DESC')
            ->findAll();
    }
    public function getVideosWithUsersDetails()
    {
        return $this->select('birthday_video_tbl.*, birthday_video__frame_tbl.frame_title, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_video__frame_tbl', 'birthday_video_tbl.fk_frame_id = birthday_video__frame_tbl.video_frame_id', 'left')
            ->join('tbl_user', 'birthday_video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('birthday_video_tbl.doctor_name, birthday_video_tbl.qualification, birthday_video_tbl.city, birthday_video_tbl.date, birthday_video_tbl.fk_user_id, birthday_video_tbl.fk_frame_id')
            ->orderBy('birthday_video_tbl.bday_video_id', 'ASC')
            ->findAll();
    }

    public function getVideosWithUsersDetailsByZone($zoneId)
    {
        return $this->select('birthday_video_tbl.*, birthday_video__frame_tbl.frame_title, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_video__frame_tbl', 'birthday_video_tbl.fk_frame_id = birthday_video__frame_tbl.video_frame_id', 'left')
            ->join('tbl_user', 'birthday_video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('birthday_video_tbl.doctor_name, birthday_video_tbl.qualification, birthday_video_tbl.city, birthday_video_tbl.date, birthday_video_tbl.fk_user_id, birthday_video_tbl.fk_frame_id')
            ->orderBy('birthday_video_tbl.bday_video_id', 'ASC')
            ->findAll();
    }

    public function getVideosWithUsersDetailsByRegion($regionId)
    {
        return $this->select('birthday_video_tbl.*, birthday_video__frame_tbl.frame_title, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_video__frame_tbl', 'birthday_video_tbl.fk_frame_id = birthday_video__frame_tbl.video_frame_id', 'left')
            ->join('tbl_user', 'birthday_video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $regionId)
            ->groupBy('birthday_video_tbl.doctor_name, birthday_video_tbl.qualification, birthday_video_tbl.city, birthday_video_tbl.date, birthday_video_tbl.fk_user_id, birthday_video_tbl.fk_frame_id')
            ->orderBy('birthday_video_tbl.bday_video_id', 'ASC')
            ->findAll();
    }

    public function getVideosWithUsersDetailsByHq($hqId)
    {
        return $this->select('birthday_video_tbl.*, birthday_video__frame_tbl.frame_title, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('birthday_video__frame_tbl', 'birthday_video_tbl.fk_frame_id = birthday_video__frame_tbl.video_frame_id', 'left')
            ->join('tbl_user', 'birthday_video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('birthday_video_tbl.doctor_name, birthday_video_tbl.qualification, birthday_video_tbl.city, birthday_video_tbl.date, birthday_video_tbl.fk_user_id, birthday_video_tbl.fk_frame_id')
            ->orderBy('birthday_video_tbl.bday_video_id', 'ASC')
            ->findAll();
    }


}


?>