<?php

namespace App\Models;

use CodeIgniter\Model;

class Brandreminder_Poster_Model extends Model
{
    protected $table = 'brand_reminder_tbl';
    protected $primaryKey = 'brand_reminder_id';

    protected $allowedFields = ['brand_reminder_id', 'doctor_name', 'doctor_img', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];

    public function getTotalPosters()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('brand_reminder_tbl.*, brandreminder_frame_tbl.frame_name, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('brandreminder_frame_tbl', 'brand_reminder_tbl.fk_frame_id = brandreminder_frame_tbl.brandreminder_frame_id', 'left')
            ->join('tbl_user', 'brand_reminder_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('brand_reminder_tbl.fk_user_id', $id)
            ->groupBy('brand_reminder_tbl.doctor_name, brand_reminder_tbl.qualification, brand_reminder_tbl.city, brand_reminder_tbl.date')
            ->orderBy('brand_reminder_tbl.brand_reminder_id', 'DESC')
            ->findAll();
    }


    public function getPosterWithUsersDetails()
    {
        return $this->select('brand_reminder_tbl.*, brandreminder_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('brandreminder_frame_tbl', 'brand_reminder_tbl.fk_frame_id = brandreminder_frame_tbl.brandreminder_frame_id', 'left')
            ->join('tbl_user', 'brand_reminder_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('brand_reminder_tbl.doctor_name, brand_reminder_tbl.qualification, brand_reminder_tbl.city, brand_reminder_tbl.date, brand_reminder_tbl.fk_user_id')
            ->orderBy('brand_reminder_tbl.brand_reminder_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByZone($zoneId)
    {
        return $this->select('brand_reminder_tbl.*, brandreminder_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('brandreminder_frame_tbl', 'brand_reminder_tbl.fk_frame_id = brandreminder_frame_tbl.brandreminder_frame_id', 'left')
            ->join('tbl_user', 'brand_reminder_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('brand_reminder_tbl.doctor_name, brand_reminder_tbl.qualification, brand_reminder_tbl.city, brand_reminder_tbl.date, brand_reminder_tbl.fk_user_id')
            ->orderBy('brand_reminder_tbl.brand_reminder_id', 'ASC')
            ->findAll();
    }

     public function getPosterWithUsersDetailsByRegion($regionId)
    {
        return $this->select('brand_reminder_tbl.*, brandreminder_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('brandreminder_frame_tbl', 'brand_reminder_tbl.fk_frame_id = brandreminder_frame_tbl.brandreminder_frame_id', 'left')
            ->join('tbl_user', 'brand_reminder_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId',  $regionId)
            ->groupBy('brand_reminder_tbl.doctor_name, brand_reminder_tbl.qualification, brand_reminder_tbl.city, brand_reminder_tbl.date, brand_reminder_tbl.fk_user_id')
            ->orderBy('brand_reminder_tbl.brand_reminder_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByHq($hqId)
{
        return $this->select('brand_reminder_tbl.*, brandreminder_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('brandreminder_frame_tbl', 'brand_reminder_tbl.fk_frame_id = brandreminder_frame_tbl.brandreminder_frame_id', 'left')
            ->join('tbl_user', 'brand_reminder_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ',  $hqId)
            ->groupBy('brand_reminder_tbl.doctor_name, brand_reminder_tbl.qualification, brand_reminder_tbl.city, brand_reminder_tbl.date, brand_reminder_tbl.fk_user_id')
            ->orderBy('brand_reminder_tbl.brand_reminder_id', 'ASC')
            ->findAll();
    }
}


?>