<?php

namespace App\Models;

use CodeIgniter\Model;

class DoctorModel extends Model
{
    protected $table            = 'doctor_data';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['id','doctor','hospital','registration_no','phone','email','place','district','state','country','user','user_id','empno','hq_id','region_id','zone_id','date'];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
    
    public function getDocterByUserHQ($userId)
    {
         $client = $this->distinct('D.id')->select("D.*")
            ->join('tbl_user U', 'U.UserID = '.$userId)
             ->join('doctor_data D', 'D.hq_id = U.HQ');
            
        return $client->orderBy('D.id', 'DESC')->findAll();
    }
    public function getDocterByUserRegion($userId)
    {
         $client = $this->distinct('D.id')->select("D.*")
            ->join('tbl_user U', 'U.UserID = '.$userId)
             ->join('doctor_data D', 'D.region_id = U.REGIONId');
            
        return $client->orderBy('D.id', 'DESC')->findAll();
    }
    public function getDocterByUserZone($userId)
    {
        $client = $this->distinct('D.id')->select("D.*")
            ->join('tbl_user U', 'U.UserID = '.$userId)
             ->join('doctor_data D', 'D.zone_id = U.zoneId');
            
        return $client->orderBy('D.id', 'DESC')->findAll();
    }
}
