<?php

namespace App\Models;

use CodeIgniter\Model;

class Doctor_Model extends Model
{
    protected $table = 'doctor_data';
    protected $allowedFields = ['id', 'doctor', 'hospital', 'registration_no', 'phone', 'email', 'place', 'district', 'state', 'country', 'user', 'user_id', 'empno', 'hq_id', 'region_id', 'zone_id', 'date'];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }

    public function checkPhoneExists($phone)
    {
        $query = $this->where('phone', $phone)->countAllResults();
        return ($query > 0) ? true : false;
    }
    public function checkPhoneAndIdExists($phone, $id)
    {
        $doctor = $this->where('phone', $phone)->first();

        if (!$doctor) {
            return 'exists';
        } elseif ($doctor['id'] == $id) {
            return 'id_match';
        } elseif ($doctor['id'] != $id) {
            return 'phone_only';
        }
    }


    public function getTotalDoctors()
    {
        return $this->select(' COUNT(*) as total ')
            ->groupBy('doctor, user, date')
            ->findAll()
        ;
    }

    public function getTotalDoctorUser()
    {
        return $this->select('user, COUNT(*) AS entry_count')
            ->groupBy('doctor,date')
            ->getRecords();
    }

    public function getDoctorUser()
    {
        return $this->select('*')
            ->groupBy('doctor, date')
            ->orderBy('id', 'DESC')
            ->findAll();

    }
    public function getTotalDoctor($perPage=500,$page=1,$zone=0,$region=0,$hq=0,$startDate="",$endDate="",$searchText="")
    {
        $results = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left');
            
            if($zone!=0){
                $results->where('doctor_data.zone_id', $zone);
            }
            if($region!=0){
                $results->where('doctor_data.region_id', $region);
            }
            if($hq!=0){
                 $results->where('doctor_data.hq_id', $hq);
            }
            if($startDate!=""){
                $array = ['doctor_data.date >=' => $startDate];
                $results->where($array);
            }
            if($endDate!=""){
                $array = ['doctor_data.date <=' => $endDate];
                $results->where($array);
            }
            if($searchText!=""){
                $array = ['doctor_data.doctor' => $searchText, 'doctor_data.registration_no' => $searchText];
                $results->like($array);
            }
            $results->groupBy('doctor, user, date')->orderBy('id', 'DESC');
            
            if($perPage!=0){
                $results_rec =  $results->paginate($perPage, 'group1', $page);
            }else{
                $results_rec = $results->getRecords();
            }
            
            
            return $results_rec;
    }

    public function getTableDataByZone($zone_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('zone_id', $zone_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getTableDataByRegion($region_id, $zone_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getTableDataByHQ($hq_id, $region_id, $zone_id)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneDoctorByRegion($region_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC');
            if($perPage!=0){
                return $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }
            
    }

    public function getZoneDoctorByHQ($hq_id, $region_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC');
            if($perPage!=0){
                return $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }
    }

    public function getRegionDoctorByHQ($hq_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->groupBy('doctor, user, date')
            ->orderBy('doctor_data.id', 'DESC');
            if($perPage!=0){
                return $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }
    }

    public function gettotalDoctorEentry($perPage=500,$page=1,$zone=0,$region=0,$hq=0,$startDate="",$endDate="",$searchText="")
    {
        $results = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left');
            
             if($zone!=0){
                $results->where('doctor_data.zone_id', $zone);
            }
            if($region!=0){
                $results->where('doctor_data.region_id', $region);
            }
            if($hq!=0){
                 $results->where('doctor_data.hq_id', $hq);
            }
                if($startDate!=""){
                $array = ['doctor_data.date >=' => $startDate];
                $results->where($array);
            }
            if($endDate!=""){
                $array = ['doctor_data.date <=' => $endDate];
                $results->where($array);
            }
            if($searchText!=""){
                $array = ['doctor_data.doctor_name' => $searchText, 'doctor_data.registration_no' => $searchText];
                $results->like($array);
            }
            $results->groupBy('doctor_data.user_id, doctor_data.hq_id, doctor_data.region_id, doctor_data.zone_id')
            ->orderBy('entry_count', 'DESC');
            if($perPage!=0){
                $results_rec =  $results->paginate($perPage, 'group1', $page);
            }else{
                $results_rec = $results->getRecords();
            }
            
         return $results_rec;
    }

    public function getUserDoctorByZone($zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC');
            if($perPage!=0){
                return  $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }
            
    }

    public function getUserDoctorByRegion($region_id, $zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC');
             if($perPage!=0){
                return  $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }

    }

    public function getUserDoctorByHQ($hq_id, $region_id, $zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->where('doctor_data.zone_id', $zone_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC');
            if($perPage!=0){
                return  $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }
    }

    public function getZoneUserDoctorByRegion($region_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getZoneUserDoctorByHQ($hq_id, $region_id)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->where('doctor_data.region_id', $region_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC')
            ->get();

        $sql = $this->getLastQuery();
        log_message('debug', 'SQL Query: ' . $sql);

        return $query->getResultArray();
    }

    public function getRegionUserDoctorByHQ($hq_id,$perPage=500,$page=1)
    {
        $query = $this->select('doctor_data.*, COUNT(DISTINCT CONCAT(doctor_data.doctor, doctor_data.date)) AS entry_count, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_hq', 'doctor_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'doctor_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'doctor_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('doctor_data.hq_id', $hq_id)
            ->groupBy('doctor_data.user_id, doctor_data.hq_id')
            ->orderBy('entry_count', 'DESC');
             if($perPage!=0){
                return  $query->paginate($perPage, 'group1', $page);
            }else{
                return $query->getRecords();
            }
          
    }

}


?>