<?php

namespace App\Models;

use CodeIgniter\Model;

class Patient_Model extends Model
{
    protected $table = 'patient_data';
    protected $allowedFields = [
        'id', 'name', 'phone', 'place', 'examination', 'age', 'gender', 'hypertension',
        'hypertension_drugs', 'drugs_combination', 'sbp1', 'dbp1', 'sbp2', 'dbp2', 'sbp3',
        'dbp3', 'average_sbp', 'average_dbp', 'monotherapy', 'combination_therapy',
        'co_morbid_conditions', 'drugs_co_morbidity', 'dr_id', 'user_id', 'user',
        'empno', 'hq_id', 'region_id', 'zone_id', 'status', 'date'
    ];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }


    public function getTotalPatient()
    {
        return $this->select(' COUNT(*) as total ')
        ->groupBy('name, user, date')
        ->findAll()
        ;
    }

    public function getTotalPatientUser()
    {
        return $this->select('user, COUNT(*) AS entry_count')
            ->groupBy('name,date')
            ->getRecords();
    }

    public function getPatientUser()
    {
        return $this->select('patient_data.*,doctor_data.doctor')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->groupBy('name, date')
            ->orderBy('id', 'DESC')
            ->findAll();

    }


    public function getTotalPatients()
    {
        return $this->select('patient_data.*,doctor_data.doctor, tbl_user.*, tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('doctor_data', 'patient_data.dr_id = doctor_data.id', 'left')
            ->join('tbl_user', 'patient_data.user_id = tbl_user.UserId', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy(' patient_data.name,patient_data.user, patient_data.date')
            ->orderBy('patient_data.id', 'DESC')
            ->findAll();
    }


    public function getTotelPatientEentry()
    {
        return $this->select('patient_data.*, COUNT(DISTINCT CONCAT(patient_data.name, patient_data.date)) AS entry_count,  tbl_user.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
            ->join('tbl_user', 'patient_data.user_id = tbl_user.UserId', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('patient_data.user_id, tbl_user.hq')
            ->orderBy('entry_count', 'DESC')
            ->findAll()
        ;
    }



}


?>