<?php

namespace App\Models;

use CodeIgniter\Model;

class Poster_Model extends Model
{
    protected $table = 'cardImage';
    protected $allowedFields = ['id', 'doctor', 'user', 'user_id', 'empno', 'hq', 'region_id', 'zone_id', 'date'];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }

    public function getTotalPosters()
    {
        $query = $this->db->query("SELECT COUNT(*) as total 
                                   FROM cardImage 
                                   GROUP BY doctor, user, date");
        return $query->getNumRows();
    }



    public function getPosters()
    {
        $builder = $this->db->table($this->table);
        $builder->select('*');
        $builder->groupBy('doctor, date, user');
        $builder->orderBy('id', 'desc');
        return $builder->get()->getResultArray();
    }

    public function getTopUsers()
    {
        $query = $this->db->query("SELECT user, COUNT(*) AS entry_count
                                  FROM cardImage
                                  GROUP BY user
                                  ORDER BY entry_count DESC
                                  LIMIT 100");
        return $query->getNumRows();
    }

    public function getTopUser()
    {
        $builder = $this->db->table($this->table);
        $builder->select('cardImage.user, COUNT(DISTINCT CONCAT(cardImage.doctor, cardImage.date)) AS entry_count, cardImage.hq, tbl_HQ.HQ, tbl_REGION.REGION ');
        $builder->join('tbl_HQ', 'cardImage.hq = tbl_HQ.HQID', 'left');
        $builder->join('tbl_REGION', 'cardImage.region_id = tbl_REGION.REGIONId', 'left');
        $builder->groupBy('cardImage.user, cardImage.hq');
        $builder->orderBy('entry_count', 'DESC');
        $builder->limit(100);
        return $builder->get()->getResultArray();
    }

    public function getUsersWithHQNames()
    {
        return $this->select('cardImage.*, tbl_HQ.HQ')
            ->join('tbl_HQ', 'cardImage.hq = tbl_HQ.HQId', 'left')
            ->groupBy(' cardImage.doctor,cardImage.user, cardImage.date')
            ->findAll()
        ;
    }

    public function getEentryCountByDate()
    {
        return $this->select('cardImage.id, cardImage.user, cardImage.date, cardImage.hq, COUNT(*) as entry_count, tbl_HQ.HQ, tbl_REGION.REGION ')
        ->join('tbl_HQ', 'cardImage.hq = tbl_HQ.HQId', 'left')
        ->join('tbl_REGION', 'cardImage.region_id = tbl_REGION.REGIONId', 'left')
        ->groupBy('cardImage.user, cardImage.hq, tbl_HQ.HQ')
        ->orderBy('cardImage.id', 'desc')
        ->findAll();
    }

    public function getEentrybyDate()
    {
        return $this->select('cardImage.id, cardImage.user, DATE(cardImage.date) as entry_date, COUNT(*) as entry_count, tbl_HQ.HQ, tbl_REGION.REGION ')
        ->join('tbl_HQ', 'cardImage.hq = tbl_HQ.HQId', 'left')
        ->join('tbl_REGION', 'cardImage.region_id = tbl_REGION.REGIONId', 'left')
        ->groupBy('cardImage.user, entry_date')
        ->orderBy('cardImage.id', 'desc')
        ->findAll();

    
    }

    public function getPosterDate()
    {
        return $this->select('cardImage.id, cardImage.date')
       ->groupBy(' date')
       ->orderBy('id', 'desc')
        ->findAll();
    }


}


?>