<?php

namespace App\Models;

use CodeIgniter\Model;

class Rx_Model extends Model
{
    protected $table = 'rx_data';
    protected $allowedFields = [ 'id', 'image', 'doctor_name', 'patient_name', 'phone_no', 'quantity', 'strips', 'indication', 'secondary', 'prescription_information', 'co_morbidity_prescription', 'patient_id', 'doctor_id', 'user_id', 'user', 'empno', 'hq_id', 'region_id', 'zone_id', 'date'];

    public function getRecords()
    {
        return $this->findAll();
    }
    public function getRecord()
    {
        return $this -> orderBy('id','DESC')->findAll();
    }
    public function getRow($id)
    {
        return $this->where('id', $id)->first();
    }

    public function getTotalData($perPage=500,$page=1,$zone=0,$region=0,$hq=0,$startDate="",$endDate="",$searchText="")
    {
        
        $results = $this->select('rx_data.id,rx_data.image,rx_data.doctor_name,rx_data.quantity,rx_data.strips,rx_data.indication,rx_data.hq_id,rx_data.region_id,rx_data.zone_id,
        rx_data.date,COUNT(patient.id) as total_patients,rx_data.empno,rx_data.user,rx_data.date as rx_date,
        GROUP_CONCAT(rx_data.prescription_information,",") as prescription_info,
        GROUP_CONCAT(rx_data.co_morbidity_prescription,",") as co_morbidity_prescription,
        doctor.registration_no,doctor.place as city,hq.HQ,region.REGION,zone.ZONE','left')
        ->join('patient_data patient', 'patient.id=rx_data.patient_id','left')
        ->join('tbl_zone zone', 'zone.ZONEId=rx_data.zone_id ','left')
        ->join('tbl_region region', 'region.REGIONId=rx_data.region_id','left')
        ->join('tbl_hq hq', 'hq.HQId=rx_data.hq_id','left')
        ->join('doctor_data doctor', 'doctor.id=rx_data.doctor_id','left');
        
        if($hq!=0){
            $results->groupStart()->where('rx_data.hq_id' , $hq)->groupEnd();  
        } if($region!=0){
            $results->groupStart()->where('rx_data.region_id' , $region)->groupEnd();  
        } if($zone!=0){
            $results->groupStart()->where('rx_data.zone_id' , $zone)->groupEnd();  
        }
        if($startDate!=""){
            $results->groupStart()->where('rx_data.date >=' , $startDate)->groupEnd();  
        }
        if($endDate!=""){
            $results->groupStart()->where('rx_data.date <=' , $endDate)->groupEnd();  
        }
        if($searchText!=""){
           $linkarray = ['rx_data.doctor_name' => $searchText, 'rx_data.user' => $searchText, 'rx_data.empno' => $searchText, 'doctor.registration_no' => $searchText];
           $results->groupStart()->like($linkarray)->groupEnd();  
        }
        
    
        $results->groupStart()
            ->where('rx_data.prescription_information !=', 'Non-Prescriber')
            ->orWhere('rx_data.co_morbidity_prescription !=', 'Non-Prescriber')
        ->groupEnd();

         $results->groupBy('rx_data.date, rx_data.doctor_id, rx_data.empno,rx_data.id')->orderBy('rx_data.date', 'DESC');               

    
            if($perPage!=0){
                $results_rec =  $results->paginate($perPage, 'group1', $page);
            }else{
                $results_rec = $results->get()->getResultArray();
            }
       
        
        foreach ($results_rec as &$row) {
            if (!empty($row['prescription_info'])) {
                $prescription_info_values = array_map('trim', explode(',', $row['prescription_info']));
                $prescription_info_values = array_filter($prescription_info_values, function($value) {
                    return $value !== 'Non-Prescriber' && $value !== '';
                });
                $distinct_count = count($prescription_info_values);
                $row['total_prescription'] = $distinct_count;
            } else {
                $row['total_prescription'] = 0;
            }
            $total_rxtor = 0;
            $total_suitglip = 0;
            $total_glyree = 0;
            if (!empty($row['co_morbidity_prescription'])) {
                $co_morbidity_values = array_map('trim', explode(',', $row['co_morbidity_prescription']));
                foreach ($co_morbidity_values as $value) {
                    if (stripos($value, 'RXtor') !== false) {
                        $total_rxtor++;
                    }
                    if (stripos($value, 'Suitglip') !== false) {
                        $total_suitglip++;
                    }
                    if (stripos($value, 'Glyree') !== false) {
                        $total_glyree++;
                    }
                }
            }
            $row['total_rxtor'] = $total_rxtor;
            $row['total_suitglip'] = $total_suitglip;
            $row['total_glyree'] = $total_glyree;
        }
    
        return $results_rec;
        
    }



    public function getTotalRxUser()
    {
        return $this->select('user_id, COUNT(*) AS entry_count')
            ->groupBy('id,date')
            ->getRecords();
    }

    public function getTotalPatientsrx($perPage=20,$page=1,$zone=0,$region=0,$hq=0,$startDate="",$endDate="",$searchText="")
    {
         $results = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left');
             if($zone!=0){
                $results->where('rx_data.zone_id', $zone);
            }
            if($region!=0){
                $results->where('rx_data.region_id', $region);
            }
            if($hq!=0){
                 $results->where('rx_data.hq_id', $hq);
            }
            if($startDate!=""){
                $array = ['rx_data.date >=' => $startDate];
                $results->where($array);
            }
            if($endDate!=""){
                $array = ['rx_data.date <=' => $endDate];
                $results->where($array);
            }
            if($searchText!=""){
                $array = ['rx_data.doctor_name' => $searchText, 'rx_data.user' => $searchText, 'rx_data.empno' => $searchText];
                $results->like($array);
            }
        
            $results->orderBy('rx_data.id', 'DESC');
             if($perPage!=0){
                $results_rec =  $results->paginate($perPage, 'group1', $page);
            }else{
                $results_rec = $results->getRecords();
            }
            

            return $results_rec;
            
    }

    public function getRxByZone($zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.zone_id', $zone_id)
            ->orderBy('rx_data.id', 'DESC');
            if($perPage!=0){
              return  $query->paginate($perPage, 'group1', $page);
            }else{
              return  $query->getRecords();
            }
    }

    public function getRxByRegion($region_id, $zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.region_id', $region_id)
            ->where('rx_data.zone_id', $zone_id)
            ->orderBy('rx_data.id', 'DESC');
            if($perPage!=0){
              return  $query->paginate($perPage, 'group1', $page);
            }else{
              return  $query->getRecords();
            }
    }

    public function getRxByHQ($hq_id, $region_id, $zone_id,$perPage=500,$page=1)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.hq_id', $hq_id)
            ->where('rx_data.region_id', $region_id)
            ->where('rx_data.zone_id', $zone_id)
            ->orderBy('rx_data.id', 'DESC');
            if($perPage!=0){
               return $query->paginate($perPage, 'group1', $page);
            }else{
               return $query->getRecords();
            }
    }

    public function getZoneRxByRegion($region_id,$perPage=500,$page=1)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.region_id', $region_id)
            ->orderBy('rx_data.id', 'DESC');
            if($perPage!=0){
               return $query->paginate($perPage, 'group1', $page);
            }else{
               return $query->getRecords();
            }
    }

    public function getZoneRxByHQ($hq_id, $region_id,$perPage=500,$page=1 )
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.hq_id', $hq_id)
            ->where('rx_data.region_id', $region_id)
            ->orderBy('rx_data.id', 'DESC');
            if($perPage!=0){
               return $query->paginate($perPage, 'group1', $page);
            }else{
               return $query->getRecords();
            }
        
    }

    public function getRegionRxByHQ($hq_id,$perPage=500,$page=1)
    {
        $query = $this->select('rx_data.*,  tbl_hq.HQ, tbl_region.REGION,tbl_zone.ZONE')
            ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
            ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left')
            ->where('rx_data.hq_id', $hq_id)
            ->orderBy('rx_data.id', 'DESC');
             if($perPage!=0){
               return $query->paginate($perPage, 'group1', $page);
            }else{
               return $query->getRecords();
            }
    }
    
    
    public function findPatientRxbyUser($user_id,$data=0)
   {
       $sql = $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left');
           if($data!=0){
                $array = array('rx_data.user_id' => $user_id, 'date >' => $data);
                $sql->where($array);
            }else{
                $sql->where('rx_data.user_id', $user_id);
            }
           
        return   $sql->orderBy('rx_data.id', 'DESC')->findAll();
        
   }
   public function findPatientRxbyHQ($HQ_id,$data)
   {

        $sql = $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left');
           if($data){
                $array = array('rx_data.user_id' => $user_id, 'date >' => $data);
                $sql->where($array);
            }else{
                $sql->where('rx_data.user_id', $user_id);
            }
           $sql->where('rx_data.hq_id', $HQ_id)->orderBy('rx_data.id', 'DESC')
           ->findAll();
   }
   public function findPatientRxbyRegion($Region_id,$data)
   {

        $sql = $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left');
           if($data){
                $array = array('rx_data.region_id' => $Region_id, 'date >' => $data);
                $sql->where($array);
            }else{
                $sql->where('rx_data.region_id', $Region_id);
            }
           $sql->orderBy('rx_data.id', 'DESC')->findAll();
           
   }
   public function findPatientRxbyZone($Zone_id,$data)
   {
       $sql = $this->distinct('rx_data.id')->select('rx_data.*, tbl_hq.HQ, tbl_region.REGION ,tbl_zone.ZONE ')
           ->join('tbl_hq', 'rx_data.hq_id = tbl_hq.HQID', 'left')
           ->join('tbl_region', 'rx_data.region_id = tbl_region.REGIONId', 'left')
           ->join('tbl_zone', 'rx_data.zone_id = tbl_zone.ZONEId', 'left');
           if($data){
                $array = array('rx_data.zone_id' => $Zone_id, 'date >' => $data);
                $sql->where($array);
            }else{
                $sql->where('rx_data.zone_id', $Zone_id);
            }
           $sql->orderBy('rx_data.id', 'DESC')->findAll();
           
   }

}


?>