<?php

namespace App\Models;

use CodeIgniter\Model;

class Video_Model extends Model
{
    protected $table = 'video_tbl';
    protected $primaryKey = 'video_id';

    protected $allowedFields = ['video_id', 'doctor_name', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'date'];


    public function getTotalVideos()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('video_tbl.*, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'video_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('video_tbl.fk_user_id', $id)
            ->groupBy('video_tbl.doctor_name, video_tbl.date')
            ->orderBy('video_tbl.video_id', 'DESC')
            ->findAll();
    }
    public function getVideosWithUsersDetails ()
    {
        return $this->select('video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('video_tbl.doctor_name, video_tbl.date, video_tbl.fk_user_id')
            ->orderBy('video_tbl.video_id', 'ASC')
            ->findAll();
    }

    public function getTotalVideosByZone($zoneId)
    {
        return $this->select('video_tbl.doctor_name, video_tbl.fk_user_id, video_tbl.date')
            ->join('tbl_user AS u', 'video_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.zoneId', $zoneId)
            ->groupBy('video_tbl.doctor_name, video_tbl.fk_user_id, video_tbl.date')
            ->countAllResults(false);
    }

    public function getVideosWithUsersDetailsByZone($zoneId)
    {
        return $this->select('video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('video_tbl.doctor_name, video_tbl.date, video_tbl.fk_user_id')
            ->orderBy('video_tbl.video_id', 'ASC')
            ->findAll();
    }

    public function getTotalVideosByRegion($region_id)
    {
        return $this->select('video_tbl.doctor_name, video_tbl.fk_user_id, video_tbl.date')
            ->join('tbl_user AS u', 'video_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.REGIONId', $region_id)
            ->groupBy('video_tbl.doctor_name, video_tbl.fk_user_id, video_tbl.date')
            ->countAllResults(false);
    }

    public function getVideosWithUsersDetailsByRegion($regionId)
    {
        return $this->select('video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.REGIONId', $regionId)
            ->groupBy('video_tbl.doctor_name, video_tbl.date, video_tbl.fk_user_id')
            ->orderBy('video_tbl.video_id', 'ASC')
            ->findAll();
    }

    public function getTotalVideosByHq($hq_id)
    {
        return $this->select('video_tbl.doctor_name, video_tbl.fk_user_id, video_tbl.date')
            ->join('tbl_user AS u', 'video_tbl.fk_user_id = u.UserID', 'left')
            ->where('u.HQ', $hq_id)
            ->groupBy('video_tbl.doctor_name, video_tbl.fk_user_id, video_tbl.date')
            ->countAllResults(false);
    }

    public function getVideosWithUsersDetailsByHq($hqId)
    {
        return $this->select('video_tbl.*, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('tbl_user', 'video_tbl.fk_user_id = tbl_user.UserID', 'left')
             ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.HQ', $hqId)
            ->groupBy('video_tbl.doctor_name, video_tbl.date, video_tbl.fk_user_id')
            ->orderBy('video_tbl.video_id', 'ASC')
            ->findAll();
    }


}


?>