<?php

namespace App\Models;

use CodeIgniter\Model;

class Anniversary_Poster_Model extends Model
{
    protected $table = 'anniversary_tbl';
    protected $primaryKey = 'anniversary_id';

    protected $allowedFields = ['anniversary_id', 'doctor_name', 'doctor_img', 'qualification', 'city', 'download_status', 'share_status', 'fk_user_id', 'fk_frame_id', 'date'];

    public function getTotalPosters()
    {
        return $this->select('doctor_name, fk_user_id, date')
            ->groupBy('doctor_name, fk_user_id, date')
            ->countAllResults(false);
    }

    public function getUserData($id)
    {
        return $this->select('anniversary_tbl.*, anniversary_frame_tbl.frame_name, tbl_user.Name, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('anniversary_frame_tbl', 'anniversary_tbl.fk_frame_id = anniversary_frame_tbl.anniversary_frame_id', 'left')
            ->join('tbl_user', 'anniversary_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('anniversary_tbl.fk_user_id', $id)
            ->groupBy('anniversary_tbl.doctor_name, anniversary_tbl.qualification, anniversary_tbl.city, anniversary_tbl.date')
            ->orderBy('anniversary_tbl.anniversary_id', 'DESC')
            ->findAll();
    }


    public function getPosterWithUsersDetails()
    {
        return $this->select('anniversary_tbl.*, anniversary_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('anniversary_frame_tbl', 'anniversary_tbl.fk_frame_id = anniversary_frame_tbl.anniversary_frame_id', 'left')
            ->join('tbl_user', 'anniversary_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->groupBy('anniversary_tbl.doctor_name, anniversary_tbl.qualification, anniversary_tbl.city, anniversary_tbl.date, anniversary_tbl.fk_user_id')
            ->orderBy('anniversary_tbl.anniversary_id', 'ASC')
            ->findAll();
    }

    public function getPosterWithUsersDetailsByZone($zoneId)
    {
        return $this->select('anniversary_tbl.*, anniversary_frame_tbl.frame_name, tbl_user.Name,DESIG, tbl_hq.HQ, tbl_region.REGION, tbl_zone.ZONE')
            ->join('anniversary_frame_tbl', 'anniversary_tbl.fk_frame_id = anniversary_frame_tbl.anniversary_frame_id', 'left')
            ->join('tbl_user', 'anniversary_tbl.fk_user_id = tbl_user.UserID', 'left')
            ->join('tbl_hq', 'tbl_user.HQ = tbl_hq.HQId', 'left')
            ->join('tbl_region', 'tbl_user.REGIONId = tbl_region.REGIONId', 'left')
            ->join('tbl_zone', 'tbl_user.zoneId = tbl_zone.ZONEId', 'left')
            ->where('tbl_user.zoneId', $zoneId)
            ->groupBy('anniversary_tbl.doctor_name, anniversary_tbl.qualification, anniversary_tbl.city, anniversary_tbl.date, anniversary_tbl.fk_user_id')
            ->orderBy('anniversary_tbl.anniversary_id', 'ASC')
            ->findAll();
    }
}


?>