<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<style>
    .box-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 20px;
        padding: 20px;
        justify-items: center;
    }

    .box-link {
        text-decoration: none;
    }

    .box {
        background-color: #009A8f;
        border-radius: 15px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        padding: 20px;
        text-align: center;
        color: white;
        transition: 0.3s;
        height: 120px;
        width: 150px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .box-title {
        font-weight: bold;
        text-align: center;
    }

    .box:hover {
        transform: scale(1.05);
    }

    @media (max-width: 768px) {
        .box-container {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 420px) {
        .box {
            max-width: 130px;
            max-height: 100px;
        }
    }

    @media (max-width: 360px) {
        .box {
            max-width: 100px;
            max-height: 80px;
        }

        .box-title {
            font-size: small;
            font-weight: bold;

        }
    }
</style>

<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>
        <div class="box-container">
            <a href="<?php echo site_url($controller .'/video_maker') ?>" class="box-link">
                <div class="box">
                    <div class="box-title">General Video</div>
                </div>
            </a>
            <a href="<?php echo site_url($controller .'/festival_video') ?>" class="box-link">
                <div class="box">
                    <div class="box-title">Festival Video</div>
                </div>
            </a>
            <a href="<?php echo site_url($controller .'/birthday_video') ?>" class="box-link">
                <div class="box">
                    <div class="box-title">Birthday Video</div>
                </div>
            </a>
            <a href="<?php echo site_url($controller .'/anniversary_video') ?>" class="box-link">
                <div class="box">
                    <div class="box-title">Anniversary Video</div>
                </div>
            </a>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include("footer.php") ?>
</body>

</html>