<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

<body>
    <!-- Sidebar Start -->
    <?php include ("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include ("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Patients</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green text-white">Generate Excel</button>
                            <div class="row mb-2">
                                <div class="col-3 mt-2">
                                 <input class="search" type="text" id="searchInput" placeholder="Search ">
                                </div>
                                <div class="col-3 mt-2">
                                    <input type="text" class="search" placeholder="Start Date:" id="startDatepicker">
                                </div>
                                <div class="col-3 mt-2">
                                    <input type="text" class="search" placeholder="End Date:" id="endDatepicker">
                                </div>
                                <div class="col-3 mt-2">
                                <button id="tblSearch"  class="btn bg-green  text-white">Search</button>
                                </div>
                            </div>
                            <div class="row mt-2 mb-2">
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="zone" id="zone">
                                        <option value="">Select Zone</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($zone)) {
                                            foreach ($zone as $zonerow) {
                                                $serial++; ?>

                                                <option value="<?php echo $zonerow['ZONEId']; ?>">
                                                    <?php echo $zonerow['ZONE']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <option>Record Not Found</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="region" id="region">
                                        <option value="">Select Region</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($region)) {
                                            foreach ($region as $regionrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $regionrow['REGIONId']; ?>">
                                                    <?php echo $regionrow['REGION']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <option>Record Not Found</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="hq" id="hq">
                                        <option value="">Select Area</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $hqrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $hqrow['HQId']; ?>">
                                                    <?php echo $hqrow['HQ']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <option>Record Not Found</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <table class="table" id="myTable" style="">
                                <thead>
                                    <tr class="">
                                        <th scope="">S.no.</th>
                                        <th scope="col">Doctor</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone</th>
                                        <th scope="col">Place</th>
                                        <th scope="col">Gender</th>
                                        <th scope="col">Age</th>
                                        <th scope="col">Examination Date</th>
                                        <th scope="col">Hypertension </th>
                                        <th scope="col">Hypertension Drugs</th>
                                        <th scope="col">Drugs Combination</th>
                                        <th scope="col">ARB Prescription</th>
                                        <th scope="col">ARB Dose</th>
                                        <th scope="col">ACE-I Prescription</th>
                                        <th scope="col">ACE-I Dose</th>
                                        <th scope="col">BB Prescription</th>
                                        <th scope="col">BB Dose</th>
                                        <th scope="col">CCB Prescription</th>
                                        <th scope="col">CCB Dose</th>
                                        <th scope="col">Diuretic Prescription</th>
                                        <th scope="col">Diuretic Dose</th>
                                        <th scope="col">Other Prescription</th>
                                        <th scope="col">Other Dose</th>
                                        <th scope="col">SBP</th>
                                        <th scope="col">DBP</th>
                                        <th scope="col">Average SBP</th>
                                        <th scope="col">Average DBP</th>
                                        <th scope="col">Co-morbid Condition</th>
                                        <th scope="col">Drugs for co-morbidity</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Employee</th>
                                        <th scope="col">Emp. ID</th>
                                        <th scope="col">Area</th>
                                        <th scope="col">Region</th>
                                        <th scope="col">Zone</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td><?php echo $serial + ($perPage * ($page - 1)) ?></td>
                                                <td><?php echo $row['doctor']; ?></td>
                                                <td><?php echo $row['name']; ?></td>
                                                <td><?php echo $row['phone']; ?></td>
                                                <td><?php echo $row['place']; ?></td>
                                                <td><?php echo $row['gender']; ?></td>
                                                <td><?php echo $row['age']; ?></td>
                                                <td><?php echo $row['examination']; ?></td>
                                                <td><?php echo $row['hypertension']; ?></td>
                                                <td><?php echo $row['hypertension_drugs']; ?></td>
                                                <td><?php echo $row['drugs_combination']; ?></td>
                                                <td><?php echo $row['arb']; ?></td>
                                                <td><?php echo $row['arb_dose']; ?></td>
                                                <td><?php echo $row['ace_i']; ?></td>
                                                <td><?php echo $row['ace_i_dose']; ?></td>
                                                <td><?php echo $row['bb']; ?></td>
                                                <td><?php echo $row['bb_dose']; ?></td>
                                                <td><?php echo $row['ccb']; ?></td>
                                                <td><?php echo $row['ccb_dose']; ?></td>
                                                <td><?php echo $row['diuretic']; ?></td>
                                                <td><?php echo $row['diuretic_dose']; ?></td>
                                                <td><?php echo $row['other']; ?></td>
                                                <td><?php echo $row['other_dose']; ?></td>
                                                <td>SBP1: <?php echo $row['sbp1']; ?>, SBP2: <?php echo $row['sbp2']; ?>, SBP3: <?php echo $row['sbp3']; ?></td>
                                                <td>DBP1: <?php echo $row['dbp1']; ?>, DBP2: <?php echo $row['dbp2']; ?>, DBP3: <?php echo $row['dbp3']; ?></td>
                                                <td><?php echo $row['average_sbp']; ?></td>
                                                <td><?php echo $row['average_dbp']; ?></td>
                                                <td><?php echo $row['co_morbid_conditions']; ?></td>
                                                <td><?php echo $row['drugs_co_morbidity']; ?></td>
                                                <td><?php echo $row['date']; ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td>
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                            
                              <?php   if(!empty($data)  && $total>20){ ?>
                        
                              <ul id="pagination-demo" class="pagination-sm"></ul>
                            
                            <?php } ?>
                            <select class="form-select" name="pagesize" id="pagesize" >
                                        <option value="20" <?php if($perPage==20){ echo "selected";} ?> >20</option>
                                        <option value="50" <?php if($perPage==50){ echo "selected";} ?>>50</option>
                                        <option value="100" <?php if($perPage==100){ echo "selected";} ?>>100</option>
                                        <option value="500" <?php if($perPage==500){ echo "selected";} ?>>500</option>
                                    </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include ("footer.php") ?>


    <script>
       let page = "<?php echo $page; ?>";
        $(document).ready(function () {
            page = 1
            function setpagination(total) {
                 console.log(total);
                 $('#pagination-demo').pagination('destroy');
                 console.log("setpagination",total);
                  $('#pagination-demo').pagination({
                    items: total,
                    itemsOnPage: $("#pagesize").val(),
                     cssStyle: 'light-theme',
                    onPageClick: function (pageNumber) {
                         $.ajax({ url: '<?php echo base_url("admin/get_patient_data_by_date"); ?>', type: 'get', 
                            data: { 
                                zone_id: $("#zone").val(),
                                region_id: $("#region").val(),
                                hq_id: $("#hq").val(),
                                startDate: $("#startDatepicker").val(),
                                endDate: $("#endDatepicker").val(),
                                searchText: $("#searchInput").val(),
                                page:pageNumber,
                                pagesize:$("#pagesize").val()
                            }, dataType: 'json', 
                            success: function (response) { 
                                updateTable(response.table_data,pageNumber); 
                                if(pageNumber==1){
                                    setpagination(response.table_data.length)
                                }
                            } 
                        }); 
                    }
                });
             }
             
            $('#tblSearch').click(function(){ console.log("aaa");
                $.ajax({ url: '<?php echo base_url("admin/get_patient_data_by_date"); ?>', type: 'get', 
                    data: { 
                        zone_id: $("#zone").val(),
                        region_id: $("#region").val(),
                        hq_id: $("#hq").val(),
                        startDate: $("#startDatepicker").val(),
                        endDate: $("#endDatepicker").val(),
                        searchText: $("#searchInput").val(),
                        page:page,
                        pagesize:$("#pagesize").val()
                    }, dataType: 'json', 
                    success: function (response) { 
                        updateTable(response.table_data); 
                         setpagination(response.total)
                    } 
                }); 
            });
 function clearFilter(){
                 $("#startDatepicker").val(null)
                 $("#endDatepicker").val(null);
                 $("#searchInput").val(null)
             }
             $('#tbltoxl').click(function(){ 
                 page = 1
                let Str = "";
                if($('#zone').val() && $('#zone').val()!="Select Zone"){
                    Str="zone="+$('#zone').val()
                }
                if($('#region').val()){
                    Str=Str+"&region="+$('#region').val()
                }
                if($('#hq').val()){
                    Str=Str+"&hq="+$('#hq').val()
                }
                if($('#hq').val()){
                    Str=Str+"&hq="+$('#hq').val()
                }
                if($('#startDatepicker').val()){
                    Str=Str+"&startDate="+$('#startDatepicker').val()
                }
                if($('#endDatepicker').val()){
                    Str=Str+"&endDate="+$('#endDatepicker').val()
                }
                window.open('<?php echo base_url(); ?>admin/generate_excel_by_total_patients?'+Str, '_blank')
            });
            $('#zone').change(function () {   page = 1
                var zoneId = $(this).val();
                if (zoneId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_regions_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#region").empty();
                            $("#region").append('<option value="">Select Region</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['REGIONId'];
                                    var name = response[i]['REGION'];
                                    $("#region").append("<option value='" + id + "'>" + name +
                                        "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);clearFilter();
                            setpagination(response.total)
                        }
                    });
                } else {
                    window.location.reload();
                }
            });

            $('#region').change(function () {  page = 1
                var regionId = $(this).val();
                var zoneId = $("#zone").val();
                if (regionId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_hq_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#hq").empty();
                            $("#hq").append('<option value="">Select Area</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['HQId'];
                                    var name = response[i]['HQ'];
                                    $("#hq").append("<option value='" + id + "'>" + name +
                                        "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_region"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);;clearFilter();
                            setpagination(response.total)
                        }
                    });
                } else {
                    var selectedZoneId = $("#zone").val();
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: selectedZoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);;clearFilter();
                            setpagination(response.total)
                        }
                    });
                }
            });

            $('#hq').change(function () {   page = 1
                var hqId = $(this).val();
                var regionId = $("#region").val();
                var zoneId = $("#zone").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_hq"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: regionId,
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);;clearFilter();
                            setpagination(response.total)
                        }
                    });
                } else {
                    var selectedRegionId = $("#region").val();
                    $.ajax({
                        url: '<?php echo base_url("admin/get_patient_data_by_region"); ?>',
                        type: 'post',
                        data: {
                            zone_id: zoneId,
                            region_id: selectedRegionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);;clearFilter();
                            setpagination(response.total)
                        }
                    });
                }
            });

            function updateTable(tableData,pageNo = 1) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var html = "<tr>" +
                            "<td>" + (((pageNo - 1) * $("#pagesize").val()) + (index + 1)) + "</td>" +
                            "<td>" + row.doctor + "</td>" +
                            "<td>" + row.name + "</td>" +
                            "<td>" + row.phone + "</td>" +
                            "<td>" + row.place + "</td>" +
                            "<td>" + row.gender + "</td>" +
                            "<td>" + row.age + "</td>" +
                            "<td>" + row.examination + "</td>" +
                            "<td>" + row.hypertension + "</td>" +
                            "<td>" + row.hypertension_drugs + "</td>" +
                            "<td>" + row.drugs_combination + "</td>" +
                            "<td>" + row.arb + "</td>" +
                            "<td>" + row.arb_dose + "</td>" +
                            "<td>" + row.ace_i + "</td>" +
                            "<td>" + row.ace_i_dose + "</td>" +
                            "<td>" + row.bb + "</td>" +
                            "<td>" + row.bb_dose + "</td>" +
                            "<td>" + row.ccb + "</td>" +
                            "<td>" + row.ccb_dose + "</td>" +
                            "<td>" + row.diuretic + "</td>" +
                            "<td>" + row.diuretic_dose + "</td>" +
                            "<td>" + row.other + "</td>" +
                            "<td>" + row.other_dose + "</td>" +
                            "<td>" + row.sbp1 + ", " + row.sbp2 + ", " + row.sbp3 + "</td>" +
                            "<td>" + row.dbp1 + ", " + row.dbp2 + ", " + row.dbp3 + "</td>" +
                            "<td>" + row.average_sbp + "</td>" +
                            "<td>" + row.average_dbp + "</td>" +
                            "<td>" + row.co_morbid_conditions + "</td>" +
                            "<td>" + row.drugs_co_morbidity + "</td>" +
                            "<td>" + row.date + "</td>" +
                            "<td>" + row.user + "</td>" +
                            "<td>" + row.empno + "</td>" +
                            "<td>" + row.HQ + "</td>" +
                            "<td>" + row.REGION + "</td>" +
                            "<td>" + row.ZONE + "</td>" +
                            "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
            
             setpagination(<?php echo $total;?>)
        });
    </script>


</body>

</html>