<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>

<body>
    <!-- Sidebar Start -->
    <?php include ("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include ("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Doctors User Count</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green text-white">Generate Excel</button>
                            <input class="search" type="text" id="searchInput" placeholder="Search ">
                            <div class="row mt-2 mb-2">
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="hq" id="hq">
                                        <option value="">Select Area</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $hqrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $hqrow['HQId']; ?>">
                                                    <?php echo $hqrow['HQ']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th scope="">S.no.</th>
                                        <th scope="col">Employee</th>
                                        <th scope="col">Emp. ID</th>
                                        <th scope="col">Area</th>
                                        <th scope="col">Region</th>
                                        <th scope="col">Zone</th>
                                        <th scope="col">Totel Doctors</th>
                                        <!-- <th scope="">Date</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td><?php echo $serial + (20 * ($page - 1)) ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td>
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                                <td><?php echo $row['entry_count']; ?></td>
                                                <!-- <td><?php // echo $row['date'];   ?></td> -->
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                            <?php   if(!empty($data)  && $total>20){ ?>
                        
                             <ul id="pagination-demo" class="pagination-sm"></ul>
                            
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    <?php include ("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
    <script>
        $(document).ready(function () {
             function setpagination(total) {
     
                 $('#pagination-demo').pagination('destroy');
                  $('#pagination-demo').pagination({
                    items: total,
                    itemsOnPage: $("#pagesize").val(),
                     cssStyle: 'light-theme',
                    onPageClick: function (pageNumber) {
                         $.ajax({ url: '<?php echo base_url("rbm/get_doctor_count_by_date"); ?>', type: 'get', 
                            data: { 
                                zone_id: $("#zone").val(),
                                region_id: $("#region").val(),
                                hq_id: $("#hq").val(),
                                startDate: $("#startDatepicker").val(),
                                endDate: $("#endDatepicker").val(),
                                searchText: $("#searchInput").val(),
                                page:pageNumber,
                                pagesize:$("#pagesize").val()
                            }, dataType: 'json', 
                            success: function (response) { 
                                updateTable(response.table_data,pageNumber); 
                                if(pageNumber==1){
                                    setpagination(response.table_data.length)
                                }
                            } 
                        }); 
                    }
                });
             }
            $('#tbltoxl').click(function(){ 
                 page = 1
                let Str = "";
                if($('#zone').val() && $('#zone').val()!="Select Zone"){
                    Str="&zone="+$('#zone').val()
                }
                if($('#region').val()){
                    Str=Str+"&region="+$('#region').val()
                }
                if($('#hq').val()){
                    Str=Str+"&hq="+$('#hq').val()
                }
                 if($('#startDatepicker').val()){
                    Str=Str+"&startDate="+$('#startDatepicker').val()
                }
                 if($('#endDatepicker').val()){
                    Str=Str+"&endDate="+$('#endDatepicker').val()
                }
                window.open('<?php echo base_url(); ?>rbm/generate_excel_by_doctor_users_count?'+Str, '_blank')
            });
            $('#hq').change(function () {
                var hqId = $(this).val();
                var regionId = $("#region").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("rbm/get_user_doctor_by_hq"); ?>',
                        type: 'post',
                        data: {
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                }
            });

            function updateTable(tableData) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var html = "<tr>" + "<td>" + (index + 1) + "</td>" + "<td>" + row.user + "</td>" +
                            "<td>" + row.empno + "</td>" + "<td>" + row.HQ + "</td>" + "<td>" + row.REGION +
                            "</td>" + "<td>" + row.ZONE + "</td>" + "<td>" + row.entry_count + "</td>" +
                            "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
            setpagination(<?php echo $total;?>)
        });
    </script>
    <script>
        document.getElementById('searchInput').addEventListener('input', function() {
            const searchText = this.value.toLowerCase();
            const table = document.querySelector('.table');
            const rows = table.querySelectorAll('tbody tr');
            rows.forEach(function(row) {
                const columns = row.querySelectorAll('td');
                let found = false;
                columns.forEach(function(column) { if (column.textContent.toLowerCase().includes(searchText)) { found = true; } });
                if (found) { row.style.display = ''; } 
                else { row.style.display = 'none'; }
            });
        });    
    </script>
</body>

</html>