<!DOCTYPE html>
<html lang="en">

<head>
    <title>MHAC - Mission Hypertension Awareness & Control</title>
    <meta charset="utf-8">
    <link href="<?php echo base_url(); ?>asset/imgs/fav.png" rel="icon">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="MHAC - Mission Hypertension Awareness & Control">
    <link rel="stylesheet" href="<?php echo base_url(); ?>asset/vendors/themify-icons/css/themify-icons.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>asset/css/meyawo.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>/asset/css/frame.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&family=Roboto:wght@700;800&display=swap"
        rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/@ffmpeg/ffmpeg@0.11.6/dist/ffmpeg.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@ffmpeg/core@0.11.0/dist/ffmpeg-core.js"></script>
</head>

<body>
    <?php
    header('Cross-Origin-Opener-Policy: same-origin');
    header('Cross-Origin-Embedder-Policy: require-corp');
    ?>
    <section class="section pt-0" id="about">
        <?php include("nav.php") ?>
        <div class=" ">
            <div class="">
                <div class="frame-container" id="step1">
                    <input type="text" class="frame-input" id="name" placeholder="Enter your name">
                    <input type="text" class="frame-input" id="qualification" placeholder="Enter Credentials">
                    <input type="text" class="frame-input" id="city" placeholder="Enter your city">
                    <input type="file" class="frame-input" id="uploadImage" accept="image/*">
                    <div class="modal" id="cropperModal">
                        <div class="modal-content">
                            <img id="cropperImage" src="" alt="Cropper Preview">
                            <button class="crop-btn" onclick="applyCrop()">Apply</button>
                        </div>
                    </div>
                    <button class="frame-button" onclick="generateVideo()">Generate Video</button>
                </div>
                <div class="frame-container" id="preview-container" style="display:none; flex-direction: column;">
                    <video id="bgVideo" muted playsinline loop style="display: none;"></video>
                    <canvas id="overlayCanvas"></canvas>
                    <div id="loader-wrapper">
                        <div id="loader"></div>
                        <p style="color:#333; font-weight: bold; align-items: center; ">Processing Video...</p>
                    </div>
                    <div id="shareStatus"></div>
                    <div class="button-group">
                        <button class="frame-button" id="downloadBtn" onclick="saveVideo()" disabled>Download</button>
                        <button class="frame-button" id="shareBtn" onclick="shareVideo()" disabled>Share</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="chr-box"><img src="<?php echo base_url(); ?>asset/imgs/character.png" class="chr" alt=" character">
        </div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <script>
        const uploadImage = document.getElementById('uploadImage');
        const cropperModal = document.getElementById('cropperModal');
        const cropperImage = document.getElementById('cropperImage');
        const name = document.getElementById('name');
        const qualification = document.getElementById('qualification');
        const city = document.getElementById('city');
        const formContainer = document.getElementById('step1');
        const previewContainer = document.getElementById('preview-container');
        const bgVideo = document.getElementById('bgVideo');
        const overlayCanvas = document.getElementById('overlayCanvas');
        const shareStatus = document.getElementById('shareStatus');
        const ctx = overlayCanvas.getContext('2d');

        let insertedVideoId = null;
        let isVideoSaved = false;
        let isVideoDownloadUpdated = false;
        let isVideoShareUpdated = false;

        let cropper;
        let overlayImg = null;
        let recorder, recordedChunks = [];
        let videoWidth = 1920;
        let videoHeight = 1080;
        let frameThumbnail = new Image();
        let frameDisclaimer = new Image();
        let convertedMp4Blob = null;

        frameThumbnail.src = '<?php echo base_url(); ?>/assets/festival_video_frame/<?php echo $video_frame["frame_thumbnail"]; ?>';
        frameDisclaimer.src = '<?php echo base_url(); ?>/assets/festival_video_frame/<?php echo $video_frame["bg_frame"]; ?>';
        const predefinedVideoUrl = '<?php echo base_url(); ?>/assets/festival_video_frame/<?php echo $video_frame["frame_name"]; ?>';

        const introDuration = 2500;
        const outroDuration = 5000;
        const disclaimerDuration = 2000;
        let startTime;
        let isPlayingMainVideo = false;
        let animationFrameId = null;
        let audioCheckInterval = null;
        let videoEnded = false;

        // Fixed spacing values in pixels
        const IMAGE_NAME_GAP = 100;
        const LINE_GAP = 15;
        const MAX_CHARS_PER_LINE = 25;

        uploadImage.addEventListener('change', () => {
            const file = uploadImage.files[0];
            if (!file) return alert("Please upload an image.");
            cropperImage.src = URL.createObjectURL(file);
            cropperModal.classList.add('active');
            if (cropper) cropper.destroy();
            cropper = new Cropper(cropperImage, {
                aspectRatio: 1,
                viewMode: 1,
                autoCropArea: 1,
            });
        });

        function applyCrop() {
            const croppedCanvas = cropper.getCroppedCanvas({
                width: 300,
                height: 300
            });
            overlayImg = new Image();
            overlayImg.src = croppedCanvas.toDataURL();
            cropperModal.classList.remove('active');
        }

        function wrapText(text, maxChars) {
            const words = text.split(' ');
            let lines = [];
            let currentLine = words[0] || '';

            for (let i = 1; i < words.length; i++) {
                const word = words[i];
                if (currentLine.length + word.length + 1 <= maxChars) {
                    currentLine += ' ' + word;
                } else {
                    lines.push(currentLine);
                    currentLine = word;
                }
            }
            lines.push(currentLine);
            return lines;
        }

        function draw() {
            // Add at the start of your draw() function
            ctx.imageSmoothingEnabled = false;
            ctx.webkitImageSmoothingEnabled = false;
            ctx.mozImageSmoothingEnabled = false;

            const now = Date.now();
            const elapsed = now - startTime;
            const videoDuration = bgVideo.duration * 1000;
            const totalDuration = introDuration + videoDuration + outroDuration + disclaimerDuration;
            const isIntro = elapsed < introDuration;
            const isVideo = elapsed >= introDuration && elapsed < (introDuration + videoDuration);
            const isOutro = elapsed >= (introDuration + videoDuration) && elapsed < (introDuration + videoDuration + outroDuration);
            const isDisclaimer = elapsed >= (introDuration + videoDuration + outroDuration);

            ctx.clearRect(0, 0, overlayCanvas.width, overlayCanvas.height);

            if (isIntro || isOutro) {
                // Draw the frame thumbnail for both intro and outro
                ctx.drawImage(frameThumbnail, 0, 0, overlayCanvas.width, overlayCanvas.height);

                if (overlayImg) {
                    const imageSize = 368;
                    const imageX = 535; // Left position
                    const imageY = 75; // Top position

                    // Draw circular profile image
                    ctx.save();
                    ctx.beginPath();
                    ctx.arc(imageX + imageSize / 2, imageY + imageSize / 2, imageSize / 2, 0, 2 * Math.PI);
                    ctx.clip();
                    ctx.drawImage(overlayImg, imageX, imageY, imageSize, imageSize);
                    ctx.restore();

                    // Text position - same for both intro and outro
                    const textX = 950; // Left position 
                    const textY = 155; // Top position
                    const maxTextWidth = 900; // Fixed maximum width of 900px
                    const lineHeightMultiplier = 1.2; // For spacing between lines

                    ctx.textAlign = 'left';
                    ctx.fillStyle = '#000000';

                    // Draw Name
                    let userName = name.value.trim();
                    let nameFontSize = 66; // Starting font size
                    ctx.font = `bold ${nameFontSize}px Poppins`;

                    // Adjust font size if needed to fit
                    while (ctx.measureText(userName).width > maxTextWidth && nameFontSize > 12) {
                        nameFontSize -= 2;
                        ctx.font = `bold ${nameFontSize}px Poppins`;
                    }

                    ctx.fillText(userName, textX, textY + nameFontSize);

                    let currentY = textY + nameFontSize * lineHeightMultiplier;

                    // Draw Qualification
                    let qualificationText = qualification.value.trim();
                    if (qualificationText) {
                        let qualFontSize = 53; // Starting font size
                        ctx.font = `bold ${qualFontSize}px Poppins`;

                        while (ctx.measureText(qualificationText).width > maxTextWidth && qualFontSize > 10) {
                            qualFontSize -= 2;
                            ctx.font = `bold ${qualFontSize}px Poppins`;
                        }

                        ctx.fillText(qualificationText, textX, currentY + qualFontSize);
                        currentY += qualFontSize * lineHeightMultiplier;
                    }

                    // Draw City
                    let cityText = city.value.trim();
                    if (cityText) {
                        let cityFontSize = 53; // Starting font size
                        ctx.font = `bold ${cityFontSize}px Poppins`;

                        while (ctx.measureText(cityText).width > maxTextWidth && cityFontSize > 10) {
                            cityFontSize -= 2;
                            ctx.font = `bold ${cityFontSize}px Poppins`;
                        }

                        ctx.fillText(cityText, textX, currentY + cityFontSize);
                    }
                }
            }
            else if (isDisclaimer) {
                // Draw disclaimer slide
                ctx.drawImage(frameDisclaimer, 0, 0, overlayCanvas.width, overlayCanvas.height);
            }

            if (isVideo) {
                // Draw the video full size
                ctx.drawImage(bgVideo, 0, 0, overlayCanvas.width, overlayCanvas.height);

                // Set text alignment to left (but position box at top right)
                ctx.textAlign = 'left';
                ctx.textBaseline = 'top';

                const maxTextWidth = 420; // Maximum text width
                const sideMargin = 10; // Margin on both sides
                const backgroundPadding = 15; // Padding inside background box
                let baseFontSize = overlayCanvas.height / 20; // Larger initial base size

                // Function to calculate appropriate font size
                function getAdjustedFontSize(text, initialSize) {
                    let fontSize = initialSize;
                    ctx.font = `bold ${fontSize}px Poppins`;
                    let textWidth = ctx.measureText(text).width;

                    // Reduce font size until text fits or minimum size reached
                    while (textWidth > maxTextWidth && fontSize > 12) {
                        fontSize -= 1;
                        ctx.font = `bold ${fontSize}px Poppins`;
                        textWidth = ctx.measureText(text).width;
                    }
                    return fontSize;
                }

                // Process name
                let nameFontSize = baseFontSize + 8;
                let nameText = name.value.trim();
                if (nameText) {
                    nameFontSize = getAdjustedFontSize(nameText, nameFontSize);
                }

                // Process qualification and city - always 3px smaller than name font size
                let qualCityFontSize = Math.max(nameFontSize - 3, 12); // Ensure minimum 12px
                let qualCityText = [];
                if (qualification.value.trim()) qualCityText.push(qualification.value.trim());
                if (city.value.trim()) qualCityText.push(city.value.trim());
                let combinedQualCity = qualCityText.join(", ");

                // Adjust qualCity font size if needed (though it should already be smaller)
                if (combinedQualCity) {
                    ctx.font = `bold ${qualCityFontSize}px Poppins`;
                    let qualCityWidth = ctx.measureText(combinedQualCity).width;
                    while (qualCityWidth > maxTextWidth && qualCityFontSize > 12) {
                        qualCityFontSize -= 1;
                        ctx.font = `bold ${qualCityFontSize}px Poppins`;
                        qualCityWidth = ctx.measureText(combinedQualCity).width;
                    }
                }

                // Calculate total height needed
                const lineSpacing = 6; // Reduced from 12 to 6 (or adjust as needed)
                let totalHeight = backgroundPadding * 2;
                if (nameText) totalHeight += nameFontSize;
                if (combinedQualCity) totalHeight += qualCityFontSize + (nameText ? lineSpacing : 0);

                // Calculate position for top-right placement (changed from bottom-right)
                const backgroundWidth = maxTextWidth + (backgroundPadding * 2);
                const backgroundX = overlayCanvas.width - backgroundWidth - sideMargin;
                const backgroundY = sideMargin; // Changed from bottom to top

                // Draw rounded semi-transparent background box
                ctx.fillStyle = '#4f4f4fba';
                ctx.beginPath();
                ctx.roundRect(backgroundX, backgroundY, backgroundWidth, totalHeight, 10); // 10px border radius
                ctx.fill();

                // Draw text (left-aligned within the right-positioned box)
                let currentY = backgroundY + backgroundPadding;
                const textX = backgroundX + backgroundPadding;

                // Draw name (top line)
                if (nameText) {
                    ctx.font = `bold ${nameFontSize}px Poppins`;
                    ctx.fillStyle = '#ffffff';
                    ctx.fillText(nameText, textX, currentY);
                    currentY += nameFontSize + lineSpacing;
                }

                // Draw qualification and city (bottom line)
                if (combinedQualCity) {
                    ctx.font = `bold ${qualCityFontSize}px Poppins`;
                    ctx.fillStyle = '#ffffff';
                    ctx.fillText(combinedQualCity, textX, currentY);
                }
            }
            else {
                if (isPlayingMainVideo) {
                    isPlayingMainVideo = false;
                    bgVideo.muted = true;
                }
            }

            if (elapsed < totalDuration) {
                animationFrameId = requestAnimationFrame(draw);
            } else {
                bgVideo.pause();
                bgVideo.currentTime = 0;
                videoEnded = true;
            }
        }

        async function generateVideo() {
            if (!overlayImg) return alert("Please crop and select an image first!");

            try {
                // Enhanced low-end device detection
                const isLowEndDevice = /(Android 1[0-3]|SM-[A-J][0-9]{3}|Redmi [0-9]|M[0-9]{3}|CPH[0-9]{4}|iPhone[6-8]|iPad[5-6]|iPod7)/i.test(navigator.userAgent) ||
                    (navigator.deviceMemory && navigator.deviceMemory < 3) ||
                    /(Helio P23|Snapdragon 630|Exynos 8895)/i.test(navigator.userAgent);

                // Show processing message for low-end devices
                if (isLowEndDevice) {
                    alert("Your device may take longer to process the video. Please be patient.");
                }

                // Use the predefined video URL
                bgVideo.src = predefinedVideoUrl;

                formContainer.style.display = 'none';
                previewContainer.style.display = 'flex';

                const loaderWrapper = document.getElementById('loader-wrapper');
                const downloadBtn = document.getElementById('downloadBtn');
                const shareBtn = document.getElementById('shareBtn');

                loaderWrapper.style.display = 'flex';
                downloadBtn.disabled = true;
                shareBtn.disabled = true;
                videoEnded = false;

                // Adjust settings for low-end devices
                if (isLowEndDevice) {
                    videoWidth = 1280;  // Slightly reduced but still HD
                    videoHeight = 720;
                    loaderWrapper.querySelector('p').textContent = 'Processing (optimizing for your device)...';
                }

                // Wait for video metadata with extended timeout
                await new Promise((resolve, reject) => {
                    let metadataLoaded = false;

                    bgVideo.onloadedmetadata = () => {
                        metadataLoaded = true;
                        overlayCanvas.width = videoWidth;
                        overlayCanvas.height = videoHeight;
                        resolve();
                    };

                    bgVideo.onerror = () => {
                        reject(new Error("Failed to load video. Please try again."));
                    };

                    // Progressive timeout for different device types
                    setTimeout(() => {
                        if (!metadataLoaded) {
                            if (bgVideo.readyState >= HTMLMediaElement.HAVE_METADATA) {
                                // Partial metadata loaded - proceed with caution
                                overlayCanvas.width = videoWidth;
                                overlayCanvas.height = videoHeight;
                                resolve();
                            } else {
                                reject(new Error("Video loading is taking longer than expected. Please wait or try a shorter video."));
                            }
                        }
                    }, isLowEndDevice ? 90000 : 30000); // 90s timeout for low-end
                });

                // Start with muted audio
                bgVideo.muted = false;
                isPlayingMainVideo = false;
                startTime = Date.now();

                // Create canvas stream with adaptive frame rate
                const frameRate = isLowEndDevice ? 15 : 30;
                const canvasStream = overlayCanvas.captureStream(frameRate);

                // Audio context with enhanced error handling
                let audioContext;
                let destination;
                try {
                    audioContext = new (window.AudioContext || window.webkitAudioContext)({
                        latencyHint: isLowEndDevice ? 'playback' : 'interactive'
                    });
                    destination = audioContext.createMediaStreamDestination();
                    const videoAudioSource = audioContext.createMediaElementSource(bgVideo);
                    videoAudioSource.connect(destination);
                } catch (e) {
                    console.warn("Audio processing limited: " + e.message);
                }

                // Combine streams with fallback
                let combinedStream;
                if (audioContext && destination) {
                    combinedStream = new MediaStream([
                        ...canvasStream.getVideoTracks(),
                        ...destination.stream.getAudioTracks()
                    ]);
                } else {
                    combinedStream = canvasStream;
                }

                // Enhanced MIME type detection
                function getBestMimeType() {
                    const types = [
                        'video/mp4;codecs="avc1.42E01E,mp4a.40.2"', // H.264 baseline
                        'video/webm;codecs="vp8,opus"', // VP8 fallback
                        'video/webm' // Most basic fallback
                    ];

                    for (let type of types) {
                        if (MediaRecorder.isTypeSupported(type)) {
                            return type;
                        }
                    }
                    return types[types.length - 1]; // Final fallback
                }

                const mimeType = getBestMimeType();

                // Adaptive bitrate settings
                const bitrateSettings = {
                    video: isLowEndDevice ? 1500000 : 2500000, // Maintain decent quality
                    audio: isLowEndDevice ? 96000 : 128000
                };

                const recorder = new MediaRecorder(combinedStream, {
                    mimeType: mimeType,
                    videoBitsPerSecond: bitrateSettings.video,
                    audioBitsPerSecond: bitrateSettings.audio
                });

                recordedChunks = [];
                let recordingStartTime = Date.now();

                recorder.ondataavailable = e => {
                    if (e.data.size > 0) {
                        recordedChunks.push(e.data);

                        // Progress feedback for long recordings
                        if (isLowEndDevice) {
                            const elapsed = (Date.now() - recordingStartTime) / 1000;
                            loaderWrapper.querySelector('p').textContent =
                                `Processing (${Math.floor(elapsed)}s)...`;
                        }
                    }
                };

                recorder.onstop = async () => {
                    cancelAnimationFrame(animationFrameId);
                    clearInterval(audioCheckInterval);

                    try {
                        loaderWrapper.querySelector('p').textContent = 'Finalizing video...';
                        const webmBlob = new Blob(recordedChunks, { type: recordedChunks[0].type });

                        // Use simpler conversion for low-end devices but maintain quality
                        convertedMp4Blob = isLowEndDevice ?
                            await convertWithCompatibilityFallback(webmBlob) :
                            await convertToMP4(webmBlob);

                        // Verify output quality
                        await verifyVideoQuality(convertedMp4Blob);
                        saveVideoMetadata();

                        loaderWrapper.style.display = 'none';
                        downloadBtn.disabled = false;
                        shareBtn.disabled = false;

                    } catch (error) {
                        console.error("Finalization error:", error);
                        alert("Processing completed but with reduced quality to work on your device.");
                        loaderWrapper.style.display = 'none';
                        downloadBtn.disabled = false;
                        shareBtn.disabled = false;
                    } finally {
                        if (audioContext && audioContext.state !== 'closed') {
                            await audioContext.close();
                        }
                    }
                };

                // Start recording with larger timeslice for low-end
                recorder.start(isLowEndDevice ? 500 : 100);
                animationFrameId = requestAnimationFrame(draw);

                // Enhanced playback control with buffering
                audioCheckInterval = setInterval(() => {
                    const elapsed = Date.now() - startTime;
                    const videoTime = elapsed - introDuration;

                    if (videoTime >= 0 && videoTime < bgVideo.duration * 1000) {
                        if (!isPlayingMainVideo) {
                            bgVideo.currentTime = 0;
                            bgVideo.play().catch(e => {
                                console.log("Playback error:", e);
                                // Try again with reduced requirements
                                bgVideo.muted = true;
                                bgVideo.play();
                            });
                            isPlayingMainVideo = true;
                        }
                    } else if (isPlayingMainVideo) {
                        bgVideo.pause();
                        isPlayingMainVideo = false;
                    }

                    // Check for completion
                    if (bgVideo.readyState > 0 && bgVideo.currentTime > bgVideo.duration - 0.5) {
                        videoEnded = true;
                    }
                }, isLowEndDevice ? 300 : 100);

                // Stop recording with extended duration for slow devices
                const totalDuration = introDuration + (bgVideo.duration * 1000) + outroDuration + disclaimerDuration;
                setTimeout(() => {
                    if (recorder.state === 'recording') {
                        recorder.stop();
                    }
                }, isLowEndDevice ? totalDuration * 1.5 : totalDuration);

            } catch (error) {
                console.error("Generation error:", error);

                if (error.message.includes("timeout")) {
                    alert("Your device is working hard to process the video. Please wait or try a shorter video.");
                } else {
                    alert("Video generation failed: " + error.message);
                }

                location.reload();
            }
        }
        async function convertWithCompatibilityFallback(webmBlob) {
            try {
                // First try FFmpeg if available
                if (typeof FFmpeg !== 'undefined') {
                    const ffmpeg = createFFmpeg({ log: true });
                    await ffmpeg.load();

                    ffmpeg.FS('writeFile', 'input.webm', await fetchFile(webmBlob));

                    // Use settings that preserve quality
                    await ffmpeg.run(
                        '-i', 'input.webm',
                        '-c:v', 'libx264',
                        '-preset', 'ultrafast',
                        '-crf', '23', // Quality factor (lower = better)
                        '-movflags', '+faststart',
                        '-pix_fmt', 'yuv420p',
                        '-c:a', 'aac',
                        '-b:a', '96k',
                        'output.mp4'
                    );

                    const data = ffmpeg.FS('readFile', 'output.mp4');
                    return new Blob([data.buffer], { type: 'video/mp4' });
                }
            } catch (e) {
                console.warn("FFmpeg conversion failed, falling back:", e);
            }

            // Fallback method that preserves quality
            return new Promise((resolve) => {
                const video = document.createElement('video');
                video.src = URL.createObjectURL(webmBlob);
                video.muted = true;
                video.playsInline = true;

                video.onloadedmetadata = () => {
                    const canvas = document.createElement('canvas');
                    canvas.width = videoWidth;
                    canvas.height = videoHeight;
                    const ctx = canvas.getContext('2d', { willReadFrequently: false });

                    const mimeType = MediaRecorder.isTypeSupported('video/mp4') ?
                        'video/mp4' : 'video/webm';

                    const stream = canvas.captureStream(15);
                    const recorder = new MediaRecorder(stream, {
                        mimeType: mimeType,
                        videoBitsPerSecond: 1500000, // Maintain decent bitrate
                        audioBitsPerSecond: 96000
                    });

                    const chunks = [];
                    recorder.ondataavailable = e => chunks.push(e.data);
                    recorder.onstop = () => {
                        const blob = new Blob(chunks, { type: mimeType });
                        URL.revokeObjectURL(video.src);
                        resolve(blob);
                    };

                    recorder.start(100);
                    video.play().catch(e => console.error("Playback error:", e));

                    function drawFrame() {
                        if (video.readyState >= HTMLMediaElement.HAVE_CURRENT_DATA) {
                            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                        }
                        if (!video.ended) {
                            requestAnimationFrame(drawFrame);
                        } else {
                            recorder.stop();
                        }
                    }
                    requestAnimationFrame(drawFrame);
                };
            });
        }

        // Quality verification
        async function verifyVideoQuality(videoBlob) {
            return new Promise((resolve, reject) => {
                const testVideo = document.createElement('video');
                testVideo.src = URL.createObjectURL(videoBlob);
                testVideo.preload = 'metadata';

                testVideo.onloadedmetadata = () => {
                    // Check if resolution is maintained
                    if (testVideo.videoWidth < 1280 && videoWidth >= 1280) {
                        console.warn("Output resolution lower than expected");
                    }
                    URL.revokeObjectURL(testVideo.src);
                    resolve();
                };

                testVideo.onerror = () => {
                    URL.revokeObjectURL(testVideo.src);
                    reject(new Error('Video verification failed'));
                };

                setTimeout(() => {
                    if (!testVideo.readyState) {
                        URL.revokeObjectURL(testVideo.src);
                        reject(new Error('Verification timed out'));
                    }
                }, 10000);
            });
        }


        // Pre-load FFmpeg.wasm if available
        if (typeof FFmpeg !== 'undefined') {
            const {
                createFFmpeg
            } = FFmpeg;
            const ffmpeg = createFFmpeg({
                log: false
            });
            ffmpeg.load().catch(e => console.log('FFmpeg pre-load failed', e));
        }

        async function convertToMP4(webmBlob) {
            const loaderText = document.getElementById('loader-wrapper').querySelector('p');
            loaderText.textContent = 'Converting to MP4...';

            let mp4Blob;

            try {
                if (typeof FFmpeg !== 'undefined') {
                    mp4Blob = await convertWithFFmpegWasm(webmBlob);
                } else {
                    mp4Blob = await convertWithOptimizedCanvas(webmBlob);
                }

                // ➕ Add compression step
                loaderText.textContent = 'Compressing Video...';
                const compressedBlob = await compressMp4Blob(mp4Blob);

                return compressedBlob; // Return final compressed video
            } catch (error) {
                console.error('Conversion error:', error);
                throw error;
            }
        }


        async function convertWithFFmpegWasm(webmBlob) {
            const {
                createFFmpeg,
                fetchFile
            } = FFmpeg;
            const ffmpeg = createFFmpeg({
                log: false, // Disable logging for better performance
                corePath: 'https://unpkg.com/@ffmpeg/core@0.11.0/dist/ffmpeg-core.js'
            });

            await ffmpeg.load();

            // Write input file
            ffmpeg.FS('writeFile', 'input.webm', await fetchFile(webmBlob));

            // Run optimized FFmpeg command
            await ffmpeg.run(
                '-i', 'input.webm',
                '-c:v', 'libx264', // H.264 codec
                '-preset', 'ultrafast', // Fastest encoding preset
                '-crf', '23', // Good quality with reasonable size
                '-movflags', '+faststart', // Enable streaming
                '-pix_fmt', 'yuv420p', // Widely compatible pixel format
                '-vf', 'fps=30', // Force 30 FPS output
                '-threads', '4', // Use multiple threads
                'output.mp4'
            );

            // Read output file
            const data = ffmpeg.FS('readFile', 'output.mp4');
            return new Blob([data.buffer], {
                type: 'video/mp4'
            });
        }

        async function convertWithOptimizedCanvas(webmBlob) {
            return new Promise((resolve) => {
                const video = document.createElement('video');
                video.src = URL.createObjectURL(webmBlob);
                video.muted = true;
                video.playsInline = true;

                video.onloadedmetadata = () => {
                    const canvas = document.createElement('canvas');
                    canvas.width = videoWidth;
                    canvas.height = videoHeight;
                    const ctx = canvas.getContext('2d');

                    const mimeType = MediaRecorder.isTypeSupported('video/mp4') ?
                        'video/mp4' : 'video/webm';

                    const stream = canvas.captureStream(15); // Lower frame rate
                    const recorder = new MediaRecorder(stream, {
                        mimeType: mimeType,
                        videoBitsPerSecond: 1000000 // Lower bitrate
                    });

                    const chunks = [];
                    recorder.ondataavailable = e => chunks.push(e.data);
                    recorder.onstop = () => resolve(new Blob(chunks, { type: mimeType }));

                    recorder.start(100);
                    video.play().catch(console.error);

                    function drawFrame() {
                        if (video.readyState >= HTMLMediaElement.HAVE_CURRENT_DATA) {
                            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                        }
                        if (!video.ended) requestAnimationFrame(drawFrame);
                        else recorder.stop();
                    }
                    requestAnimationFrame(drawFrame);
                };
            });
        }

        async function testVideoPlayback(videoBlob) {
            return new Promise((resolve, reject) => {
                const testVideo = document.createElement('video');
                testVideo.src = URL.createObjectURL(videoBlob);
                testVideo.preload = 'metadata';

                testVideo.onloadedmetadata = () => {
                    URL.revokeObjectURL(testVideo.src);
                    resolve();
                };

                testVideo.onerror = () => {
                    URL.revokeObjectURL(testVideo.src);
                    reject(new Error('Video playback test failed'));
                };

                // Timeout if metadata takes too long to load
                setTimeout(() => {
                    if (!testVideo.readyState) {
                        URL.revokeObjectURL(testVideo.src);
                        reject(new Error('Video test timed out'));
                    }
                }, 5000);
            });
        }

        async function compressMp4Blob(inputBlob) {
            const { createFFmpeg, fetchFile } = FFmpeg;
            const ffmpeg = createFFmpeg({
                log: false,
                corePath: 'https://unpkg.com/@ffmpeg/core@0.11.0/dist/ffmpeg-core.js'
            });

            await ffmpeg.load();

            ffmpeg.FS('writeFile', 'input.mp4', await fetchFile(inputBlob));

            // Compress with fast preset and lower bitrate
            await ffmpeg.run(
                '-i', 'input.mp4',
                '-vcodec', 'libx264',
                '-b:v', '1200k',  // Reduce bitrate for compression
                '-preset', 'ultrafast',
                '-acodec', 'aac',
                '-b:a', '96k',
                '-movflags', '+faststart',
                'compressed.mp4'
            );

            const compressedData = ffmpeg.FS('readFile', 'compressed.mp4');
            return new Blob([compressedData.buffer], { type: 'video/mp4' });
        }


        function saveVideoMetadata() {
            if (isVideoSaved) return;

            const xhr = new XMLHttpRequest();
            xhr.open("POST", "<?php echo site_url('/user/add_festival_video'); ?>", true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

            const userName = name.value.trim();
            const qualificationText = qualification.value.trim();
            const cityText = city.value.trim();
            const UserID = '<?php echo $row["UserID"]; ?>';
            const frame_id = '<?php echo $video_frame["video_frame_id"]; ?>';

            const params = 'input_text=' + encodeURIComponent(userName) +
                '&input_text2=' + encodeURIComponent(qualificationText) +
                '&input_text3=' + encodeURIComponent(cityText) +
                '&id=' + encodeURIComponent(UserID) +
                '&frame_id=' + encodeURIComponent(frame_id);

            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.status === "success") {
                                insertedVideoId = response.video_id;
                                isVideoSaved = true;
                                console.log("Video metadata saved. ID:", insertedVideoId);
                            } else {
                                console.error("Failed to save video metadata:", response.message);
                            }
                        } catch (e) {
                            console.error("Invalid response", e);
                        }
                    } else {
                        console.error("Error saving video metadata. Status:", xhr.status);
                    }
                }
            };

            xhr.onerror = function () {
                console.error("Request failed to save video metadata");
            };

            xhr.send(params);
        }


        async function saveVideo() {
            try {
                if (!convertedMp4Blob) {
                    throw new Error("No converted video available");
                }

                const loaderWrapper = document.getElementById('loader-wrapper');
                const downloadBtn = document.getElementById('downloadBtn');

                // Show loading state briefly (even though video is already converted)
                loaderWrapper.style.display = 'flex';
                loaderWrapper.querySelector('p').textContent = 'Preparing download...';
                downloadBtn.disabled = true;

                // Create download link for the pre-converted MP4
                const url = URL.createObjectURL(convertedMp4Blob);
                const a = document.createElement('a');
                a.href = url;
                a.download = `video_${Date.now()}.mp4`;
                document.body.appendChild(a);
                a.click();

                // Clean up
                setTimeout(() => {
                    document.body.removeChild(a);
                    URL.revokeObjectURL(url);
                    loaderWrapper.style.display = 'none';
                    downloadBtn.disabled = false;
                }, 100);

                // Update download status
                if (insertedVideoId && !isVideoDownloadUpdated) {
                    const xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo site_url('/user/festival_video_download_status'); ?>", true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.send('video_id=' + encodeURIComponent(insertedVideoId));
                    isVideoDownloadUpdated = true;
                }
            } catch (error) {
                console.error('Download error:', error);
                alert('Error preparing video for download. Please try again.');
                document.getElementById('loader-wrapper').style.display = 'none';
                document.getElementById('downloadBtn').disabled = false;
            }
        }

        async function shareVideo() {
            try {
                if (!convertedMp4Blob) {
                    throw new Error("No converted video available");
                }

                const fileToShare = new File([convertedMp4Blob], `video_${Date.now()}.mp4`, {
                    type: 'video/mp4'
                });

                // Check if sharing is supported
                if (navigator.share && navigator.canShare && navigator.canShare({
                    files: [fileToShare]
                })) {
                    await navigator.share({
                        files: [fileToShare],
                        title: 'Check out my Video!',
                        text: 'Check out my Video!',
                    });

                    // Update share status if successful
                    if (insertedVideoId && !isVideoShareUpdated) {
                        await updateShareStatus(insertedVideoId);
                        isVideoShareUpdated = true;
                    }
                } else {
                    // Fallback for browsers that don't support file sharing
                    fallbackShare();
                }
            } catch (error) {
                console.error('Sharing error:', error);

                // More specific error messages
                if (error.name === 'AbortError') {
                    alert('Sharing was cancelled by the user.');
                } else if (error.name === 'NotAllowedError') {
                    alert('Permission to share was denied.');
                } else if (error.message.includes('too large')) {
                    alert('Video is too large to share. Please try downloading instead.');
                } else {
                    // Try fallback method if direct sharing fails
                    fallbackShare();
                }
            }
        }

        function fallbackShare() {
            if (!convertedMp4Blob) return;

            const url = URL.createObjectURL(convertedMp4Blob);
            const link = document.createElement('a');
            link.href = url;
            link.download = `video_${Date.now()}.mp4`;
            document.body.appendChild(link);

            if (confirm(
                'Direct sharing not available. Do you want to download the video first, then share it through another app?'
            )) {
                link.click();
            }

            setTimeout(() => {
                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            }, 100);
        }

        // Helper function to update share status
        function updateShareStatus(videoId) {
            return new Promise((resolve, reject) => {
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url('/user/festival_video_share_status'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                xhr.onload = () => {
                    if (xhr.status === 200) {
                        resolve();
                    } else {
                        reject(new Error('Failed to update share status'));
                    }
                };

                xhr.onerror = () => reject(new Error('Request failed'));
                xhr.send('video_id=' + encodeURIComponent(videoId));
            });
        }

    </script>

</html>