<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Start your development with Meyawo landing page.">
    <meta name="author" content="Devcrud">
    <title>MHAC</title>
    <link rel="stylesheet" href="<?php echo base_url(); ?>/asset/vendors/themify-icons/css/themify-icons.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>/asset/css/meyawo.css" />
    <style>
        .hidden {
            display: none;
        }

        .hide-sec {
            display: none;
        }
    </style>
</head>

<body>

    <section class="section pt-0" id="about">
        <?php include("nav.php"); ?>

        <div class="container text-center ">
            <div class="about">

                <div class="about-caption">
                    <h5>Patient / Volunteer Data</h5>

                    <form action="<?php echo site_url('/user/patient_data') ?>" method="post"
                        onsubmit="return validateForm()">

                        <div class="sec-1">

                            <input onkeyup="validateName(this)" class="input" type="text" id="input_style" required
                                name="name" placeholder="Name">

                            <input onkeyup="validatePhone(this)" class="input" type="tel" id="input_style" required
                                name="phone" pattern="[6-9]{1}[0-9]{9}" placeholder="Phone ">

                            <input onkeyup="validateAge(this)" class="input" type="number" id="input_style" required
                                name="age" placeholder="Age">

                            <input class="input" type="text" id="input_style" required name="place"
                                onkeyup="validateName(this)" placeholder="Place">

                            <input class="input" type="date" id="input_style" required name="examination"
                                placeholder="Date of Examination">
                            <br>

                            <label>Gender : </label><br>

                            <label class="radio-inline  input">
                                Male <input type="radio" name="gender" required value="Male">
                            </label>
                            <label class="radio-inline  input">
                                Female <input type="radio" name="gender" required value="Female">
                            </label> 
                            <label class="radio-inline  input">
                                Other <input type="radio" name="gender" required value="Other">
                            </label>

                            <input class="input" type="hidden" required name="dr_id" value="<?= $row['id']; ?>">
                            <input class="input" type="hidden" required name="user_id" value="<?= $row['user_id']; ?>">
                            <input class="input" type="hidden" required name="user" value="<?= $row['user']; ?>">
                            <input class="input" type="hidden" required name="empno" value="<?= $row['empno']; ?>">
                            <input class="input" type="hidden" required name="hq_id" value="<?= $row['hq_id']; ?>">
                            <input class="input" type="hidden" required name="region_id"
                                value="<?= $row['region_id']; ?>">
                            <input class="input" type="hidden" required name="zone_id" value="<?= $row['zone_id']; ?>">
                            <br><br>
                            <div class="text-center">

                                <button type="button" class="btn sub-btn"
                                    onclick="showPreviousSection('sec-1', 'sec-1')">Back</button>

                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-1', 'sec-2')">
                                    Next</button>

                            </div>
                        </div>
                        <div class="sec-2 hide-sec">
                            <label>Known case of Hypertension</label>
                            <br>
                            <label class="radio-inline  input">
                                Yes <input type="radio" name="hypertension" required value="Yes"
                                    onclick="showInputField()">
                            </label>
                            <label class="radio-inline  input">
                                No <input type="radio" name="hypertension" required value="No"
                                    onclick="hideInputField()">
                            </label>

                            <br>

                            <div class="radio-inline hidden">
                                Anti-Hypertension Drugs:
                                <br>
                                <label>
                                    Mono
                                    <input type="radio" name="drugs" required value="Mono">
                                </label>
                                <br>

                                <label>
                                    Dual
                                    <input type="radio" name="drugs" required value="Dual">
                                </label>
                                <br>

                                <label>
                                    Triple
                                    <input type="radio" name="drugs" required value="Triple">
                                </label>
                            </div>

                            <br>
                            <div class="hidden">
                                Which Combination:
                                <br>
                                <label>
                                    ARB <input type="checkbox" name="combination[]" value="ARB">
                                </label>
                                <br>
                                <label>
                                    ACE-I <input type="checkbox" name="combination[]" value="ACE-I">
                                </label>
                                <br>
                                <label>
                                    BB <input type="checkbox" name="combination[]" value="BB">
                                </label>
                                <br>
                                <label>
                                    CCB <input type="checkbox" name="combination[]" value="CCB">
                                </label>
                                <br>
                                <label>
                                    Diuretic <input type="checkbox" name="combination[]" value="Diuretic">
                                </label>
                            </div>

                            <br>

                            <div class="text-center">


                                <button type="button" class="btn sub-btn"
                                    onclick="showPreviousSection('sec-2', 'sec-1')">Back</button>

                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-2', 'sec-3')">
                                    Next</button>

                            </div>

                        </div>
                        <div class="sec-3 hide-sec">
                            <h6>
                                If Not a Known case of Hypertension then take
                                3 BP Reading with 2 minutes gap
                            </h6>


                            <label style="margin-bottom:10px">Reading 1</label>
                            <label style="margin:0px" class="radio-inline  ">
                                SBP <input type="number" class="input" name="sbp1" id="sbp1" required
                                    placeholder="mmHg">
                            </label>
                            <label style="margin:0px" class="radio-inline  ">
                                DBP <input type="number" class="input" name="dbp1" id="dbp1" required
                                    placeholder="mmHg">
                            </label>


                            <label style="margin-bottom:10px">Reading 2</label>
                            <label style="margin:0px" class="radio-inline  ">
                                SBP <input type="number" class="input" name="sbp2" id="sbp2" required
                                    placeholder="mmHg">
                            </label>
                            <label style="margin:0px" class="radio-inline  ">
                                DBP <input type="number" class="input" name="dbp2" id="dbp2" required
                                    placeholder="mmHg">
                            </label>


                            <label style="margin-bottom:10px">Reading 3</label>
                            <label style="margin:0px" class="radio-inline  ">
                                SBP <input type="number" class="input" name="sbp3" id="sbp3" required
                                    placeholder="mmHg">
                            </label>
                            <label style="margin:0px" class="radio-inline  ">
                                DBP <input type="number" class="input" name="dbp3" id="dbp3" required
                                    placeholder="mmHg">
                            </label>


                            <label style="margin-bottom:10px">Average Reading</label>
                            <label style="margin:0px" class="radio-inline  ">
                                SBP <input type="number" class="input" name="average_sbp" id="average_sbp" required
                                    placeholder="mmHg" readonly>
                            </label>
                            <label style="margin:0px" class="radio-inline  ">
                                DBP <input type="number" class="input" name="average_dbp" id="average_dbp" required
                                    placeholder="mmHg" readonly>
                            </label>

                            <br> <br>
                            <div class="text-center">
                                <button type="button" class="btn sub-btn"
                                    onclick="showPreviousSection('sec-3', 'sec-2')">Back</button>

                                <button type="button" class="btn sub-btn" onclick="showNextSection('sec-3', 'sec-4')">
                                    Next</button>

                            </div>

                            <p>
                                <b>Note:</b><br>
                                1. Incase increase in BP, he or she needs to seek repeat examination after a week.
                                <br>
                                2. <b>DBP</b> can not be higher then <b>SBP</b>


                            </p>

                        </div>
                        <div class="sec-4 hide-sec">

                            <h6>
                                If diagnosis of Hypertension is established, then what prescription you prefer
                            </h6>


                            <label style="margin-bottom:10px">Monotherapy <br> (Molecule Name & Dosage)</label>
                            <label style="margin:0px" class="radio-inline  ">
                                <textarea type="text" class="input" name="monotherapy" rows="1" id="textarea " required
                                    placeholder="Monotherapy"></textarea>
                            </label>


                            <label style="margin-bottom:10px">Combination Therapy <br> (Combination &
                                Dosage)</label>
                            <label style="margin:0px" class="radio-inline  ">
                                <textarea type="text" class="input" name="combinationtherapy" rows="1" id="textarea "
                                    required placeholder="Combination Therapy"></textarea>
                            </label>


                            <label style="margin-bottom:10px">Co-morbid Conditions if any <br> Diabetes/established
                                ASCVD/CKD/Previous Stroke</label>
                            <label style="margin:0px" class="radio-inline  ">
                                <textarea type="text" class="input" name="comorbid_con" rows="1" id="textarea " required
                                    placeholder="Co-morbid Conditions"></textarea>
                            </label>


                            <label style="margin-bottom:10px">Drugs for co-morbidity </label>
                            <label style="margin:0px" class="radio-inline  ">
                                <textarea type="text" class="input" name="drg_comorbid" rows="1" id="textarea " required
                                    placeholder="Drugs for co-morbidity "></textarea>
                            </label>

                            <br> <br>

                            <div class="text-center">
                                <button type="button" class="btn sub-btn"
                                    onclick="showPreviousSection('sec-4', 'sec-3')">Back</button>

                                <button type="submit" class="btn sub-btn"> Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="">
            <img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt=" ">
        </div>
    </section> <!-- end of about section -->

    <?php include("footer.php") ?>

    <script>
        function showInputField() {
            var inputs = document.querySelectorAll('.hidden');
            for (var i = 0; i < inputs.length; i++) {
                inputs[i].style.display = 'inline-block';
                if (inputs[i].getAttribute('type') === 'radio') {
                    inputs[i].setAttribute('required', 'required');
                }
            }
        }

        function hideInputField() {
            // Set the value of the "drugs" radio button with value "Mono" to "NO"
            var drugsRadios = document.querySelectorAll('input[name="drugs"]');
            for (var j = 0; j < drugsRadios.length; j++) {
                if (drugsRadios[j].value === 'Mono') {
                    drugsRadios[j].setAttribute('value', 'No');
                    drugsRadios[j].checked = true;
                } else {
                    drugsRadios[j].disabled = true;
                }
            }

            // Set the value of the "combination[]" checkbox with value "ARB" to "NO"
            var combinationCheckboxes = document.querySelectorAll('input[name="combination[]"]');
            for (var k = 0; k < combinationCheckboxes.length; k++) {
                if (combinationCheckboxes[k].value === 'ARB') {
                    combinationCheckboxes[k].checked = false;
                    combinationCheckboxes[k].value = 'NO'; // Set the value to "NO"
                } else {
                    combinationCheckboxes[k].disabled = true;
                }
            }


        }

        function enableCheckboxes(maxChecked) {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]');
            var drugsRadio = document.querySelector('input[name="drugs"]:checked');

            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].disabled = false;
            }

            if (drugsRadio && drugsRadio.value === "Triple") {
                // If "Triple" is selected, enable all checkboxes
                for (var i = 0; i < checkboxes.length; i++) {
                    checkboxes[i].disabled = false;
                }
            } else if (drugsRadio && drugsRadio.value === "Dual") {
                // If "Dual" is selected, enable the number of checkboxes specified by maxChecked
                for (var i = 0; i < checkboxes.length; i++) {
                    checkboxes[i].disabled = i >= maxChecked;
                }
            }
        }
    </script>


    <script>
        function validateForm() {
            var sbp1 = document.getElementById("sbp1").value;
            var dbp1 = document.getElementById("dbp1").value;

            if (parseInt(sbp1) < parseInt(dbp1)) {
                alert("Reading 1 : SBP cannot be less than DBP");
                return false;
            }

            var sbp2 = document.getElementById("sbp2").value;
            var dbp2 = document.getElementById("dbp2").value;

            if (parseInt(sbp2) < parseInt(dbp2)) {
                alert("Reading 2 : SBP cannot be less than DBP");
                return false;
            }

            var sbp3 = document.getElementById("sbp3").value;
            var dbp3 = document.getElementById("dbp3").value;

            if (parseInt(sbp3) < parseInt(dbp3)) {
                alert("Reading 3 : SBP cannot be less than DBP");
                return false;
            }

            return true;
        }
    </script>

    <script>
        function calculateAverages() {
            var sbp1 = parseFloat(document.getElementById("sbp1").value || 0);
            var dbp1 = parseFloat(document.getElementById("dbp1").value || 0);
            var sbp2 = parseFloat(document.getElementById("sbp2").value || 0);
            var dbp2 = parseFloat(document.getElementById("dbp2").value || 0);
            var sbp3 = parseFloat(document.getElementById("sbp3").value || 0);
            var dbp3 = parseFloat(document.getElementById("dbp3").value || 0);

            var average_sbp = (sbp1 + sbp2 + sbp3) / 3;
            var average_dbp = (dbp1 + dbp2 + dbp3) / 3;

            document.getElementById("average_sbp").value = average_sbp.toFixed(2);
            document.getElementById("average_dbp").value = average_dbp.toFixed(2);
        }

        // Add event listeners to calculate averages on input change
        document.getElementById("sbp1").addEventListener("input", calculateAverages);
        document.getElementById("dbp1").addEventListener("input", calculateAverages);
        document.getElementById("sbp2").addEventListener("input", calculateAverages);
        document.getElementById("dbp2").addEventListener("input", calculateAverages);
        document.getElementById("sbp3").addEventListener("input", calculateAverages);
        document.getElementById("dbp3").addEventListener("input", calculateAverages);


        function showNextSection(currentSec, nextSec) {
            if (validateForm(currentSec)) {
                hideAndUnhide(currentSec, nextSec);
            }
        }

        // Function to validate the form for the given section
        function validateForm(section) {
            if (section === 'sec-1') {
                var name = document.querySelector('input[name="name"]').value.trim();
                var phone = document.querySelector('input[name="phone"]').value.trim();
                var place = document.querySelector('input[name="place"]').value.trim();
                var examination = document.querySelector('input[name="examination"]').value.trim();
                var age = document.querySelector('input[name="age"]').value.trim();
                var gender = document.querySelector('input[name="gender"]').value.trim();

                if (name === '' || phone === '' || place === '' || examination === '' || age === '' || gender === '') {
                    alert('Please fill in all fields ');
                    return false;
                }
            } else if (section === 'sec-2') {
                var hypertension = document.querySelector('input[name="hypertension"]:checked');
                if (!hypertension) {
                    alert('Please select if you have known hypertension');
                    return false;
                } else if (hypertension.value === 'Yes') {
                    var drugsRadio = document.querySelector('input[name="drugs"]:checked');
                    if (!drugsRadio) {
                        alert("Please select a value for 'Anti-Hypertension Drugs'");
                        return false;
                    }

                    var checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
                    var maxChecked = parseInt(drugsRadio.value);

                    if (drugsRadio.value === 'Mono') {
                        var checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
                        if (checkboxes.length !== 1) {
                            alert("Please select exactly 1 checkbox for 'Anti-Hypertension Drugs' when Mono is chosen");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Dual') {
                        var checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
                        var maxChecked = 2;
                        if (checkboxes.length !== maxChecked) {
                            alert("Please select exactly " + maxChecked +
                                " checkboxes for 'Anti-Hypertension Drugs' when Dual is chosen");
                            return false;
                        }
                    } else if (drugsRadio.value === 'Triple') {
                        var checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
                        var minChecked = 3;
                        if (checkboxes.length < minChecked) {
                            alert("Please select at least " + minChecked +
                                " checkboxes for 'Anti-Hypertension Drugs' when Triple is chosen");
                            return false;
                        }
                    }
                }

            } else if (section === 'sec-3') {
                var sbp1 = parseInt(document.querySelector('input[name="sbp1"]').value);
                var dbp1 = parseInt(document.querySelector('input[name="dbp1"]').value);
                var sbp2 = parseInt(document.querySelector('input[name="sbp2"]').value);
                var dbp2 = parseInt(document.querySelector('input[name="dbp2"]').value);
                var sbp3 = parseInt(document.querySelector('input[name="sbp3"]').value);
                var dbp3 = parseInt(document.querySelector('input[name="dbp3"]').value);

                if (isNaN(sbp1) || isNaN(dbp1) || isNaN(sbp2) || isNaN(dbp2) || isNaN(sbp3) || isNaN(dbp3)) {
                    alert('Please enter valid BP readings ');
                    return false;
                }

                if (sbp1 < dbp1 || sbp2 < dbp2 || sbp3 < dbp3) {
                    alert('SBP cannot be less than DBP ');
                    return false;
                }
            }

            return true;
        }

        // Function to hide the current section and unhide the next section
        function hideAndUnhide(currentSec, nextSec) {
            document.querySelector('.' + currentSec).style.display = 'none';
            document.querySelector('.' + nextSec).style.display = 'block';
        }

        function showPreviousSection(currentSec, prevSec) {
            hideAndUnhide(currentSec, prevSec);
            currentSection = prevSec;
        }

        document.querySelector('button[data-action="back-sec-2"]').addEventListener("click", function () {
            showPreviousSection('sec-2', 'sec-1');
        });

        document.querySelector('button[data-action="back-sec-3"]').addEventListener("click", function () {
            showPreviousSection('sec-3', 'sec-2');
        });

        document.querySelector('button[data-action="back-sec-4"]').addEventListener("click", function () {
            showPreviousSection('sec-4', 'sec-3');
        });



        function validateName(input) {
            var inputValue = input.value;
            var alphanumericPattern = /^[a-zA-Z\s.]*$/;

            if (!alphanumericPattern.test(inputValue)) {
                input.value = inputValue.replace(/[^a-zA-Z\s.]/g, ''); // Remove special characters
            }
        }

        function validatePhone(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^[6-9]\d{9}$/; // Matches exactly 10 digits starting with a digit between 6 and 9

            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, ''); // Remove non-digit characters
                if (input.value.length > 10) {
                    input.value = input.value.slice(0, 10); // Truncate to 10 digits if longer
                }
            }
        }

        function validateAge(input) {
            var inputValue = input.value;
            var tenDigitPattern = /^\d{2}$/; // Matches exactly 10 digits starting with a digit between 6 and 9

            if (!tenDigitPattern.test(inputValue)) {
                input.value = inputValue.replace(/\D/g, ''); // Remove non-digit characters
                if (input.value.length > 2) {
                    input.value = input.value.slice(0, 2); // Truncate to 10 digits if longer
                }
            }
        }
    </script>

</body>

</html>