<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<!-- Add these lines to include DataTables and jQuery -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
<body>
    <!-- about section -->
    <section class="section pt-0" id="about">
        <?php include("nav.php"); ?>
        <!-- container -->
        <div class="container text-center ">
            <!-- about wrapper -->
            <div class="about">
                <div class="about-caption">
                    <div class="container" style="overflow-x:auto; box-shadow: 0px 8px 20px 2px #0000005c; border-radius: 10px;">
                        <table class="table" id="myTable">
                            <thead class="">
                                <tr>
                                    <th scope="col">S. No</th>
                                    <th scope="col">Doctor</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Phone</th>
                                    <th scope="col">Place</th>
                                    <th scope="col">Gender</th>
                                    <th scope="col">Age</th>
                                    <th scope="col">Examination Date</th>
                                    <th scope="col">Hypertension </th>
                                    <th scope="col">Hypertension Drugs</th>
                                    <th scope="col">Drugs Combination</th>
                                    <th scope="col">ARB Prescription</th>
                                    <th scope="col">ARB Dose</th>
                                    <th scope="col">ACE-I Prescription</th>
                                    <th scope="col">ACE-I Dose</th>
                                    <th scope="col">BB Prescription</th>
                                    <th scope="col">BB Dose</th>
                                    <th scope="col">CCB Prescription</th>
                                    <th scope="col">CCB Dose</th>
                                    <th scope="col">Diuretic Prescription</th>
                                    <th scope="col">Diuretic Dose</th>
                                    <th scope="col">Other Prescription</th>
                                    <th scope="col">Other Dose</th>
                                    <th scope="col">SBP</th>
                                    <th scope="col">DBP</th>
                                    <th scope="col">Average SBP</th>
                                    <th scope="col">Average DBP</th>
                                    <th scope="col">Co-morbid Condition</th>
                                    <th scope="col">Drugs for co-morbidity</th>
                                    <th scope="col">Date</th>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php
                                $serial = 0;
                                if (!empty($data)) {
                                    foreach ($data as $row) {
                                        $serial++; ?>
                                        <tr>
                                            <td><?php echo $serial ?></td>
                                            <td><?php echo $row['doctor']; ?></td>
                                            <td><?php echo $row['name']; ?></td>
                                            <td><?php echo $row['phone']; ?></td>
                                            <td><?php echo $row['place']; ?></td>
                                            <td><?php echo $row['gender']; ?></td>
                                            <td><?php echo $row['age']; ?></td>
                                            <td><?php echo $row['examination']; ?></td>
                                            <td><?php echo $row['hypertension']; ?></td>
                                            <td><?php echo $row['hypertension_drugs']; ?></td>
                                            <td><?php echo $row['drugs_combination']; ?></td>
                                            <td><?php echo $row['arb']; ?></td>
                                            <td><?php echo $row['arb_dose']; ?></td>
                                            <td><?php echo $row['ace_i']; ?></td>
                                            <td><?php echo $row['ace_i_dose']; ?></td>
                                            <td><?php echo $row['bb']; ?></td>
                                            <td><?php echo $row['bb_dose']; ?></td>
                                            <td><?php echo $row['ccb']; ?></td>
                                            <td><?php echo $row['ccb_dose']; ?></td>
                                            <td><?php echo $row['diuretic']; ?></td>
                                            <td><?php echo $row['diuretic_dose']; ?></td>
                                            <td><?php echo $row['other']; ?></td>
                                            <td><?php echo $row['other_dose']; ?></td>
                                            <td>SBP1:-  <?php echo $row['sbp1']; ?> SBP2:- <?php echo $row['sbp2']; ?> SBP3:- <?php echo $row['sbp3']; ?></td>
                                            <td>DBP1:- <?php echo $row['dbp1']; ?> DBP2:- <?php echo $row['dbp2']; ?> DBP3:- <?php echo $row['dbp3']; ?></td>
                                            <td><?php echo $row['average_sbp']; ?></td>
                                            <td><?php echo $row['average_dbp']; ?></td>
                                            <td><?php echo $row['co_morbid_conditions']; ?></td>
                                            <td><?php echo $row['drugs_co_morbidity']; ?></td>
                                            <td><?php echo $row['date']; ?></td>
                                        </tr>
                                    <?php }
                                } else { ?>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class=""><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt=" "></div>
    </section>
    <script src="<?php echo base_url(); ?>/asset/vendors/bootstrap/bootstrap.bundle.js"></script>
    <script src="<?php echo base_url(); ?>/asset/vendors/bootstrap/bootstrap.affix.js"></script>
    <script src="<?php echo base_url(); ?>/asset/js/meyawo.js"></script>
    <script>
        $(document).ready(function () {
            $('#myTable').DataTable({
                "paging": true, 
                "pageLength": 10, 
                "lengthChange": false, 
            });
        });
    </script>
</body>
</html>