<!DOCTYPE html>
<html lang="en">
<?php include ("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

<body>
    <section class="section pt-0" id="about">
        <?php include ("nav.php"); ?>
        <div class="container text-center ">
            <div class="about">
                <div class="about-caption">
                    <div class="container"
                        style="overflow-x:auto; box-shadow: 0px 8px 20px 2px #0000005c; border-radius: 10px;">
                        <table class="table" id="myTable">
                            <thead class="">
                                <tr>
                                    <th scope="col">S. No</th>
                                    <th scope="col">Image</th>
                                    <th scope="col">Patient Name</th>
                                    <th scope="col">Patient Phone</th>
                                    <th scope="col">Doctor Name</th>
                                    <th scope="col">Quantity of Strips</th>
                                    <th scope="col">Indication</th>
                                    <th scope="col">Secondary in Units</th>
                                    <th scope="col">Prescription Information</th>
                                    <th scope="col">Co-Morbidity Prescription</th>
                                    <th scope="col">Date</th>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php
                                $serial = 0;
                                if (!empty($data)) {
                                    foreach ($data as $row) {
                                        $serial++;
                                        ?>
                                        <tr>
                                            <td><?php echo $serial ?></td>
                                            <td>
                                                <?php $file_extension = pathinfo($row['image'], PATHINFO_EXTENSION);
                                                $allowed_extensions = array('jpg', 'jpeg', 'png', 'webp', 'gif', 'bmp');
                                                if (in_array(strtolower($file_extension), $allowed_extensions)) {
                                                    echo '<img src="' . base_url() . '/assets/patient_data/' . $row['image'] . '" style="width:100px">';
                                                } else { echo $row['image'];} ?>
                                            </td>
                                            <td><?php echo $row['patient_name']; ?></td>
                                            <td><?php echo $row['phone_no']; ?></td>
                                            <td><?php echo $row['doctor_name']; ?></td>
                                            <td><?php echo $row['strips']; ?></td>
                                            <td><?php echo $row['indication']; ?></td>
                                            <td><?php echo $row['secondary']; ?></td>
                                            <td><?php echo $row['prescription_information']; ?></td>
                                            <td><?php echo $row['co_morbidity_prescription']; ?></td>
                                            <td><?php echo $row['date']; ?></td>
                                        </tr>
                                    <?php }
                                } else { ?>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class=""><img src="<?php echo base_url(); ?>/asset/imgs/character.png" class="chr" alt=" "></div>
    </section>
    <script src="<?php echo base_url(); ?>/asset/vendors/bootstrap/bootstrap.bundle.js"></script>
    <script src="<?php echo base_url(); ?>/asset/vendors/bootstrap/bootstrap.affix.js"></script>
    <script src="<?php echo base_url(); ?>/asset/js/meyawo.js"></script>
    <script>
        $(document).ready(function () {
            $('#myTable').DataTable({
                "paging": true,
                "pageLength": 10,
                "lengthChange": false,
            });
        });
    </script>
</body>

</html>