<!DOCTYPE html>
<html lang="en">

<?php include("head.php") ?>

<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>

        <div class="container-fluid "><br>
            <div class="row">
                <div class="col-sm-12 ">
                    <div class="bg-white rounded h-100 p-4">
                        <h3 class="mb-4">Add Employee Form</h3>
                        <form role="form" action="<?php echo site_url('/zone/user_insert') ?>" method="post"
                            onsubmit="return submitForm(this);" enctype="multipart/form-data">
                            <div class="col-sm-12 row">
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Enter Employee Name</label>
                                    <input required type="text" class="form-control" placeholder="Employee Name"
                                        name="name">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Enter Employee Mobile Number</label>
                                    <input required type="tel" class="form-control" pattern="[6-9]{1}[0-9]{9}"
                                        placeholder="9 * * * * * * * * 0" name="phone">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Enter Employee E-mail</label>
                                    <input required type="email" class="form-control" placeholder="Employee E-mail"
                                        name="email">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Enter Employee No.</label>
                                    <input required type="text" class="form-control" placeholder="Employee NO."
                                        name="emp_no">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label">User Type</label><br>
                                    <select class="form-select col-1" name="user_type" required>
                                        <option value="1">BO</option>
                                        <option value="2">ABM</option>
                                        <option value="3">RBM</option>
                                        <option value="4">ZBM</option>
                                        <br>
                                    </select>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label"> Enter City</label>
                                    <input required type="text" class="form-control" placeholder="City" name="city">
                                    <br>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label">Designation</label><br>
                                    <select class="form-select col-1" name="desig" required>
                                        <option value="BO">BO</option>
                                        <option value="ABM">ABM</option>
                                        <option value="RBM">RBM</option>
                                        <option value="ZBM">ZBM</option>
                                        <br>
                                    </select>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label">Head Quarters</label><br>
                                    <select class="form-select col-1" name="hq" required>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $row) {
                                                ?>
                                                <option value="<?php echo $row['HQId']; ?>"><?php echo $row['HQ']; ?> </option>

                                                <br>
                                            <?php }
                                        } else { ?>
                                        <option>Head Quarter Not Found </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-sm-3">
                                    <label for="" class="form-label">Region</label><br>
                                    <select class="form-select col-1" name="region" required>
                                        <?php
                                        $serial = 0;
                                        if (!empty($region)) {
                                            foreach ($region as $row) {
                                                ?>
                                                <option value="<?php echo $row['REGIONId']; ?>"><?php echo $row['REGION']; ?> </option>

                                                <br>
                                            <?php }
                                        } else { ?>
                                        <option>Region Not Found </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <input type="hidden" value="<?php echo $zone_id; ?>" name="zone" class="form-control">


                            </div>
                            <center>

                                <div class="col-xs-12 ">
                                    <br>

                                    <input type="submit" class="btn btn-primary" name="submit" value="submit">

                                </div>
                            </center>
                        </form>

                    </div>
                </div>
            </div>
            
        </div>


    </div>


    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <?php include("footer.php") ?>


</body>

</html>