<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>


<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">

                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Doctor Patients</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green  text-white">Generate Excel</button>

                            <table class="table" id="myTable" style="">

                                <thead>
                                    <tr class="">
                                        <th scope="">S.no.</th>
                                        <th scope="col">Doctor Name</th>
                                        <th scope="col">Patient Name</th>
                                        <th scope="col">Phone</th>
                                        <th scope="col">Place</th>
                                        <th scope="col">Gender</th>
                                        <th scope="col">Age</th>
                                        <th scope="col">Examination Date</th>
                                        <th scope="col">Hypertension </th>
                                        <th scope="col">Hypertension Drugs</th>
                                        <th scope="col">Drugs Combination</th>
                                        <th scope="col">SBP</th>
                                        <th scope="col">DBP</th>
                                        <th scope="col">Average SBP</th>
                                        <th scope="col">Average DBP</th>
                                        <th scope="col">Mono Therapy</th>
                                        <th scope="col">Combination Therapy</th>
                                        <th scope="col">Co-morbid Condition</th>
                                        <th scope="col">Drugs for co-morbidity</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">User</th>
                                        <th scope="col">Emp. Id</th>
                                        <th scope="col">HQ</th>
                                        <th scope="col">Region</th>
                                        <th scope="col">Zone</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td>
                                                    <?php echo $serial ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['doctor']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['name']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['phone']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['place']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['gender']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['age']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['examination']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['hypertension']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['hypertension_drugs']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['drugs_combination']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['sbp1']; ?> ,
                                                    <?php echo $row['sbp2']; ?> ,
                                                    <?php echo $row['sbp3']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['dbp1']; ?> ,
                                                    <?php echo $row['dbp2']; ?> ,
                                                    <?php echo $row['dbp3']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['average_sbp']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['average_dbp']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['monotherapy']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['combination_therapy']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['co_morbid_conditions']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['drugs_co_morbidity']; ?>
                                                </td>
                                            
                                                <td>
                                                    <?php echo $row['date']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['user']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['empno']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['HQ']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['REGION']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['ZONE']; ?>
                                                </td>


                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4> Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" ">
                <br>
            </div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>

    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
    <script>
        document.getElementById('tbltoxl').addEventListener('click', function () {
            var table2excel = new Table2Excel();
            table2excel.export(document.querySelectorAll("#myTable"));
        })
    </script>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>

    <script>
        $(document).ready(function () {
            $('#myTable').DataTable({
                responsive: true,
                paging: true // Enable pagination
            });
        });
    </script>

</body>

</html>