<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>


<body>
    <section class="section pt-0" id="about">
        <?php include("nav.php") ?>

        <div class=" ">
            <div class="">
                <div class="frame-container" id="step1">
                    <input type="text" class="frame-input" id="name" placeholder="Enter Name">
                    <input type="text" class="frame-input" id="qualification" placeholder="Enter Qualification">
                    <input type="text" class="frame-input" id="city" placeholder="Enter City">
                    <input type="file" class="frame-input" id="upload" accept="image/*">
                    <!-- <div class="image-preview" id="preview"></div> -->
                    <button class="frame-button" onclick="openCropperModal()">Crop Image</button>
                    <button class="frame-button" onclick="generateFrame()">Generate Frame</button>
                </div>

                <!-- Modal Cropper -->

                <!-- Modal Cropper -->
                <div class="modal" id="cropperModal">
                    <div class="modal-content">
                        <img id="cropperImage" src="" alt="Cropper Preview">
                        <button class="crop-btn" onclick="applyCrop()">Crop & Continue</button>
                    </div>
                </div>

                <!-- Preview + Canvas Area -->
                <div class="frame-container" id="preview-container" style="display:none; flex-direction: column;">
                    <canvas id="canvas" width="1080" height="1350" style="border-radius: 1rem;"></canvas>
                    <button class="frame-button" onclick="saveImage()">Download</button>
                    <button class="frame-button" onclick="shareImage()">Share</button>
                </div>

            </div>
        </div>
        <div class="chr-box"><img src="<?php echo base_url(); ?>asset/imgs/character.png" class="chr" alt=" character"></div>
    </section>
    <!-- JS Libraries -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>

    <script>
        const upload = document.getElementById('upload');
        const preview = document.getElementById('preview');
        const cropperModal = document.getElementById('cropperModal');
        const cropperImage = document.getElementById('cropperImage');
        const canvas = document.getElementById("canvas");
        const ctx = canvas.getContext("2d");
        const frame = new Image();
        frame.src = "<?php echo base_url(); ?>/assets/frame/<?php echo $photo_frame["frame_name"]; ?>"; // Make sure this path is correct

        const cropperContainer = document.getElementById('cropperModal');
        const previewContainer = document.getElementById("preview-container");
        const step1Container = document.getElementById("step1");

        let cropper;
        let croppedImageDataUrl;
        let insertedPosterId = null;
        let isPosterSaved = false;
        let isDownloadUpdated = false;
        let isShareUpdated = false;

        upload.addEventListener('change', function () {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    cropperImage.src = e.target.result;
                    cropperModal.classList.add('active');
                    if (cropper) cropper.destroy();
                    cropper = new Cropper(cropperImage, {
                        aspectRatio: 1,
                        viewMode: 1,
                        background: false,
                        autoCropArea: 1,
                    });
                }
                reader.readAsDataURL(file);
            }
        });

        function openCropperModal() {
            const file = upload.files[0];
            if (!file) return alert("Upload an image first.");
            cropperModal.classList.add('active');
            if (cropper) cropper.destroy();
            cropper = new Cropper(cropperImage, {
                aspectRatio: 1,
                viewMode: 1,
                background: false,
                autoCropArea: 1,
            });
        }

        function applyCrop() {
            const croppedCanvas = cropper.getCroppedCanvas({ width: 1080, height: 1080 });
            croppedImageDataUrl = croppedCanvas.toDataURL();
            const croppedImage = new Image();
            croppedImage.onload = function () {
                ctx.clearRect(0, 0, canvas.width, canvas.height);
                ctx.drawImage(croppedImage, 190, 180, 700, 700); // Draw cropped image on canvas
                cropperModal.classList.remove('active');
            };
            croppedImage.src = croppedImageDataUrl;
            cropper.destroy();
        }

        function generateFrame() {
            const userName = document.getElementById("name").value.trim();
            const qualification = document.getElementById("qualification").value.trim();
            const city = document.getElementById("city").value.trim();

            if (!userName || !qualification || !city) {
                alert("Please fill in Name, Qualification & City before generating the frame.");
                return;
            }

            const inputText = userName || "Doctor Name Here";
            const inputQualification = qualification || "Qualification Here";
            const inputCity = city || "City Here";

            if (croppedImageDataUrl) {
                const croppedImage = new Image();
                croppedImage.onload = function () {
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    ctx.drawImage(croppedImage, 16, 12, 321, 321);
                    ctx.drawImage(frame, 0, 0, 1080, 1350);

                    ctx.fillStyle = "black";
                    ctx.textAlign = "left";

                    const fontFamily = "Lato";
                    const nameX = 400;
                    const nameY = 135;

                    // Name
                    let maxAllowedWidth = 600;
                    let nameFontSize = 40;
                    ctx.font = `600 ${nameFontSize}px ${fontFamily}`;
                    while (ctx.measureText(inputText).width > maxAllowedWidth && nameFontSize > 19) {
                        nameFontSize--;
                        ctx.font = `600 ${nameFontSize}px ${fontFamily}`;
                    }
                    ctx.fillText(inputText, nameX, nameY);

                    // Qualification
                    let qualFontSize = 30;
                    let qualY = nameY + 40;
                    ctx.font = `500 ${qualFontSize}px ${fontFamily}`;
                    while (ctx.measureText(inputQualification).width > maxAllowedWidth && qualFontSize > 18) {
                        qualFontSize--;
                        ctx.font = `500 ${qualFontSize}px ${fontFamily}`;
                    }
                    ctx.fillText(inputQualification, nameX, qualY);

                    // City
                    let cityFontSize = 28;
                    let cityY = qualY + 35;
                    ctx.font = `500 ${cityFontSize}px ${fontFamily}`;
                    ctx.fillText(inputCity, nameX, cityY);
                };
                croppedImage.src = croppedImageDataUrl;
            }

            previewContainer.style.display = "flex";
            step1Container.style.display = "none";

            if (isPosterSaved) {
                console.log("Poster already saved. Skipping insert.");
                return;
            }

            const user_id = '<?php echo $row["UserID"]; ?>';
            const frame_id = '<?php echo $photo_frame["frame_id"]; ?>';

            const xhr = new XMLHttpRequest();
            xhr.open("POST", "<?php echo site_url('/user/add_poster') ?>", true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    try {
                        const response = JSON.parse(xhr.responseText);
                        if (response.status === "success") {
                            insertedPosterId = response.poster_id;
                            isPosterSaved = true; // Prevent duplicate insert
                            console.log("Poster saved:", insertedPosterId);
                        }
                    } catch (e) {
                        console.error("Invalid response", e);
                    }
                }
            };

            const params = 'input_text=' + encodeURIComponent(userName) +
                '&input_text2=' + encodeURIComponent(qualification) +
                '&input_text3=' + encodeURIComponent(city) +
                '&id=' + encodeURIComponent(user_id) +
                '&frameid=' + encodeURIComponent(frame_id);

            xhr.send(params);
        }


        function saveImage() {
            const imageData = canvas.toDataURL("image/png");
            const link = document.createElement("a");
            link.download = "framed-photo.png";
            link.href = imageData;
            link.click();

            if (insertedPosterId && !isDownloadUpdated) {
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "<?php echo site_url('/user/poster_download_status'); ?>", true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.send('poster_id=' + encodeURIComponent(insertedPosterId));
                isDownloadUpdated = true; // Only once
            } else {
                console.warn("Download status already updated or poster ID missing.");
            }
        }


        async function shareImage() {
            const blob = await (await fetch(canvas.toDataURL())).blob();
            const file = new File([blob], "framed-photo.png", { type: "image/png" });

            if (navigator.canShare && navigator.canShare({ files: [file] })) {
                try {
                    await navigator.share({
                        files: [file],
                        title: "Framed with sunshine!",
                        text: "Check out my photo!",
                    });

                    if (insertedPosterId && !isShareUpdated) {
                        const xhr = new XMLHttpRequest();
                        xhr.open("POST", "<?php echo site_url('/user/poster_share_status'); ?>", true);
                        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                        xhr.send('poster_id=' + encodeURIComponent(insertedPosterId));
                        isShareUpdated = true;
                    } else {
                        console.warn("Share status already updated or poster ID missing.");
                    }
                } catch (err) {
                    console.error("Share cancelled or failed", err);
                }
            } else {
                alert("Sharing not supported on this device. Try downloading the image.");
            }
        }


    </script>


</body>

</html>