<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>
<body>
    <!-- Sidebar Start -->
    <?php include("sidebar.php") ?>
    <!-- Sidebar End -->
    <!-- Content Start -->
    <div class="content">
        <!-- Navbar Start -->
        <?php include("nav.php") ?>
        <!-- Navbar End -->
        <!-- Table Start -->
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Patients User Count</h3>
                        <div class="table-responsive">
                            <button id="tbltoxl" class="btn bg-green text-white">Generate Excel</button>
                            <input class="search" type="text" id="searchInput" placeholder="Search ">
                            <div class="row mt-2 mb-2">
                               <div class="dropdown col-sm-4">
                                    <select class="form-select" name="region" id="region">
                                        <option value="">Select Region</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($region)) {
                                            foreach ($region as $regionrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $regionrow['REGIONId']; ?>">
                                                    <?php echo $regionrow['REGION']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="dropdown col-sm-4">
                                    <select class="form-select" name="hq" id="hq">
                                        <option value="">Select HQ</option>
                                        <?php
                                        $serial = 0;
                                        if (!empty($hq)) {
                                            foreach ($hq as $hqrow) {
                                                $serial++;
                                                ?>
                                                <option value="<?php echo $hqrow['HQId']; ?>">
                                                    <?php echo $hqrow['HQ']; ?>
                                                </option>
                                            <?php }
                                        } else { ?>
                                            <h4>Record Not Found</h4>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th scope="">S.no.</th>
                                        <th scope="">Employee Name</th>
                                        <th scope="">Emp. ID</th>
                                        <th scope="">Area</th>
                                        <th scope="">Region</th>
                                        <th scope="">Zone</th>
                                        <th scope="">Totel Patients</th>
                                        <!-- <th scope="">Date</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td><?php echo $serial ?></td>
                                                <td><?php echo $row['user']; ?></td>
                                                <td><?php echo $row['empno']; ?></td> 
                                                <td><?php echo $row['HQ']; ?></td>
                                                <td><?php echo $row['REGION']; ?></td>
                                                <td><?php echo $row['ZONE']; ?></td>
                                                <td><?php echo $row['entry_count']; ?></td>
                                                <!-- <td><?php // echo $row['date']; ?></td> -->
                                            </tr>
                                        <?php }
                                    } else { ?>
                                        <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" "><br></div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>
    <script>
        $(document).ready(function () {
            $('#region').change(function () {
                var regionId = $(this).val();
                if (regionId) {
                    $.ajax({
                        url: '<?php echo base_url("zone/get_hq_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            var len = response.length;
                            $("#hq").empty();
                            $("#hq").append('<option value="">Select HQ</option>');
                            if (len > 0) {
                                for (var i = 0; i < len; i++) {
                                    var id = response[i]['HQId'];
                                    var name = response[i]['HQ'];
                                    $("#hq").append("<option value='" + id + "'>" + name +
                                        "</option>");
                                }
                            }
                        }
                    });
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                    var selectedZoneId = $("#zone").val();
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_zone"); ?>',
                        type: 'post',
                        data: {
                            zone_id: selectedZoneId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                }
            });

            $('#hq').change(function () {
                var hqId = $(this).val();
                var regionId = $("#region").val();
                if (hqId) {
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_hq"); ?>',
                        type: 'post',
                        data: {
                            region_id: regionId,
                            hq_id: hqId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                } else {
                    var selectedRegionId = $("#region").val();
                    $.ajax({
                        url: '<?php echo base_url("zone/get_user_patient_by_region"); ?>',
                        type: 'post',
                        data: {
                            region_id: selectedRegionId
                        },
                        dataType: 'json',
                        success: function (response) {
                            updateTable(response.table_data);
                        }
                    });
                }
            });

            function updateTable(tableData) {
                $("#myTable tbody").empty();
                if (tableData.length > 0) {
                    $.each(tableData, function (index, row) {
                        var html = "<tr>" + "<td>" + (index + 1) + "</td>" + "<td>" + row.user + "</td>" +
                            "<td>" + row.empno + "</td>" + "<td>" + row.HQ + "</td>" + "<td>" + row.REGION +
                            "</td>" + "<td>" + row.ZONE + "</td>" + "<td>" + row.entry_count + "</td>" +
                            "</tr>";
                        $("#myTable tbody").append(html);
                    });
                } else {
                    $("#myTable tbody").html("<tr><td colspan='15'>No data available</td></tr>");
                }
            }
        });
    </script>
</body>
 </html>