<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Usertype_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Admin_controller extends BaseController
{
    public function dashboard()
    {
        $session = session();
        if ($session->has('user_id')) {
            $user = new User_Model;
            $posterModel = new Poster_Model;

            $data = [
                'totalUsers' => $user->getTotalUsers(),
                'totalPosters' => $posterModel->getTotalPosters(),
                'topUsers' => $posterModel->getTopUsers(),
            ];

            $date = $posterModel->getPosterDate();
            $data['date'] = $date;

            return view('admin/dashboard', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function totel_poster()
    {
        $session = session();
        if ($session->has('user_id')) {
            $poster = new Poster_Model;

            $data['data'] = $poster->getPosterWithUsersDetails();

            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/poster', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function top_users()
    {
        $session = session();
        if ($session->has('user_id')) {

            $poster = new Poster_Model;

            $data['data'] = $poster->getTopUser();

            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/top_user', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function users_count()
    {
        $session = session();
        if ($session->has('user_id')) {
            $poster = new Poster_Model;
            $data['data'] = $poster->getUserCount();

            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/usercount', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function users_date_count()
    {
        $session = session();
        if ($session->has('user_id')) {
            $poster = new Poster_Model;
            $data['data'] = $poster->getEentrybyDate();

            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/user_datecount', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function users_date($id)
    {
        $session = session();
        if ($session->has('user_id')) {
            $poster = new Poster_Model;

            $row['row'] = $poster->where('poster_id', $id)->first();
            if (!empty($row)) {
                foreach ($row as $poster_date) {
                    $date = $poster_date['date'];
                }
            }

            $data['data'] = $poster->where('date', $date)->getEentrybyDate();

            $pdate = $poster->getPosterDate();
            $data['date'] = $pdate;

            return view('admin/users_date', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function admin_profile()
    {
        $session = session();
        if ($session->has('user_id')) {
            $id = $session->get('user_id');
            $emp = new User_Model;
            $poster = new Poster_Model;

            $data['admin'] = $emp->where('user_id', $id)->first();

            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/profile', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function employee_form()
    {

        $session = session();
        if ($session->has('user_id')) {

            $usertype = new Usertype_Model;
            $usertype_array = $usertype->getRecords();
            $data['usertype'] = $usertype_array;

            $hq = new Hq_Model;
            $hq_array = $hq->getRecords();
            $data['hq'] = $hq_array;

            $region = new Region_Model;
            $region_array = $region->getRecords();
            $data['region'] = $region_array;

            $zone = new Zone_Model;
            $zone_array = $zone->getRecords();
            $data['zone'] = $zone_array;

            $poster = new Poster_Model();
            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/employee_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function employee_insert()
    {
        $employee = new User_Model;
        $data = [
            'name' => $this->request->getVar('name'),
            'phone_no' => $this->request->getVar('phone'),
            'email' => $this->request->getVar('email'),
            'city' => $this->request->getVar('city'),
            'fk_usertype_id' => $this->request->getVar('user_type'),
            'emp_no' => $this->request->getVar('emp_no'),
            'pass' => 'telminorm',
            'fk_hq_id' => $this->request->getVar('hq'),
            'fk_region_id' => $this->request->getVar('region'),
            'fk_zone_id' => $this->request->getVar('zone'),
        ];
        $employee->save($data);
        return redirect()->to('admin/employee_form');
    }

    public function employee_table()
    {
        $session = session();
        if ($session->has('user_id')) {
            $employee = new User_Model;
            $poster = new Poster_Model;

            $emp_array = $employee->getUsersWithDetails();
            $data['data'] = $emp_array;

            $date = $poster->getPosterDate();
            $data['date'] = $date;
            return view('admin/employee_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function employee_edit($id)
    {
        $User = new User_Model;
        $data['employee_row'] = $User->where('user_id', $id)->first();

        $usertype = new Usertype_Model;
        $usertype_array = $usertype->getRecords();
        $data['usertype'] = $usertype_array;

        $hq = new Hq_Model;
        $hq_array = $hq->getRecords();
        $data['hq'] = $hq_array;

        $region = new Region_Model;
        $region_array = $region->getRecords();
        $data['region'] = $region_array;

        $zone = new Zone_Model;
        $zone_array = $zone->getRecords();
        $data['zone'] = $zone_array;

        $poster = new Poster_Model();
        $date = $poster->getPosterDate();
        $data['date'] = $date;

        return view('admin/employee_edit', $data);
    }
    public function employee_update()
    {
        $employee = new user_Model;
        $user_id = $this->request->getVar('user_id');
        $data = [
            'name' => $this->request->getVar('name'),
            'phone_no' => $this->request->getVar('phone'),
            'email' => $this->request->getVar('email'),
            'city' => $this->request->getVar('city'),
            'fk_usertype_id' => $this->request->getVar('user_type'),
            'emp_no' => $this->request->getVar('emp_no'),
            'fk_hq_id' => $this->request->getVar('hq'),
            'fk_region_id' => $this->request->getVar('region'),
            'fk_zone_id' => $this->request->getVar('zone'),
        ];
        $employee->update($user_id, $data);
        return redirect()->to('admin/employee_table');
    }

    public function employee_delete($id)
    {
        $user = new User_Model;
        $user->where('user_id', $id)->delete();
        return redirect()->to('admin/employee_table');
    }

    public function campaign_form()
    {
        $session = session();
        if ($session->has('user_id')) {

            $poster = new Poster_Model();
            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/campaign_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function campaign_insert()
    {
        $campaign = new Campaign_Model;
        $data = [
            'campaign_name' => $this->request->getVar('campaign_name')
        ];
        $campaign->save($data);
        return redirect()->to('admin/campaign_form');
    }

    public function campaign_table()
    {
        $session = session();
        if ($session->has('user_id')) {
            $campaign = new Campaign_Model;
            $poster = new Poster_Model;

            $emp_array = $campaign->getRecords();
            $data['data'] = $emp_array;

            $date = $poster->getPosterDate();
            $data['date'] = $date;
            return view('admin/campaign_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function campaign_edit($id)
    {
        $User = new Campaign_Model;
        $data['campaign_row'] = $User->where('campaign_id', $id)->first();

        $poster = new Poster_Model();
        $date = $poster->getPosterDate();
        $data['date'] = $date;

        return view('admin/campaign_edit', $data);
    }
    public function campaign_update()
    {
        $campaign = new Campaign_Model;
        $campaign_id = $this->request->getVar('campaign_id');
        $data = [
            'campaign_name' => $this->request->getVar('campaign_name')
        ];
        $campaign->update($campaign_id, $data);
        return redirect()->to('admin/campaign_table');
    }

    public function campaign_delete($id)
    {
        $user = new Campaign_Model;
        $user->where('campaign_id', $id)->delete();
        return redirect()->to('admin/campaign_table');
    }

    public function language_form()
    {

        $session = session();
        if ($session->has('user_id')) {

            $poster = new Poster_Model();
            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/language_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function language_insert()
    {
        $language = new Language_Model;
        $data = [
            'language' => $this->request->getVar('language')
        ];
        $language->save($data);
        return redirect()->to('admin/language_form');
    }
    public function language_table()
    {
        $session = session();
        if ($session->has('user_id')) {
            $language = new Language_Model;
            $poster = new Poster_Model;

            $language_array = $language->getRecords();
            $data['data'] = $language_array;

            $date = $poster->getPosterDate();
            $data['date'] = $date;
            return view('admin/language_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function language_edit($id)
    {
        $User = new Language_Model;
        $data['language_row'] = $User->where('language_id', $id)->first();

        $poster = new Poster_Model();
        $date = $poster->getPosterDate();
        $data['date'] = $date;

        return view('admin/language_edit', $data);
    }
    public function language_update()
    {
        $language = new Language_Model;
        $language_id = $this->request->getVar('language_id');
        $data = [
            'language' => $this->request->getVar('language')
        ];
        $language->update($language_id, $data);
        return redirect()->to('admin/language_table');
    }

    public function language_delete($id)
    {
        $user = new Language_Model;
        $user->where('language_id', $id)->delete();
        return redirect()->to('admin/language_table');
    }
    public function frame_form()
    {

        $session = session();
        if ($session->has('user_id')) {

            $campaign = new Campaign_Model();
            $campaign_array = $campaign->getRecords();
            $data['campaign'] = $campaign_array;

            $language = new Language_Model();
            $language_array = $language->getRecords();
            $data['language'] = $language_array;

            $poster = new Poster_Model();
            $date = $poster->getPosterDate();
            $data['date'] = $date;

            return view('admin/frame_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function frame_insert()
    {
        $frame = new Frame_Model;
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "frame_" . $RandomName;
            $img_file->move('assets/frame/', $image);
        }

        $data = [
            'frame_name' => $image,
            'fk_campaign_id' => $this->request->getVar('fk_campaign_id'),
            'fk_language_id' => $this->request->getVar('fk_language_id'),
        ];
        $frame->save($data);
        return redirect()->to('admin/frame_form');
    }
    public function frame_table()
    {
        $session = session();
        if ($session->has('user_id')) {
            $frame = new Frame_Model;
            $poster = new Poster_Model;

            $emp_array = $frame->getFrames();
            $data['data'] = $emp_array;

            $date = $poster->getPosterDate();
            $data['date'] = $date;
            return view('admin/frame_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }
    public function frame_edit($id)
    {
        $User = new Frame_Model;
        $data['frame_row'] = $User->where('frame_id', $id)->first();

        $campaign = new Campaign_Model();
        $campaign_array = $campaign->getRecords();
        $data['campaign'] = $campaign_array;

        $language = new Language_Model();
        $language_array = $language->getRecords();
        $data['language'] = $language_array;

        $poster = new Poster_Model();
        $date = $poster->getPosterDate();
        $data['date'] = $date;

        return view('admin/frame_edit', $data);
    }

    public function frame_update()
    {
        $frame = new Frame_Model;
        $frame_id = $this->request->getVar('frame_id');
        $oldimage = $this->request->getPost('old_image');
        $img_file = $this->request->getFile('frame_img');

        if ($img_file->isValid() && !$img_file->hasMoved()) {
            $RandomName = $img_file->getRandomName();
            $image = "frame_" . $RandomName;
            $img_file->move('assets/frame/', $image);

            if (!empty($oldimage)) {
                $oldImagePath = 'assets/frame/' . $oldimage;
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }
        } else {
            $image = $oldimage;
        }

        $data = [
            'frame_name' => $image,
            'fk_campaign_id' => $this->request->getVar('fk_campaign_id'),
            'fk_language_id' => $this->request->getVar('fk_language_id'),
        ];
        $frame->update($frame_id, $data);
        return redirect()->to('admin/frame_table');
    }

    public function frame_delete($id)
    {
        $frame = new Frame_Model;
        $data = $frame->find($id);

        $datafile = $data['frame_name'];
        if (file_exists("assets/frame/" . $datafile)) {
            unlink("assets/frame/" . $datafile);
        }

        $frame->where('frame_id', $id)->delete();
        return redirect()->to('admin/frame_table');
    }
}