<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Poster_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class User_controller extends BaseController
{

    public function home()
    {
        $session = session();
        if ($session->has('user_id')) {
            $language = new Language_Model;

            $language_array = $language->getRecords();
            $data['language'] = $language_array;

            return view('user_bo/home', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function get_campaigns_by_language($languageid)
    {
        $frameModel = new Frame_Model();
        $campaigns = $frameModel->getCampaignsByLanguage($languageid);

        return $this->response->setJSON($campaigns);
    }
    public function poster_maker($id)
    {
        $session = session();
        if ($session->has('user_id')) {
            $user = new User_Model;
            $frame = new Frame_Model;
            $photo_frame = $frame->getRow($id);
            $data['photo_frame'] = $photo_frame;

            $id = $session->get('user_id');
            $data['row'] = $user->where('user_id', $id)->first();

            return view('user_bo/poster_maker', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function add_poster()
    {
        $poster = new Poster_Model();

        $data = [
            'doctor_name' => $this->request->getPost('input_text'),
            'qualification' => $this->request->getPost('input_text2'),
            'city' => $this->request->getPost('input_text3'),
            'download_status' => 'No',
            'share_status' => 'No',
            'fk_user_id' => $this->request->getVar('id'),
            'fk_frame_id' => $this->request->getVar('frameid'),
            'date' => date('Y-m-d'),
        ];

        $poster->save($data);
        $posterId = $poster->insertID();

        return $this->response->setJSON(['status' => 'success', 'poster_id' => $posterId]);
    }

    public function update_download_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['download_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function update_share_status()
    {
        $poster = new Poster_Model();
        $poster_id = $this->request->getPost('poster_id');

        if ($poster_id) {
            $poster->update($poster_id, ['share_status' => 'Yes']);
            return $this->response->setJSON(['status' => 'success']);
        }
        return $this->response->setJSON(['status' => 'error']);
    }

    public function poster_tbl()
    {

        $session = session();
        if ($session->has('user_id')) {

            $id = $session->get('user_id');

            $user = new User_Model;
            $data['user_row'] = $user->where('user_id', $id)->first();

            $poster = new Poster_Model;
            $data['data'] = $poster->getUserData($id);

            return view('user_bo/poster_tbl', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

}