<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Poster_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Usertype_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Zone_controller extends BaseController
{
    public function z_dashboard()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_zone_id'])) {
                return redirect()->to('/index')->with('error', 'Zone information not found.');
            }

            $zoneId = $user['fk_zone_id'];

            $data = [
                'totalUsers' => $userModel->getTotalUsersByZone($zoneId),
                'totalPosters' => $posterModel->getTotalPostersByZone($zoneId),
                'topUsers' => $posterModel->getTopUsersByZone($zoneId),
            ];

            return view('zone/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function z_totel_poster()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_zone_id'])) {
                return redirect()->to('/index')->with('error', 'Zone information not found.');
            }

            $zoneId = $user['fk_zone_id'];

            $data['data'] = $posterModel->getPosterWithUsersDetailsByZone($zoneId);

            return view('zone/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function z_top_users()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_zone_id'])) {
                return redirect()->to('/index')->with('error', 'Zone information not found.');
            }

            $zoneId = $user['fk_zone_id'];

            $data['data'] = $posterModel->getTopUserByZone($zoneId);

            return view('zone/top_user', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function z_users_count()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_zone_id'])) {
                return redirect()->to('/index')->with('error', 'Zone information not found.');
            }

            $zoneId = $user['fk_zone_id'];

            $data['data'] = $posterModel->getUserCountByZone($zoneId);

            return view('zone/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function z_users_date_count()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_zone_id'])) {
                return redirect()->to('/index')->with('error', 'Zone information not found.');
            }

            $zoneId = $user['fk_zone_id'];

            $data['data'] = $posterModel->getEntryByDateByZone($zoneId);

            return view('zone/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function z_admin_profile()
    {
        $session = session();
        if ($session->has('user_id')) {
            $id = $session->get('user_id');
            $emp = new User_Model;
            $poster = new Poster_Model;

            $data['admin'] = $emp->where('user_id', $id)->first();

            return view('zone/profile', $data); 
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function z_employee_form()
    {
        $session = session();
        if ($session->has('user_id')) {
            $userModel = new User_Model;
            $user = $userModel->where('user_id', $session->get('user_id'))->first();
            $my_usertype = $user['fk_usertype_id'];
            $my_zone_id = $user['fk_zone_id'];

            $usertype = new Usertype_Model;
            $data['usertype'] = $usertype->where('usertype_id <', $my_usertype)->findAll();

            $regionModel = new Region_Model;
            $regions = $regionModel->where('fk_zone_id', $my_zone_id)->findAll();
            $data['region'] = $regions;

            $region_ids = array_column($regions, 'region_id');
            $hqModel = new Hq_Model;
            if (!empty($region_ids)) {
                $data['hq'] = $hqModel->whereIn('fk_region_id', $region_ids)->findAll();
            } else {
                $data['hq'] = [];
            }

            return view('zone/employee_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function z_employee_insert()
    {
        $session = session();
        $loggedInUserId = $session->get('user_id');

        $userModel = new User_Model;
        $loggedInUser = $userModel->where('user_id', $loggedInUserId)->first();
        $zone_id = $loggedInUser['fk_zone_id'];

        $data = [
            'name' => $this->request->getVar('name'),
            'phone_no' => $this->request->getVar('phone'),
            'email' => $this->request->getVar('email'),
            'city' => $this->request->getVar('city'),
            'fk_usertype_id' => $this->request->getVar('user_type'),
            'emp_no' => $this->request->getVar('emp_no'),
            'pass' => 'telminorm',
            'fk_hq_id' => $this->request->getVar('hq'),
            'fk_region_id' => $this->request->getVar('region'),
            'fk_zone_id' => $zone_id, 
        ];
        $userModel->save($data);
        return redirect()->to('zone/employee_form');
    }


    public function z_employee_table()
    {
        $session = session();
        if ($session->has('user_id')) {
            $user_id = $session->get('user_id');

            $userModel = new User_Model;
            $loggedInUser = $userModel->where('user_id', $user_id)->first();
            $zone_id = $loggedInUser['fk_zone_id'];

            $employees = $userModel->where('tbl_user.fk_zone_id', $zone_id)->where('user_id !=', $user_id)->getUsersWithDetails();

            $data['data'] = $employees;


            return view('zone/employee_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function z_employee_edit($id)
    {
        $session = session();
        if ($session->has('user_id')) {
            $userModel = new User_Model;

            $loggedInUser = $userModel->where('user_id', $session->get('user_id'))->first();
            $my_usertype = $loggedInUser['fk_usertype_id'];
            $my_zone_id = $loggedInUser['fk_zone_id'];

            $data['employee_row'] = $userModel->where('user_id', $id)->first();

            $usertype = new Usertype_Model;
            $data['usertype'] = $usertype->where('usertype_id <', $my_usertype)->findAll();

            $regionModel = new Region_Model;
            $regions = $regionModel->where('fk_zone_id', $my_zone_id)->findAll();
            $data['region'] = $regions;

            $region_ids = array_column($regions, 'region_id');
            $hqModel = new Hq_Model;
            if (!empty($region_ids)) {
                $data['hq'] = $hqModel->whereIn('fk_region_id', $region_ids)->findAll();
            } else {
                $data['hq'] = [];
            }

            return view('zone/employee_edit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }


    public function z_employee_update()
    {
        $employee = new User_Model;
        $user_id = $this->request->getVar('user_id');
        
        $data = [
            'name' => $this->request->getVar('name'),
            'phone_no' => $this->request->getVar('phone'),
            'email' => $this->request->getVar('email'),
            'city' => $this->request->getVar('city'),
            'fk_usertype_id' => $this->request->getVar('user_type'),
            'emp_no' => $this->request->getVar('emp_no'),
            'fk_hq_id' => $this->request->getVar('hq'),
            'fk_region_id' => $this->request->getVar('region'),
        ];
        $employee->update($user_id, $data);
        return redirect()->to('zone/employee_table');
    }

    public function z_employee_delete($id)
    {
        $user = new User_Model;
        $user->where('user_id', $id)->delete();
        return redirect()->to('zone/employee_table');
    }
}