<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>

<body>
    <?php include("nav.php") ?>
    <div class="container">
        <h2>All Campaigns</h2>

        <div class="dropdown">
            <button class="dropdown-toggle" onclick="toggleDropdown()">Select Language</button>
            <div class="dropdown-menu" id="dropdownMenu">
                <?php foreach ($language as $row): ?>
                    <a href="#" onclick="fetchCampaigns(<?= $row['language_id']; ?>)">
                        <?= esc($row['language']); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

        <div id="campaignLinks" style="margin-top: 20px;"></div>
    </div>

    <script>
        function toggleDropdown() {
            document.getElementById("dropdownMenu").classList.toggle("show");
        }

        window.onclick = function (event) {
            if (!event.target.matches('.dropdown-toggle')) {
                var dropdowns = document.getElementsByClassName("dropdown-menu");
                for (var i = 0; i < dropdowns.length; i++) {
                    dropdowns[i].classList.remove('show');
                }
            }
        }

        function fetchCampaigns(languageid) {
            fetch("<?= base_url('user/get_campaigns_by_language/') ?>" + languageid)
                .then(response => response.json())
                .then(data => {
                    let html = '';
                    if (data.length > 0) {
                        data.forEach(row => {
                            html += `<div style="margin-bottom: 10px;">
                        <a href="<?= base_url('user/poster_maker') ?>/${row.frame_id}" class="btn-link">
                           ${row.campaign_name}
                        </a><br>
                        <img src="<?= base_url(); ?>/assets/frame/${row.frame_name}" style="height:320px; margin-top:10px">
                    </div>`;
                        });
                    } else {
                        html = '<p style="color: #000">No campaigns found for selected language.</p>';
                    }

                    document.getElementById('campaignLinks').innerHTML = html;
                })
                .catch(error => {
                    console.error('Error fetching campaigns:', error);
                });
        }

    </script>


</body>

</html>