<!DOCTYPE html>
<html lang="en">
<?php include("head.php") ?>

<body>
    <?php include("sidebar.php") ?>
    <div class="content">
        <?php include("nav.php") ?>
        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <div class="col-12">
                    <div class="bg-light rounded h-100 p-4">
                        <h3 class="mb-4">All Registered Employees</h3>
                        <a href="<?php echo site_url('/zone/employee_form'); ?>" class="btn btn-primary btn">Add</a>
                        <button id="tbltoxl" class="btn btn-success">Generate Excel</button>
                        <input class="search" type="text" id="searchInput" placeholder="Search ">
                        <div class="table-responsive">
                            <table class="table" id="user">
                                <thead>
                                    <tr>
                                        <th scope="">S.no.</th>
                                        <th scope="">Name</th>
                                        <th scope="">Phone</th>
                                        <th scope="">Email</th>
                                        <th scope="">User Type</th>
                                        <th scope="">City</th>
                                        <th scope="">Emp. No</th>
                                        <th scope="">HQ</th>
                                        <th scope="">Region</th>
                                        <th scope="">Zone</th>
                                        <th scope="">Edit</th>
                                        <th scope="">Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial = 0;
                                    if (!empty($data)) {
                                        foreach ($data as $row) {
                                            $serial++;
                                            ?>
                                            <tr>
                                                <td>
                                                    <?php echo $serial ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['name']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['phone_no']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['email']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['user_type']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['city']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['emp_no']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['hq']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['region']; ?>
                                                </td>
                                                <td>
                                                    <?php  echo $row['zone']; ?>
                                                </td>
                                                <td>
                                                    <a href="<?php echo site_url('zone/employee_edit/' . $row['user_id']) ?>"
                                                        class="btn btn-primary "><i class="bi bi-pencil-square"></i></a>
                                                </td>
                                                <td>
                                                    <a class="btn btn-danger " onclick="return myFunction()"
                                                        href="<?php echo site_url('zone/employee_delete/' . $row['user_id']) ?>"
                                                        title="Delete"><i class="bi bi-trash"></i></a>
                                                </td>
                                            </tr>
                                        <?php }
                                    } else { ?>
                                    <h4>ID Not Found</h4>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class=" ">
                <br>
            </div>
        </div>
    </div>
    <script>
        function myFunction() {
            return confirm('Are You Sure You Want To Delete This Record');
        }
    </script>
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>
    <?php include("footer.php") ?>
    <script>
        document.getElementById('tbltoxl').addEventListener('click', function () {
            var table2excel = new Table2Excel();
            table2excel.export(document.querySelectorAll("#user"));
        })
    </script>
    <script src="<?php echo base_url(); ?>/assets/js/table2excel.js"></script>

</body>

</html>