<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Poster_Model;
use App\Models\Campaign_Model;
use App\Models\Language_Model;
use App\Models\Frame_Model;
use App\Models\Hq_Model;
use App\Models\Region_Model;
use App\Models\Zone_Model;
use App\Models\Usertype_Model;

date_default_timezone_set('Asia/Kolkata');

use CodeIgniter\Controller;

class Region_controller extends BaseController
{
    public function r_dashboard()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_region_id'])) {
                return redirect()->to('/index')->with('error', 'Region information not found.');
            }

            $regionId = $user['fk_region_id'];

            $data = [
                'totalUsers' => $userModel->getTotalUsersByRegion($regionId),
                'totalPosters' => $posterModel->getTotalPostersByRegion($regionId),
                'topUsers' => $posterModel->getTopUsersByRegion($regionId),
            ];

            return view('region/dashboard', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_totel_poster()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_region_id'])) {
                return redirect()->to('/index')->with('error', 'Region information not found.');
            }

            $regionId = $user['fk_region_id'];

            $data['data'] = $posterModel->getPosterWithUsersDetailsByRegion($regionId);

            return view('region/poster', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_top_users()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_region_id'])) {
                return redirect()->to('/index')->with('error', 'Region information not found.');
            }

            $regionId = $user['fk_region_id'];

            $data['data'] = $posterModel->getTopUserByRegion($regionId);

            return view('region/top_user', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_users_count()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_region_id'])) {
                return redirect()->to('/index')->with('error', 'Region information not found.');
            }

            $regionId = $user['fk_region_id'];

            $data['data'] = $posterModel->getUserCountByRegion($regionId);

            return view('region/usercount', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_users_date_count()
    {
        $session = session();

        if ($session->has('user_id')) {
            $userModel = new User_Model();
            $posterModel = new Poster_Model();

            $userId = $session->get('user_id');
            $user = $userModel->find($userId);

            if (!$user || !isset($user['fk_region_id'])) {
                return redirect()->to('/index')->with('error', 'Region information not found.');
            }

            $regionId = $user['fk_region_id'];

            $data['data'] = $posterModel->getEntryByDateByRegion($regionId);

            return view('region/user_datecount', $data);
        } else {
            return redirect()->to('/index');
        }
    }


    public function r_admin_profile()
    {
        $session = session();
        if ($session->has('user_id')) {
            $id = $session->get('user_id');
            $emp = new User_Model;
            $data['admin'] = $emp->where('user_id', $id)->first();

            return view('region/profile', $data);
        } else {
            return redirect()->to('/index');
        }
    }

    public function r_employee_form()
    {
        $session = session();
        if ($session->has('user_id')) {
            $userModel = new User_Model;
            $user = $userModel->where('user_id', $session->get('user_id'))->first();
            $my_usertype = $user['fk_usertype_id'];
            $my_region_id = $user['fk_region_id'];

            $usertype = new Usertype_Model;
            $data['usertype'] = $usertype->where('usertype_id <', $my_usertype)->findAll();

            $hqModel = new Hq_Model;
            $data['hq'] = $hqModel->where('fk_region_id', $my_region_id)->findAll();

            $data['region_id'] = $my_region_id;

            return view('region/employee_form', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_employee_insert()
    {
        $session = session();
        $loggedInUserId = $session->get('user_id');

        $userModel = new User_Model;
        $loggedInUser = $userModel->where('user_id', $loggedInUserId)->first();
        $region_id = $loggedInUser['fk_region_id'];
        $zone_id = $loggedInUser['fk_zone_id'];

        $data = [
            'name' => $this->request->getVar('name'),
            'phone_no' => $this->request->getVar('phone'),
            'email' => $this->request->getVar('email'),
            'city' => $this->request->getVar('city'),
            'fk_usertype_id' => $this->request->getVar('user_type'),
            'emp_no' => $this->request->getVar('emp_no'),
            'pass' => 'telminorm',
            'fk_hq_id' => $this->request->getVar('hq'),
            'fk_region_id' => $region_id,
            'fk_zone_id' => $zone_id, 
        ];
        $userModel->save($data);
        return redirect()->to('region/employee_form');
    }

    public function r_employee_table()
    {
        $session = session();
        if ($session->has('user_id')) {
            $user_id = $session->get('user_id');

            $userModel = new User_Model;
            $loggedInUser = $userModel->where('user_id', $user_id)->first();
            $my_usertype = $loggedInUser['fk_usertype_id'];
            $region_id = $loggedInUser['fk_region_id'];

            $employees = $userModel->where('tbl_user.fk_region_id', $region_id)->where('usertype_id <', $my_usertype)->getUsersWithDetails();

            $data['data'] = $employees;

            return view('region/employee_table', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_employee_edit($id)
    {
        $session = session();
        if ($session->has('user_id')) {
            $userModel = new User_Model;

            $loggedInUser = $userModel->where('user_id', $session->get('user_id'))->first();
            $my_usertype = $loggedInUser['fk_usertype_id'];
            $my_region_id = $loggedInUser['fk_region_id'];

            $data['employee_row'] = $userModel->where('user_id', $id)->first();

            $usertype = new Usertype_Model;
            $data['usertype'] = $usertype->where('usertype_id <', $my_usertype)->findAll();

            $hqModel = new Hq_Model;
            $data['hq'] = $hqModel->where('fk_region_id', $my_region_id)->findAll();

            $data['region_id'] = $my_region_id;

            return view('region/employee_edit', $data);
        } else {
            return redirect()->to('/admin/index');
        }
    }

    public function r_employee_update()
    {
        $employee = new User_Model;
        $user_id = $this->request->getVar('user_id');

        $data = [
            'name' => $this->request->getVar('name'),
            'phone_no' => $this->request->getVar('phone'),
            'email' => $this->request->getVar('email'),
            'city' => $this->request->getVar('city'),
            'fk_usertype_id' => $this->request->getVar('user_type'),
            'emp_no' => $this->request->getVar('emp_no'),
            'fk_hq_id' => $this->request->getVar('hq'),
        ];
        $employee->update($user_id, $data);
        return redirect()->to('region/employee_table');
    }

    public function r_employee_delete($id)
    {
        $user = new User_Model;
        $user->where('user_id', $id)->delete();
        return redirect()->to('region/employee_table');
    }

}